/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq;

import java.io.Serializable;
import java.util.Map;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.server.guireq.AlertEmail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertDefinition
implements Serializable,
Cloneable {
    static final long serialVersionUID = 7547461129608221481L;
    public int aldAlertID;
    public String aldCreator;
    private String aldName;
    public String aldDescription;
    public String aldNotifyOnLogin;
    public AlertEmail aldEmailDef;
    public boolean aldEnabled;
    public short aldProductID;
    public short aldType;
    public short aldCondition;
    public byte aldThresholdType;
    public int aldThresholdValue;
    public int aldThresholdValue2;
    public int aldThresholdValue3;
    public int aldThresholdValue4;
    public boolean aldSnmpTrap;
    public boolean aldTecEvent;
    public boolean aldOsLog;
    public byte aldOsLogSeverity;
    public byte aldSyslogFacility;
    public boolean aldEmail;
    public boolean aldSALog = true;
    public int aldScriptComputerID;
    public String aldScriptName;
    public byte aldDbmsType;
    public static final String USER_STRING = "user";
    public static final String GROUP_STRING = "group";
    public static final String FILESYSTEM_STRING = "filesystem";
    public static final String DIRECTORY_STRING = "directory";

    public String getLogMsgID() {
        return AlertConditionManager.getLogMessageId(this.aldCondition);
    }

    public String getEmailMsgID() {
        return AlertConditionManager.getEmailMessageId(this.aldCondition);
    }

    public String getEmailSubjectID() {
        return AlertConditionManager.getEmailSubjectId(this.aldCondition);
    }

    public Map<Integer, String> getEmailParmMsgIdMap() {
        return AlertConditionManager.getEmailParameterIdMap(this.aldCondition);
    }

    public boolean accumulateAlertLog() {
        return AlertConditionManager.isAccumulate(this.aldCondition);
    }

    public int hashCode() {
        return Integer.valueOf(this.aldAlertID).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AlertDefinition) {
            return this.aldAlertID == ((AlertDefinition)o).aldAlertID;
        }
        return false;
    }

    public boolean isEqualTo(AlertDefinition that) {
        return this.aldProductID == that.aldProductID && this.aldType == that.aldType && this.aldDbmsType == that.aldDbmsType && this.aldCondition == that.aldCondition && this.aldThresholdType == that.aldThresholdType && this.aldThresholdValue == that.aldThresholdValue && this.aldSnmpTrap == that.aldSnmpTrap && this.aldTecEvent == that.aldTecEvent && this.aldOsLog == that.aldOsLog && this.aldOsLogSeverity == that.aldOsLogSeverity && this.aldSyslogFacility == that.aldSyslogFacility && this.aldEmail == that.aldEmail && Util.stringsEqual(this.aldNotifyOnLogin, that.aldNotifyOnLogin) && (this.aldEmailDef == null && that.aldEmailDef == null || this.aldEmailDef != null && that.aldEmailDef != null && this.aldEmailDef.equals(that.aldEmailDef)) && this.aldScriptComputerID == that.aldScriptComputerID && (this.aldScriptComputerID < 0 || Util.stringsEqual(this.aldScriptName, that.aldScriptName));
    }

    public static boolean alertDefsEqual(AlertDefinition one, AlertDefinition two) {
        if (one == null) {
            return two == null;
        }
        return two != null && one.isEqualTo(two);
    }

    public Object clone() {
        AlertDefinition result = null;
        try {
            result = (AlertDefinition)super.clone();
            if (this.aldEmailDef != null) {
                result.aldEmailDef = (AlertEmail)this.aldEmailDef.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException();
        }
        return result;
    }

    public String getAldName() {
        return Util.getTranslatedName(this.aldName);
    }

    public void setAldName(String alertDefintionName) {
        this.aldName = alertDefintionName;
    }
}

