/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.request.handler;

import java.awt.Container;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.TStorm.gui.RemoveMissing;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.common.ElementManagerHelperInterface;
import org.eclipse.aperi.gui.common.ElementManagerManager;
import org.eclipse.aperi.gui.disk.system.SubsystemDDI;
import org.eclipse.aperi.gui.fabric.details.DetailsClient;
import org.eclipse.aperi.gui.tape.library.LibraryDDI;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.ITopoBackend;
import org.eclipse.aperi.gui.topo.widget.ITopoFrontend;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequestImpl;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.request.handler.ThreadPool;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerAutoRefreshTimer;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerCache;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerException;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerGuiSendRequest;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerRequestNode;

public abstract class ViewerRequestDispatcher
implements ITopoBackend {
    private ITopoFrontend topoViewer = null;
    protected ThreadPool pool = new ThreadPool(2, 4);
    private Hashtable pendingRefresh = new Hashtable();
    private ViewerRequestNode pendingRequests;
    ViewerAutoRefreshTimer timer;
    private ControllerApp controllerApp = null;
    private static ElementManagerHelperInterface elementManagerHelper = new ElementManagerHelperInterface(){

        public String extractGUID(Object element) {
            GraphEntity node = (GraphEntity)element;
            String guid = (String)node.getEntityID().getID();
            return guid;
        }

        public String extractDefaultElementManager(Object element) {
            String defaultElementManager = null;
            if (element instanceof GraphSubsystem) {
                GraphSubsystem gArray = (GraphSubsystem)element;
                defaultElementManager = gArray.getDefaultElementManager();
            } else if (element instanceof GraphSwitch) {
                GraphSwitch gSwitch = (GraphSwitch)element;
                defaultElementManager = gSwitch.getDefaultElementManager();
            } else if (element instanceof GraphTapeLibrary) {
                GraphTapeLibrary gTape = (GraphTapeLibrary)element;
                defaultElementManager = gTape.getDefaultElementManager();
            }
            return defaultElementManager;
        }

        public String extractDisplayName(Object element) {
            GraphEntity node = (GraphEntity)element;
            String displayName = node.getDisplayName();
            return displayName;
        }
    };

    public void close() {
        if (this.pool != null) {
            this.pool.shutdown();
            this.pool = null;
        }
        this.pendingRefresh.clear();
        if (this.timer != null) {
            this.timer.stopTimer();
            this.timer = null;
        }
    }

    public void print(Container container) {
        this.topoViewer.print();
    }

    public void setTimer(ViewerAutoRefreshTimer timer) {
        Runnable r = new Runnable(){

            public void run() {
                ViewerRequestImpl rqst = new ViewerRequestImpl();
                rqst.setRequestType(2);
                rqst.getRefreshRate();
                try {
                    ViewerRequestDispatcher.this.dispatchRequest(rqst);
                }
                catch (ViewerException e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.pool != null) {
            this.pool.execute(r, true, true);
        }
        this.timer = timer;
    }

    public ITopoFrontend getITopoFrontend() {
        return this.topoViewer;
    }

    public ViewerAutoRefreshTimer getTimer() {
        return this.timer;
    }

    public synchronized ViewerRequestNode addToPending(ViewerGuiSendRequest requestor) {
        ViewerRequestNode result = new ViewerRequestNode();
        result.requestor = requestor;
        result.next = this.pendingRequests;
        this.pendingRequests = result;
        this.setBusyState(true);
        return result;
    }

    public synchronized boolean removeNode(ViewerRequestNode node) {
        boolean res;
        if (this.pendingRefresh == null) {
            return false;
        }
        if (node != null && node.request != null && node.request.requestData instanceof ViewerRequest) {
            ViewerRequest request = (ViewerRequest)node.request.requestData;
            this.pendingRefresh.remove(request);
        }
        ViewerRequestNode prev = null;
        ViewerRequestNode current = this.pendingRequests;
        while (current != null && current != node) {
            prev = current;
            current = current.next;
        }
        if (current == null) {
            res = false;
        } else {
            if (prev != null) {
                prev.next = current.next;
            } else {
                this.pendingRequests = current.next;
            }
            res = true;
        }
        this.setBusyState(this.pendingRequests != null);
        return res;
    }

    public synchronized void cancelAll() {
        this.pendingRefresh.clear();
        ViewerRequestNode current = this.pendingRequests;
        while (current != null) {
            current.requestor.cancel();
            current = current.next;
        }
        this.pendingRequests = null;
        this.setBusyState(false);
        if (this.topoViewer != null) {
            this.topoViewer.cancelAllRefresh();
        }
    }

    public synchronized boolean nonePending() {
        return this.pendingRequests == null;
    }

    protected abstract void dispatchRequest(ViewerRequest var1) throws ViewerException;

    protected abstract void setBusyState(boolean var1);

    public void addListener(ITopoFrontend listener) {
        this.topoViewer = listener;
    }

    public void removeListener(ITopoFrontend listener) {
        this.topoViewer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResponse(short status, Request request, Response response) {
        block26: {
            try {
                if (response == null || response.responseData == null) break block26;
                ViewerResponse rsp = (ViewerResponse)response.responseData;
                Object o = rsp.getResponse();
                if (rsp.getResponseType() == 0) {
                    if (o instanceof GraphModel) {
                        try {
                            String elementManager;
                            GraphModel model = (GraphModel)o;
                            Enumeration e = model.enumerate(GraphSubsystem.TYPE);
                            while (e.hasMoreElements()) {
                                GraphSubsystem gArray = (GraphSubsystem)e.nextElement();
                                elementManager = ElementManagerManager.getInstance().getElementManager(gArray, elementManagerHelper);
                                if (elementManager != null) {
                                    gArray.setElementManager(elementManager);
                                    continue;
                                }
                                gArray.setElementManager(gArray.getDefaultElementManager());
                            }
                            e = model.enumerate(GraphSwitch.TYPE);
                            while (e.hasMoreElements()) {
                                GraphSwitch gSwitch = (GraphSwitch)e.nextElement();
                                elementManager = ElementManagerManager.getInstance().getElementManager(gSwitch, elementManagerHelper);
                                if (elementManager != null) {
                                    gSwitch.setElementManager(elementManager);
                                    continue;
                                }
                                gSwitch.setElementManager(gSwitch.getDefaultElementManager());
                            }
                            e = model.enumerate(GraphTapeLibrary.TYPE);
                            while (e.hasMoreElements()) {
                                GraphTapeLibrary gTape = (GraphTapeLibrary)e.nextElement();
                                elementManager = ElementManagerManager.getInstance().getElementManager(gTape, elementManagerHelper);
                                if (elementManager != null) {
                                    gTape.setElementManager(elementManager);
                                    continue;
                                }
                                gTape.setElementManager(gTape.getDefaultElementManager());
                            }
                            ViewerCache.updateCache(rsp.getResponseCode(), model.getModelID(), model);
                            model.getModelID();
                            if (this.topoViewer != null && response != null) {
                                this.topoViewer.updateView(rsp.getResponseCode(), model);
                            }
                        }
                        catch (Exception t) {
                            GraphDebug.exception(t);
                        }
                    }
                } else if (rsp.getResponseType() == 2) {
                    if (this.timer != null) {
                        int timeout = rsp.getRefreshRate();
                        this.timer.setTimeout(timeout);
                        if (this.controllerApp != null) {
                            this.controllerApp.getTopoSetting().setRefreshRate(timeout / 60);
                        }
                    }
                } else if (rsp.getResponseType() == 4) {
                    if (this.controllerApp == null) {
                        return;
                    }
                    TopoSetting topoSetting = rsp.getTopoSettings();
                    if (topoSetting == null) {
                        return;
                    }
                    int timeout = this.controllerApp.getTopoSetting().getRefreshRate();
                    topoSetting.setRefreshRate(timeout);
                    this.controllerApp.setTopoSetting(topoSetting);
                }
                if (o instanceof Throwable) {
                    GraphDebug.trace("Exception at the backend Topology Viewer handler:");
                    GraphDebug.exception((Throwable)o);
                }
            }
            finally {
                if (request != null && request.requestData != null) {
                    this.finishRefresh(request);
                }
            }
        }
    }

    public void finishRefresh(Request request) {
        ViewerRequest rqst = (ViewerRequest)request.requestData;
        if (rqst.getModelID() != null) {
            GraphModel.ID id = rqst.getModelID();
            this.topoViewer.finishRefreshView(id);
        }
    }

    public void refreshView(final GraphModel.ID modelID) {
        if (this.timer != null) {
            this.timer.startTimer();
        }
        Runnable r = new Runnable(){

            public void run() {
                ViewerRequestDispatcher.this.refreshView(modelID, true);
            }
        };
        if (this.pool != null) {
            this.pool.execute(r, true, true);
        }
    }

    public void refreshView(GraphModel.ID modelID, boolean useCache) {
        GraphModel graphModel;
        if (this.topoViewer == null) {
            return;
        }
        ViewerRequestImpl rqst = new ViewerRequestImpl();
        rqst.addRequest(modelID, null);
        try {
            this.topoViewer.startRefreshView(modelID);
        }
        catch (Exception e) {
            GraphDebug.trace("Refreshing modelId:" + modelID);
            GraphDebug.exception(e);
        }
        if (useCache && (graphModel = ViewerCache.getFromCache(modelID, true)) != null) {
            this.topoViewer.updateView(0, graphModel);
            return;
        }
        try {
            if (this.pendingRefresh.get(rqst) == null) {
                this.pendingRefresh.put(rqst, rqst);
                this.dispatchRequest(rqst);
            } else {
                GraphDebug.trace("Request in progress...");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector getOpenedViews() {
        return this.topoViewer.getOpenedViews();
    }

    public void refreshAllViews() {
        Vector modelIDV;
        if (this.timer != null) {
            this.timer.resetTimer();
        }
        if ((modelIDV = this.topoViewer.getOpenedViews()) == null || modelIDV.size() == 0) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                for (GraphModel.ID modelID : modelIDV) {
                    ViewerRequestDispatcher.this.refreshView(modelID, false);
                }
            }
        };
        if (this.pool != null) {
            this.pool.execute(r, false, true);
        }
    }

    public void closeView(GraphModel.ID modelID) {
        ViewerCache.markAsClosed(modelID);
    }

    private ElementManagerHelperInterface getElementManagerHelper() {
        return elementManagerHelper;
    }

    public void launchElementManager(GraphEntity nodeID) {
        String savedElmMgr = ElementManagerManager.getInstance().getElementManager(nodeID, this.getElementManagerHelper());
        ElementManagerManager.getInstance().launchElementManager(nodeID, this.getElementManagerHelper());
    }

    public void setTimeout(int second) {
        if (this.timer != null) {
            this.timer.setTimeout(second);
        }
        try {
            ViewerRequestImpl rqst = new ViewerRequestImpl();
            rqst.setRequestType(1);
            rqst.setRefreshRate(second);
            this.dispatchRequest(rqst);
        }
        catch (ViewerException e) {
            e.printStackTrace();
        }
    }

    public void launchDetailsPanel(GraphEntity.ID nodeID) {
        String id = (String)nodeID.getID();
        int i = id.indexOf(58);
        String prefix = id.substring(0, i + 1);
        String sufix = id.substring(i + 1);
        if ("switch:".equals(prefix) || "hba:".equals(prefix) || "host:".equals(prefix) || "server:".equals(prefix) || "fabric:".equals(prefix) || "Port:".equalsIgnoreCase(prefix) || "pe:".equals(prefix) || "node:".equals(prefix) || "other:".equals(prefix)) {
            if ("other:".equals(prefix)) {
                i = sufix.indexOf(58);
                prefix = sufix.substring(0, i + 1);
                sufix = sufix.substring(i + 1);
            }
            if ("host:".equals(prefix)) {
                prefix = "server:";
            }
            prefix = prefix.toLowerCase();
            prefix = prefix.substring(0, prefix.length() - 1);
            DetailsClient.showDetails(prefix, sufix);
        } else if ("subsystem:".equals(prefix)) {
            SubsystemDDI ddi = new SubsystemDDI(Integer.parseInt(sufix));
            ((DataDisplayInfo)ddi).reDisplay();
        } else if ("tapelibrary:".equals(prefix)) {
            LibraryDDI ddi = new LibraryDDI(Integer.parseInt(sufix));
            ((DataDisplayInfo)ddi).reDisplay();
        }
    }

    public int getTimeout() {
        if (this.timer != null) {
            return this.timer.getTimeout();
        }
        return 0;
    }

    public void removeEntity(Vector v) {
        RemoveMissing removeMissing = new RemoveMissing();
        Vector<String> ids = new Vector<String>();
        for (GraphEntity node : v) {
            GraphEntity.ID id = node.getEntityID();
            String realId = (String)id.getID();
            if (realId != null && realId.startsWith("other:")) {
                realId = realId.substring(6);
            }
            if (realId.startsWith("server:")) {
                realId = "host:" + realId.substring(7);
            }
            if (realId.startsWith("port2port:")) {
                realId = "port2port:" + realId.substring(realId.lastIndexOf(44) + 1);
            }
            realId = realId.toLowerCase();
            ids.add(realId);
        }
        String[] idArray = new String[v.size()];
        ids.toArray(idArray);
        removeMissing.remove(idArray);
    }

    public void refreshPinnedList(GraphModel.ID modelID) {
    }

    public void probeAll(final Vector elements) {
        Runnable r = new Runnable(){

            public void run() {
                ViewerRequestImpl rqst = new ViewerRequestImpl();
                rqst.setRequestType(3);
                rqst.setRequestObject(elements);
                try {
                    ViewerRequestDispatcher.this.dispatchRequest(rqst);
                }
                catch (ViewerException e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.pool != null) {
            this.pool.execute(r, false, true);
        }
    }

    public void requestTopoSettings(ControllerApp topo) {
        this.controllerApp = topo;
        Runnable r = new Runnable(){

            public void run() {
                ViewerRequestImpl rqst = new ViewerRequestImpl();
                rqst.setRequestType(4);
                try {
                    ViewerRequestDispatcher.this.dispatchRequest(rqst);
                }
                catch (ViewerException e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.pool != null) {
            this.pool.execute(r, true, true);
        }
    }

    public void persistTopoSettings(final TopoSetting topoSetting) {
        Runnable r = new Runnable(){

            public void run() {
                ViewerRequestImpl rqst = new ViewerRequestImpl();
                rqst.setRequestType(5);
                rqst.setTopoSettings(topoSetting);
                try {
                    ViewerRequestDispatcher.this.dispatchRequest(rqst);
                }
                catch (ViewerException e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.pool != null) {
            this.pool.execute(r, true, true);
        }
    }
}

