/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL1;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Other;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerOtherL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL2;

public class ViewerOtherL1
extends ViewerOtherL0 {
    private static final boolean debug = false;
    public static final String SELECT_OTHER = "SELECT \tOTHER.PREFIX_ID PREFIX_ID, \tOTHER.OTHER_ID OTHER_ID, \tOTHER.DISPLAY_NAME DISPLAY_NAME, \tOTHER.PROPAGATED_STATUS PROPAGATED_STATUS, \tOTHER.DETECTABLE DETECTABLE, \tMODEL.MODEL_NAME MODEL, \tVENDOR.VENDOR_NAME VENDOR, \tOTHER.SERIAL_NUMBER SERIAL_NUMBER, \tOTHER.OTHER_TYPE DISPLAY_TYPE FROM T_VIEW_VOTHER OTHER left outer join T_RES_MODEL MODEL on \tOTHER.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on \tOTHER.VENDOR_ID = VENDOR.VENDOR_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \tTMP.ID = ? and \tTMP.PREFIX_ID = OTHER.PREFIX_ID and \tTMP.ENTITY_ID = OTHER.OTHER_ID ";
    public static final String SELECT_SWITCH_FROM_OTHER = "SELECT distinct \tTMP.PREFIX_ID OTHER_PREFIX_ID, \tTMP.ENTITY_ID OTHER_ID, \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3  FROM \tT_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_MODEL MODEL on    T_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on  \tT_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID, T_VIEW_VSWITCH2OTHER SWITCH2OTHER, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE     TMP.ID = ? and     SWITCH2OTHER.OTHER_ID = TMP.ENTITY_ID and \t SWITCH2OTHER.OTHER_PREFIX_ID = TMP.PREFIX_ID and \t T_RES_SWITCH.PREFIX_ID = SWITCH2OTHER.SWITCH_PREFIX_ID and \t T_RES_SWITCH.SWITCH_ID = SWITCH2OTHER.SWITCH_ID ";
    public static final String SELECT_SANS_FROM_SWITCH_FROM_OTHER = "SELECT distinct \tSWITCH2FABRIC.PREFIX_ID, \tSWITCH2FABRIC.SWITCH_ID SWITCH_ID, \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM     T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_VIEW_VSWITCH2OTHER SWITCH2OTHER,T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \tT_RES_FABRIC.FABRIC_ID = SWITCH2FABRIC.FABRIC_ID and    SWITCH2FABRIC.SWITCH_ID = SWITCH2OTHER.SWITCH_ID and    SWITCH2OTHER.OTHER_PREFIX_ID = TMP.PREFIX_ID and    SWITCH2OTHER.OTHER_ID = TMP.ENTITY_ID and \tTMP.ID = ?";
    public static final String SELECT_SWITCH2OTHER_FROM_OTHER = "SELECT distinct     SWITCH2OTHER.OTHER_PREFIX_ID,\t SWITCH2OTHER.OTHER_ID, \t SWITCH2OTHER.SWITCH_PREFIX_ID SWITCH_PREFIX_ID, \t SWITCH2OTHER.SWITCH_ID SWITCH_ID,     SWITCH2OTHER.PORT2PORT_ID PORT2PORT_ID,     SWITCH2OTHER.DETECTABLE DETECTABLE  FROM T_VIEW_VSWITCH2OTHER SWITCH2OTHER, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE     TMP.ID = ? and \t SWITCH2OTHER.OTHER_ID = TMP.ENTITY_ID and \t SWITCH2OTHER.OTHER_PREFIX_ID = TMP.PREFIX_ID ";
    public static final String SELECT_SANS_FROM_OTHER = "SELECT \t OTHER2FABRIC.FABRIC_ID FABRIC_ID, \t OTHER2FABRIC.PREFIX_ID PREFIX_ID, \t OTHER2FABRIC.OTHER_ID OTHER_ID FROM T_VIEW_VOTHER2FABRIC OTHER2FABRIC WHERE     OTHER2FABRIC.PREFIX_ID= ? and     OTHER2FABRIC.OTHER_ID  = ? ";
    public static final String SELECT_FABRIC_FROM_ZONES_FROM_OTHER = "SELECT DISTINCT \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VOTHER2PORT OTHER2PORT,     T_VIEW_PORT2ZONE PORT2ZONE,  \t T_RES_ZONE, T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE    TMP.ID = ? and \tOTHER2PORT.PREFIX_ID = TMP.PREFIX_ID and    OTHER2PORT.OTHER_ID = TMP.ENTITY_ID and \tOTHER2PORT.PORT_ID = PORT2ZONE.PORT_ID and \tPORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \tT_RES_ZONE.FABRIC_WWN = T_RES_FABRIC.FABRIC_WWN";
    public static final String SELECT_ZONES_FROM_OTHER = "SELECT distinct    T_RES_ZONE.ZONE_ID ZONE_ID, \tT_RES_ZONE.ZONE_TYPE ZONE_TYPE, \tT_RES_ZONE.ACTIVE ACTIVE,\tT_RES_ZONE.ZONE_NAME ZONE_NAME, \tT_RES_ZONE.FABRIC_WWN FABRIC_WWN, \tT_RES_ZONE.DESCRIPTION DESCRIPTION,  \tT_RES_ZONE.ZONE_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM     T_RES_ZONE, T_VIEW_VOTHER2PORT OTHER2PORT,T_VIEW_PORT2ZONE PORT2ZONE, T_RES_FABRIC FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t OTHER2PORT.PREFIX_ID = TMP.PREFIX_ID and     OTHER2PORT.OTHER_ID = TMP.ENTITY_ID and \t OTHER2PORT.PORT_ID = PORT2ZONE.PORT_ID and \t PORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \t T_RES_ZONE.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static final String SELECT_ZONE2MEMBER_FROM_OTHER = "SELECT DISTINCT     ENTITY_TO_PORT.ZONE_ID ZONE_ID,     ENTITY_TO_PORT.PORT_ID PORT_ID,\t ENTITY_TO_PORT.TYPE, \t ENTITY_TO_PORT.PREFIX_ID, \t ENTITY_TO_PORT.ENTITY_ID, \t ENTITY_TO_PORT.DISPLAY_NAME, \t ENTITY_TO_PORT.ZONE_ID, \t ENTITY_TO_PORT.PORT_DISPLAY_NAME, \t PORT2ZONE2.MEMBER_NAME, \t PORT2ZONE2.ZONE_MEMBER_ID,     PORT.PORT_NUMBER FROM T_VIEW_VOTHER2PORT OTHER2PORT,T_VIEW_PORT2ZONE PORT2ZONE1,T_VIEW_PORT2ZONE PORT2ZONE2 left outer join \t T_VIEW_ENTITY_TO_PORT ENTITY_TO_PORT on \t PORT2ZONE2.PORT_ID = ENTITY_TO_PORT.PORT_ID left outer join T_RES_PORT PORT on  \t PORT2ZONE2.PORT_ID = PORT.PORT_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE     TMP.ID = ? and \t OTHER2PORT.PREFIX_ID = TMP.PREFIX_ID and \t OTHER2PORT.OTHER_ID = TMP.ENTITY_ID and     OTHER2PORT.PORT_ID = PORT2ZONE1.PORT_ID and \t PORT2ZONE1.ZONE_ID = PORT2ZONE2.ZONE_ID ";
    public static final String SELECT_ZSET2ZONE_FROM_OTHER = "SELECT DISTINCT     ZSET2ZONE.ZONE_ID,     ZSET2ZONE.ZSET_ID FROM T_VIEW_VOTHER2PORT OTHER2PORT,T_VIEW_PORT2ZONE PORT2ZONE,    T_RES_ZSET2ZONE ZSET2ZONE, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t OTHER2PORT.PREFIX_ID = TMP.PREFIX_ID and     OTHER2PORT.OTHER_ID = TMP.ENTITY_ID and \t OTHER2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = ZSET2ZONE.ZONE_ID";
    public static final String SELECT_ZSET_FROM_OTHER = "SELECT DISTINCT    T_RES_ZSET.ZSET_ID, \tT_RES_ZSET.ACTIVE ACTIVE,\tT_RES_ZSET.ZSET_NAME ZSET_NAME, \tT_RES_ZSET.FABRIC_WWN FABRIC_WWN, \tT_RES_ZSET.DESCRIPTION DESCRIPTION,    T_RES_ZSET.ZSET_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VOTHER2PORT OTHER2PORT, T_VIEW_PORT2ZSET PORT2ZSET,    T_RES_ZSET, T_RES_FABRIC FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t OTHER2PORT.PREFIX_ID = TMP.PREFIX_ID and     OTHER2PORT.OTHER_ID = TMP.ENTITY_ID and \t OTHER2PORT.PORT_ID = PORT2ZSET.PORT_ID and     PORT2ZSET.ZSET_ID = T_RES_ZSET.ZSET_ID and \t T_RES_ZSET.FABRIC_WWN = FABRIC.FABRIC_WWN ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphOther getOther(Connection con, GraphModel model, HashMap entityMap, int id) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphOther gOther = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_OTHER);
            stmt.setInt(1, id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer unknownId = (Integer)resultSet.getObject("OTHER_ID");
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                String otherKey = prefixId + unknownId;
                if (entityMap == null || entityMap.get(otherKey) == null) {
                    gOther = new GraphOther(otherKey);
                    this.populator.populateOther(resultSet, gOther);
                    model.put(gOther);
                    entityMap.put(otherKey, gOther);
                    if (model != null) {
                        model.put(gOther);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(otherKey, gOther);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getOther", "Duplicated Other entry:" + otherKey);
            }
        }
        finally {
            block18: {
                block17: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block17;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block18;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                }
            }
        }
        return gOther;
    }

    public void getSansFromSwitch(Connection con, GraphModel model, HashMap entityMap, int id) throws SQLException {
        this.getSansFromSwitch(con, model, entityMap, new Object[]{new Integer(id)}, SELECT_SANS_FROM_SWITCH_FROM_OTHER);
    }

    public void getSansFromUnknown(Connection con, GraphModel model, HashMap entityMap, String prefix, int id) throws SQLException {
        this.getSansFromUnknown(con, model, entityMap, new Object[]{prefix, new Integer(id)}, SELECT_SANS_FROM_OTHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitchFromOther(Connection con, GraphModel model, HashMap entityMap, int id) throws SQLException {
        Integer switchId;
        String prefixId;
        Integer otherId;
        String otherPrefixId;
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphSwitch gSwitch = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_SWITCH_FROM_OTHER);
            stmt.setInt(1, id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                otherPrefixId = (String)resultSet.getObject("OTHER_PREFIX_ID");
                otherId = (Integer)resultSet.getObject("OTHER_ID");
                prefixId = (String)resultSet.getObject("PREFIX_ID");
                switchId = (Integer)resultSet.getObject("SWITCH_ID");
                String otherKey = otherPrefixId + otherId;
                GraphOther gOther = (GraphOther)entityMap.get(otherKey);
                if (gOther == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerOtherL1.class.getName(), "getSwitchFromHost", "MIssing host");
                    continue;
                }
                if (switchId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromHost", "SWITCH_WWN is NULL");
                    continue;
                }
                String switchKey = prefixId + switchId;
                gSwitch = (GraphSwitch)entityMap.get(switchKey);
                if (gSwitch != null) continue;
                gSwitch = new GraphSwitch(switchKey);
                this.populator.populateSwitch(resultSet, gSwitch, true);
                if (model != null) {
                    model.put(gSwitch);
                }
                if (entityMap == null) continue;
                entityMap.put(switchKey, gSwitch);
            }
        }
        finally {
            block36: {
                block35: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block35;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block36;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", e);
                }
            }
        }
        i = false;
        try {
            stmt = con.prepareStatement(SELECT_SWITCH2OTHER_FROM_OTHER);
            stmt.setInt(1, id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                otherPrefixId = (String)resultSet.getObject("OTHER_PREFIX_ID");
                otherId = (Integer)resultSet.getObject("OTHER_ID");
                prefixId = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                switchId = (Integer)resultSet.getObject("SWITCH_ID");
                Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                String otherKey = otherPrefixId + otherId;
                GraphOther gOther = (GraphOther)entityMap.get(otherKey);
                if (gOther == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerOtherL1.class.getName(), "getSwitchFromHost", "MIssing host");
                    continue;
                }
                if (switchId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromHost", "SWITCH_WWN is NULL");
                    continue;
                }
                String switchKey = prefixId + switchId;
                gSwitch = (GraphSwitch)entityMap.get(switchKey);
                if (gSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromHost", "SWITCH not found");
                    continue;
                }
                String switch2otherKey = "port2port:" + prefixId + switchId + ',' + otherPrefixId + otherId + ',' + port2portId;
                GraphSwitch2Other switch2other = (GraphSwitch2Other)entityMap.get(switch2otherKey);
                if (switch2other != null) continue;
                switch2other = new GraphSwitch2Other(switch2otherKey);
                switch2other.setOtherID((GraphOther.ID)gOther.getEntityID());
                switch2other.setSwitchID((GraphSwitch.ID)gSwitch.getEntityID());
                this.populator.populatePort2Port(resultSet, switch2other);
                model.put(switch2other);
                entityMap.put(switch2otherKey, switch2other);
            }
        }
        finally {
            block39: {
                block38: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block38;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block39;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", e);
                }
            }
        }
    }

    public void getZonesFromOther(Connection con, GraphModel model, HashMap entityMap, int id) throws SQLException {
        this.getZonesFromEntitiesConnectedToEntity(con, model, entityMap, new Object[]{new Integer(id)}, new String[]{SELECT_FABRIC_FROM_ZONES_FROM_OTHER, SELECT_ZONES_FROM_OTHER, SELECT_ZSET_FROM_OTHER, SELECT_ZSET2ZONE_FROM_OTHER, SELECT_ZONE2MEMBER_FROM_OTHER});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getView(Connection con, ViewerRequest rqst, ViewerResponse resp, int operationId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL2.class.getName(), "getView", "");
        }
        GraphModelOtherL1 gModel = null;
        Object otherId = null;
        GraphModel.MultiEntityID multiNodeModelID = (GraphModel.MultiEntityID)rqst.getModelID();
        this.removeTmpHosts(con, operationId);
        try {
            this.setTmpEntity(con, multiNodeModelID.getChildFocusEntityIDs(), operationId);
            HashMap entityMap = new HashMap();
            Timestamp prevUpdate = rqst.getTimestamp();
            Timestamp lastUpdate = null;
            if (lastUpdate == null || prevUpdate == null || lastUpdate.after(prevUpdate)) {
                gModel = new GraphModelOtherL1((GraphModelOtherL1.ID)rqst.getModelID());
                this.getOther(con, gModel, entityMap, operationId);
                this.getSwitchFromOther(con, gModel, entityMap, operationId);
                this.getSansFromSwitch(con, gModel, entityMap, operationId);
                this.commit(con);
                if (rqst.getModelID().isNeedZoneData()) {
                    this.getZonesFromOther(con, gModel, entityMap, operationId);
                    this.commit(con);
                }
                gModel.setWithZoneData(rqst.getModelID().isNeedZoneData());
                resp.addResponse(0, gModel);
            } else {
                resp.addResponse(0, null);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(ViewerSubsystemL2.class.getName(), "getView", "");
            }
        }
        finally {
            this.removeTmpHosts(con, operationId);
        }
    }
}

