/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL1;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Lun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL2;

public class ViewerServerL1
extends ViewerServerL0 {
    private static final boolean debug = false;
    public static final String SELECT_HOST = "SELECT \t\tT_RES_HOST.PREFIX_ID, \t    CASE WHEN T_RES_HOST.HOST_NAME IS NOT NULL THEN T_RES_HOST.HOST_NAME \t\t\t WHEN T_RES_HOST.HOST_URL IS NOT NULL THEN T_RES_HOST.HOST_URL \t\t\t ELSE CAST(T_RES_HOST.COMPUTER_ID as CHAR(10)) \t\tEND  DISPLAY_NAME,        T_RES_HOST.DEV_STATUS DEV_STATUS,        T_RES_HOST.DAT_STATUS DAT_STATUS, \t\tT_RES_HOST.HOST_NAME HOST_NAME, \t\tT_RES_HOST.COMPUTER_ID HOST_ID, \t\tT_RES_HOST.GUID GUID, \t\tT_RES_HOST.OS_TYPE OS_TYPE,\t\tT_RES_HOST.OS_VERSION OS_VERSION,\t\tT_RES_HOST.TIME_ZONE TIME_ZONE,\t\tT_RES_HOST.IP_ADDRESS IP_ADDRESS,\t\tT_RES_HOST.DETECTABLE DETECTABLE, \t\tT_RES_HOST.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_HOST.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_HOST.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_HOST.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_HOST.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_HOST.USER_ATTRIB3 USER_ATTRIB3  FROM \tT_VIEW_VHOST T_RES_HOST,\tT_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \tT_RES_HOST.PREFIX_ID = TMP.PREFIX_ID and \tT_RES_HOST.COMPUTER_ID = TMP.ENTITY_ID and  \tTMP.ID = ?";
    public static final String SELECT_SWITCH_FROM_HOST = "SELECT \tTMP.PREFIX_ID HOST_PREFIX_ID, \tTMP.ENTITY_ID HOST_ID, \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3 ,\t SWITCH2HOST.SWITCH_PORT_ID PORT_ID FROM T_VIEW_VSWITCH2HOST SWITCH2HOST,     T_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_VENDOR VENDOR on     T_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on     T_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID =? and \t TMP.PREFIX_ID = SWITCH2HOST.HOST_PREFIX_ID and \t TMP.ENTITY_ID = SWITCH2HOST.HOST_ID and     SWITCH2HOST.SWITCH_ID = T_RES_SWITCH.SWITCH_ID ";
    public static final String SELECT_SWITCH2HOST_FROM_HOST = "SELECT distinct \t SWITCH2HOST.HOST_PREFIX_ID, \t SWITCH2HOST.HOST_ID, \t SWITCH2HOST.SWITCH_PREFIX_ID SWITCH_PREFIX_ID, \t SWITCH2HOST.SWITCH_ID,\t SWITCH2HOST.PORT2PORT_ID PORT2PORT_ID,\t SWITCH2HOST.DETECTABLE DETECTABLE FROM T_VIEW_VSWITCH2HOST SWITCH2HOST, T_RES_TMP_TOPOLOGY_ENTITY TMP where     TMP.ID = ? and \t TMP.PREFIX_ID = SWITCH2HOST.HOST_PREFIX_ID and \t TMP.ENTITY_ID = SWITCH2HOST.HOST_ID ";
    public static final String SELECT_HOST2SUBSYSTEM_FROM_HOST = "SELECT     TMP.PREFIX_ID HOST_PREFIX_ID, \t TMP.ENTITY_ID HOST_ID, \t T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID, \t HOST2SUBSYSTEM.PORT2PORT_ID PORT2PORT_ID, \t HOST2SUBSYSTEM.DETECTABLE DETECTABLE, \t HOST2SUBSYSTEM.SUBSYSTEM_PORT_ID PORT_ID FROM T_VIEW_VHOST2SUBSYSTEM HOST2SUBSYSTEM,    T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on     T_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on     T_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t TMP.PREFIX_ID = HOST2SUBSYSTEM.HOST_PREFIX_ID and \t TMP.ENTITY_ID = HOST2SUBSYSTEM.HOST_ID and     HOST2SUBSYSTEM.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID ";
    public static final String SELECT_FABRIC_FROM_ZONES_FROM_HOST = "SELECT DISTINCT \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VHOST2PORT HOST2PORT,     T_VIEW_PORT2ZONE PORT2ZONE,  \t T_RES_ZONE, T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE    TMP.ID = ? and \tTMP.PREFIX_ID = HOST2PORT.PREFIX_ID and    TMP.ENTITY_ID = HOST2PORT.HOST_ID and \tHOST2PORT.PORT_ID = PORT2ZONE.PORT_ID and \tPORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \tT_RES_ZONE.FABRIC_WWN = T_RES_FABRIC.FABRIC_WWN";
    public static final String SELECT_ZONES_FROM_HOST = "SELECT DISTINCT    T_RES_ZONE.ZONE_ID ZONE_ID, \tT_RES_ZONE.ZONE_TYPE ZONE_TYPE, \tT_RES_ZONE.ACTIVE ACTIVE,\tT_RES_ZONE.ZONE_NAME ZONE_NAME, \tT_RES_ZONE.FABRIC_WWN FABRIC_WWN, \tT_RES_ZONE.DESCRIPTION DESCRIPTION,  \tT_RES_ZONE.ZONE_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VHOST2PORT HOST2PORT,T_VIEW_PORT2ZONE PORT2ZONE,    T_RES_ZONE, T_RES_FABRIC FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t TMP.PREFIX_ID = HOST2PORT.PREFIX_ID and \t TMP.ENTITY_ID = HOST2PORT.HOST_ID and     HOST2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \t T_RES_ZONE.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static final String SELECT_ZONE2MEMBER_FROM_HOST = "SELECT DISTINCT     PORT2ZONE2.ZONE_ID ZONE_ID,     ENTITY_TO_PORT.PORT_ID PORT_ID,\t ENTITY_TO_PORT.TYPE, \t ENTITY_TO_PORT.PREFIX_ID, \t ENTITY_TO_PORT.ENTITY_ID, \t ENTITY_TO_PORT.DISPLAY_NAME, \t ENTITY_TO_PORT.PORT_DISPLAY_NAME, \t PORT2ZONE2.MEMBER_NAME, \t PORT2ZONE2.ZONE_MEMBER_ID,     PORT.PORT_NUMBER FROM T_VIEW_VHOST2PORT HOST2PORT,T_VIEW_PORT2ZONE PORT2ZONE1,T_VIEW_PORT2ZONE PORT2ZONE2 left outer join \t T_VIEW_ENTITY_TO_PORT ENTITY_TO_PORT on \t PORT2ZONE2.PORT_ID = ENTITY_TO_PORT.PORT_ID left outer join T_RES_PORT PORT on  \t PORT2ZONE2.PORT_ID = PORT.PORT_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE     TMP.ID = ? and \t TMP.PREFIX_ID = HOST2PORT.PREFIX_ID and \t TMP.ENTITY_ID = HOST2PORT.HOST_ID and     HOST2PORT.PORT_ID = PORT2ZONE1.PORT_ID and \t PORT2ZONE1.ZONE_ID = PORT2ZONE2.ZONE_ID  ";
    public static final String SELECT_ZSET2ZONE_FROM_HOST = "SELECT DISTINCT     PORT2ZONE.ZONE_ID ZONE_ID,     ZSET2ZONE.ZSET_ID ZSET_ID FROM T_VIEW_VHOST2PORT HOST2PORT, T_VIEW_PORT2ZONE PORT2ZONE, \tT_RES_ZSET2ZONE ZSET2ZONE, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t TMP.PREFIX_ID = HOST2PORT.PREFIX_ID and \t TMP.ENTITY_ID = HOST2PORT.HOST_ID and     HOST2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = ZSET2ZONE.ZONE_ID";
    public static final String SELECT_ZSET_FROM_HOST = "SELECT DISTINCT    T_RES_ZSET.ZSET_ID, \tT_RES_ZSET.ACTIVE ACTIVE,\tT_RES_ZSET.ZSET_NAME ZSET_NAME, \tT_RES_ZSET.FABRIC_WWN FABRIC_WWN, \tT_RES_ZSET.DESCRIPTION DESCRIPTION,    T_RES_ZSET.ZSET_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VHOST2PORT HOST2PORT, T_VIEW_PORT2ZSET PORT2ZSET,     T_RES_ZSET, T_RES_FABRIC FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t TMP.PREFIX_ID = HOST2PORT.PREFIX_ID and \t TMP.ENTITY_ID = HOST2PORT.HOST_ID and     HOST2PORT.PORT_ID = PORT2ZSET.PORT_ID and     PORT2ZSET.ZSET_ID = T_RES_ZSET.ZSET_ID and \t T_RES_ZSET.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static String SELECT_SANS_FOR_HOST = "SELECT\t\tHOST2FABRIC.PREFIX_ID PREFIX_ID,\t\tHOST2FABRIC.HOST_ID HOST_ID,\t    HOST2FABRIC.FABRIC_ID FABRIC_ID FROM T_VIEW_VHOST2FABRIC HOST2FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t    TMP.ID = ? and \t\tTMP.PREFIX_ID = HOST2FABRIC.PREFIX_ID and \t    TMP.ENTITY_ID = HOST2FABRIC.HOST_ID ";
    public static final String SELECT_SANS_FROM_SWITCH_FROM_HOST = "SELECT \tSWITCH2FABRIC.PREFIX_ID, \tSWITCH2FABRIC.SWITCH_ID SWITCH_ID, \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3  FROM     T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_VIEW_VSWITCH2HOST SWITCH2HOST, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \tT_RES_FABRIC.FABRIC_ID = SWITCH2FABRIC.FABRIC_ID and \tSWITCH2FABRIC.SWITCH_ID = SWITCH2HOST.SWITCH_ID and    TMP.PREFIX_ID = SWITCH2HOST.HOST_PREFIX_ID and \tTMP.ENTITY_ID = SWITCH2HOST.HOST_ID and \tTMP.ID = ?";
    public static final String SELECT_SANS_FROM_DIRECTLY_ATTACHED_SUBSYSTEM_FROM_HOST = "SELECT \t SUBSYSTEM2FABRIC.SUBSYSTEM_ID SUBSYSTEM_ID,\t SUBSYSTEM2FABRIC.FABRIC_ID FABRIC_ID FROM  T_VIEW_VHOST2SUBSYSTEM HOST2SUBSYSTEM, T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \tSUBSYSTEM2FABRIC.SUBSYSTEM_ID = HOST2SUBSYSTEM.SUBSYSTEM_ID and    HOST2SUBSYSTEM.HOST_ID = TMP.ENTITY_ID and \tTMP.PREFIX_ID = 'server:' and \tTMP.ID = ?";
    public static final String SELECT_FILESYSTEM_SIMPLE_FROM_LUN = "SELECT distinct \tTMP.PREFIX_ID,\tTMP.ENTITY_ID HOST_ID, \tfs.filesystem_id, \tda.LUN, \tssluncmp.SVID volume_id, \tfs.logical_disk_id, \tsd.disk_id, \tc.host_name,  \tvendor.vendor_name, \tfs.mount_point, \tfs.capacity,  \tfs.free_space, \tfs.filesystem_id, \tda.path, ss.os_type,  \tcase \t\twhen ss.user_provided_name is not null and ss.user_provided_name not in '' then ss.user_provided_name    \t\telse ss.display_name \tend display_name, \tshare.name, \tssluncmp.lun_id,  \tsd.capacity, \tsv.display_name, \tcimv.device_id   FROM \tt_res_host c, t_res_storage_subsystem ss, t_res_dev_access da, t_stat_disk sd, \tt_res_filesystem fs, t_res_chunk chunk, t_res_share share, t_res_vendor vendor, \tt_res_view_ssluncmp ssluncmp, t_res_storage_volume sv, t_res_cimkey_volume cimv,   \tT_RES_TMP_TOPOLOGY_ENTITY TMP WHERE  \tTMP.ID = ? and \tTMP.PREFIX_ID = 'server:' and \tTMP.ENTITY_ID = ssluncmp.computer_id and \tssluncmp.computer_id = c.computer_id and  \tssluncmp.svid = sv.svid and  \tsv.svid = cimv.volume_id and  \tssluncmp.subsystem_id = ss.subsystem_id and  \tss.vendor_id = vendor.vendor_id and  \tssluncmp.physical_volume_id = sd.disk_id and  \tsd.disk_id = chunk.disk_id and  \tssluncmp.physical_volume_id = da.device_id and  \tc.computer_id = fs.computer_id and  \tfs.logical_disk_id = chunk.logical_disk_id and  \tshare.resource_id = chunk.logical_disk_id ";
    public static final String SELECT_DIRECTLY_ATTACHED_SUBSYSTEM_FROM_HOST = "SELECT \tTMP.PREFIX_ID HOST_PREFIX_ID,\tTMP.ENTITY_ID HOST_ID, \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 ,\t HOST2SUBSYSTEM.SUBSYSTEM_PORT_ID PORT_ID FROM T_VIEW_VHOST2SUBSYSTEM HOST2SUBSYSTEM,     T_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on     T_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on     T_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t TMP.PREFIX_ID = HOST2SUBSYSTEM.HOST_PREFIX_ID and \t TMP.ENTITY_ID = HOST2SUBSYSTEM.HOST_ID and     HOST2SUBSYSTEM.SUBSYSTEM_PREFIX_ID = T_RES_STORAGE_SUBSYSTEM.PREFIX_ID and \t HOST2SUBSYSTEM.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID ";
    public static final String SELECT_LUN_FROM_HOST = "SELECT distinct     LUN2HOST.PREFIX_ID,     LUN2HOST.HOST_ID HOST_ID,     LUN2HOST.HOST_LUN_ID HOST_LUN_ID,     LUN2HOST.VOLUME_ID VOLUME_ID, \tLUN2HOST.PATH,   \tLUN2HOST.DEVICE_ID FROM (SELECT DISTINCT \t 'server:' PREFIX_ID, \t COMPUTER.COMPUTER_ID HOST_ID,     ACCESS.LUN HOST_LUN_ID, \t VOLUME.SVID VOLUME_ID, \t ACCESS.PATH PATH,   \t ACCESS.DEVICE_ID FROM \tT_RES_HOST COMPUTER,    T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME \tleft outer join T_RES_STORAGE_VOLUME VOLUME on \t\tlower(PHYSICAL_VOLUME.SUBSYSTEM_SERIAL_NUMBER || '/' || PHYSICAL_VOLUME.SERIAL_NUMBER) \t \t= lower(VOLUME.UNIQUE_ID),    T_RES_DEV_ACCESS ACCESS,    T_RES_CONTROLLER CONTROLLER WHERE     PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND    CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID UNION (SELECT DISTINCT   \t HOST.PREFIX_ID,   \t HOST.COMPUTER_ID HOST_ID,   \t DATA_PATH.HOST_LUN_ID,   \t DATA_PATH.VOLUME_ID VOLUME_ID,   \t CAST('n/a' as VARCHAR(255)) PATH,  \t CAST(NULL as INTEGER) DEVICE_ID FROM   \tT_RES_DATA_PATH DATA_PATH,     \tT_VIEW_VHOST HOST, T_VIEW_VHOST2PORT HOST2PORT, (SELECT DISTINCT   \tHOST.PREFIX_ID,  \tHOST.COMPUTER_ID HOST_ID,   \tDATA_PATH.VOLUME_ID VOLUME_ID FROM   \tT_RES_DATA_PATH DATA_PATH,     \tT_VIEW_VHOST HOST, T_VIEW_VHOST2PORT HOST2PORT WHERE   \tHOST.PREFIX_ID = HOST2PORT.PREFIX_ID and   \tHOST.COMPUTER_ID = HOST2PORT.HOST_ID and   \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID EXCEPT SELECT DISTINCT                   'server:' PREFIX_ID, \tCOMPUTER.COMPUTER_ID HOST_ID, \t VOLUME.SVID VOLUME_ID FROM   \tT_RES_HOST COMPUTER,     T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME   \tleft outer join T_RES_STORAGE_VOLUME VOLUME on   \t\tlower(PHYSICAL_VOLUME.SUBSYSTEM_SERIAL_NUMBER || '/' || PHYSICAL_VOLUME.SERIAL_NUMBER) \t \t= lower(VOLUME.UNIQUE_ID),    T_RES_DEV_ACCESS ACCESS,     T_RES_CONTROLLER CONTROLLER WHERE       PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND     CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID) HOST2DATAPATH_IN WHERE   \tHOST2DATAPATH_IN.PREFIX_ID = HOST.PREFIX_ID and \tHOST2DATAPATH_IN.HOST_ID = HOST.COMPUTER_ID and  \tHOST2DATAPATH_IN.VOLUME_ID = DATA_PATH.VOLUME_ID and \tHOST.PREFIX_ID = HOST2PORT.PREFIX_ID and   \tHOST.COMPUTER_ID = HOST2PORT.HOST_ID and   \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID )) LUN2HOST, \tT_RES_TMP_TOPOLOGY_ENTITY TMP WHERE     TMP.ID = ? and \t TMP.PREFIX_ID = LUN2HOST.PREFIX_ID and \t TMP.ENTITY_ID = LUN2HOST.HOST_ID";
    public static final String SELECT_ARRAYS_FROM_VOLUMES_FROM_HOST = "SELECT distinct \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 ,\tSUBSYSTEM2HOST.VOLUME_ID VOLUME_ID, \tSUBSYSTEM2HOST.PREFIX_ID HOST_PREFIX_ID, \tSUBSYSTEM2HOST.HOST_ID FROM (SELECT DISTINCT \t'server:' PREFIX_ID, \tCOMPUTER.COMPUTER_ID HOST_ID,  \tVOLUME.SVID VOLUME_ID, \tSUBSYSTEM.SUBSYSTEM_ID FROM \tT_RES_HOST COMPUTER,    T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME,    T_RES_DEV_ACCESS ACCESS,    T_RES_CONTROLLER CONTROLLER, \tT_RES_STORAGE_VOLUME VOLUME,\tT_RES_STORAGE_SUBSYSTEM SUBSYSTEM  WHERE  \tSUBSYSTEM.SUBSYSTEM_ID = VOLUME.SUBSYSTEM_ID and \tlower(PHYSICAL_VOLUME.SUBSYSTEM_SERIAL_NUMBER || '/' || PHYSICAL_VOLUME.SERIAL_NUMBER) = lower(VOLUME.UNIQUE_ID) and    PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND    CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID UNION SELECT DISTINCT \t HOST.PREFIX_ID, \t HOST.COMPUTER_ID HOST_ID, \t DATA_PATH.VOLUME_ID, \t DATA_PATH.SUBSYSTEM_ID FROM \tT_RES_DATA_PATH DATA_PATH, T_RES_STORAGE_VOLUME VOLUME,  \tT_VIEW_VHOST HOST, T_VIEW_VHOST2PORT HOST2PORT WHERE \tHOST.PREFIX_ID = HOST2PORT.PREFIX_ID and \tHOST.COMPUTER_ID = HOST2PORT.HOST_ID and \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID ) SUBSYSTEM2HOST, T_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on  \tT_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \tT_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID, \tT_RES_TMP_TOPOLOGY_ENTITY TMP WHERE     TMP.ID = ? and \t TMP.PREFIX_ID = SUBSYSTEM2HOST.PREFIX_ID and \t TMP.ENTITY_ID = SUBSYSTEM2HOST.HOST_ID and \t SUBSYSTEM2HOST.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID";
    public static final String SELECT_VOLUMES_FROM_HOST = "SELECT distinct     VOLUMES2HOST.PREFIX_ID, \t VOLUMES2HOST.HOST_ID HOST_ID,     CASE WHEN T_RES_STORAGE_VOLUME.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_STORAGE_VOLUME.DISPLAY_NAME) != '' THEN T_RES_STORAGE_VOLUME.DISPLAY_NAME \t\t  WHEN T_RES_STORAGE_VOLUME.SVID IS NOT NULL THEN CAST(T_RES_STORAGE_VOLUME.SVID as CHAR) \t END DISPLAY_NAME, T_RES_STORAGE_VOLUME.SVID SVID, T_RES_STORAGE_VOLUME.NAME || '+' || CAST(T_RES_STORAGE_VOLUME.NAME_FORMAT as CHAR) NATURAL_KEY, (T_RES_STORAGE_VOLUME.CAPACITY*512) CAPACITY, T_RES_STORAGE_VOLUME.POOL_ID POOL_ID, T_RES_STORAGE_VOLUME.FORMAT FORMAT, T_RES_STORAGE_VOLUME.IS_ASSIGNED IS_ASSIGNED, T_RES_STORAGE_VOLUME.USER_ATTRIB1 USER_ATTRIB1, T_RES_STORAGE_VOLUME.USER_ATTRIB2 USER_ATTRIB2, T_RES_STORAGE_VOLUME.USER_ATTRIB3 USER_ATTRIB3, T_RES_STORAGE_VOLUME.DETECTABLE DETECTABLE, T_RES_STORAGE_VOLUME.OPERATIONAL_STATUS OPERATIONAL_STATUS, T_RES_STORAGE_VOLUME.CONSOLIDATED_STATUS CONSOLIDATED_STATUS  FROM (SELECT DISTINCT \t 'server:' PREFIX_ID, \t COMPUTER.COMPUTER_ID HOST_ID,     VOLUME.SVID VOLUME_ID FROM \tT_RES_HOST COMPUTER,    T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME,    T_RES_DEV_ACCESS ACCESS,    T_RES_CONTROLLER CONTROLLER, \tT_RES_STORAGE_VOLUME VOLUME  WHERE  \tlower(PHYSICAL_VOLUME.SUBSYSTEM_SERIAL_NUMBER || '/' || PHYSICAL_VOLUME.SERIAL_NUMBER) = lower(VOLUME.UNIQUE_ID) and    PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND    CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID UNION SELECT DISTINCT \tHOST.PREFIX_ID, \tHOST.COMPUTER_ID HOST_ID, \tDATA_PATH.VOLUME_ID VOLUME_ID FROM \tT_RES_DATA_PATH DATA_PATH, T_RES_STORAGE_VOLUME VOLUME,  \tT_VIEW_VHOST HOST, T_VIEW_VHOST2PORT HOST2PORT WHERE \tHOST.PREFIX_ID = HOST2PORT.PREFIX_ID and \tHOST.COMPUTER_ID = HOST2PORT.HOST_ID and \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID ) VOLUMES2HOST,     T_RES_STORAGE_VOLUME, \t T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE     TMP.ID = ? and \t TMP.PREFIX_ID = VOLUMES2HOST.PREFIX_ID and \t TMP.ENTITY_ID = VOLUMES2HOST.HOST_ID and \t T_RES_STORAGE_VOLUME.SVID = VOLUMES2HOST.VOLUME_ID";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphComputer getHost(Connection con, GraphModel model, HashMap entityMap, int Id) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphComputer gHost = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_HOST);
            stmt.setInt(1, Id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer hostIdNew = (Integer)resultSet.getObject("HOST_ID");
                if (hostIdNew == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystem", "Host ID is NULL");
                    continue;
                }
                String hostKey = prefixId + hostIdNew;
                if (entityMap == null || entityMap.get(hostKey) == null) {
                    gHost = new GraphComputer(hostKey);
                    this.populator.populateHost(resultSet, gHost);
                    if (model != null) {
                        model.put(gHost);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(hostKey, gHost);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystem", "Duplicated Host entry:" + hostKey);
            }
        }
        finally {
            block19: {
                block18: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block18;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block19;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                }
            }
        }
        return gHost;
    }

    public void getZonesFromHost(Connection con, GraphModel model, HashMap entityMap, int switchId) throws SQLException {
        this.getZonesFromEntitiesConnectedToEntity(con, model, entityMap, new Object[]{new Integer(switchId)}, new String[]{SELECT_FABRIC_FROM_ZONES_FROM_HOST, SELECT_ZONES_FROM_HOST, SELECT_ZSET_FROM_HOST, SELECT_ZSET2ZONE_FROM_HOST, SELECT_ZONE2MEMBER_FROM_HOST});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitch2HostFromHost(Connection srmConnection, GraphModel model, HashMap entityMap, int id) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL1.class.getName(), "getSwitch2HostFromHost", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        boolean i = false;
        try {
            stmt = srmConnection.prepareStatement(SELECT_SWITCH2HOST_FROM_HOST);
            stmt.setInt(1, id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String hostPrefixId = (String)resultSet.getObject("HOST_PREFIX_ID");
                Integer hostId = (Integer)resultSet.getObject("HOST_ID");
                String switchPrefixId = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                Integer switchId = (Integer)resultSet.getObject("SWITCH_ID");
                Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                GraphComputer gHost = (GraphComputer)entityMap.get(hostPrefixId + hostId);
                if (gHost == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2HostFromHost", "host not found:" + id);
                    continue;
                }
                if (switchId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2HostFromHost", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String switchKey = switchPrefixId + switchId;
                GraphSwitch gSwitch = (GraphSwitch)entityMap.get(switchKey);
                if (gSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2HostFromHost", "Switch not found:" + switchKey);
                    continue;
                }
                String switch2serverKey = "port2port:" + hostPrefixId + hostId + ',' + switchPrefixId + switchId + ',' + port2portId;
                if (entityMap.get(switch2serverKey) == null) {
                    GraphSwitch2Computer switch2server = new GraphSwitch2Computer(switch2serverKey);
                    switch2server.setComputerID((GraphComputer.ID)gHost.getEntityID());
                    switch2server.setSwitchID((GraphSwitch.ID)gSwitch.getEntityID());
                    this.populator.populatePort2Port(resultSet, switch2server);
                    model.put(switch2server);
                    entityMap.put(switch2serverKey, switch2server);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2HostFromHost", "Duplicated :" + switch2serverKey);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch2HostFromHost", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch2HostFromHost", e);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL1.class.getName(), "getSwitch2HostFromHost", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getHost2VolumeFromHost(Connection srmConnection, GraphModel model, HashMap entityMap, int id) throws SQLException {
        Integer hostId;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        boolean i = false;
        try {
            stmt = srmConnection.prepareStatement(SELECT_VOLUMES_FROM_HOST);
            stmt.setInt(1, id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String hostPrefixId = (String)resultSet.getObject("PREFIX_ID");
                hostId = (Integer)resultSet.getObject("HOST_ID");
                Integer volumeId = (Integer)resultSet.getObject("SVID");
                if (volumeId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String hostKey = hostPrefixId + hostId;
                GraphComputer gHost = (GraphComputer)entityMap.get(hostKey);
                if (gHost == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "host not found:" + hostKey);
                    continue;
                }
                String volumeKey = "volume:" + volumeId;
                GraphVolume gVolume = (GraphVolume)entityMap.get(volumeKey);
                if (gVolume == null) {
                    gVolume = new GraphVolume(volumeKey);
                    this.populator.populateStorageVolume(resultSet, gVolume);
                    entityMap.put(volumeKey, gVolume);
                    model.put(gVolume);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + volumeKey);
                }
                String server2volumeKey = "server2volume:" + hostId + ',' + volumeId;
                if (entityMap.get(server2volumeKey) == null) {
                    GraphComputer2Volume gServer2volume = new GraphComputer2Volume(server2volumeKey);
                    gServer2volume.setComputerID((GraphComputer.ID)gHost.getEntityID());
                    gServer2volume.setVolumeID((GraphVolume.ID)gVolume.getEntityID());
                    model.put(gServer2volume);
                    entityMap.put(server2volumeKey, gServer2volume);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + server2volumeKey);
            }
        }
        finally {
            block45: {
                block44: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block44;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getHost2VolumeFromHost", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block45;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getHost2VolumeFromHost", e);
                }
            }
        }
        try {
            stmt = srmConnection.prepareStatement(SELECT_ARRAYS_FROM_VOLUMES_FROM_HOST);
            stmt.setInt(1, id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                GraphVolume gVolume;
                String prefixId = (String)resultSet.getObject("HOST_PREFIX_ID");
                hostId = (Integer)resultSet.getObject("HOST_ID");
                Integer subsystemId = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                Integer volumeId = (Integer)resultSet.getObject("VOLUME_ID");
                String hostKey = prefixId.toString() + hostId;
                GraphComputer gHost = (GraphComputer)entityMap.get(hostKey);
                if (gHost == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "host not found:" + hostKey);
                    continue;
                }
                if (subsystemId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String subsystemKey = "subsystem:" + subsystemId;
                String volumeKey = "volume:" + volumeId;
                GraphSubsystem gSubsystem = (GraphSubsystem)entityMap.get(subsystemKey);
                if (gSubsystem == null) {
                    gSubsystem = new GraphSubsystem(subsystemKey);
                    this.populator.populateSubsystem(resultSet, gSubsystem);
                    entityMap.put(subsystemKey, gSubsystem);
                    model.put(gSubsystem);
                }
                if ((gVolume = (GraphVolume)entityMap.get(volumeKey)) != null) {
                    String array2volumeKey = "subsystem2volume:" + subsystemId + ',' + volumeId;
                    GraphSubsystem2Volume array2volume = new GraphSubsystem2Volume(array2volumeKey);
                    array2volume.setSubsystemID((GraphSubsystem.ID)gSubsystem.getEntityID());
                    array2volume.setVolumeID((GraphVolume.ID)gVolume.getEntityID());
                    entityMap.put(array2volumeKey, array2volume);
                    model.put(array2volume);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + subsystemKey);
                }
                String server2volumeKey = "server2volume:" + hostId + ',' + volumeId;
                if (entityMap.get(server2volumeKey) == null) {
                    GraphComputer2Volume gServer2volume = new GraphComputer2Volume(server2volumeKey);
                    gServer2volume.setComputerID((GraphComputer.ID)gHost.getEntityID());
                    gServer2volume.setVolumeID((GraphVolume.ID)gVolume.getEntityID());
                    model.put(gServer2volume);
                    entityMap.put(server2volumeKey, gServer2volume);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + server2volumeKey);
            }
        }
        finally {
            block48: {
                block47: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block47;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block48;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", e);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitchFromHost(Connection con, GraphModel model, HashMap entityMap, int id) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphSwitch gSwitch = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_SWITCH_FROM_HOST);
            stmt.setInt(1, id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String hostPrefixId = (String)resultSet.getObject("HOST_PREFIX_ID");
                Integer hostId = (Integer)resultSet.getObject("HOST_ID");
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer switchId = (Integer)resultSet.getObject("SWITCH_ID");
                GraphComputer gHost = (GraphComputer)entityMap.get(hostPrefixId + hostId);
                if (gHost == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromHost", "MIssing host");
                    continue;
                }
                if (switchId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromHost", "SWITCH_WWN is NULL");
                    continue;
                }
                String switchKey = prefixId + switchId;
                if (entityMap == null || entityMap.get(switchKey) == null) {
                    gSwitch = new GraphSwitch(switchKey);
                    this.populator.populateSwitch(resultSet, gSwitch, true);
                    if (model != null) {
                        model.put(gSwitch);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(switchKey, gSwitch);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitch", "Duplicated Switch entry:" + switchKey);
            }
        }
        finally {
            block20: {
                block19: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block19;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block20;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSubsystemFromHost(Connection con, GraphModel model, HashMap entityMap, int id) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphSubsystem gArray = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_DIRECTLY_ATTACHED_SUBSYSTEM_FROM_HOST);
            stmt.setInt(1, id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String hostPrefixId = (String)resultSet.getObject("HOST_PREFIX_ID");
                Integer hostId = (Integer)resultSet.getObject("HOST_ID");
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer subsystemId = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                GraphComputer gHost = (GraphComputer)entityMap.get(hostPrefixId + hostId);
                if (gHost == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystemFromHost", "Host not found server:" + hostId);
                    continue;
                }
                if (subsystemId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystemFromHost", "SUBSYSTEM_ID is NULL");
                    continue;
                }
                String arrayKey = prefixId + subsystemId;
                if (entityMap == null || entityMap.get(arrayKey) == null) {
                    gArray = new GraphSubsystem(arrayKey);
                    this.populator.populateSubsystem(resultSet, gArray);
                    if (model != null) {
                        model.put(gArray);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(arrayKey, gArray);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystemFromHost", "Duplicated Subsystem entry:" + arrayKey);
            }
        }
        finally {
            block20: {
                block19: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block19;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block20;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                }
            }
        }
    }

    public void getHost2SubsystemFromHost(Connection con, GraphModel model, HashMap entityMap, int id) throws SQLException {
        long init = System.currentTimeMillis();
        Object stmt = null;
        Object resultSet = null;
    }

    public void commit(Connection con) {
        block2: {
            try {
                con.commit();
            }
            catch (SQLException e) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL1.class.getName(), "commit", e);
            }
        }
    }

    public void getSansFromHost(Connection con, GraphModel model, HashMap entityMap, String prefixId, int hostId) throws SQLException {
        this.getSansFromHost(con, model, entityMap, prefixId, new Integer(hostId), SELECT_SANS_FOR_HOST);
    }

    public void getSansFromSubsystem(Connection con, GraphModel model, HashMap entityMap, String prefixId, int subsystemId) throws SQLException {
        this.getSansFromSubsystem(con, model, entityMap, prefixId, new Integer(subsystemId), SELECT_SANS_FROM_DIRECTLY_ATTACHED_SUBSYSTEM_FROM_HOST);
    }

    public void getSansFromSwitch(Connection con, GraphModel model, HashMap entityMap, int Id) throws SQLException {
        this.getSansFromSwitch(con, model, entityMap, new Object[]{new Integer(Id)}, SELECT_SANS_FROM_SWITCH_FROM_HOST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLUN(Connection con, GraphModel model, HashMap entityMap, int id) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        Object gArray = null;
        boolean i = false;
        Object gPool = null;
        i = false;
        init = System.currentTimeMillis();
        gArray = null;
        i = false;
        try {
            stmt = con.prepareStatement(SELECT_LUN_FROM_HOST);
            stmt.setInt(1, id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer volumeId = (Integer)resultSet.getObject("VOLUME_ID");
                Integer hostId = (Integer)resultSet.getObject("HOST_ID");
                Integer deviceId = (Integer)resultSet.getObject("DEVICE_ID");
                Integer lunId = (Integer)resultSet.getObject("HOST_LUN_ID");
                String path = (String)resultSet.getObject("PATH");
                String lunKey = "lun:" + deviceId;
                GraphLun gLun = new GraphLun(lunKey);
                if (lunId != null) {
                    try {
                        gLun.setLunID(new Integer(lunId));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                gLun.setDisplayName(path);
                gLun.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                GraphComputer gHost = (GraphComputer)entityMap.get("server:" + hostId);
                if (gHost == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getHostFromSubsystem", "Host not found: server:" + hostId);
                    continue;
                }
                GraphVolume gVolume = (GraphVolume)entityMap.get("volume:" + volumeId);
                if (gVolume == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getHostFromSubsystem", "Volume not found: volume:" + volumeId);
                    continue;
                }
                model.put(gLun);
                entityMap.put(lunKey, gLun);
                String host2lunKey = "server2lun:" + hostId + ',' + deviceId;
                GraphComputer2Lun host2lun = new GraphComputer2Lun(host2lunKey);
                host2lun.setLunID((GraphLun.ID)gLun.getEntityID());
                host2lun.setComputerID((GraphComputer.ID)gHost.getEntityID());
                model.put(host2lun);
                entityMap.put(host2lunKey, host2lun);
                String volume2lunKey = "lun2volume:" + volumeId + ',' + deviceId;
                GraphVolume2Lun volume2lun = new GraphVolume2Lun(volume2lunKey);
                volume2lun.setLunID((GraphLun.ID)gLun.getEntityID());
                volume2lun.setVolumeID((GraphVolume.ID)gVolume.getEntityID());
                model.put(volume2lun);
                entityMap.put(volume2lunKey, volume2lun);
            }
        }
        finally {
            block35: {
                block34: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block34;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block35;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                }
            }
        }
        init = System.currentTimeMillis();
        gArray = null;
        i = false;
        try {
            stmt = con.prepareStatement(SELECT_FILESYSTEM_SIMPLE_FROM_LUN);
            stmt.setInt(1, id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer hostId = (Integer)resultSet.getObject("HOST_ID");
                Integer filesystemId = (Integer)resultSet.getObject("FILESYSTEM_ID");
                Integer volumeId = (Integer)resultSet.getObject("VOLUME_ID");
                Integer deviceId = (Integer)resultSet.getObject("DEVICE_ID");
                Integer lunId = (Integer)resultSet.getObject("LUN");
                String mountPoint = (String)resultSet.getObject("MOUNT_POINT");
                String lunKey = "lun:" + deviceId;
                GraphLun gLun = (GraphLun)entityMap.get(lunKey);
                if (gLun == null) continue;
                String filesystemKey = "filesystem:" + filesystemId;
                GraphFilesystem filesystem = new GraphFilesystem(filesystemKey);
                filesystem.setDisplayName(mountPoint);
                model.put(filesystem);
                entityMap.put(filesystemKey, filesystem);
                String filesystem2lunKey = "fs2lun:" + filesystemId + ',' + deviceId;
                GraphFilesystem2Lun filesystem2lun = new GraphFilesystem2Lun(filesystem2lunKey);
                filesystem2lun.setFilesystemID(filesystem);
                filesystem2lun.setLunID(gLun);
                model.put(filesystem2lun);
                entityMap.put(filesystem2lunKey, filesystem2lun);
            }
        }
        finally {
            block38: {
                block37: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block37;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block38;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getView(Connection con, ViewerRequest rqst, ViewerResponse resp, int operationId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL2.class.getName(), "getView", "");
        }
        GraphModelComputerL1 gModel = null;
        Object hostId = null;
        GraphModel.MultiEntityID multiNodeModelID = (GraphModel.MultiEntityID)rqst.getModelID();
        this.removeTmpHosts(con, operationId);
        try {
            this.setTmpEntity(con, multiNodeModelID.getChildFocusEntityIDs(), operationId);
            HashMap entityMap = new HashMap();
            Timestamp prevUpdate = rqst.getTimestamp();
            Timestamp lastUpdate = null;
            if (lastUpdate == null || prevUpdate == null || lastUpdate.after(prevUpdate)) {
                gModel = new GraphModelComputerL1((GraphModelComputerL1.ID)rqst.getModelID());
                if (this.getHost(con, gModel, entityMap, operationId) != null) {
                    this.getSwitchFromHost(con, gModel, entityMap, operationId);
                    this.getSwitch2HostFromHost(con, gModel, entityMap, operationId);
                    this.getSubsystemFromHost(con, gModel, entityMap, operationId);
                    this.getHost2SubsystemFromHost(con, gModel, entityMap, operationId);
                    this.commit(con);
                    this.getHost2VolumeFromHost(con, gModel, entityMap, operationId);
                    this.getSansFromSwitch(con, gModel, entityMap, operationId);
                    this.commit(con);
                    if (rqst.getModelID().isNeedZoneData()) {
                        this.getZonesFromHost(con, gModel, entityMap, operationId);
                    }
                    this.commit(con);
                    gModel.setWithZoneData(rqst.getModelID().isNeedZoneData());
                }
                gModel.setWithZoneData(rqst.getModelID().isNeedZoneData());
                resp.addResponse(0, gModel);
            } else {
                resp.addResponse(0, null);
            }
        }
        finally {
            this.removeTmpHosts(con, operationId);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL2.class.getName(), "getView", "");
        }
    }
}

