/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL0;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerEntityPopulator;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;

public class ViewerSwitchL0
extends ViewerSanL1 {
    protected ViewerEntityPopulator populator = new ViewerEntityPopulator();
    public static boolean debug = false;
    public static String SELECT_SWITCH = "SELECT \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3 FROM \tT_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_MODEL MODEL on\tT_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on \tT_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID ";
    public static final String SELECT_SANS_FOR_SWITCH = "SELECT distinct \t SWITCH2FABRIC.PREFIX_ID, \t SWITCH2FABRIC.SWITCH_ID SWITCH_ID, \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3  FROM     T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC WHERE     T_RES_FABRIC.FABRIC_ID = SWITCH2FABRIC.FABRIC_ID ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitches(Connection con, GraphModel model, HashMap entityMap) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSwitchL0.class.getName(), "getSwitches", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("switch...");
        }
        GraphSwitch gSwitch = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_SWITCH);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer switchId = (Integer)resultSet.getObject("SWITCH_ID");
                if (switchId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL0.class.getName(), "getSwitches", "SWITCH_ID is NULL");
                    continue;
                }
                String switchKey = prefixId + switchId;
                if (entityMap == null || entityMap.get(switchKey) == null) {
                    gSwitch = new GraphSwitch(switchKey);
                    this.populator.populateSwitch(resultSet, gSwitch, true);
                    if (model != null) {
                        model.put(gSwitch);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(switchKey, gSwitch);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL0.class.getName(), "getSwitches", "Duplicated Switch entry:" + switchKey);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerSwitchL0.class.getName(), "getSwitches", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerSwitchL0.class.getName(), "getSwitches", e);
                }
            }
        }
        if (debug) {
            System.out.println("switch totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSwitchL0.class.getName(), "getSwitches", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSansFromSwitch(Connection con, GraphModel model, HashMap entityMap, Object[] focusId, String query) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSwitchL0.class.getName(), "getSansFromSwitch", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("san2switch...");
        }
        try {
            stmt = con.prepareStatement(query);
            if (focusId != null) {
                for (int i = 0; i < focusId.length; ++i) {
                    stmt.setObject(i + 1, focusId[i]);
                }
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer switchId = (Integer)resultSet.getObject("SWITCH_ID");
                Integer fabricIds = (Integer)resultSet.getObject("FABRIC_ID");
                GraphSwitch refSwitch = (GraphSwitch)entityMap.get(prefixId + switchId);
                GraphFabric san = new GraphFabric("fabric:" + fabricIds);
                this.populator.populateSan(resultSet, san);
                GraphFabric2Switch san2switch = new GraphFabric2Switch("fabric2switch:" + fabricIds + ',' + switchId);
                san2switch.setFabricID((GraphFabric.ID)san.getEntityID());
                san2switch.setSwitchID((GraphSwitch.ID)refSwitch.getEntityID());
                model.put(san);
                model.put(san2switch);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSwitchL0.class.getName(), "getSansFromSwitch", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSwitchL0.class.getName(), "getSansFromSwitch", e);
                }
            }
        }
        if (debug) {
            System.out.println("san2switch totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSwitchL0.class.getName(), "getSansFromSwitch", "");
        }
    }

    public void getSansFromSwitch(Connection con, GraphModel model, HashMap entityMap) throws SQLException {
        this.getSansFromSwitch(con, model, entityMap, null, SELECT_SANS_FOR_SWITCH);
    }

    public void commit(Connection con) {
        block2: {
            try {
                con.commit();
            }
            catch (SQLException e) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", e);
            }
        }
    }

    public void getView(Connection con, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSwitchL0.class.getName(), "getView", "");
        }
        HashMap entityMap = new HashMap();
        Timestamp prevUpdate = rqst.getTimestamp();
        Timestamp lastUpdate = null;
        if (lastUpdate == null || prevUpdate == null || lastUpdate.after(prevUpdate)) {
            GraphModelSwitchL0 gModel = new GraphModelSwitchL0((GraphModelSwitchL0.ID)rqst.getModelID());
            this.getSwitches(con, gModel, entityMap);
            this.getSansFromSwitch(con, gModel, entityMap);
            resp.addResponse(0, gModel);
            gModel.setWithZoneData(true);
            this.commit(con);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSwitchL0.class.getName(), "getView", "");
        }
    }

    public void main(String[] args) {
    }
}

