/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmpagent.manager.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.IpTarget;
import org.eclipse.aperi.infrastructure.database.objects.Scanner;

public class SqlUtil {
    public static String className = SqlUtil.class.getName();
    public static final String MESSAGE_NAME = "aperi.logger.message.SnmpAgentManager";
    public static final String TRACE_NAME = "aperi.logger.trace.SnmpAgentManager";
    public static String MSG_FILE = "org.eclipse.aperi.resources.SnmpAgentManager";

    public static DBResultSet getCapability(DBConnection connection, String ipAddress, String[] scanners) {
        String methodName = "getCapability";
        StringBuffer scannerList = new StringBuffer();
        if (scanners.length > 0) {
            scannerList.append("(SCANNER.TYPE=" + SqlUtil.wrap(scanners[0]));
            for (int i = 1; i < scanners.length; ++i) {
                scannerList.append(" or SCANNER.TYPE=" + SqlUtil.wrap(scanners[i]));
            }
            scannerList.append(") and ");
        } else {
            scannerList.append("(1=2) and ");
        }
        String query = "select                SCANNER.ENABLED,               SCANNER.TYPE as SCANNER from                T_RES_SCANNER as SCANNER where " + scannerList + "               SCANNER.AGENT_NAME=" + SqlUtil.wrap(ipAddress);
        return SqlUtil.executeQuery(connection, query);
    }

    private static String wrap(String value) {
        String methodName = "wrap";
        return value == null ? "null" : "'" + value + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet executeQuery(DBConnection connection, String query) {
        try {
            DBResultSet dBResultSet = ComplexQuery.sqlQuery(connection, query, new Hashtable());
            return dBResultSet;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeTarget(String ipAddress) {
        String methodName = "removeTarget";
        int rowCount = 0;
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        DBConnection connection = ServiceUtils.getConnection();
        htWhereClause.put(IpTarget.getColumnInfo("IP_ADDRESS"), ipAddress);
        try {
            IpTarget target = IpTarget.retrieve(connection, htWhereClause);
            if (target != null) {
                rowCount = target.delete(connection);
                connection.commit();
            }
            htWhereClause.clear();
            htWhereClause.put(Scanner.getColumnInfo("AGENT_NAME"), ipAddress);
            Scanner scanner = Scanner.retrieve(connection, htWhereClause);
            if (scanner != null) {
                rowCount = scanner.delete(connection);
                connection.commit();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception dbe) {
            dbe.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setUseridPassword(String ipAddress, String userID, String password) {
        String methodName = "setUseridPassword";
        DBConnection connection = ServiceUtils.getConnection();
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        htWhereClause.put(IpTarget.getColumnInfo("IP_ADDRESS"), ipAddress);
        IpTarget.IpTargetCursor cursor = null;
        try {
            cursor = IpTarget.getCursor(connection, htWhereClause, null);
            while (cursor.next()) {
                IpTarget target = cursor.getObject();
                target.setUserId(userID);
                target.setPassword(password);
                target.update(connection);
            }
            boolean target = true;
            return target;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (SQLException ignore) {}
            }
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addTarget(String hostname, String ipAddress, String userID, String password) {
        String methodName = "addTarget";
        DBConnection connection = ServiceUtils.getConnection();
        IpTarget target = new IpTarget();
        try {
            target.setHostName(hostname);
            target.setIpAddress(ipAddress);
            target.setUserId(userID);
            target.setPassword(password);
            target.insert(connection);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            try {
                target.update(connection);
                boolean e2 = true;
                return e2;
            }
            catch (Exception dbe) {
                dbe.printStackTrace();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return false;
    }

    public static boolean updateCapability(String ipAddress, String[] scanners) {
        String methodName = "updateCapability";
        StringBuffer scannerList = new StringBuffer();
        if (scanners.length > 0) {
            scannerList.append("case when ( ");
            for (int i = 0; i < scanners.length; ++i) {
                if (i > 0) {
                    scannerList.append(" OR ");
                }
                scannerList.append(" TYPE = " + SqlUtil.wrap(scanners[i]));
            }
            scannerList.append(" ) then 1 else 0 end ");
        } else {
            scannerList.append("0 ");
        }
        String query = "update T_RES_SCANNER set    ENABLED = " + scannerList + "where " + "               AGENT_NAME=" + SqlUtil.wrap(ipAddress) + "       and     ENABLED != " + scannerList;
        return SqlUtil.updateQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateQuery(String query) {
        DBConnection connection = ServiceUtils.getConnection();
        try {
            int result = ComplexQuery.sqlUpdate(connection, query, new Hashtable());
            boolean bl = result > 0;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IpTarget getTarget(String ipAddress) {
        DBConnection connection = ServiceUtils.getConnection();
        try {
            IpTarget target;
            Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
            htWhereClause.put(IpTarget.getColumnInfo("IP_ADDRESS"), ipAddress);
            IpTarget ipTarget = target = IpTarget.retrieve(connection, htWhereClause);
            return ipTarget;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IpTarget getTarget(String ipAddress, DBConnection connection) {
        try {
            IpTarget target;
            Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
            htWhereClause.put(IpTarget.getColumnInfo("IP_ADDRESS"), ipAddress);
            IpTarget ipTarget = target = IpTarget.retrieve(connection, htWhereClause);
            return ipTarget;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getTargets(DBConnection connection) {
        ArrayList<IpTarget> targets = new ArrayList<IpTarget>();
        IpTarget.IpTargetCursor cursor = null;
        try {
            cursor = IpTarget.getCursor(connection, null, null);
            while (cursor.next()) {
                targets.add(cursor.getObject());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (SQLException ignore) {}
            }
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception exception) {}
            }
        }
        return targets;
    }
}

