/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.xmsg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.aperi.common.ListElement;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class CurtailedWriter
extends PrintWriter
implements FilenameFilter {
    public static NumberFormat extension = new DecimalFormat("000000'.log'");
    private String prefix;
    private int dirPart;
    private PrintWriter real;
    private int messageCount;
    private SortedMap<OneDotTwoInteger, OneDotTwoInteger> sorter;
    private Range workingRange;
    private Range rangeHead;
    private int filesOnDisk;
    private boolean redirectErrOut;
    private String currentFileName;
    public int maxMessages;
    public int maxFiles;

    public CurtailedWriter(OutputStream out) {
        super(out);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "CurtailedWriter", "out");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "CurtailedWriter");
        }
    }

    public CurtailedWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "CurtailedWriter", "out, autoFlush");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "CurtailedWriter");
        }
    }

    public CurtailedWriter(Writer out) {
        super(out);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "CurtailedWriter", "out");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "CurtailedWriter");
        }
    }

    public CurtailedWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "CurtailedWriter", "out, autoFlush");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "CurtailedWriter");
        }
    }

    private String nextFilename() {
        int x;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "nextFilename", "");
        }
        this.workingRange.last = x = this.workingRange.last + 1;
        ++this.filesOnDisk;
        String traceResult = this.prefix + extension.format(x);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "nextFilename", traceResult);
        }
        return traceResult;
    }

    private void purge() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "purge", "");
        }
        if (this.maxFiles <= 0) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(CurtailedWriter.class.getName(), "purge");
            }
            return;
        }
        for (int toPurge = this.filesOnDisk - this.maxFiles; toPurge > 0; --toPurge) {
            String name = this.prefix + extension.format(this.rangeHead.first);
            File file = new File(name);
            if (!file.delete()) {
                Object[] args = new Object[]{name};
                this.real.println(MessageLog.getMessage("GEN0038W", args));
            }
            ++this.rangeHead.first;
            if (this.rangeHead.first <= this.rangeHead.last) continue;
            this.rangeHead = (Range)this.rangeHead.nextElement;
        }
        this.filesOnDisk = this.maxFiles;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "purge");
        }
    }

    public boolean accept(File dir, String name) {
        int value;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "accept", "dir, name");
        }
        if (!name.endsWith(".log")) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(CurtailedWriter.class.getName(), "accept", traceResult);
            }
            return traceResult;
        }
        int dot = name.length() - 4;
        int underscore = this.prefix.length() - this.dirPart;
        if (!name.regionMatches(0, this.prefix, this.dirPart, underscore)) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(CurtailedWriter.class.getName(), "accept", traceResult);
            }
            return traceResult;
        }
        try {
            value = Integer.parseInt(name.substring(underscore, dot));
        }
        catch (NumberFormatException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(CurtailedWriter.class.getName(), "accept", e);
            }
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(CurtailedWriter.class.getName(), "accept", traceResult);
            }
            return traceResult;
        }
        if (value <= 0) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(CurtailedWriter.class.getName(), "accept", traceResult);
            }
            return traceResult;
        }
        ++this.filesOnDisk;
        OneDotTwoInteger key = new OneDotTwoInteger(-value);
        this.sorter.put(key, key);
        boolean traceResult = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "accept", traceResult);
        }
        return traceResult;
    }

    private void setMaxMessages(int maxMessagesPerFile) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "setMaxMessages", "maxMessagesPerFile");
        }
        this.maxMessages = maxMessagesPerFile > 5 || maxMessagesPerFile <= 0 ? maxMessagesPerFile : 5;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "setMaxMessages");
        }
    }

    private void setMaxFiles(int pMaxFiles) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "setMaxFiles", "pMaxFiles");
        }
        this.maxFiles = pMaxFiles != 1 ? pMaxFiles : 2;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "setMaxFiles");
        }
    }

    public CurtailedWriter(String pPrefix, int pMaxFiles, int maxMessagesPerFile, boolean pRedirectErrOut) throws IOException {
        super(System.err);
        OneDotTwoInteger obj;
        int current;
        FileOutputStream stream;
        this.setMaxFiles(pMaxFiles);
        this.maxMessages = 0;
        this.prefix = pPrefix + "_";
        this.redirectErrOut = pRedirectErrOut;
        String oldName = pPrefix + ".log";
        try {
            stream = new FileOutputStream(oldName);
        }
        catch (IOException e) {
            MessageLog.logException("GEN0036E", e);
            throw e;
        }
        this.currentFileName = oldName;
        if (this.redirectErrOut) {
            MessageLog.redirectErrOut(stream);
        }
        this.real = new PrintWriter(stream, true);
        this.dirPart = this.prefix.lastIndexOf(File.separatorChar) + 1;
        File dir = this.dirPart > 0 ? new File(this.prefix.substring(0, this.dirPart)) : new File(".");
        this.filesOnDisk = 0;
        this.sorter = new TreeMap<OneDotTwoInteger, OneDotTwoInteger>();
        if (dir.list(this) == null) {
            Object[] args = new Object[]{dir.getPath()};
            this.println(MessageLog.getMessage("GEN0052E", args));
            return;
        }
        this.rangeHead = this.workingRange = new Range();
        Iterator<OneDotTwoInteger> iterator = this.sorter.values().iterator();
        if (!iterator.hasNext()) {
            current = 0;
        } else {
            obj = iterator.next();
            current = -obj.intValue();
        }
        this.workingRange.last = current;
        int previous = current;
        while (iterator.hasNext()) {
            obj = iterator.next();
            current = -obj.intValue();
            if (current != previous - 1) {
                this.rangeHead.first = previous;
                Range range = new Range();
                range.last = current;
                range.nextElement = this.rangeHead;
                this.rangeHead = range;
            }
            previous = current;
        }
        this.rangeHead.first = previous;
        this.sorter = null;
        String name = this.nextFilename();
        boolean renamed = false;
        this.real.close();
        if (!this.real.checkError()) {
            File original = new File(oldName);
            File target = new File(name);
            renamed = original.renameTo(target);
            if (!renamed) {
                name = oldName;
            }
            try {
                stream = new FileOutputStream(name);
            }
            catch (IOException e) {
                MessageLog.logException("GEN0036E", e);
                throw e;
            }
            if (this.redirectErrOut) {
                MessageLog.redirectErrOut(stream);
            }
            this.real = new PrintWriter(stream, true);
        }
        if (!renamed) {
            Object[] args = new Object[]{oldName, name};
            this.println(MessageLog.getMessage("GEN0023E", args));
            return;
        }
        this.currentFileName = name;
        if (current > 0) {
            this.purge();
        } else {
            this.workingRange.first = 1;
        }
        this.setMaxMessages(maxMessagesPerFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParms(int pMaxFiles, int maxMessagesPerFile) {
        Range range = this.workingRange;
        synchronized (range) {
            this.setMaxFiles(pMaxFiles);
            this.setMaxMessages(maxMessagesPerFile);
            this.purge();
        }
    }

    public void flush() {
        this.real.flush();
    }

    public void close() {
        this.real.close();
    }

    public boolean checkError() {
        return this.real.checkError();
    }

    public void print(boolean b) {
        this.real.print(b);
    }

    public void print(char c) {
        this.real.print(c);
    }

    public void print(char[] s) {
        this.real.print(s);
    }

    public void print(int i) {
        this.real.print(i);
    }

    public void print(long l) {
        this.real.print(l);
    }

    public void print(float f) {
        this.real.print(f);
    }

    public void print(double d) {
        this.real.print(d);
    }

    public void print(String s) {
        this.real.print(s);
    }

    public void print(Object obj) {
        this.real.print(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String s) {
        int count;
        this.real.println(s);
        if (this.maxMessages <= 0) {
            return;
        }
        Object object = this;
        synchronized (object) {
            this.messageCount = count = this.messageCount + 1;
        }
        if (count % this.maxMessages != 0) {
            return;
        }
        object = this.workingRange;
        synchronized (object) {
            FileOutputStream stream;
            String name = this.nextFilename();
            try {
                stream = new FileOutputStream(name);
            }
            catch (IOException e) {
                this.real.println(MessageLog.getMessageWithException("GEN0036E", e));
                --this.workingRange.last;
                --this.filesOnDisk;
                return;
            }
            this.currentFileName = name;
            if (this.redirectErrOut) {
                MessageLog.redirectErrOut(stream);
            }
            PrintWriter oldWriter = this.real;
            this.real = new PrintWriter(stream, true);
            oldWriter.close();
            this.purge();
        }
    }

    public void println() {
        this.println("");
    }

    public void println(boolean b) {
        this.println(String.valueOf(b));
    }

    public void println(char c) {
        this.println(String.valueOf(c));
    }

    public void println(char[] s) {
        this.println(String.valueOf(s));
    }

    public void println(int i) {
        this.println(String.valueOf(i));
    }

    public void println(long l) {
        this.println(String.valueOf(l));
    }

    public void println(float f) {
        this.println(String.valueOf(f));
    }

    public void println(double d) {
        this.println(String.valueOf(d));
    }

    public void println(Object obj) {
        this.println(String.valueOf(obj));
    }

    public String getCurrentFileName() {
        return this.currentFileName;
    }

    private static class OneDotTwoInteger
    implements Comparable {
        private int value;

        public OneDotTwoInteger(int pValue) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry(OneDotTwoInteger.class.getName(), "OneDotTwoInteger", "pValue");
            }
            this.value = pValue;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(OneDotTwoInteger.class.getName(), "OneDotTwoInteger");
            }
        }

        public int compareTo(Object obj) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry(OneDotTwoInteger.class.getName(), "compareTo", "obj");
            }
            OneDotTwoInteger right = (OneDotTwoInteger)obj;
            int traceResult = this.value - right.value;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(OneDotTwoInteger.class.getName(), "compareTo", traceResult);
            }
            return traceResult;
        }

        public int intValue() {
            return this.value;
        }
    }

    private static class Range
    extends ListElement {
        static final long serialVersionUID = 3043739478394309129L;
        public int first;
        public int last;

        private Range() {
        }
    }
}

