/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal;

import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.eclipse.aperi.connector.internal.CustomSerializerMgr;
import org.eclipse.aperi.connector.internal.JavaObjectSerializer;
import org.eclipse.aperi.connector.log.LogHelper;
import org.eclipse.aperi.util.extensions.ExtensionException;

public class MappingRegistry
extends SOAPMappingRegistry {
    private static final String soapEncURI = "http://schemas.xmlsoap.org/soap/encoding/";
    private final JavaObjectSerializer jos = new JavaObjectSerializer();
    private static MappingRegistry instance = new MappingRegistry();

    public MappingRegistry() {
    }

    public MappingRegistry(SOAPMappingRegistry parent, String schemaURI) {
        super(parent, schemaURI);
    }

    public static MappingRegistry getInstance() {
        return instance;
    }

    private void mapJavaObject(Class javaType) {
        this.mapTypes(soapEncURI, new QName(javaType.getName(), "JavaObject"), javaType, this.jos, this.jos);
    }

    public QName queryElementType(Class javaType, String encodingStyleURI) throws IllegalArgumentException {
        try {
            return super.queryElementType(javaType, encodingStyleURI);
        }
        catch (IllegalArgumentException e) {
            if (javaType != null && encodingStyleURI != null && encodingStyleURI.equals(soapEncURI)) {
                this.mapJavaObject(javaType);
                return new QName(javaType.getName(), "JavaObject");
            }
            throw e;
        }
    }

    public Serializer querySerializer(Class javaType, String encodingStyleURI) throws IllegalArgumentException {
        String METHOD = "querySerializer";
        Serializer serializer = null;
        try {
            serializer = super.querySerializer(javaType, encodingStyleURI);
        }
        catch (IllegalArgumentException e) {
            LogHelper.trace("Did not find serializer for '" + javaType.getName() + "' in standard mapping registry, search extensions registry.", ((Object)((Object)this)).getClass(), "querySerializer");
            try {
                CustomSerializerMgr csm = CustomSerializerMgr.getInstance();
                serializer = csm.getSerializer(javaType.getName());
            }
            catch (ExtensionException e1) {
                LogHelper.trace("Did not find serializer for '" + javaType.getName() + "' in the extensions registry, use the Java Bean Serializer.", ((Object)((Object)this)).getClass(), "querySerializer");
                if (javaType != null && encodingStyleURI != null && encodingStyleURI.equals(soapEncURI)) {
                    this.mapJavaObject(javaType);
                    return this.jos;
                }
                LogHelper.trace("javaType is null and encodingStyleURI is null", ((Object)((Object)this)).getClass(), "querySerializer");
                Exception e2 = new Exception(e1);
                LogHelper.traceException(e2, ((Object)((Object)this)).getClass(), "querySerializer");
                throw e;
            }
        }
        return serializer;
    }

    public Deserializer queryDeserializer(QName elementType, String encodingStyleURI) throws IllegalArgumentException {
        String METHOD = "queryDeserializer";
        Deserializer deserializer = null;
        try {
            deserializer = super.queryDeserializer(elementType, encodingStyleURI);
        }
        catch (IllegalArgumentException e) {
            LogHelper.trace("Did not find deserializer for '" + elementType.getClass().getName() + "' in standard mapping registry, search extensions registry.", ((Object)((Object)this)).getClass(), "queryDeserializer");
            try {
                CustomSerializerMgr csm = CustomSerializerMgr.getInstance();
                deserializer = csm.getDeserializer(elementType.getNamespaceURI());
            }
            catch (ExtensionException e1) {
                LogHelper.trace("Did not find serializer for '" + elementType.getClass().getName() + "' in the extensions registry, use the Java Bean Serializer.", ((Object)((Object)this)).getClass(), "queryDeserializer");
                if (elementType != null && encodingStyleURI != null && encodingStyleURI.equals(soapEncURI)) {
                    String javaTypeString = elementType.getNamespaceURI();
                    Class javaType = Object.class;
                    try {
                        javaType = Class.forName(javaTypeString);
                    }
                    catch (Exception e2) {
                        throw new IllegalArgumentException(e2.toString());
                    }
                    this.mapJavaObject(javaType);
                    return this.jos;
                }
                LogHelper.trace("elementType is null and encodingStyleURI is null", ((Object)((Object)this)).getClass(), "queryDeserializer");
                Exception e2 = new Exception(e1);
                LogHelper.traceException(e2, ((Object)((Object)this)).getClass(), "queryDeserializer");
                throw e;
            }
        }
        return deserializer;
    }

    public Class queryJavaType(QName elementType, String encodingStyleURI) throws IllegalArgumentException {
        try {
            return super.queryJavaType(elementType, encodingStyleURI);
        }
        catch (IllegalArgumentException e) {
            if (elementType != null && encodingStyleURI != null && encodingStyleURI.equals(soapEncURI)) {
                String javaTypeString = elementType.getNamespaceURI();
                Class javaType = Object.class;
                try {
                    javaType = Class.forName(javaTypeString);
                }
                catch (Exception e1) {
                    throw new IllegalArgumentException(e.toString());
                }
                this.mapJavaObject(javaType);
                return javaType;
            }
            throw e;
        }
    }
}

