/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal;

import java.util.Hashtable;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;

public class SessionContext {
    private static Hashtable<Integer, HttpServletRequest> sessions = new Hashtable();

    public static void addSession(HttpServletRequest session) {
        Integer hash = new Integer(Thread.currentThread().hashCode());
        sessions.put(hash, session);
    }

    public static void removeSession(HttpServletRequest session) {
        Integer hash = new Integer(Thread.currentThread().hashCode());
        sessions.remove(hash);
    }

    public static String getUserName() {
        String name = null;
        HttpServletRequest req = SessionContext.getHttpServletRequest();
        if (req != null) {
            name = req.getRemoteUser();
        }
        return name;
    }

    public static boolean isSystemUser() {
        return SessionContext.getUserName() == null;
    }

    public static boolean isUserInRole(String role) {
        boolean result = false;
        HttpServletRequest req = SessionContext.getHttpServletRequest();
        if (req != null) {
            result = req.isUserInRole(role);
        }
        return result;
    }

    private static HttpServletRequest getHttpServletRequest() {
        Integer hash = new Integer(Thread.currentThread().hashCode());
        return sessions.get(hash);
    }

    public static void setSecretKey(SecretKey serverKey) {
        SessionContext.getHttpServletRequest().getSession().putValue("hostAuth", (Object)serverKey);
    }

    public static SecretKey getSecretKey() {
        return (SecretKey)SessionContext.getHttpServletRequest().getSession().getValue("hostAuth");
    }

    public static void successfulHandshake() {
        SessionContext.getHttpServletRequest().getSession().putValue("isSystemUser", (Object)new Boolean(true));
    }

    public static String getRemoteHostname() {
        String name = null;
        HttpServletRequest req = SessionContext.getHttpServletRequest();
        if (req != null) {
            name = req.getRemoteHost();
        }
        return name;
    }
}

