/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.client;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import org.eclipse.aperi.connector.Config;
import org.eclipse.aperi.connector.Constants;
import org.eclipse.aperi.connector.internal.InternalConstants;
import org.eclipse.aperi.connector.internal.client.SocketBuilder;

public class RawSocketClient
implements InternalConstants,
Constants {
    public static Socket post(String host, int port, String serviceName) throws IllegalArgumentException, IOException {
        Socket s;
        OutputStream outStream = null;
        boolean sslEnabled = true;
        String sslProp = Config.getProperty("connector.ssl.enabled");
        if (sslProp == null || "false".equals(sslProp)) {
            sslEnabled = false;
        }
        try {
            s = SocketBuilder.buildSocket(host, port, sslEnabled);
            outStream = s.getOutputStream();
        }
        catch (Exception e) {
            Throwable t = e;
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            throw new IllegalArgumentException("Error opening socket: " + t);
        }
        StringBuffer headerbuf = new StringBuffer();
        headerbuf.append("POST").append(' ').append(host).append(" HTTP/").append("1.0").append("\r\n").append("Host").append(": ").append(host).append(':').append(port).append("\r\n").append("Content-Type").append(": ").append("RawSocket").append("\r\n").append("RawSocket-Service").append(": ").append(serviceName).append("\r\n").append("Content-Length").append(": ").append(0).append("\r\n");
        headerbuf.append("\r\n");
        String header = headerbuf.toString();
        int outputBufferSize = header.getBytes().length;
        BufferedOutputStream bOutStream = new BufferedOutputStream(outStream, outputBufferSize);
        bOutStream.write(header.getBytes("iso-8859-1"));
        bOutStream.flush();
        outStream.flush();
        BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
        String response = in.readLine();
        if (!"OK".equals(response)) {
            throw new IOException("Bad response");
        }
        return s;
    }
}

