/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.client;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.soap.Fault;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.transport.SOAPTransport;
import org.eclipse.aperi.connector.Config;
import org.eclipse.aperi.connector.Constants;
import org.eclipse.aperi.connector.internal.MappingRegistry;
import org.eclipse.aperi.connector.internal.NotAuthorizedException;
import org.eclipse.aperi.connector.internal.NullUserException;
import org.eclipse.aperi.connector.internal.RetryFailedException;
import org.eclipse.aperi.connector.internal.SOAPNotAuthorizedException;
import org.eclipse.aperi.connector.internal.SecurityContext;
import org.eclipse.aperi.connector.internal.UserSecurityContext;
import org.eclipse.aperi.connector.internal.client.SOAPConnection;
import org.w3c.dom.Element;

public class SoapClient
implements Constants {
    private SecurityContext sc = null;
    private URL url = null;
    private Call call = null;
    private Vector<Parameter> params = null;
    private SOAPMappingRegistry smr = null;
    private String encodingStyleURI = "http://schemas.xmlsoap.org/soap/encoding/";

    public SoapClient(SecurityContext sc) {
        this.sc = sc;
    }

    public void init(String hostUrl, String service) throws MalformedURLException {
        if (this.sc == null) {
            this.sc = SecurityContext.getDefaultContext();
            SecurityContext.setDefaultContext(this.sc);
        }
        this.smr = MappingRegistry.getInstance();
        this.call = new Call();
        SOAPConnection shc = new SOAPConnection();
        this.call.setSOAPTransport((SOAPTransport)shc);
        if (this.sc instanceof UserSecurityContext) {
            // empty if block
        }
        this.call.setSOAPMappingRegistry(this.smr);
        this.call.setTargetObjectURI(service);
        this.call.setEncodingStyleURI(this.encodingStyleURI);
        this.params = new Vector();
        String ssl = Config.getProperty("connector.ssl.enabled");
        String protocol = null;
        protocol = ssl == null || "false".equalsIgnoreCase(ssl) ? "http://" : "https://";
        this.url = new URL(protocol + hostUrl + "/ServiceManager");
    }

    public Object invoke() throws Throwable {
        String targetURI = this.call.getFullTargetObjectURI();
        Object returnVal = null;
        Response resp = null;
        if (Thread.interrupted()) {
            throw new ThreadDeath();
        }
        resp = this.call.invoke(this.url, null);
        if (Thread.interrupted()) {
            throw new ThreadDeath();
        }
        if (resp != null) {
            if (!resp.generatedFault()) {
                Parameter result = resp.getReturnValue();
                if (result != null) {
                    returnVal = result.getValue();
                }
            } else {
                returnVal = this.handleFault(resp, targetURI);
            }
        }
        return returnVal;
    }

    protected Object handleFault(Response resp, String targetURI) throws Throwable {
        Throwable ex = null;
        Fault fault = resp.getFault();
        Vector v = fault.getDetailEntries();
        if (v == null || v.size() < 1) {
            ex = new RuntimeException(fault.toString());
        } else {
            Object obj = v.get(0);
            if (obj instanceof Element) {
                try {
                    String value = ((Element)v.get(0)).getFirstChild().getNodeValue();
                    ObjectInputStream ois = null;
                    ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((String)value));
                    ois = new ObjectInputStream(bais);
                    ex = (Throwable)ois.readObject();
                }
                catch (Exception e) {
                    ex = new RuntimeException(fault.toString());
                }
            } else if (obj instanceof Parameter) {
                Parameter param = (Parameter)obj;
                Object val = param.getValue();
                if (val instanceof Throwable) {
                    ex = (Throwable)val;
                }
            } else {
                ex = new RuntimeException(fault.toString());
            }
        }
        if (ex instanceof NullUserException) {
            Vector origParams = (Vector)this.call.getParams().clone();
            String origMethodName = this.call.getMethodName();
            resp = null;
            this.setMethod(origMethodName, origParams);
            this.call.setTargetObjectURI(targetURI);
            if (Thread.interrupted()) {
                throw new ThreadDeath();
            }
            resp = this.call.invoke(this.url, null);
            if (Thread.interrupted()) {
                throw new ThreadDeath();
            }
            if (resp != null) {
                if (!resp.generatedFault()) {
                    Parameter result = resp.getReturnValue();
                    if (result != null) {
                        return result.getValue();
                    }
                    return null;
                }
                ex = new RetryFailedException(ex.getMessage());
            }
        }
        this.call.setFullTargetObjectURI(targetURI);
        if (ex instanceof SOAPNotAuthorizedException) {
            ex = new NotAuthorizedException(ex.getMessage());
        }
        throw ex;
    }

    protected void setMethod(Method m, Object[] args) throws Exception {
        if (this.params != null) {
            this.params.removeAllElements();
        } else {
            this.params = new Vector();
        }
        if (m != null) {
            this.call.setMethodName(m.getName());
            Class<?>[] types = m.getParameterTypes();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    this.params.addElement(new Parameter("arg" + i, types[i], args[i], null));
                }
            }
        } else {
            throw new Exception("Method is null");
        }
        this.call.setParams(this.params);
    }

    public void setMethod(String methodName, Vector params) {
        if (params != null && methodName != null) {
            this.call.setMethodName(methodName);
            this.call.setParams(params);
        }
    }
}

