/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.ssl;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.aperi.connector.Config;
import org.eclipse.aperi.connector.IKeyStoreMgr;
import org.eclipse.aperi.connector.internal.ssl.KeyStoreMgr;

public class SSLManager {
    private static SSLContext sslContext = null;

    public static SSLSocketFactory getSSLSocketFactory() {
        SSLSocketFactory sssf = SSLManager.getSSLContext().getSocketFactory();
        return sssf;
    }

    public static SSLServerSocketFactory getSSLServerSocketFactory() {
        SSLServerSocketFactory sssf = SSLManager.getSSLContext().getServerSocketFactory();
        return sssf;
    }

    protected static SSLContext getSSLContext() {
        if (sslContext == null) {
            try {
                sslContext = SSLContext.getInstance("TLS");
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(Config.getProperty("connector.ssl.algorithm"));
                IKeyStoreMgr iksm = KeyStoreMgr.getIKeyStoreMgr();
                KeyStore ks = iksm.getKeyStore();
                kmf.init(ks, iksm.getPassword());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(Config.getProperty("connector.ssl.algorithm"));
                tmf.init(ks);
                TrustManager[] tms = tmf.getTrustManagers();
                try {
                    sslContext.init(kmf.getKeyManagers(), tms, new SecureRandom());
                }
                catch (KeyManagementException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sslContext;
    }
}

