/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.DiscoverMapperManager;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.cimom.CIMScanner;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.CIMParser;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMInstance;

public class AssociatorCIMQuery
extends DiscoverProcess {
    Query queryTemplate = null;
    String entityName = null;
    String entityClass = null;
    boolean persist;

    public AssociatorCIMQuery(String description, Query query, String entityName, String entityClass, boolean persist) {
        super(description, false, new String[]{"CIMOM", entityName}, new String[]{String[].class.getName(), entityClass});
        this.queryTemplate = query;
        this.entityName = entityName;
        this.entityClass = entityClass;
        this.persist = persist;
    }

    public Result process(Request discoverRequest, Map parameters) throws ParameterException {
        String[] cimom = (String[])AssociatorCIMQuery.getParameter(parameters, "CIMOM", String[].class.getName());
        Object entity = AssociatorCIMQuery.getParameter(parameters, this.entityName, this.entityClass);
        try {
            CIMInstance instance = (CIMInstance)DiscoverMapperManager.map("DBMapper", "SMIS", entity);
            Vector properties = instance.getAllProperties();
            Query query = (Query)this.queryTemplate.clone();
            query.setClassName(instance.getClassName());
            query.setProperties(properties);
            query.setCOP(instance.getObjectPath());
            JobInfo job = new JobInfo();
            job.setDiscoverRequest(new Integer(discoverRequest.getId()).toString());
            job.setResourceQueue(this.getResourceQueueName());
            job.setResourceId(cimom[0]);
            job.setRequestId(cimom[0] + ":" + query.getCmd() + ":" + query.getClassName() + query.getAssocClassName() + query.getResultClassName() + properties);
            job.setRequest((Response)query);
            job.setTarget(cimom);
            if (this.persist) {
                JobInfo processJob = (JobInfo)job.clone();
                processJob.setResourceQueue(CIMParser.queueName);
                job.setNextJob(processJob);
            }
            JobEngine.getInstance().addJob(job);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Result(99);
        }
        return new Result(0);
    }

    protected String getResourceQueueName() {
        return CIMScanner.queueName;
    }
}

