/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.AssociatorCIMQuery;
import org.eclipse.aperi.discovery.IDiscoveryTypes;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.ProcessProcessor;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.SLPDiscoveryProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.interfaces.ParameterException;

public class Discover
implements IDiscoveryTypes {
    public static String discoverAll = "DiscoverAll";
    public static String slpDiscover = "SLPDiscover";
    public static String frontEndProcessHandler = "frontEndProcessHandler";

    static {
        Router.getRouter().addProcess(slpDiscover, new SLPDiscoveryProcess());
        Router.getRouter().addProcess("DIMdiscoverPerformanceStatisticsServiceForSubsystem", new AssociatorCIMQuery("Discover Performance Statistics Service for Subsystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_HostedService", (String)"IBMTSESS_PerformanceStatisticsService", (String)"Antecedent", (String)"Dependent"), "SYSTEM", StorageSubsystem.class.getName(), false));
        Router.getRouter().addProcess(frontEndProcessHandler, new DiscoverProcess("Handler that routes a process request to the ProcessHandler resource", false, new String[]{"Request"}, new String[]{Object[].class.getName()}){

            public Result process(Request discoverRequest, Map parameters) throws ParameterException {
                Object[] request = (Object[])1.getParameter(parameters, "Request", Object[].class.getName());
                JobInfo job = new JobInfo();
                job.setDiscoverRequest(new Integer(discoverRequest.getId()).toString());
                job.setResourceQueue(ProcessProcessor.queueName);
                job.setRequestId(request.toString());
                job.setRequest((Response)new ObjectResponse(request, job));
                JobEngine.getInstance().addJob(job);
                return new Result(0);
            }

            public String getProcessInfoForJobLog(Map parameters) {
                try {
                    Object[] request = (Object[])1.getParameter(parameters, "Request", Object[].class.getName());
                    String type = (String)request[0];
                    Hashtable properties = (Hashtable)request[1];
                    IDiscoverProcess spawnedProcess = Router.getRouter().findProcess(type, properties);
                    String info = spawnedProcess.getProcessInfoForJobLog((Map)properties);
                    if (info != null) {
                        return info;
                    }
                    return type;
                }
                catch (ParameterException e) {
                    return null;
                }
            }

            public String getComputerForJobLog(Map parameters) {
                try {
                    Object[] request = (Object[])1.getParameter(parameters, "Request", Object[].class.getName());
                    String type = (String)request[0];
                    Hashtable properties = (Hashtable)request[1];
                    IDiscoverProcess spawnedProcess = Router.getRouter().findProcess(type, properties);
                    return spawnedProcess.getComputerForJobLog((Map)properties);
                }
                catch (ParameterException e) {
                    return null;
                }
            }
        });
    }
}

