/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.util.Hashtable;
import org.eclipse.aperi.discovery.Mapper;
import org.eclipse.aperi.discovery.MappingException;
import org.eclipse.aperi.discovery.TPCtoSMISMapper;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.sblim.wbem.cim.CIMInstance;

public class DiscoverMapperManager {
    static Hashtable mappings = new Hashtable();

    private DiscoverMapperManager() {
    }

    public static Mapper getMapper(String from, String to) throws MappingException {
        Mapper mapper = (Mapper)mappings.get(from + "to" + to);
        if (mapper == null) {
            throw new MappingException("No mapper found for mapping " + from + " to " + to + ".");
        }
        return mapper;
    }

    public static Object map(String from, String to, StorageSubsystem system) throws MappingException {
        Mapper mapper = DiscoverMapperManager.getMapper(from, to);
        return mapper.getKey(system);
    }

    public static Object map(String from, String to, CIMInstance instance) throws MappingException {
        Mapper mapper = DiscoverMapperManager.getMapper(from, to);
        return mapper.getKey(instance);
    }

    public static Object map(String from, String to, Object o) throws MappingException {
        if (o instanceof StorageSubsystem) {
            return DiscoverMapperManager.map(from, to, (StorageSubsystem)o);
        }
        if (o instanceof CIMInstance) {
            return DiscoverMapperManager.map(from, to, (CIMInstance)o);
        }
        throw new MappingException("Unable to map " + o + " the class " + o.getClass().getName() + " is unrecognized.");
    }

    static {
        mappings.put("DBMappertoSMIS", new TPCtoSMISMapper());
    }
}

