/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.cimom.CIMScanner;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.CIMParser;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMObjectPath;

public class SimpleCIMDiscoverProcess
extends DiscoverProcess {
    Query[] queries;
    boolean persist;

    public SimpleCIMDiscoverProcess(String description, boolean mainProcess, Query[] queries, boolean persist) {
        super(description, mainProcess, new String[]{"CIMOM"}, new String[]{String[].class.getName()});
        this.queries = queries;
        this.persist = persist;
    }

    public Result process(Request discoverRequest, Map parameters) throws ParameterException {
        String[] cimom = (String[])SimpleCIMDiscoverProcess.getParameter(parameters, "CIMOM", String[].class.getName());
        for (int i = 0; i < this.queries.length; ++i) {
            JobInfo queryJob = new JobInfo();
            queryJob.setDiscoverRequest(new Integer(discoverRequest.getId()).toString());
            queryJob.setResourceQueue(this.getResourceQueueName());
            queryJob.setResourceId(cimom[0]);
            queryJob.setRequestId(cimom[0] + ":" + this.queries[i].getCmd() + ":" + this.queries[i].getClassName() + this.queries[i].getAssocClassName() + this.queries[i].getResultClassName());
            if (parameters.containsKey("NAMESPACE")) {
                String mNameSpace = (String)SimpleCIMDiscoverProcess.getParameter(parameters, "NAMESPACE", String.class.getName());
                CIMObjectPath mCop = new CIMObjectPath(this.queries[i].getClassName(), mNameSpace);
                this.queries[i].setCOP(mCop);
            }
            queryJob.setRequest((Response)this.queries[i]);
            queryJob.setTarget(cimom);
            if (this.persist) {
                JobInfo processJob = (JobInfo)queryJob.clone();
                processJob.setResourceQueue(CIMParser.queueName);
                queryJob.setNextJob(processJob);
            }
            JobEngine.getInstance().addJob(queryJob);
        }
        return new Result(0);
    }

    protected String getResourceQueueName() {
        return CIMScanner.queueName;
    }
}

