/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.util.Hashtable;
import org.eclipse.aperi.discovery.ProbePerfTracker;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;

public class TrackProbePerformance {
    protected static Hashtable cTrackedProbes = new Hashtable();
    protected static boolean sPerfTraceEnabled = false;

    public static void startProbe(String pScannerId) {
        if (pScannerId != null && TrackProbePerformance.checkPerfTraceEnabledConfiguration()) {
            ProbePerfTracker mNewPerfTracker = new ProbePerfTracker(pScannerId);
            cTrackedProbes.put(pScannerId, mNewPerfTracker);
        }
    }

    public static ProbePerfTracker.ProbeAction startProbeAction(String pScannerId, int pActionType) {
        ProbePerfTracker mProbePerfTracker;
        if (sPerfTraceEnabled && pScannerId != null && (mProbePerfTracker = (ProbePerfTracker)cTrackedProbes.get(pScannerId)) != null) {
            return mProbePerfTracker.startAction(pActionType);
        }
        return null;
    }

    public static void finishedProbeAction(String pScannerId, int pActionType) {
        ProbePerfTracker mProbePerfTracker;
        if (sPerfTraceEnabled && pScannerId != null && (mProbePerfTracker = (ProbePerfTracker)cTrackedProbes.get(pScannerId)) != null) {
            mProbePerfTracker.finishedAction(pActionType);
        }
    }

    public static void finishedProbeAction(ProbePerfTracker.ProbeAction pFinishedAction) {
        if (sPerfTraceEnabled && pFinishedAction != null) {
            pFinishedAction.finished();
        }
    }

    public static void finishedProbe(String pScannerId, LogTraceHelper pLTH) {
        ProbePerfTracker mProbePerfTracker;
        if (sPerfTraceEnabled && pScannerId != null && (mProbePerfTracker = (ProbePerfTracker)cTrackedProbes.get(pScannerId)) != null) {
            mProbePerfTracker.probeFinished(pLTH);
            cTrackedProbes.remove(pScannerId);
        }
    }

    private static boolean checkPerfTraceEnabledConfiguration() {
        boolean mPerfTraceEnabled;
        sPerfTraceEnabled = mPerfTraceEnabled = DiskManagerConfigSvc.getBooleanConfigValue((String)"Probe.TrackProbePerformance", (boolean)false);
        return mPerfTraceEnabled;
    }
}

