/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.cimom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.ProbePerfTracker;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.TrackProbePerformance;
import org.eclipse.aperi.discovery.cimom.CimomWrapperCreator;
import org.eclipse.aperi.discovery.interfaces.CIMEnumerationResponse;
import org.eclipse.aperi.discovery.interfaces.CIMExceptionResponse;
import org.eclipse.aperi.discovery.interfaces.FakeCIMEnumeration;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.pool.Pool;
import org.eclipse.aperi.util.pool.ResourceCreator;
import org.eclipse.aperi.util.queue.DefaultJobQueue;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.QueueController;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class CIMScanner
extends Thread {
    public static String queueName = "CIM/OM";
    public static Pool cimomWrapperPool = new Pool((ResourceCreator)new CimomWrapperCreator());
    private boolean shutdown = false;
    private Thread thread = null;
    public static final String MESSAGE_NAME = "aperi.logger.message.CIMScanner";
    public static final String TRACE_NAME = "aperi.logger.trace.CIMScanner";
    public static String MSG_FILE = "org.eclipse.aperi.resources.CIMScanner";
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    public boolean trace = false;
    String className = CIMScanner.class.getName();

    public CIMScanner() {
        this.setName(queueName + " (" + this.getName() + ")");
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new DefaultJobQueue());
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        String methodName = "CIMScanner.run";
        if (traceLogger != null && traceLogger.isLogging()) {
            this.trace = true;
        }
        if (this.trace) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this.className, methodName);
        }
        this.thread = Thread.currentThread();
        while (!this.shutdown) {
            traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, methodName, queueName + ": waiting for a job");
            JobInfo job = QueueController.getInstance().getNextJob(queueName);
            if (this.shutdown) continue;
            if (job == null) {
                if (!this.trace) continue;
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, methodName, ":Error - got a NULL job from the queue");
                continue;
            }
            Query query = (Query)job.getRequest().getData();
            String mScannerId = null;
            Request request = Router.getRouter().getRequest(job.getDiscoverRequest());
            if (request != null) {
                mScannerId = request.getScannerId();
            }
            if (this.trace) {
                StringBuffer buf = new StringBuffer();
                buf.append(queueName + ": invoking " + query.toString() + " on " + job.getTarget()[0] + " " + job.getTarget()[1]);
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, methodName, buf.toString());
            }
            Object mO = job.getRequest().getData();
            CIMClientWrapper cimClient = null;
            try {
                block41: {
                    Hashtable<String, String> parameters = new Hashtable<String, String>();
                    parameters.put("USERID", job.getTarget().length > 2 ? (job.getTarget()[2] != null ? job.getTarget()[2] : "") : "");
                    parameters.put("PASSWORD", job.getTarget().length > 3 ? (job.getTarget()[3] != null ? job.getTarget()[3] : "") : "");
                    parameters.put("URL", job.getTarget()[0]);
                    parameters.put("NAMESPACE", job.getTarget()[1]);
                    cimClient = (CIMClientWrapper)cimomWrapperPool.getResource(parameters);
                    if (job.getTarget().length > 4 && job.getTarget()[4] != null) {
                        try {
                            long bTimeout = Long.parseLong(job.getTarget()[4]);
                            cimClient.setTimeout(bTimeout);
                            if (this.trace) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, methodName, "Using CIM timeout value of " + job.getTarget()[4]);
                            }
                        }
                        catch (NumberFormatException pEx) {
                            if (!this.trace) break block41;
                            traceLogger.text(IRecordType.TYPE_WARN, (Object)this.className, methodName, "Could not parse CIM timeout value of " + job.getTarget()[4]);
                        }
                    }
                }
                Object e = null;
                switch (query.getCmd()) {
                    case 6: {
                        if (this.trace) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, methodName, queueName + ": invoking cimClient.references" + query.getCmd());
                        }
                        ProbePerfTracker.ProbeAction mProbePerfTrackerAction = TrackProbePerformance.startProbeAction(mScannerId, ProbePerfTracker.CIMOM_REFERENCES);
                        e = cimClient.references(query.getCOP(), query.getResultClassName(), query.getRole(), true, true, null);
                        TrackProbePerformance.finishedProbeAction(mProbePerfTrackerAction);
                        break;
                    }
                    case 7: {
                        if (this.trace) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, methodName, queueName + ": invoking cimClient.referenceNames" + query.getCmd());
                        }
                        ProbePerfTracker.ProbeAction mProbePerfTrackerAction = TrackProbePerformance.startProbeAction(mScannerId, ProbePerfTracker.CIMOM_REFERENCES_NAMES);
                        e = cimClient.referenceNames(query.getCOP());
                        TrackProbePerformance.finishedProbeAction(mProbePerfTrackerAction);
                        break;
                    }
                    case 0: {
                        ProbePerfTracker.ProbeAction mProbePerfTrackerAction;
                        if (this.trace) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, methodName, queueName + ": invoking cimClient.enumerateInstances" + query.getCmd());
                        }
                        if (query.getCOP() != null) {
                            mProbePerfTrackerAction = TrackProbePerformance.startProbeAction(mScannerId, ProbePerfTracker.CIMOM_ENUMERATOR);
                            e = cimClient.enumerateInstances(query.getCOP());
                            TrackProbePerformance.finishedProbeAction(mProbePerfTrackerAction);
                            break;
                        }
                        mProbePerfTrackerAction = TrackProbePerformance.startProbeAction(mScannerId, ProbePerfTracker.CIMOM_ENUMERATOR);
                        e = cimClient.enumerateInstances(new CIMObjectPath(query.getClassName()), true, false);
                        TrackProbePerformance.finishedProbeAction(mProbePerfTrackerAction);
                        break;
                    }
                    case 1: {
                        if (this.trace) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, methodName, queueName + ": invoking cimClient.enumerateInstanceNames" + query.getCmd());
                        }
                        ProbePerfTracker.ProbeAction mProbePerfTrackerAction = TrackProbePerformance.startProbeAction(mScannerId, ProbePerfTracker.CIMOM_ENUMERATOR_NAMES);
                        e = cimClient.enumerateInstanceNames(new CIMObjectPath(query.getClassName()));
                        TrackProbePerformance.finishedProbeAction(mProbePerfTrackerAction);
                        break;
                    }
                    case 2: {
                        if (this.trace) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, methodName, queueName + ": invoking cimClient.associators" + query.getCmd());
                        }
                        ProbePerfTracker.ProbeAction mProbePerfTrackerAction = TrackProbePerformance.startProbeAction(mScannerId, ProbePerfTracker.CIMOM_ASSOCIATORS);
                        e = cimClient.associators(query.getCOP(), query.getAssocClassName(), query.getResultClassName(), query.getRole(), query.getResultRole(), false, false, null);
                        TrackProbePerformance.finishedProbeAction(mProbePerfTrackerAction);
                        break;
                    }
                    case 3: {
                        if (this.trace) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, methodName, queueName + ": invoking cimClient.AssociatorNames" + query.getCmd());
                        }
                        ProbePerfTracker.ProbeAction mProbePerfTrackerAction = TrackProbePerformance.startProbeAction(mScannerId, ProbePerfTracker.CIMOM_ASSOCIATORS_NAMES);
                        e = cimClient.associatorNames(query.getCOP(), query.getAssocClassName(), query.getResultClassName(), query.getRole(), query.getResultRole());
                        TrackProbePerformance.finishedProbeAction(mProbePerfTrackerAction);
                        break;
                    }
                    case 5: {
                        if (this.trace) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, methodName, queueName + ": invoking cimClient.enumerateClassNames" + query.getCmd());
                        }
                        e = cimClient.enumerateClassNames(new CIMObjectPath(query.getClassName()));
                        break;
                    }
                    case 4: {
                        if (this.trace) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, methodName, queueName + ": invoking cimClient.enumerateClasses" + query.getCmd());
                        }
                        e = cimClient.enumerateClasses(new CIMObjectPath(query.getClassName()), true, false, false, false);
                        break;
                    }
                    case 8: {
                        if (this.trace) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, methodName, queueName + ": invoking cimClient.getInstance" + query.getCmd());
                        }
                        ProbePerfTracker.ProbeAction mProbePerfTrackerAction = TrackProbePerformance.startProbeAction(mScannerId, ProbePerfTracker.CIMOM_GETINSTANCE);
                        CIMInstance bCInst = cimClient.getInstance(query.getCOP(), false, null);
                        TrackProbePerformance.finishedProbeAction(mProbePerfTrackerAction);
                        ArrayList<CIMInstance> bCInstlist = new ArrayList<CIMInstance>(1);
                        bCInstlist.add(bCInst);
                        e = new FakeCIMEnumeration(Collections.enumeration(bCInstlist));
                        break;
                    }
                    default: {
                        if (!this.trace) break;
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, methodName, queueName + ": Unsupported query " + query.getCmd());
                    }
                }
                job.setResponse((Response)new CIMEnumerationResponse((Enumeration)e, job));
                job.setReturnCode(99);
                job.complete(true);
                if (cimClient == null) continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.trace) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this.className, methodName, (Throwable)e);
                }
                job.setResponse((Response)new CIMExceptionResponse((Throwable)e, job));
                job.setReturnCode(99);
                job.complete(false);
                continue;
            }
            catch (Throwable e2) {
                e2.printStackTrace();
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, e2);
                if (this.trace) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this.className, methodName, e2);
                }
                job.setResponse((Response)new CIMExceptionResponse(e2, job));
                job.setReturnCode(99);
                job.complete(false);
                if (cimClient == null) continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                cimomWrapperPool.freeResource(cimClient);
                continue;
            }
            finally {
                if (cimClient == null) continue;
                cimomWrapperPool.freeResource(cimClient);
                continue;
            }
            cimomWrapperPool.freeResource((Object)cimClient);
        }
        if (this.trace) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this.className, methodName);
        }
    }

    public void shutdown() {
        this.shutdown = true;
        String methodName = "shutdown";
        if (traceLogger != null && traceLogger.isLogging()) {
            this.trace = true;
        }
        if (this.thread != null) {
            try {
                if (this.trace) {
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)this, methodName, "CIMScanner is shutting down");
                }
                this.thread.interrupt();
                this.thread.join(30000L);
                this.thread = null;
            }
            catch (Exception e) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "Error during CIMScanner shutdown");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this.className, methodName, (Throwable)e);
                }
                e.printStackTrace();
            }
        }
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }
}

