/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.parser;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.discovery.parser.TSANMLegacyParser;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.objects.Alias;
import org.eclipse.aperi.infrastructure.database.objects.Alias2member;
import org.eclipse.aperi.infrastructure.database.objects.Cluster;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.Disk;
import org.eclipse.aperi.infrastructure.database.objects.Fabric;
import org.eclipse.aperi.infrastructure.database.objects.Fabric2switch;
import org.eclipse.aperi.infrastructure.database.objects.Hba;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.database.objects.Node2hba;
import org.eclipse.aperi.infrastructure.database.objects.Pe2node;
import org.eclipse.aperi.infrastructure.database.objects.PhyPe;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.Port2port;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.Server;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.Switch2port;
import org.eclipse.aperi.infrastructure.database.objects.SwitchBlade;
import org.eclipse.aperi.infrastructure.database.objects.TapeDrive;
import org.eclipse.aperi.infrastructure.database.objects.Zone;
import org.eclipse.aperi.infrastructure.database.objects.Zone2alias;
import org.eclipse.aperi.infrastructure.database.objects.Zone2member;
import org.eclipse.aperi.infrastructure.database.objects.ZoneMember;
import org.eclipse.aperi.infrastructure.database.objects.Zset;
import org.eclipse.aperi.infrastructure.database.objects.Zset2zone;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class AlertProcessor {
    static ILogger msgLogger = TSANMLegacyParser.msgLogger;
    static ILogger traceLogger = TSANMLegacyParser.traceLogger;
    static final String className = AlertProcessor.class.getName();
    public static final Hashtable tableToAutoIdMapping = new Hashtable();

    public static void processAlerts(String processId, MapperResult result, Hashtable newEntities, Hashtable modified) {
        AlertProcessor.processAlerts(processId, result, newEntities, modified, false);
    }

    public static void processAlerts(String processId, MapperResult result, Hashtable newEntities, Hashtable modified, boolean isFirstProbe) {
        String methodName = "processAlerts";
        Hashtable modifiedRows = result.getModifiedRows();
        Enumeration e = modifiedRows.keys();
        block0: while (e.hasMoreElements()) {
            String autoIdName;
            String key = (String)e.nextElement();
            Hashtable value = (Hashtable)modifiedRows.get(key);
            Vector<String> entities = (Vector<String>)modified.get(key);
            if (entities == null) {
                entities = new Vector<String>();
                modified.put(key, entities);
            }
            if ((autoIdName = (String)tableToAutoIdMapping.get(key)) == null) {
                if (!traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "No ID mapping for " + key);
                continue;
            }
            Enumeration e2 = value.keys();
            while (e2.hasMoreElements()) {
                ColumnInfo column = (ColumnInfo)e2.nextElement();
                if (!column.getName().equals(autoIdName)) continue;
                String autoId = value.get(column).toString();
                entities.add(autoId);
                if (!traceLogger.isLogging()) continue block0;
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Detected change in " + key + ", auto ID=" + autoId);
                continue block0;
            }
        }
        Hashtable insertedRows = result.getInsertedRows();
        Enumeration e2 = insertedRows.keys();
        block2: while (e2.hasMoreElements()) {
            String autoIdName;
            String key = (String)e2.nextElement();
            Hashtable value = (Hashtable)insertedRows.get(key);
            Vector<String> entities = (Vector<String>)newEntities.get(key);
            if (entities == null) {
                entities = new Vector<String>();
                newEntities.put(key, entities);
            }
            if ((autoIdName = (String)tableToAutoIdMapping.get(key)) == null) {
                if (!traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "No ID mapping for " + key);
                continue;
            }
            Enumeration e22 = value.keys();
            while (e22.hasMoreElements()) {
                ColumnInfo column = (ColumnInfo)e22.nextElement();
                if (!column.getName().equals(autoIdName)) continue;
                String autoId = value.get(column).toString();
                entities.add(autoId);
                if (isFirstProbe) continue block2;
                Processor.getEventMonitorProxy().handleNewDevice(processId, key, autoId);
                continue block2;
            }
        }
    }

    static {
        tableToAutoIdMapping.put(Fabric.getTablename(), "FABRIC_ID");
        tableToAutoIdMapping.put(Fabric2switch.getTablename(), "FABRIC2SWITCH_ID");
        tableToAutoIdMapping.put(Server.getTablename(), "SERVER_ID");
        tableToAutoIdMapping.put(Switch.getTablename(), "SWITCH_ID");
        tableToAutoIdMapping.put(Switch2port.getTablename(), "SWITCH2PORT_ID");
        tableToAutoIdMapping.put(StorageVolume.getTablename(), "SVID");
        tableToAutoIdMapping.put(Port.getTablename(), "PORT_ID");
        tableToAutoIdMapping.put(Port2port.getTablename(), "PORT2PORT_ID");
        tableToAutoIdMapping.put(PhyPe.getTablename(), "PHY_PE_ID");
        tableToAutoIdMapping.put(Hba.getTablename(), "HBA_ID");
        tableToAutoIdMapping.put(Zone.getTablename(), "ZONE_ID");
        tableToAutoIdMapping.put(Zset.getTablename(), "ZSET_ID");
        tableToAutoIdMapping.put(Zset2zone.getTablename(), "ZSET2ZONE_ID");
        tableToAutoIdMapping.put(ZoneMember.getTablename(), "ZONE_MEMBER_ID");
        tableToAutoIdMapping.put(Zone2member.getTablename(), "ZONE2MEMBER_ID");
        tableToAutoIdMapping.put(Node.getTablename(), "NODE_ID");
        tableToAutoIdMapping.put(Node2hba.getTablename(), "NODE2HBA_ID");
        tableToAutoIdMapping.put(Pe2node.getTablename(), "PE2NODE_ID");
        tableToAutoIdMapping.put(StoragePool.getTablename(), "POOL_ID");
        tableToAutoIdMapping.put(Disk.getTablename(), "DISK_ID");
        tableToAutoIdMapping.put(StorageSubsystem.getTablename(), "SUBSYSTEM_ID");
        tableToAutoIdMapping.put(StorageVolume.getTablename(), "SVID");
        tableToAutoIdMapping.put(DataPath.getTablename(), "DATA_PATH_ID");
        tableToAutoIdMapping.put(TapeDrive.getTablename(), "TAPE_DRIVE_ID");
        tableToAutoIdMapping.put(SwitchBlade.getTablename(), "SWITCH_BLADE_ID");
        tableToAutoIdMapping.put(Cluster.getTablename(), "CLUSTER_ID");
        tableToAutoIdMapping.put(Pe2node.getTablename(), "PE2NODE_ID");
        tableToAutoIdMapping.put(Host.getTablename(), "COMPUTER_ID");
        tableToAutoIdMapping.put(Fabric2switch.getTablename(), "FABRIC2SWITCH_ID");
        tableToAutoIdMapping.put(Zset2zone.getTablename(), "ZSET2ZONE_ID");
        tableToAutoIdMapping.put(Switch2port.getTablename(), "SWITCH2PORT_ID");
        tableToAutoIdMapping.put(RegisteredCimom.getTablename(), "REG_CIMOM_ID");
        tableToAutoIdMapping.put(Alias.getTablename(), "ALIAS_ID");
        tableToAutoIdMapping.put(Alias2member.getTablename(), "ALIAS2MEMBER_ID");
        tableToAutoIdMapping.put(Zone2alias.getTablename(), "ZONE2ALIAS_ID");
        tableToAutoIdMapping.put(PhysicalVolume.getTablename(), "PHYSICAL_VOLUME_ID");
    }
}

