/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.parser;

import java.util.Hashtable;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.CIMEnumerationResponse;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.discovery.parser.Parser;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.queue.DefaultJobQueue;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.QueueController;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.client.CIMEnumeration;

public class CIMParser
extends Thread {
    public static String queueName = "CIMParser";
    public static final String MESSAGE_NAME = "aperi.logger.message.CIMParser";
    public static final String TRACE_NAME = "aperi.logger.trace.Discovery";
    public static String MSG_FILE = "org.eclipse.aperi.resources.CIMParser";
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    public boolean trace = false;
    String className = CIMParser.class.getName();
    private Worker worker = null;
    private boolean shutdown = false;
    private Thread thread = null;

    public CIMParser() {
        if (traceLogger != null && traceLogger.isLogging()) {
            this.trace = true;
        }
        this.setName(queueName + " (" + this.getName() + ")");
        this.worker = new Worker();
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new DefaultJobQueue());
        this.start();
    }

    public void run() {
        this.thread = Thread.currentThread();
        while (!this.shutdown) {
            if (Configuration.debug && traceLogger.isLogging()) {
                traceLogger.message(IRecordType.TYPE_INFO, (Object)this, queueName, ": waiting for a job");
            }
            JobInfo job = QueueController.getInstance().getNextJob(queueName);
            if (this.shutdown) continue;
            if (job == null) {
                if (traceLogger.isLogging()) {
                    traceLogger.message(IRecordType.TYPE_ERROR, (Object)this.className, queueName, ":Error - got a NULL job from queue");
                }
                System.out.println(queueName + ":Error - got a NULL job from the queue");
                msgLogger.message(IRecordType.TYPE_INFO, (Object)this, queueName, ":Error - got a NULL job from the queue");
                continue;
            }
            this.worker.processJob(job);
        }
    }

    public void shutdown() {
        String methodName = "shutdown";
        this.shutdown = true;
        if (this.thread != null) {
            try {
                this.thread.interrupt();
                this.thread.join(30000L);
                this.thread = null;
            }
            catch (Exception e) {
                msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, "Exception During:" + methodName);
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this.className, methodName, (Throwable)e);
                }
                e.printStackTrace();
            }
        }
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }

    class Worker
    extends Parser {
        Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected void parse(JobInfo job) {
            block46: {
                String methodName = "parse";
                Response response = job.getRequest();
                try {
                    block47: {
                        CIMProcessor processor;
                        CIMEnumeration e;
                        block45: {
                            block44: {
                                block49: {
                                    block48: {
                                        if (!(response instanceof CIMEnumerationResponse)) break block47;
                                        if (Configuration.debug) {
                                            System.out.println(queueName + ": Received a CIM Enumeration response");
                                            if (traceLogger.isLogging()) {
                                                traceLogger.message(IRecordType.TYPE_ERROR, (Object)CIMParser.this.className, methodName, queueName + ": Received a CIM Enumeration response");
                                            }
                                            msgLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, queueName + ": Received a CIM Enumeration response");
                                        }
                                        e = null;
                                        processor = new CIMProcessor();
                                        if (!processor.start(job)) break block44;
                                        e = (CIMEnumeration)response.getData();
                                        if (job == null) break block48;
                                        Query query = (Query)job.getPreviousJob().getRequest().getData();
                                        switch (query.getCmd()) {
                                            case 0: 
                                            case 1: {
                                                while (e.hasMoreElements()) {
                                                    CIMInstance instance = (CIMInstance)e.nextElement();
                                                    processor.handleInstance(job, instance);
                                                }
                                                break block49;
                                            }
                                            case 2: 
                                            case 3: {
                                                Hashtable properties = CIMProcessor.convertPropertiesToHashtable(query.getProperties(), new Hashtable());
                                                while (e.hasMoreElements()) {
                                                    CIMInstance instance = (CIMInstance)e.nextElement();
                                                    Hashtable responseProperties = CIMProcessor.convertPropertiesToHashtable(instance.getProperties(), new Hashtable());
                                                    processor.handleAssociation(job, query.getAssocClassName(), query.getClassName(), properties, instance.getClassName(), responseProperties, null);
                                                }
                                                break block49;
                                            }
                                            case 4: 
                                            case 5: {
                                                while (e.hasMoreElements()) {
                                                    CIMClass klass = (CIMClass)e.nextElement();
                                                    if (klass.getSuperClass() == null) continue;
                                                    Hashtable<String, String> properties = new Hashtable<String, String>();
                                                    properties.put("ref_classname", klass.getName());
                                                    properties.put("ref_superclass", klass.getSuperClass());
                                                    processor.handleEntity(job, "CIM_Class", properties);
                                                }
                                                break block49;
                                            }
                                            default: {
                                                if (traceLogger.isLogging()) {
                                                    traceLogger.message(IRecordType.TYPE_INFORMATION, (Object)CIMParser.this.className, methodName, "Unable to determine type of data-cmd" + ((Query)job.getRequest().getData()).getCmd() + "is undefined");
                                                }
                                                msgLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, " unable to determine type of data - cmd = " + ((Query)job.getRequest().getData()).getCmd() + "is undefined.");
                                                System.out.println(queueName + " unable to determine type of data - cmd = " + ((Query)job.getRequest().getData()).getCmd() + "is undefined.");
                                            }
                                        }
                                        break block49;
                                    }
                                    if (traceLogger.isLogging()) {
                                        traceLogger.message(IRecordType.TYPE_INFORMATION, (Object)CIMParser.this.className, methodName, queueName + ": Unable to determine type of data - no previousJobInfo");
                                    }
                                    System.out.println(queueName + ": unable to determine type of data - no previousJob info");
                                }
                                job.setReturnCode(0);
                                job.complete(true);
                            }
                            Object var11_16 = null;
                            if (processor == null) break block45;
                            processor.end(Integer.parseInt(job.getDiscoverRequest()));
                            processor.shutdown();
                            processor = null;
                        }
                        try {
                            if (e != null) {
                                e.close();
                            }
                            break block46;
                        }
                        catch (Exception inE) {
                            msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, "Exception in CIMParse:" + methodName);
                            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)inE);
                            if (traceLogger.isLogging()) {
                                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)CIMParser.this.className, methodName, (Throwable)inE);
                            }
                            inE.printStackTrace();
                        }
                        break block46;
                        {
                            catch (Exception ex) {
                                msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, "Exception in CIMParse:" + methodName);
                                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)ex);
                                if (traceLogger.isLogging()) {
                                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)CIMParser.this.className, methodName, (Throwable)ex);
                                }
                                job.setReturnCode(99);
                                job.complete(false);
                                ex.printStackTrace();
                                Object var11_17 = null;
                                if (processor != null) {
                                    processor.end(Integer.parseInt(job.getDiscoverRequest()));
                                    processor.shutdown();
                                    processor = null;
                                }
                                try {
                                    if (e != null) {
                                        e.close();
                                    }
                                    break block46;
                                }
                                catch (Exception inE) {
                                    msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, "Exception in CIMParse:" + methodName);
                                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)inE);
                                    if (traceLogger.isLogging()) {
                                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)CIMParser.this.className, methodName, (Throwable)inE);
                                    }
                                    inE.printStackTrace();
                                }
                                break block46;
                            }
                            catch (Throwable t) {
                                msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, "Exception in CIMParse:" + methodName);
                                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, t);
                                if (traceLogger.isLogging()) {
                                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)CIMParser.this.className, methodName, t);
                                }
                                job.complete(false);
                                t.printStackTrace();
                                Object var11_18 = null;
                                if (processor != null) {
                                    processor.end(Integer.parseInt(job.getDiscoverRequest()));
                                    processor.shutdown();
                                    processor = null;
                                }
                                try {
                                    if (e != null) {
                                        e.close();
                                    }
                                    break block46;
                                }
                                catch (Exception inE) {
                                    msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, "Exception in CIMParse:" + methodName);
                                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)inE);
                                    if (traceLogger.isLogging()) {
                                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)CIMParser.this.className, methodName, (Throwable)inE);
                                    }
                                    inE.printStackTrace();
                                }
                                break block46;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_19 = null;
                            if (processor != null) {
                                processor.end(Integer.parseInt(job.getDiscoverRequest()));
                                processor.shutdown();
                                processor = null;
                            }
                            try {
                                if (e != null) {
                                    e.close();
                                }
                            }
                            catch (Exception inE) {
                                msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, "Exception in CIMParse:" + methodName);
                                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)inE);
                                if (traceLogger.isLogging()) {
                                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)CIMParser.this.className, methodName, (Throwable)inE);
                                }
                                inE.printStackTrace();
                            }
                            throw throwable;
                        }
                    }
                    System.out.println("Invalid response type for CIM Parser");
                    job.complete(false);
                }
                finally {
                    try {
                        if (Configuration.debug) {
                            System.out.println(queueName + ": Finishing job");
                        }
                        response.close();
                    }
                    catch (Exception inE) {
                        msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, "Exception in CIMParse:" + methodName);
                        msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)inE);
                        if (traceLogger.isLogging()) {
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)CIMParser.this.className, methodName, (Throwable)inE);
                        }
                        inE.printStackTrace();
                    }
                }
            }
        }
    }
}

