/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.parser;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.Constants;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.discovery.parser.TSANMLegacyParser;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DESaxParser
extends DefaultHandler
implements ErrorHandler {
    static ILogger msgLogger = TSANMLegacyParser.msgLogger;
    static ILogger traceLogger = TSANMLegacyParser.traceLogger;
    static final String className = DESaxParser.class.getName();
    private String charDataBuffer;
    private short currentLevel = 0;
    private String sectionUniqueID;
    private String currentSection = null;
    private Processor processor = null;
    private Hashtable entityTable = new Hashtable();
    private String paramName = null;
    private boolean isConnectivityXml = false;
    private JobInfo job = null;
    private ILogger jobLogger = null;
    private Request request = null;

    public DESaxParser(Processor processor, JobInfo job) {
        this.processor = processor;
        this.job = job;
        this.request = Router.getRouter().getRequest(job.getDiscoverRequest());
        if (this.request != null) {
            this.jobLogger = this.request.getJobLogger();
        }
    }

    public void startElement(String nameSpaceURI, String localName, String qualifiedName, Attributes attribs) throws SAXException {
        String methodName = "startElement()";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (this.currentLevel == 0 || this.currentLevel == 1) {
            this.currentLevel = (short)(this.currentLevel + 1);
            this.currentSection = qualifiedName;
        } else if (this.currentLevel == 2 || this.currentLevel == 3) {
            if (qualifiedName.equalsIgnoreCase("ConnectivityGroupXml")) {
                this.isConnectivityXml = true;
            }
            this.currentLevel = (short)(this.currentLevel + 1);
        }
        if (traceLogger.isLogging()) {
            String msg = "qualifiedName = " + qualifiedName + "\tcurrentLevel = " + this.currentLevel;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, msg);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String methodName = "characters()";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.charDataBuffer = this.charDataBuffer == null ? new String(ch, start, length) : new String(this.charDataBuffer + new String(ch, start, length));
        if (traceLogger.isLogging()) {
            String msg = "charDataBuffer = " + (this.charDataBuffer == null ? null : this.charDataBuffer);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, msg);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String msg;
        String methodName = "endElement()";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new SAXException("Discover Engine shutdown detected.");
        }
        if (this.currentSection.equalsIgnoreCase("SolarisStorageAutomationHost")) {
            this.currentLevel = (short)(this.currentLevel - 1);
            if (traceLogger.isLogging()) {
                String msg2 = "Skipping tag, SolarisStorageAutomationHost";
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, msg2);
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return;
        }
        if (this.currentLevel == 4) {
            if (qName.equalsIgnoreCase("NameXml")) {
                this.paramName = this.charDataBuffer;
                this.charDataBuffer = null;
                if (traceLogger.isLogging()) {
                    msg = "currentLevel = " + this.currentLevel + "\t" + qName + " = " + this.paramName;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, msg);
                }
            } else if (qName.equalsIgnoreCase("ValueXml")) {
                if (traceLogger.isLogging()) {
                    msg = "currentLevel = " + this.currentLevel + "\t" + qName + " = " + this.charDataBuffer;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, msg);
                }
                if (this.charDataBuffer != null) {
                    this.entityTable.put(this.paramName, this.charDataBuffer);
                }
                this.charDataBuffer = null;
                this.paramName = null;
            } else if (this.isConnectivityXml && !qName.equalsIgnoreCase("ParameterXml")) {
                if (traceLogger.isLogging()) {
                    msg = "currentLevel = " + this.currentLevel + "\t Processing ConnectivityGroupXml";
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, msg);
                    msg = "sectionUniqueID = " + this.sectionUniqueID + "\t" + "ConnectivityGroupXml" + qName + "\tvalue = " + this.charDataBuffer;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, msg);
                }
                if (!this.entityTable.isEmpty()) {
                    this.processEntityData();
                }
                this.processRelationshipData(this.sectionUniqueID, "ConnectivityGroupXml" + qName, this.charDataBuffer);
                this.charDataBuffer = null;
            }
            this.currentLevel = (short)(this.currentLevel - 1);
        } else if (this.currentLevel == 3) {
            if (!qName.equalsIgnoreCase("ParameterXml")) {
                if (qName.equalsIgnoreCase("UniqueIdXml") || qName.equalsIgnoreCase("DeltaXml")) {
                    if (traceLogger.isLogging()) {
                        msg = "currentLevel = " + this.currentLevel + "\t" + qName + " = " + (this.charDataBuffer == null ? null : this.charDataBuffer);
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, msg);
                    }
                    if (this.charDataBuffer == null) {
                        String errStr = "null uniqueID in section " + this.currentSection;
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, errStr);
                            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                        }
                        throw new SAXException(errStr);
                    }
                    this.sectionUniqueID = this.charDataBuffer;
                    this.entityTable.put(qName, new String(this.charDataBuffer));
                    this.charDataBuffer = null;
                } else if (qName.equalsIgnoreCase("ConnectivityGroupXml")) {
                    if (traceLogger.isLogging()) {
                        msg = "Processing " + qName;
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, msg);
                    }
                    if (!this.entityTable.isEmpty()) {
                        this.processEntityData();
                    }
                    this.isConnectivityXml = false;
                } else {
                    if (!this.entityTable.isEmpty()) {
                        this.processEntityData();
                    }
                    if (this.charDataBuffer == null) {
                        String errStr = "null uniqueID for tag " + qName + " in section " + this.currentSection;
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, errStr);
                            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                        }
                        throw new SAXException(errStr);
                    }
                    this.processRelationshipData(this.sectionUniqueID, qName, this.charDataBuffer);
                    this.charDataBuffer = null;
                }
            }
            this.currentLevel = (short)(this.currentLevel - 1);
        } else if (this.currentLevel == 2) {
            if (traceLogger.isLogging()) {
                msg = "currentLevel = " + this.currentLevel + "\t qName = " + qName;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, msg);
            }
            if (this.currentSection.equalsIgnoreCase("DeltaXml")) {
                if (this.charDataBuffer != null) {
                    this.entityTable.put(qName, this.charDataBuffer);
                }
                this.charDataBuffer = null;
            } else if (!this.entityTable.isEmpty()) {
                this.processEntityData();
            }
            this.currentLevel = (short)(this.currentLevel - 1);
        } else if (this.currentLevel == 1) {
            // empty if block
        }
        if (traceLogger.isLogging()) {
            msg = "currentLevel = " + this.currentLevel;
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, msg);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void processEntityData() {
        String methodName = "processEntityData()";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (this.entityTable.isEmpty()) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "entityTable is empty");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return;
        }
        if (!this.currentSection.equalsIgnoreCase("HeaderXml")) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Content of entityTable:");
                Enumeration keys = this.entityTable.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = (String)this.entityTable.get(key);
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, key + " = " + value);
                }
            }
            try {
                this.processor.handleEntity(this.job, this.currentSection, this.entityTable);
            }
            catch (Exception e) {
                if (this.jobLogger != null) {
                    this.jobLogger.message(IRecordType.TYPE_ERROR, (Object)className, methodName, "DESaxParserParserJob_PersistError", (Object[])new String[]{this.request.getDeviceServerRunNumber(), String.valueOf(this.request.getId()), e.getMessage()});
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                this.job.setSuccessful(false);
            }
            this.entityTable.clear();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void processRelationshipData(String fromUniqueID, String relationShipName, String toUniqueID) {
        String methodName = "processRelationshipData()";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (this.entityTable != null) {
            this.entityTable.clear();
        }
        this.entityTable.put("FromUniqueIdXml", fromUniqueID);
        this.entityTable.put("ToUniqueIdXml", toUniqueID);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Content of the entityTable:");
            Enumeration keys = this.entityTable.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)this.entityTable.get(key);
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, key + " = " + value);
            }
        }
        try {
            this.processor.handleEntity(this.job, this.currentSection + "2" + relationShipName, this.entityTable);
        }
        catch (Exception e) {
            if (this.jobLogger != null) {
                this.jobLogger.message(IRecordType.TYPE_ERROR, (Object)className, methodName, "DESaxParserParserJob_PersistError", (Object[])new String[]{this.request.getDeviceServerRunNumber(), String.valueOf(this.request.getId()), e.getMessage()});
            }
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
        }
        this.entityTable.clear();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private String getScannerId(String oldId) {
        Object newId = null;
        int index = oldId.indexOf(58);
        String prefix = oldId.substring(0, index);
        String suffix = oldId.substring(index + 1);
        return Constants.SCANNERS.get(prefix) + suffix;
    }

    public void warning(SAXParseException exception) throws SAXException {
        String methodName = "warning";
        if (this.jobLogger != null) {
            this.jobLogger.message(IRecordType.TYPE_WARNING, (Object)className, methodName, "DESaxParserParserJob_Warning", (Object[])new String[]{this.request.getDeviceServerRunNumber(), String.valueOf(this.request.getId()), this.GetErrorString(exception)});
        }
        if (traceLogger.isLogging()) {
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)exception);
        }
        msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)exception);
        throw new SAXException(this.GetErrorString(exception));
    }

    public void error(SAXParseException exception) throws SAXException {
        String methodName = "error";
        if (this.jobLogger != null) {
            this.jobLogger.message(IRecordType.TYPE_ERROR, (Object)className, methodName, "DESaxParserParserJob_Error", (Object[])new String[]{this.request.getDeviceServerRunNumber(), String.valueOf(this.request.getId()), this.GetErrorString(exception)});
        }
        msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)exception);
        if (traceLogger.isLogging()) {
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)exception);
        }
        throw new SAXException(this.GetErrorString(exception));
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        String methodName = "fatalError";
        if (this.jobLogger != null) {
            this.jobLogger.message(IRecordType.TYPE_FATAL, (Object)className, methodName, "DESaxParserParserJob_FatalError", (Object[])new String[]{this.request.getDeviceServerRunNumber(), String.valueOf(this.request.getId()), this.GetErrorString(exception)});
        }
        msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)exception);
        if (traceLogger.isLogging()) {
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)exception);
        }
        throw new SAXException(this.GetErrorString(exception));
    }

    private String GetErrorString(SAXParseException exception) {
        StringBuffer errString = new StringBuffer("Line: ");
        errString.append(exception.getLineNumber());
        errString.append("\nMessage: ");
        errString.append(exception.getMessage());
        return errString.toString();
    }
}

