/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.parser;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.DiscoveryActivator;
import org.eclipse.aperi.discovery.interfaces.DiscoveryException;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.AlertProcessor;
import org.eclipse.aperi.discovery.parser.EntityPersistWrapper;
import org.eclipse.aperi.discovery.parser.PersistWrapper;
import org.eclipse.aperi.discovery.parser.RelationshipPersistWrapper;
import org.eclipse.aperi.discovery.parser.TSANMLegacyParser;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.objects.Scanner;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityResult;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response;
import org.sblim.wbem.cim.CIMValue;

public class Processor {
    private static int numOperationsPerTransaction = 0;
    private static final int DEFAULT_NUM_OPERATIONS_PER_TRANSACTION = 1;
    private static final String PROPERTY_NUM_OPS_PER_TRANSACTION = "NumOperationsPerTransaction";
    private static final String PROPERTY_GROUP = "DiscoverService";
    private static final int MaxNumRetries = 20;
    private static IConfigService configServiceProxy = null;
    static ILogger msgLogger = TSANMLegacyParser.msgLogger;
    static ILogger traceLogger = TSANMLegacyParser.traceLogger;
    static final String className = Processor.class.getName();
    protected static String discoverEventPrefix = "D";
    private static boolean timeToShutdown = false;
    protected DBConnection connection = null;
    private String sourceType = null;
    private MapperRouter mapperRouter = MapperRouter.getMapperRouter();
    private ViewReportTablesUpdater vrtu = null;
    private static IEventMonitorService eventMonitor = null;
    protected Hashtable newEntities = new Hashtable();
    protected Hashtable modifiedEntities = new Hashtable();
    private ChangeDetection changeDetection = null;
    private List history = new ArrayList();

    public Processor(String sourceType) {
        this.sourceType = sourceType;
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            this.connection = (DBConnection)ds.getPooledConnection();
            this.changeDetection = new ChangeDetection(this.connection);
            this.vrtu = new ViewReportTablesUpdater();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.connection = null;
        }
    }

    public boolean start(int discoverRequest) {
        block4: {
            String methodName = "start";
            Request request = Router.getRouter().getRequest(new Integer(discoverRequest).toString());
            if (request != null) {
                Request parentRequest = request.getParentRequest();
                if (!(request.getScannerId() == null || parentRequest != null && parentRequest.getScannerId() != null && parentRequest.getScannerId().equals(request.getScannerId()))) {
                    try {
                        DetectabilityService.startDiscovery((String)request.getScannerId(), (int)request.getAuthoritativeReferenceType(), (int)request.getAuthoritativeReferenceId(), (String)(discoverEventPrefix + request.getId()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                        if (!traceLogger.isLogging()) break block4;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
        }
        return true;
    }

    public boolean start(JobInfo job) {
        if (!this.checkLevel(job)) {
            return false;
        }
        this.start(Integer.parseInt(job.getDiscoverRequest()));
        return this.isReturnCodeOK(job);
    }

    public void finish() {
        try {
            this.connection.commit();
            this.history.clear();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void end(int discoverRequest) {
        String methodName = "end";
        try {
            this.connection.commit();
            this.history.clear();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Request request = Router.getRouter().getRequest(new Integer(discoverRequest).toString());
        if (request != null) {
            block16: {
                Request parentRequest = request.getParentRequest();
                if (!(request.getScannerId() == null || parentRequest != null && parentRequest.getScannerId() != null && parentRequest.getScannerId().equals(request.getScannerId()))) {
                    try {
                        DetectabilityResult result = DetectabilityService.stopDiscovery((String)request.getScannerId());
                        if (result.modifiedEntities != null) {
                            for (String systemType : result.modifiedEntities.keySet()) {
                                List systemIdVec = (List)result.modifiedEntities.get(systemType);
                                if (systemIdVec == null) continue;
                                List modIdVec = (List)this.modifiedEntities.get(systemType);
                                if (modIdVec == null) {
                                    this.modifiedEntities.put(systemType, systemIdVec);
                                    continue;
                                }
                                modIdVec.addAll(systemIdVec);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                        if (!traceLogger.isLogging()) break block16;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.changeDetection.startNew(this.connection, (Map)this.newEntities);
            this.newEntities.clear();
            try {
                this.changeDetection.complete(this.connection, (Map)this.modifiedEntities, discoverEventPrefix + new Integer(discoverRequest).toString());
                this.modifiedEntities.clear();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            Processor.getEventMonitorProxy().handleModelUpdate(discoverEventPrefix + new Integer(discoverRequest).toString());
            this.vrtu.processEntityView(request.getAuthoritativeReferenceId(), request.getAuthoritativeReferenceType());
        } else {
            System.out.println("Process.end - unable to find request for " + discoverRequest);
        }
    }

    public void updateLevel(JobInfo job) {
        this.updateLevel(job, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateLevel(JobInfo job, boolean clearLevel) {
        block34: {
            boolean updateOK = true;
            String methodName = "updateLevel";
            DBConnection conn = ServiceUtils.getConnection();
            Scanner scanner = new Scanner();
            scanner.setScannerId(this.getScanID(job));
            if (job.isSuccessful() && !clearLevel) {
                scanner.setBenchmark(this.getLevel(job));
            } else {
                scanner.setBenchmark(-1);
            }
            scanner.update(conn);
            Object var9_7 = null;
            try {
                if (conn != null) {
                    if (updateOK) {
                        conn.commit();
                    } else {
                        conn.rollback();
                    }
                }
            }
            catch (Exception e2) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e2);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                }
                updateOK = false;
            }
            try {
                if (conn != null) {
                    conn.close();
                }
                break block34;
            }
            catch (Exception e2) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e2);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                }
                updateOK = false;
            }
            break block34;
            {
                catch (Exception e) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    updateOK = false;
                    Object var9_8 = null;
                    try {
                        if (conn != null) {
                            if (updateOK) {
                                conn.commit();
                            } else {
                                conn.rollback();
                            }
                        }
                    }
                    catch (Exception e2) {
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e2);
                        if (traceLogger.isLogging()) {
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                        }
                        updateOK = false;
                    }
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block34;
                    }
                    catch (Exception e2) {
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e2);
                        if (traceLogger.isLogging()) {
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                        }
                        updateOK = false;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (conn != null) {
                        if (updateOK) {
                            conn.commit();
                        } else {
                            conn.rollback();
                        }
                    }
                }
                catch (Exception e2) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e2);
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                    }
                    updateOK = false;
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception e2) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e2);
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                    }
                    updateOK = false;
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void setInactiveProcessed(JobInfo job, int inactiveProcessed) {
        block32: {
            boolean updateOK = true;
            String methodName = "setInactiveProcessed";
            DBConnection conn = ServiceUtils.getConnection();
            Scanner scanner = new Scanner();
            scanner.setScannerId(this.getScanID(job));
            scanner.setInactiveProcessed(inactiveProcessed);
            scanner.update(conn);
            Object var9_7 = null;
            try {
                if (conn != null) {
                    if (updateOK) {
                        conn.commit();
                    } else {
                        conn.rollback();
                    }
                }
            }
            catch (Exception e2) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e2);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                }
                updateOK = false;
            }
            try {
                if (conn != null) {
                    conn.close();
                }
                break block32;
            }
            catch (Exception e2) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e2);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                }
                updateOK = false;
            }
            break block32;
            {
                catch (Exception e) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    updateOK = false;
                    Object var9_8 = null;
                    try {
                        if (conn != null) {
                            if (updateOK) {
                                conn.commit();
                            } else {
                                conn.rollback();
                            }
                        }
                    }
                    catch (Exception e2) {
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e2);
                        if (traceLogger.isLogging()) {
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                        }
                        updateOK = false;
                    }
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block32;
                    }
                    catch (Exception e2) {
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e2);
                        if (traceLogger.isLogging()) {
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                        }
                        updateOK = false;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (conn != null) {
                        if (updateOK) {
                            conn.commit();
                        } else {
                            conn.rollback();
                        }
                    }
                }
                catch (Exception e2) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e2);
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                    }
                    updateOK = false;
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception e2) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e2);
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                    }
                    updateOK = false;
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkLevel(JobInfo job) {
        Scanner scanner = null;
        int dbLevel = -1;
        if (!this.isReturnCodeOK(job)) {
            return true;
        }
        if (this.getBenchmarkLevel(job) == -1) {
            return true;
        }
        DBConnection conn = ServiceUtils.getConnection();
        try {
            Hashtable<ColumnInfo, String> parm = new Hashtable<ColumnInfo, String>();
            parm.put(Scanner.getColumnInfo((String)"SCANNER_ID"), this.getScanID(job));
            scanner = Scanner.retrieve((DBConnection)conn, parm);
            if (scanner != null) {
                dbLevel = scanner.getBenchmark();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (dbLevel == -1) {
            return true;
        }
        return dbLevel != this.getLevel(job);
    }

    public static boolean isTimeToShutdown() {
        return timeToShutdown;
    }

    public static void setTimeToShutdown(boolean timeToShutdown) {
        Processor.timeToShutdown = timeToShutdown;
    }

    public void handleAssociation(JobInfo job, String association, String entity1, Hashtable entity1_properties, String entity2, Hashtable entity2_properties, Hashtable properties) throws DiscoveryException {
        if (Configuration.debug) {
            Processor.printAssociation(association, entity1, entity1_properties, entity2, entity2_properties, properties);
        }
        try {
            String dedicated = null;
            try {
                dedicated = (String)properties.get("dedicated");
            }
            catch (Exception e) {
                // empty catch block
            }
            IDBAttributeMapper invokerMapper = this.mapperRouter.findMapper(association, null, null, null, dedicated);
            if (invokerMapper == null) {
                System.out.println("DB Mapper does not exist for " + association + " " + properties);
                return;
            }
            dedicated = null;
            try {
                dedicated = (String)entity1_properties.get("dedicated");
            }
            catch (Exception e) {
                // empty catch block
            }
            IDBAttributeMapper entity1Mapper = this.mapperRouter.findMapper(entity1, null, null, null, dedicated);
            if (entity1Mapper == null) {
                System.out.println("DB Mapper does not exist for " + entity1 + " " + entity1_properties);
                return;
            }
            dedicated = null;
            try {
                dedicated = (String)entity2_properties.get("dedicated");
            }
            catch (Exception e) {
                // empty catch block
            }
            IDBAttributeMapper entity2Mapper = this.mapperRouter.findMapper(entity2, null, null, null, dedicated);
            if (entity2Mapper == null) {
                System.out.println("DB Mapper does not exist for " + entity2 + " " + entity2_properties);
                return;
            }
            MapperResult result = Processor.persist(this.connection, invokerMapper, properties, entity1Mapper, entity1_properties, entity2Mapper, entity2_properties, this.getScanID(job), this.history, discoverEventPrefix + job.getDiscoverRequest(), this.newEntities, this.modifiedEntities);
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.connection.rollback();
                this.history.clear();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw new DiscoveryException(e);
        }
        catch (Exception e) {
            throw new DiscoveryException(e);
        }
    }

    public void handleEntity(JobInfo job, String instance, Hashtable properties) throws DiscoveryException {
        if (Configuration.debug) {
            Processor.printEntity(instance, properties);
        }
        try {
            String dedicated = null;
            try {
                dedicated = (String)properties.get("dedicated");
            }
            catch (Exception e) {
                // empty catch block
            }
            IDBAttributeMapper mapper = this.mapperRouter.findMapper(instance, null, null, null, dedicated);
            if (mapper == null) {
                System.out.println("DB Mapper does not exist for " + instance + " " + properties);
                return;
            }
            MapperResult result = Processor.persist(this.connection, mapper, properties, this.getScanID(job), this.history, discoverEventPrefix + job.getDiscoverRequest(), this.newEntities, this.modifiedEntities);
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.connection.rollback();
                this.history.clear();
            }
            catch (SQLException ignore) {
                throw new DiscoveryException(e);
            }
        }
        catch (Throwable e) {
            throw new DiscoveryException(e);
        }
    }

    public static void printHashtable(Hashtable properties) {
        if (properties != null) {
            Enumeration e = properties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object value = properties.get(key);
                if (value instanceof CIMValue) {
                    System.out.println("    Property = " + key + ", Value = " + value.toString());
                    continue;
                }
                if (value instanceof ArrayList) {
                    System.out.print("    Property = " + key + ", ValueArray = ");
                    ArrayList arr = (ArrayList)value;
                    if (arr.isEmpty()) {
                        System.out.print("null");
                    } else {
                        for (int i = 0; i < arr.size(); ++i) {
                            System.out.print((String)arr.get(i) + " : ");
                        }
                    }
                    System.out.println();
                    continue;
                }
                String val = value.toString();
                if ("".equals(val)) {
                    val = "null";
                }
                System.out.println("    Property = " + key + ", Value = " + val);
            }
        } else {
            System.out.println("    Property hashtable is null");
        }
    }

    public static void printEntity(String instance, Hashtable properties) {
        System.out.println("Instance = " + instance);
        Processor.printHashtable(properties);
    }

    public static void printAssociation(String association, String entity1, Hashtable entity1_properties, String entity2, Hashtable entity2_properties, Hashtable properties) {
        System.out.println("Association = " + association);
        System.out.println("Entity1 = " + entity1);
        Processor.printHashtable(entity1_properties);
        System.out.println("Entity2 = " + entity2);
        Processor.printHashtable(entity2_properties);
        System.out.println("Properties:");
        Processor.printHashtable(properties);
    }

    private int getLevel(JobInfo job) {
        int result = -1;
        if (job.getRequest() != null && job.getRequest().getData() instanceof Response && ((Response)job.getRequest().getData()).getReturnCode() == Response.RETURN_CODE_OK) {
            result = ((Response)job.getRequest().getData()).getLevel();
        }
        return result;
    }

    private int getBenchmarkLevel(JobInfo job) {
        int result = -1;
        if (job.getRequest() != null && job.getRequest().getData() instanceof Response && ((Response)job.getRequest().getData()).getReturnCode() == Response.RETURN_CODE_OK) {
            result = ((Response)job.getRequest().getData()).getBenchmarkLevel();
        }
        return result;
    }

    private boolean isReturnCodeOK(JobInfo job) {
        if (job.getRequest() != null && job.getRequest().getData() != null && job.getRequest().getData() instanceof Response) {
            return ((Response)job.getRequest().getData()).getReturnCode() == Response.RETURN_CODE_OK;
        }
        return true;
    }

    protected String getScanID(JobInfo job) {
        Request request = Router.getRouter().getRequest(job.getDiscoverRequest());
        if (request != null) {
            return request.getScannerId();
        }
        return null;
    }

    public static IEventMonitorService getEventMonitorProxy() {
        if (eventMonitor == null) {
            eventMonitor = (IEventMonitorService)DiscoveryActivator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        }
        return eventMonitor;
    }

    public static IConfigService getConfigServiceProxy() {
        if (configServiceProxy == null) {
            configServiceProxy = (IConfigService)DiscoveryActivator._serviceHelper.bindLocal("ConfigService");
        }
        return configServiceProxy;
    }

    public static int getNumberOfOperationsPerTransaction() {
        String methodName = "getNumberOfOperationsPerTransaction";
        if (numOperationsPerTransaction <= 0) {
            try {
                numOperationsPerTransaction = Integer.parseInt(Processor.getConfigServiceProxy().getProperty(PROPERTY_NUM_OPS_PER_TRANSACTION, PROPERTY_GROUP));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (numOperationsPerTransaction <= 0) {
                numOperationsPerTransaction = 1;
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Number of Operations per Transaction is " + numOperationsPerTransaction);
            }
        }
        return numOperationsPerTransaction;
    }

    public static MapperResult persist(DBConnection connection, IDBAttributeMapper invoker, Hashtable invoker_htValues, IDBAttributeMapper entity1, Hashtable entity1_htValues, IDBAttributeMapper entity2, Hashtable entity2_htValues, String scanID, List history, String alertID, Hashtable newEntities, Hashtable modifiedEntities) throws SQLException {
        MapperResult result = null;
        try {
            history.add(new RelationshipPersistWrapper(invoker, (Hashtable)invoker_htValues.clone(), entity1, (Hashtable)entity1_htValues.clone(), entity2, (Hashtable)entity2_htValues.clone(), scanID));
            result = invoker.persist(connection, entity1, (Hashtable)entity1_htValues.clone(), entity2, (Hashtable)entity2_htValues.clone(), scanID);
            AlertProcessor.processAlerts(alertID, result, newEntities, modifiedEntities);
            if (history.size() > Processor.getNumberOfOperationsPerTransaction()) {
                connection.commit();
                history.clear();
            }
        }
        catch (SQLException e) {
            if (SQLExceptionHelper.isDeadlock((DBConnection)connection, (SQLException)e)) {
                result = Processor.retryPersist(connection, history);
                AlertProcessor.processAlerts(alertID, result, newEntities, modifiedEntities);
                connection.commit();
                history.clear();
            }
            throw e;
        }
        return result;
    }

    public static MapperResult persist(DBConnection connection, IDBAttributeMapper entity, Hashtable entity_htValues, String scanID, List history, String alertID, Hashtable newEntities, Hashtable modifiedEntities) throws SQLException {
        MapperResult result = null;
        try {
            history.add(new EntityPersistWrapper(entity, (Hashtable)entity_htValues.clone(), scanID));
            result = entity.persist(connection, (Hashtable)entity_htValues.clone(), scanID);
            AlertProcessor.processAlerts(alertID, result, newEntities, modifiedEntities);
            if (history.size() > Processor.getNumberOfOperationsPerTransaction()) {
                connection.commit();
                history.clear();
            }
        }
        catch (SQLException e) {
            if (SQLExceptionHelper.isDeadlock((DBConnection)connection, (SQLException)e)) {
                result = Processor.retryPersist(connection, history);
                AlertProcessor.processAlerts(alertID, result, newEntities, modifiedEntities);
                connection.commit();
                history.clear();
            }
            throw e;
        }
        return result;
    }

    protected static MapperResult retryPersist(DBConnection connection, List persistHistory) throws SQLException {
        String methodName = "persist";
        boolean toRetry = false;
        int numRetries = 0;
        Random randomGenerator = new Random();
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Deadlock encountered - retrying " + persistHistory.size() + " operations.");
        }
        while (true) {
            try {
                MapperResult result = null;
                for (Object o : persistHistory) {
                    PersistWrapper w;
                    if (o instanceof RelationshipPersistWrapper) {
                        w = (RelationshipPersistWrapper)o;
                        result = ((RelationshipPersistWrapper)w).getInvoker().persist(connection, ((RelationshipPersistWrapper)w).getEntity1(), (Hashtable)((RelationshipPersistWrapper)w).getEntity1_htValues().clone(), ((RelationshipPersistWrapper)w).getEntity2(), (Hashtable)((RelationshipPersistWrapper)w).getEntity2_htValues().clone(), ((RelationshipPersistWrapper)w).getScanID());
                        continue;
                    }
                    if (o instanceof EntityPersistWrapper) {
                        w = (EntityPersistWrapper)o;
                        result = ((EntityPersistWrapper)w).getEntity().persist(connection, (Hashtable)((EntityPersistWrapper)w).getEntity_htValues().clone(), ((EntityPersistWrapper)w).getScanID());
                        continue;
                    }
                    System.out.println("Unrecognized PersistWrapper type");
                }
                toRetry = false;
                return result;
            }
            catch (SQLException e) {
                if (SQLExceptionHelper.isDeadlock((DBConnection)connection, (SQLException)e)) {
                    connection.rollback();
                    if (++numRetries <= 20) {
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Deadlock within Retry of Operations - Retry " + numRetries + " after deadlock");
                        } else {
                            System.out.println(className + " " + methodName + " Retry " + numRetries + "after deadlock");
                        }
                        toRetry = true;
                        long msWaitPeriod = (long)(15000.0 * randomGenerator.nextDouble() * (double)numRetries);
                        if (msWaitPeriod < 100L) {
                            msWaitPeriod = 100L;
                        }
                        try {
                            Thread.sleep(msWaitPeriod);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        continue;
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Number of Retries exceeded; aborting with SQLException");
                    }
                    throw e;
                }
                throw e;
                if (toRetry) continue;
                return null;
            }
            break;
        }
    }

    public DBConnection getConnection() {
        return this.connection;
    }
}

