/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.parser;

import java.io.StringReader;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.DESaxParser;
import org.eclipse.aperi.discovery.parser.Parser;
import org.eclipse.aperi.discovery.parser.TSANMLegacyProcessor;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.KeyedJobQueue;
import org.eclipse.aperi.util.queue.QueueController;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class TSANMLegacyParser
extends Thread {
    boolean shutdown = false;
    Thread thread = null;
    public static String queueName = "TSANMLegacyParser";
    public static SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    public static final String MESSAGE_NAME = "aperi.logger.message.TSANMLegacy";
    public static final String TRACE_NAME = "aperi.logger.trace.TSANMLegacy";
    public static String MSG_FILE = "org.eclipse.aperi.discovery.parser.resources.MsgLoggingTMS";
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    public static final String TopologyScanner = "TopologyScanner";
    private static Hashtable scanners = new Hashtable();
    private static String className = TSANMLegacyParser.class.getName();

    public TSANMLegacyParser() {
        this.setName(queueName + " (" + this.getName() + ")");
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new KeyedJobQueue(true));
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String methodName = "run";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        msgLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "TSANMLegacy_Started");
        this.thread = Thread.currentThread();
        Worker worker = new Worker();
        while (!this.shutdown) {
            String msg;
            if (traceLogger.isLogging()) {
                String msg2 = queueName + ": waiting for a job";
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, msg2);
            }
            JobInfo job = QueueController.getInstance().getNextJob(queueName);
            if (this.shutdown) continue;
            if (job == null) {
                if (!traceLogger.isLogging()) continue;
                String msg3 = queueName + ":Error - got a NULL job from the queue";
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, msg3);
                continue;
            }
            Response response = job.getRequest();
            if (response instanceof ObjectResponse) {
                if (traceLogger.isLogging()) {
                    msg = queueName + ": Received an Object response";
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, msg);
                }
                ILogger jobLogger = null;
                Request request = null;
                try {
                    request = Router.getRouter().getRequest(job.getDiscoverRequest());
                    if (request != null) {
                        jobLogger = request.getJobLogger();
                    }
                    worker.processJob(job);
                    if (job.isSuccessful()) {
                        job.setReturnCode(0);
                        job.complete(true);
                    } else {
                        if (jobLogger != null && request != null) {
                            jobLogger.message(IRecordType.TYPE_ERROR, (Object)className, methodName, "TSANMLegacyParserJob_Error", (Object[])new String[]{request.getDeviceServerRunNumber(), String.valueOf(request.getId()), ""});
                        }
                        job.setReturnCode(99);
                        job.complete(false);
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "TSANMLegacyParser Error");
                        }
                    }
                }
                catch (Throwable e) {
                    if (jobLogger != null && request != null) {
                        jobLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "TSANMLegacyParserJob_Error", (Object[])new String[]{request.getDeviceServerRunNumber(), String.valueOf(request.getId()), e.getMessage()});
                    }
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, e);
                    job.setReturnCode(99);
                    job.complete(false);
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, e);
                    }
                }
                finally {
                    response.close();
                }
            }
            if (traceLogger.isLogging()) {
                msg = queueName + ": Finishing job";
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, msg);
            }
            if (!traceLogger.isLogging()) continue;
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void shutdown() {
        String methodName;
        block5: {
            this.shutdown = true;
            methodName = "shutdown";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            if (this.thread != null) {
                msgLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "TSANMLegacy_Shutdown");
                try {
                    this.thread.interrupt();
                    this.thread.join(30000L);
                    this.thread = null;
                }
                catch (Exception e) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    if (!traceLogger.isLogging()) break block5;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
        saxFactory.setValidating(false);
    }

    class Worker
    extends Parser {
        String className = TSANMLegacyParser.class.getName();

        Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void parse(JobInfo job) {
            String methodName;
            block28: {
                methodName = "parse";
                ILogger jobLogger = null;
                Request request = Router.getRouter().getRequest(job.getDiscoverRequest());
                if (request != null) {
                    jobLogger = request.getJobLogger();
                }
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this.className, methodName);
                }
                String scanData = null;
                String agent = null;
                String scannerShortName = null;
                Object response = job.getRequest().getData();
                if (!(response instanceof org.eclipse.aperi.discovery.snmp.scanner.interfaces.Response)) {
                    if (response instanceof org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response) {
                        scanData = ((org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response)job.getRequest().getData()).getData();
                        scannerShortName = ((org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response)job.getRequest().getData()).getHeader().getScannerName();
                        agent = ((org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response)job.getRequest().getData()).getHeader().getAgentAddress();
                        int position = scannerShortName.lastIndexOf(".");
                        if (position > -1) {
                            scannerShortName = scannerShortName.substring(position + 1);
                        }
                    } else {
                        System.out.println("Error getting XML scan data from Response.");
                    }
                }
                TSANMLegacyProcessor processor = new TSANMLegacyProcessor();
                try {
                    if (processor.start(job)) {
                        processor.setInactiveProcessed(job, 0);
                        try {
                            SAXParser parser = null;
                            SAXParserFactory sAXParserFactory = saxFactory;
                            synchronized (sAXParserFactory) {
                                parser = saxFactory.newSAXParser();
                            }
                            DESaxParser handler = new DESaxParser(processor, job);
                            if (traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this.className, methodName, scanData);
                            }
                            if (jobLogger != null) {
                                jobLogger.message(IRecordType.TYPE_INFORMATION, (Object)this.className, methodName, "TSANMLegacyParserJob_Run", (Object[])new String[]{scannerShortName, agent});
                            }
                            parser.parse(new InputSource(new StringReader(scanData)), (DefaultHandler)handler);
                            if (jobLogger != null) {
                                jobLogger.message(IRecordType.TYPE_INFORMATION, (Object)this.className, methodName, "TSANMLegacyParserJob_Successful", (Object[])new String[]{scannerShortName, agent});
                            }
                            break block28;
                        }
                        catch (Exception e) {
                            job.setSuccessful(false);
                            if (jobLogger != null) {
                                jobLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this.className, methodName, "TSANMLegacyParserJob_Error", (Object[])new String[]{scannerShortName, agent, e.getMessage()});
                            }
                            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this.className, methodName, (Throwable)e);
                            if (traceLogger.isLogging()) {
                                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this.className, methodName, (Throwable)e);
                            }
                            break block28;
                        }
                        finally {
                            processor.updateLevel(job);
                            processor.end(Integer.parseInt(job.getDiscoverRequest()));
                        }
                    }
                    if (job.getRequest() != null && job.getRequest().getData() != null && job.getRequest().getData() instanceof org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response && ((org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response)job.getRequest().getData()).getReturnCode() != org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_OK) {
                        processor.end(Integer.parseInt(job.getDiscoverRequest()));
                        processor.updateLevel(job, true);
                        processor.setInactiveProcessed(job, 1);
                    } else if (jobLogger != null) {
                        jobLogger.message(IRecordType.TYPE_INFORMATION, (Object)this.className, methodName, "TSANMLegacyParserJob_SameBenchmark", (Object[])new String[]{scannerShortName, agent});
                    }
                }
                finally {
                    if (processor != null) {
                        processor.shutdown();
                        processor = null;
                    }
                }
            }
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this.className, methodName);
            }
        }
    }
}

