/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.aperi.disk.discovery.DiscoveryProcessPlugin;
import org.eclipse.aperi.util.extensions.AbstractExtensionMgr;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;

public class ProcessPluginExtensionMgr
extends AbstractExtensionMgr {
    private static ProcessPluginExtensionMgr singleton = null;
    private static final String EXTENSION_POINT_ID = "org.eclipse.aperi.discovery.discoveryProcessPlugin";
    private static final String CONFIGURATION_ELEMENT = "DiscoveryProcessPlugin";
    private static final String ATTR_TOPLEVEL_TYPE = "toplevel_type";
    private static final String ATTR_NO_SERVER_PROFILE = "no_server_profile";
    private static final String ATTR_ELEMENT_NAME = "property_elementname";
    private static final String ATTR_NAME = "property_name";
    private static final String ATTR_CREATION_CLASS_NAME = "property_creation_class_name";
    private static final String ATTR_DESCRIPTION = "property_description";

    public String getExtensionPointId() {
        return EXTENSION_POINT_ID;
    }

    public ProcessPluginExtensionMgr() {
        IExtensionRegistry reg = RegistryFactory.getRegistry();
        reg.addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public static synchronized ProcessPluginExtensionMgr getExtensionMgr() {
        if (singleton == null) {
            singleton = new ProcessPluginExtensionMgr();
        }
        return singleton;
    }

    public void dispose() {
        super.dispose();
        IExtensionRegistry reg = RegistryFactory.getRegistry();
        reg.removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    public String getExtensionAttribute(String extensionId, String attribute) {
        IExtensionRegistry xReg = RegistryFactory.getRegistry();
        IExtensionPoint extensionPoint = xReg.getExtensionPoint(this.getExtensionPointId());
        IExtension extension = extensionPoint.getExtension(extensionId);
        if (extension != null) {
            IConfigurationElement[] configElements = null;
            configElements = extension.getConfigurationElements();
            if (configElements != null) {
                return configElements[0].getAttribute(attribute);
            }
        }
        return null;
    }

    public DiscoveryProcessPlugin getPlugin(Properties pCIMOMProp, Map pParameters) {
        IExtensionPoint mPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (mPoint == null) {
            return null;
        }
        String sIsNoServerProfile = pCIMOMProp.getProperty("NoServerProfile") != null ? "true" : "false";
        IExtension[] bExtensions = mPoint.getExtensions();
        for (int bExtIndex = 0; bExtIndex < bExtensions.length; ++bExtIndex) {
            IConfigurationElement[] bCES = bExtensions[bExtIndex].getConfigurationElements();
            for (int bConfigIndex = 0; bConfigIndex < bCES.length; ++bConfigIndex) {
                if (!bCES[bConfigIndex].getName().equals(CONFIGURATION_ELEMENT)) continue;
                IConfigurationElement bCE = bCES[bConfigIndex];
                String sToplevelType = bCE.getAttribute(ATTR_TOPLEVEL_TYPE);
                String sCreationClassName = bCE.getAttribute(ATTR_CREATION_CLASS_NAME);
                String sName = bCE.getAttribute(ATTR_NAME);
                String sElementName = bCE.getAttribute(ATTR_ELEMENT_NAME);
                String sDescription = bCE.getAttribute(ATTR_DESCRIPTION);
                String sNoServerProfile = bCE.getAttribute(ATTR_NO_SERVER_PROFILE);
                if (!ProcessPluginExtensionMgr.matchesStringPattern((String)pParameters.get("Type"), sToplevelType) || !ProcessPluginExtensionMgr.matchesStringPattern(sIsNoServerProfile, sNoServerProfile) || !ProcessPluginExtensionMgr.matchesStringPattern(pCIMOMProp.getProperty("CreationClassName"), sCreationClassName) || !ProcessPluginExtensionMgr.matchesStringPattern(pCIMOMProp.getProperty("Name"), sName) || !ProcessPluginExtensionMgr.matchesStringPattern(pCIMOMProp.getProperty("ElementName"), sElementName) || !ProcessPluginExtensionMgr.matchesStringPattern(pCIMOMProp.getProperty("Description"), sDescription)) continue;
                try {
                    DiscoveryProcessPlugin plugin = (DiscoveryProcessPlugin)this.getExtensionImpl(bExtensions[bExtIndex].getUniqueIdentifier());
                    return plugin;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    protected static boolean matchesStringPattern(String string, String pattern) {
        if (pattern == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        try {
            return Pattern.matches(pattern, string);
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }
}

