/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.CIMExceptionResponse;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerRTException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.discovery.DiscoveryException;
import org.eclipse.aperi.disk.discovery.DiscoveryProcessPlugin;
import org.eclipse.aperi.disk.discovery.ProcessPluginFactory;
import org.eclipse.aperi.disk.util.DiscoveryMessageHelper;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMAuthenticationException;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMTransportException;

public class TopLevelDiscoveryProcess
extends DiscoverProcess
implements DiscoveryConstants,
CIMNames {
    private static String discoverEventPrefix = "D";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopLevelDiscoveryProcess(String description, boolean mainProcess) {
        super(description, mainProcess, new String[]{"CIMOM", "Type"}, new String[]{String[].class.getName(), String.class.getName()});
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"TopLevelDiscoveryProcess", (Object[])new Object[]{description, new Boolean(mainProcess)});
        try {
            mLTH.objectCreation(TopLevelDiscoveryProcess.class.getName());
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result handleCIMOM(TopLevelParameter pTLP) {
        Result result;
        Properties mCIMOMProperties;
        Result mReturn;
        LogTraceHelper mLTH;
        block5: {
            mLTH = LogTraceHelper.entry((Request)pTLP.getDiscoverRequest(), (Object)this, (String)"handleCIMOM", (Object[])new Object[0]);
            mReturn = null;
            pTLP.setCIMOMProperties(null);
            mCIMOMProperties = this.collectCIMOMData(pTLP);
            pTLP.setCIMOMProperties(mCIMOMProperties);
            if (mCIMOMProperties != null) break block5;
            mLTH.traceError("Error finding devices", null);
            mLTH.logMsg("HWN021601E", new Object[]{"collect CIM_ObjectManager"});
            Result result2 = mReturn = new Result(10002, new SRMMessage("HWN021601E", new String[]{"discoverStorageSubsystems"}));
            mLTH.exit((Object)mReturn);
            return result2;
        }
        try {
            DiscoveryProcessPlugin mDiscoveryProcessPlugin = ProcessPluginFactory.getProcessPlugin(mCIMOMProperties, pTLP.getParameters());
            mDiscoveryProcessPlugin.initRequest(pTLP.getDiscoverRequest(), pTLP.getParameters(), pTLP.getDiskCIMProcessor());
            pTLP.setDiscoveryProcessPlugin(mDiscoveryProcessPlugin);
            result = new Result(0, new SRMMessage("HWN020001I", new String[]{"discoverStorageSubsystems"}));
        }
        catch (DiscoveryException pEx) {
            Result result3;
            try {
                mReturn = new Result(10003, new SRMMessage(pEx.getMsgKey(), pEx.getMsgInserts()));
                mLTH.logMsg(pEx.getMsgKey(), (Object[])pEx.getMsgInserts());
                mLTH.traceInfo("StorageDiscoveryProcess : unable to collect CIMOM ");
                result3 = mReturn;
            }
            catch (Throwable throwable) {
                mLTH.exit(mReturn);
                throw throwable;
            }
            mLTH.exit((Object)mReturn);
            return result3;
        }
        mLTH.exit((Object)mReturn);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties collectCIMOMData(TopLevelParameter pTLP) throws DiscoveryException {
        Properties mReturn;
        LogTraceHelper mLTH;
        block18: {
            Properties properties;
            JobInfo mObjectJob;
            String[] mObjectManager;
            JobInfo mJob;
            block16: {
                Serializable bEx;
                String mMethodName = "collectCIMOMData";
                mLTH = LogTraceHelper.entry((Request)pTLP.getDiscoverRequest(), (Object)this, (String)mMethodName, (Object[])new Object[0]);
                mReturn = null;
                String[] mRegProfiles = Router.getRouter().perform("RegisteredProfile", pTLP.getParameters(), new Integer(pTLP.getDiscoverRequest().getId()).toString());
                Router.getRouter().waitTilComplete(mRegProfiles);
                mJob = (JobInfo)JobEngine.getInstance().getJobs(mRegProfiles[1]).get(0);
                if (mJob.isSuccessful()) break block16;
                String bFailureCause = "";
                if (mJob.getResponse() != null) {
                    bEx = null;
                    Object mObject = mJob.getResponse().getData();
                    if (mObject instanceof CIMException) {
                        bEx = (Throwable)((CIMExceptionResponse)mJob.getResponse()).getData();
                    } else if (mObject instanceof DiskManagerRTException) {
                        Throwable bExRt = (Throwable)((CIMExceptionResponse)mJob.getResponse()).getData();
                        while (bExRt.getCause() != null) {
                            if ((bExRt = bExRt.getCause()) instanceof CIMException) {
                                bEx = bExRt;
                                break;
                            }
                            bEx = null;
                        }
                    } else {
                        mLTH.traceInfo("No instance of CIMException");
                        bEx = null;
                    }
                    if (bEx != null && bEx instanceof CIMTransportException || bEx instanceof CIMException && ((Throwable)bEx).getMessage().indexOf("UNABLE_TO_CONNECT") > 0) {
                        mLTH.traceError("CIMOM connection Failure", (Throwable)bEx);
                        throw new DiscoveryException("CIMOM connection Failure", "HWN021537E", new String[]{((String[])pTLP.getParameters().get("CIMOM"))[0], ((Throwable)bEx).getMessage()}, (Exception)bEx);
                    }
                    if (bEx != null && bEx instanceof CIMAuthenticationException || bEx != null && bEx instanceof CIMException && ((Throwable)bEx).getMessage().indexOf("challenge") > 0) {
                        mLTH.traceError("CIMOM authentication Failure", (Throwable)bEx);
                        throw new DiscoveryException("CIMOM authentication Failure", "HWN021537E", new String[]{((String[])pTLP.getParameters().get("CIMOM"))[0], ((Throwable)bEx).getMessage()}, (Exception)bEx);
                    }
                    if (bEx != null && bEx instanceof CIMException && ((Throwable)bEx).getMessage().indexOf("ERR_TIME_OUT") > 0) {
                        mLTH.traceError("CIMOM timout Failure", (Throwable)bEx);
                        throw new DiscoveryException("CIMOM timout Failure", "HWN021650E", new String[]{((String[])pTLP.getParameters().get("CIMOM"))[0], ((Throwable)bEx).getMessage()}, (Exception)bEx);
                    }
                    if (bEx != null && bEx instanceof DiskManagerTimeoutException) {
                        mLTH.traceError("CIMOM timout Failure", (Throwable)bEx);
                        throw new DiscoveryException("CIMOM timout Failure", "HWN021650E", new String[]{((String[])pTLP.getParameters().get("CIMOM"))[0], ((Throwable)bEx).getMessage()}, (Exception)bEx);
                    }
                    bFailureCause = ((Throwable)((CIMExceptionResponse)mJob.getResponse()).getData()).toString();
                    mLTH.traceWarning("No Profile found (" + bFailureCause + ")");
                }
                mReturn = new Properties();
                mReturn.put("NoServerProfile", new Boolean(true));
                bEx = mReturn;
                mLTH.exit((Object)mReturn);
                return bEx;
            }
            try {
                Response mResponse = mJob.getResponse();
                if (!(mResponse instanceof Response)) break block18;
                Map mParameters = pTLP.getParameters();
                Enumeration mRegProfEnum = (Enumeration)mResponse.getData();
                while (mRegProfEnum.hasMoreElements()) {
                    CIMInstance mProfInst = (CIMInstance)mRegProfEnum.nextElement();
                    if (!"Server".equals((String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mProfInst, (String)"RegisteredName"))) continue;
                    mParameters.put("IN_SYSTEM_OBJECTMANAGER", mProfInst);
                    mObjectManager = Router.getRouter().perform("OBJECTMANAGER", mParameters, new Integer(pTLP.getDiscoverRequest().getId()).toString());
                    Router.getRouter().waitTilComplete(mObjectManager);
                    mObjectJob = (JobInfo)JobEngine.getInstance().getJobs(mObjectManager[1]).get(0);
                    if (mObjectJob.isSuccessful()) break block19;
                    mLTH.traceInfo("Error executing associator call CIM_RegiseredProfile, CIM_ElementConformsToProfile, CIM_ObjectManager");
                    properties = null;
                }
            }
            catch (Throwable throwable) {
                mLTH.exit(mReturn);
                throw throwable;
            }
            {
                block19: {
                    mLTH.exit((Object)mReturn);
                    return properties;
                }
                mReturn = this.saveProperties(mReturn, mObjectManager, mObjectJob);
                continue;
            }
        }
        mLTH.exit((Object)mReturn);
        return mReturn;
    }

    private Properties saveProperties(Properties mReturn, String[] mObjectManager, JobInfo mObjectJob) {
        Response mResOM = mObjectJob.getResponse();
        Enumeration mObjMgrEnum = (Enumeration)mResOM.getData();
        while (mObjMgrEnum.hasMoreElements()) {
            mReturn = new Properties();
            CIMInstance mInstance = (CIMInstance)mObjMgrEnum.nextElement();
            CIMObjectPath mCIMOMcop = new CIMObjectPath(mInstance.toString());
            String mNameSpace = mCIMOMcop.getNameSpace();
            mReturn.put("Name", CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"Name"));
            mReturn.put("SystemName", CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"SystemName"));
            mReturn.put("ElementName", CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"ElementName"));
            mReturn.put("Description", CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"Description"));
            mReturn.put("CreationClassName", CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"CreationClassName"));
            mReturn.put("SystemCreationClassName", CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"SystemCreationClassName"));
            String mVersion = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"Version");
            if (mVersion != null) {
                mReturn.put("Version", mVersion);
            } else {
                mReturn.put("Version", "");
            }
            mReturn.put("ObjectManager", mObjectManager[1]);
        }
        return mReturn;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result collectStorageDevices(TopLevelParameter pTLP) {
        Result result;
        Result mReturn;
        LogTraceHelper mLTH;
        String mCIMOMServiceURL;
        block16: {
            block15: {
                block14: {
                    CIMOM[] mCIMOM;
                    block13: {
                        mCIMOMServiceURL = ((String[])pTLP.getParameters().get("CIMOM"))[0];
                        mLTH = LogTraceHelper.entry((Request)pTLP.getDiscoverRequest(), (Object)this, (String)"collectStorageDevices", (Object[])new Object[]{mCIMOMServiceURL});
                        mReturn = null;
                        Map mParams = pTLP.getParameters();
                        mParams = DiscoverUtils.setProbeTimeout(mParams, DiskManagerConfigSvc.getLongConfigValue((String)"Discovery.Timeout", (long)0L), mLTH);
                        pTLP.setParameters(mParams);
                        mLTH.logMsg("HWN021727I", new Object[]{mCIMOMServiceURL});
                        mCIMOM = CIMOMManager.getCIMOMManager().getCIMOMs(new String[]{mCIMOMServiceURL});
                        if (mCIMOM != null && mCIMOM.length != 0) break block13;
                        SRMMessage bMessage = new SRMMessage("HWN021801E", new String[]{mCIMOMServiceURL});
                        mReturn = new Result(10030, bMessage);
                        mLTH.traceInfo("TopLevelDiscoveryProcess : unable to collect CIMOM " + mCIMOMServiceURL);
                        mLTH.logMsg(bMessage.getMsgId(), (Object[])bMessage.getMsgInserts());
                        Result result2 = mReturn;
                        mLTH.logMsg("HWN021728I", new Object[]{mCIMOMServiceURL});
                        mLTH.exit((Object)mReturn);
                        return result2;
                    }
                    CIMOMConnectionStatus[] mStatus = CIMOMManager.getCIMOMManager().testCIMOMConnection(mCIMOM);
                    if (mStatus[0].isSuccess()) break block14;
                    Result result3 = this.getResultFromConnectionStaus(mStatus[0], mCIMOM[0], mLTH);
                    mLTH.logMsg("HWN021728I", new Object[]{mCIMOMServiceURL});
                    mLTH.exit((Object)mReturn);
                    return result3;
                }
                mReturn = this.handleCIMOM(pTLP);
                if (mReturn.getRc() == 0) break block15;
                Result result4 = mReturn;
                mLTH.logMsg("HWN021728I", new Object[]{mCIMOMServiceURL});
                mLTH.exit((Object)mReturn);
                return result4;
            }
            if (pTLP.getDiscoveryProcessPlugin() == null) break block16;
            List mDeviceData = pTLP.getDiscoveryProcessPlugin().collectDeviceData((String)pTLP.getCIMOMProperties().get("ObjectManager"), (String)pTLP.getCIMOMProperties().get("Version"));
            Result result5 = mReturn;
            mLTH.logMsg("HWN021728I", new Object[]{mCIMOMServiceURL});
            mLTH.exit((Object)mReturn);
            return result5;
        }
        try {
            result = mReturn = new Result(10001, new SRMMessage("HWN021503E", new String[0]));
        }
        catch (DiscoveryException pEx) {
            String mMsgKey;
            block17: {
                Result result6;
                try {
                    mMsgKey = pEx.getMsgKey();
                    if ((mMsgKey == null || !mMsgKey.equalsIgnoreCase("HWN021537E")) && (mMsgKey == null || !mMsgKey.equalsIgnoreCase("HWN021538E"))) break block17;
                    mReturn = new Result(10003, new SRMMessage(pEx.getMsgKey(), pEx.getMsgInserts()));
                    mLTH.traceInfo("TopLevelDiscoveryProcess : unable to collect CIMOM ");
                    mLTH.logMsg(mMsgKey, (Object[])pEx.getMsgInserts());
                    result6 = mReturn;
                }
                catch (Throwable throwable) {
                    mLTH.logMsg("HWN021728I", new Object[]{mCIMOMServiceURL});
                    mLTH.exit((Object)mReturn);
                    throw throwable;
                }
                mLTH.logMsg("HWN021728I", new Object[]{mCIMOMServiceURL});
                mLTH.exit((Object)mReturn);
                return result6;
            }
            if (mMsgKey != null && mMsgKey.equalsIgnoreCase("HWN021650E")) {
                mReturn = new Result(10006, new SRMMessage(pEx.getMsgKey(), pEx.getMsgInserts()));
                mLTH.traceInfo("TopLevelDiscoveryProcess : unable to collect CIMOM with timeout ");
            } else if (pEx.getCause() instanceof CIMException) {
                mLTH.traceInfo("TopLevelDiscoveryProcess : CIMException  ");
            }
            mReturn = new Result(10001, new SRMMessage(pEx.getMsgKey(), pEx.getMsgInserts()));
            throw DiskMessageHelper.getServerException((String)pEx.getMsgKey(), (Object)pEx.getMsgInserts(), (Throwable)pEx, (LogTraceHelper)mLTH);
            catch (Exception pEx2) {
                mReturn = new Result(10001, new SRMMessage("HWN021503E", new String[0]));
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx2.getMessage(), (Throwable)pEx2, (LogTraceHelper)mLTH);
            }
        }
        mLTH.logMsg("HWN021728I", new Object[]{mCIMOMServiceURL});
        mLTH.exit((Object)mReturn);
        return result;
    }

    private Result getResultFromConnectionStaus(CIMOMConnectionStatus pStatus, CIMOM pCimom, LogTraceHelper pLTH) {
        Result mReturn = null;
        if (pStatus.equals(CIMOMConnectionStatus.LOGIN_FAILED)) {
            String mUser = pCimom.getUserId() == null ? "null" : pCimom.getUserId();
            mReturn = new Result(10022, new SRMMessage("HWN021538E", new String[]{mUser, pCimom.getServiceUrl()}));
            pLTH.logMsg("HWN021538E", (Object[])new String[]{mUser, pCimom.getServiceUrl()});
            pLTH.traceInfo("getResultFromConnectionStaus : Login failed ");
        } else if (pStatus.equals(CIMOMConnectionStatus.TIMEOUT)) {
            mReturn = new Result(10006, new SRMMessage("HWN021650E", new String[]{pCimom.getServiceUrl()}));
            pLTH.logMsg("HWN021650E", (Object[])new String[]{pCimom.getServiceUrl()});
            pLTH.traceInfo("getResultFromConnectionStaus : timeout ");
        } else if (pStatus.equals(CIMOMConnectionStatus.REFUSED)) {
            mReturn = new Result(10003, new SRMMessage("HWN021537E", new String[]{pCimom.getServiceUrl(), pStatus.toString()}));
            pLTH.logMsg("HWN021537E", (Object[])new String[]{pCimom.getServiceUrl(), pStatus.toString()});
            pLTH.traceInfo("getResultFromConnectionStaus : connection failed ");
        } else {
            mReturn = new Result(10001, new SRMMessage("HWN021537E", new String[]{pCimom.getServiceUrl(), pStatus.toString()}));
            pLTH.logMsg("HWN021650E", (Object[])new String[]{pCimom.getServiceUrl(), pStatus.toString()});
            pLTH.traceInfo("getResultFromConnectionStaus : other ");
        }
        return mReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result process(Request mDiscoverRequest, Map pParameters) throws ParameterException {
        TopLevelParameter mTLP = new TopLevelParameter();
        mTLP.setDiscoverRequest(mDiscoverRequest);
        mTLP.setParameters(pParameters);
        DiskCIMProcessor mDiskCIMProcessor = new DiskCIMProcessor(this.getScannerId(pParameters));
        mDiskCIMProcessor.setCIMServiceURL(((String[])pParameters.get("CIMOM"))[0]);
        Result mReturn = null;
        try {
            mTLP.setDiskCIMProcessor(mDiskCIMProcessor);
            mDiskCIMProcessor.start(mDiscoverRequest.getId());
            mReturn = this.collectStorageDevices(mTLP);
        }
        finally {
            if (mDiskCIMProcessor != null) {
                mDiskCIMProcessor.end(mDiscoverRequest.getId());
                mDiskCIMProcessor.shutdown();
                mDiskCIMProcessor = null;
            }
        }
        return mReturn;
    }

    public String getScannerId(Map pParameters) throws ParameterException {
        String prefix = "DS2";
        String[] mCIMOM = (String[])pParameters.get("CIMOM");
        if (mCIMOM == null || mCIMOM.length < 1) {
            throw new ParameterException("Missing parameter: CIMOM");
        }
        String mCIMOMServiceURL = mCIMOM[0];
        String mScannerId = prefix + ":" + mCIMOMServiceURL;
        return mScannerId;
    }

    public int getAuthoritativeReferenceType(Map pParameters) throws ParameterException {
        return 100;
    }

    public int getAuthoritativeReferenceId(Map pParameters) throws ParameterException {
        try {
            String[] mCIMOM = (String[])pParameters.get("CIMOM");
            if (mCIMOM == null || mCIMOM.length < 1) {
                throw new ParameterException("Missing parameter: CIMOM");
            }
            String mCIMOMServiceURL = mCIMOM[0];
            return CIMOMManager.getCIMOMManager().getCIMOMIDforURL(mCIMOMServiceURL);
        }
        catch (SQLException e) {
            throw new ParameterException("Missing parameter for saved CIMOM : CIMOM");
        }
    }

    public String getProcessInfoForJobLog(Map parameters) {
        try {
            String[] cimom = (String[])TopLevelDiscoveryProcess.getParameter(parameters, "CIMOM", String[].class.getName());
            return "discoverSubsystems+" + cimom[0];
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static void checkJobSuccessful(String pMethodName, LogTraceHelper pLTH, JobInfo pObjectJob, String pType, Map pParameters) throws DiscoveryException {
        DiscoveryException mEx = null;
        Throwable bEx = null;
        Object mObject = pObjectJob.getResponse().getData();
        if (mObject instanceof CIMException) {
            bEx = (Throwable)((CIMExceptionResponse)pObjectJob.getResponse()).getData();
        } else if (mObject instanceof DiskManagerRTException) {
            Throwable bExRt = (Throwable)((CIMExceptionResponse)pObjectJob.getResponse()).getData();
            while (bExRt.getCause() != null) {
                if ((bExRt = bExRt.getCause()) instanceof CIMException) {
                    bEx = bExRt;
                    break;
                }
                bEx = null;
            }
        } else {
            pLTH.traceInfo("No instance of CIMException");
            bEx = null;
        }
        if (bEx != null && bEx instanceof CIMTransportException || bEx != null && bEx instanceof CIMException && bEx.getMessage().indexOf("UNABLE_TO_CONNECT") > 0) {
            pLTH.traceError("CIMOM connection Failure", bEx);
            mEx = DiscoveryMessageHelper.getDiscoveryException(pMethodName + pType, "HWN021537E", new String[]{((String[])pParameters.get("CIMOM"))[0], bEx.getMessage()}, pObjectJob, pLTH);
        } else if (bEx != null && bEx instanceof CIMAuthenticationException) {
            pLTH.traceError("CIMOM authentication Failure", bEx);
            mEx = DiscoveryMessageHelper.getDiscoveryException(pMethodName + pType, "HWN021538E", new String[]{(String)pParameters.get("USERID"), ((String[])pParameters.get("CIMOM"))[0], bEx.getMessage()}, pObjectJob, pLTH);
        } else if (bEx != null && bEx instanceof CIMException && bEx.getMessage().indexOf("ERR_TIME_OUT") > 0) {
            pLTH.traceError("CIMOM timout Failure", bEx);
            mEx = DiscoveryMessageHelper.getDiscoveryException(pMethodName + pType, "HWN021650E", new String[]{((String[])pParameters.get("CIMOM"))[0]}, pObjectJob, pLTH);
        } else if (mObject != null && mObject instanceof DiskManagerTimeoutException) {
            pLTH.traceError("CIMOM timout Failure", bEx);
            mEx = DiscoveryMessageHelper.getDiscoveryException(pMethodName + pType, "HWN021650E", new String[]{((String[])pParameters.get("CIMOM"))[0]}, pObjectJob, pLTH);
        } else if (bEx != null && bEx instanceof CIMException) {
            pLTH.traceError("CIMOM timout Failure", bEx);
            mEx = DiscoveryMessageHelper.getDiscoveryException(pMethodName + pType, "HWN021529E", new String[]{((String[])pParameters.get("CIMOM"))[0]}, pObjectJob, pLTH);
        } else {
            mEx = DiscoveryMessageHelper.getDiscoveryException(pMethodName + pType, "HWN021503E", new String[0], pObjectJob, pLTH);
        }
        throw mEx;
    }

    private class TopLevelParameter {
        private DiscoveryProcessPlugin cDiscoveryProcessPlugin = null;
        private Request cDiscoverRequest = null;
        private Map cParameters = null;
        private Properties cCIMOMProperties = null;
        private DiskCIMProcessor cDiskCIMProcessor = null;

        public Properties getCIMOMProperties() {
            return this.cCIMOMProperties;
        }

        public Request getDiscoverRequest() {
            return this.cDiscoverRequest;
        }

        public DiscoveryProcessPlugin getDiscoveryProcessPlugin() {
            return this.cDiscoveryProcessPlugin;
        }

        public DiskCIMProcessor getDiskCIMProcessor() {
            return this.cDiskCIMProcessor;
        }

        public Map getParameters() {
            return this.cParameters;
        }

        public void setCIMOMProperties(Properties pProperties) {
            this.cCIMOMProperties = pProperties;
        }

        public void setDiscoverRequest(Request pRequest) {
            this.cDiscoverRequest = pRequest;
        }

        public void setDiscoveryProcessPlugin(DiscoveryProcessPlugin pPlugin) {
            this.cDiscoveryProcessPlugin = pPlugin;
        }

        public void setDiskCIMProcessor(DiskCIMProcessor pProcessor) {
            this.cDiskCIMProcessor = pProcessor;
        }

        public void setParameters(Map pMap) {
            this.cParameters = pMap;
        }
    }
}

