/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.util.queue;

import java.util.Hashtable;
import java.util.ListIterator;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response;
import org.eclipse.aperi.util.queue.DefaultJobQueue;

public class KeyedJobQueue
extends DefaultJobQueue {
    protected Hashtable jobHashtable = new Hashtable();

    public KeyedJobQueue() {
    }

    public KeyedJobQueue(boolean aLimited) {
        super(aLimited);
    }

    private int getLevel(JobInfo job) {
        int result = -1;
        if (job.getRequest() != null && job.getRequest().getData() != null && job.getRequest().getData() instanceof Response && ((Response)job.getRequest().getData()).getReturnCode() == Response.RETURN_CODE_OK) {
            result = ((Response)job.getRequest().getData()).getLevel();
        }
        return result;
    }

    private int getBenchmarkLevel(JobInfo job) {
        int result = -1;
        if (job.getRequest() != null && job.getRequest().getData() != null && job.getRequest().getData() instanceof Response && ((Response)job.getRequest().getData()).getReturnCode() == Response.RETURN_CODE_OK) {
            result = ((Response)job.getRequest().getData()).getBenchmarkLevel();
        }
        return result;
    }

    private String getKey(JobInfo job) {
        return job.getRequestId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(JobInfo job) {
        Object object = this.lock;
        synchronized (object) {
            String tempKey = this.getKey(job);
            JobInfo tempJob = job;
            if (this.jobHashtable.containsKey(tempKey)) {
                JobInfo oldJob = (JobInfo)this.jobHashtable.get(tempKey);
                int tempNewLevel = this.getLevel(job);
                int tempNewBenchmarkLevel = this.getBenchmarkLevel(job);
                int tempOldLevel = this.getLevel(oldJob);
                int delta = tempNewLevel - tempOldLevel;
                if (tempOldLevel == -1 || tempNewLevel == -1 || tempNewBenchmarkLevel == -1 || delta >= 0 && delta < 500 || delta < -500) {
                    tempJob = job;
                    JobEngine.getInstance().replaceJob(oldJob, job);
                } else {
                    tempJob = oldJob;
                    JobEngine.getInstance().replaceJob(job, oldJob);
                }
            }
            this.jobHashtable.put(tempKey, tempJob);
            if (!this.order.contains(tempJob)) {
                this.order.addLast(tempJob);
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo getNextJob() {
        JobInfo tempJobInfo = null;
        String tempKey = null;
        while (!Thread.interrupted() && tempJobInfo == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.order.size() > 0) {
                    ListIterator tempListIterator = this.order.listIterator(0);
                    while (tempListIterator.hasNext()) {
                        tempJobInfo = (JobInfo)tempListIterator.next();
                        tempKey = this.getKey(tempJobInfo);
                        if ((tempJobInfo = (JobInfo)this.jobHashtable.get(tempKey)) != null) {
                            if (this.limited) {
                                if (this.iActiveJobs.contains(tempKey)) {
                                    tempJobInfo = null;
                                    continue;
                                }
                                this.iActiveJobs.add(tempKey);
                            }
                            this.jobHashtable.remove(tempKey);
                            tempListIterator.remove();
                            break;
                        }
                        tempListIterator.remove();
                    }
                }
                if (tempJobInfo == null) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException ie) {
                        return null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                while (tempJobInfo != null && tempJobInfo.getStatus() == 4) {
                    if (this.limited) {
                        this.iActiveJobs.remove(tempKey);
                    }
                    if ((tempJobInfo = tempJobInfo.getReplacementJob()) == null) continue;
                    this.order.remove(tempJobInfo);
                    tempKey = this.getKey(tempJobInfo);
                    if (!this.limited) continue;
                    this.iActiveJobs.add(tempKey);
                }
            }
        }
        if (tempJobInfo != null) {
            this.jobStarted(tempJobInfo);
        }
        if (Thread.interrupted()) {
            return null;
        }
        return tempJobInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobCompleted(JobInfo job) {
        job.setEndTime(System.currentTimeMillis());
        if (this.limited) {
            this.iActiveJobs.remove(this.getKey(job));
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }
}

