/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.ControlRouter;
import org.eclipse.aperi.control.interfaces.NotAvailableException;
import org.eclipse.aperi.control.interfaces.storagesubsystem.IStorageSubsystemControl;
import org.eclipse.aperi.disk.api.IDiskConfigurationService;
import org.eclipse.aperi.disk.api.IDiskSVCConfigurationService;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.api.impl.DiskOperations;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DBHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskParameterChecker;
import org.eclipse.aperi.disk.common.util.DiskParameterHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.ParameterChecker;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.control.util.CreateSVCStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.CreateStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.DeleteStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.ModifyStoragePoolParameter;
import org.eclipse.aperi.disk.control.util.ModifyStorageVolumeParameter;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyVolume;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.sblim.wbem.cim.CIMObjectPath;

public class DiskConfigurationOperations
extends DiskOperations
implements IDiskConfigurationService,
IDiskSVCConfigurationService {
    protected HashMap cSubsystemConnectionData = new HashMap();

    public DiskConfigurationOperations(DiskManager diskManager) {
        super(diskManager);
    }

    public void handleServiceShutdown() {
        super.handleServiceShutdown();
    }

    protected void initialize() {
    }

    protected IStorageSubsystemControl getStorageSubsystemController() {
        Class<?> clazz;
        Class<?> clazz2;
        try {
            clazz2 = Class.forName("org.eclipse.aperi.control.interfaces.storagesubsystem.IStorageSubsystemControl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.control.storagesubsystem.StorageSubsystemController");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IStorageSubsystemControl iStorageSubsystemControl = (IStorageSubsystemControl)ControlRouter.getControllerProxy(clazz2, (ClassLoader)clazz.getClassLoader());
        return iStorageSubsystemControl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult createStorageVolumes(long[] lArray, String[] stringArray, String[] stringArray2, HashMap hashMap) throws ServerException, InvalidParameterException, MissingParameterException {
        String string = "createStorageVolumes";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)string, (Object[])new Object[]{lArray, stringArray, stringArray2, hashMap});
        AsyncResult asyncResult = null;
        DBConnection dBConnection = null;
        try {
            AsyncResult asyncResult2;
            try {
                CreateStorageVolumesParameter[] createStorageVolumesParameterArray;
                ParameterChecker.assertMandatoryParameter((int)1, (String)"Sizes", (Object)lArray, (LogTraceHelper)logTraceHelper);
                ParameterChecker.assertValidPrimitiveParameterArray((int)1, (String)"Sizes", (Object)lArray, (LogTraceHelper)logTraceHelper);
                ParameterChecker.assertMandatoryParameter((int)2, (String)"StoragePoolIDs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
                ParameterChecker.assertMandatoryParameterArraySizes((int)2, (String)"Sizes, StoragePoolIDs", (Object)lArray, (Object)stringArray, (LogTraceHelper)logTraceHelper);
                ParameterChecker.assertOptionalParameterArraySizes((int)3, (String)"StoragePoolIDs, VolumeNames", (Object)stringArray, (Object)stringArray2, (LogTraceHelper)logTraceHelper);
                if (stringArray2 == null) {
                    stringArray2 = new String[stringArray.length];
                }
                dBConnection = ServiceUtils.getConnection();
                StorageSubsystem[] storageSubsystemArray = new StorageSubsystem[stringArray.length];
                StoragePool[] storagePoolArray = new StoragePool[stringArray.length];
                CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[stringArray.length];
                CIMObjectPath[] cIMObjectPathArray2 = new CIMObjectPath[stringArray.length];
                CIMOMSelector.SubsystemConnectionData[] subsystemConnectionDataArray = new CIMOMSelector.SubsystemConnectionData[stringArray.length];
                CIMOMSelector cIMOMSelector = CIMOMSelector.getSelector();
                int n = 0;
                while (n < stringArray.length) {
                    try {
                        String string2 = ExternalKeyConverter.frameKeyStorageSubsystemFromPool((String)stringArray[n], (LogTraceHelper)logTraceHelper);
                        storageSubsystemArray[n] = ExternalKeyManager.getStorageSubsystem((String)string2, (DBConnection)dBConnection);
                        storagePoolArray[n] = ExternalKeyManager.getStoragePool((String)stringArray[n], (int)storageSubsystemArray[n].getSubsystemId(), (DBConnection)dBConnection);
                        subsystemConnectionDataArray[n] = this.getCimomForSubsystem(cIMOMSelector, storageSubsystemArray[n]);
                        cIMObjectPathArray[n] = subsystemConnectionDataArray[n].getSubsystemCop();
                        cIMObjectPathArray2[n] = ExternalKeyManager.getCIMObjectPath((StoragePool)storagePoolArray[n], (String)subsystemConnectionDataArray[n].getCimNamespace());
                        this.checkOperationSupported(subsystemConnectionDataArray[n].getCapability(), string2, "CreateStorageVolumes", logTraceHelper);
                    }
                    catch (IDParseException iDParseException) {
                        throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN020003E", (Object)stringArray[n], (LogTraceHelper)logTraceHelper);
                    }
                    catch (EntityNotFoundException entityNotFoundException) {
                        throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN021654E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
                    }
                    ++n;
                }
                dBConnection.commit();
                this.checkPoolSupportsSize(stringArray, storagePoolArray, cIMObjectPathArray2, lArray, logTraceHelper);
                HashMap<CreateStorageVolumesParameter[], CreateStorageVolumesParameter> hashMap2 = new HashMap<CreateStorageVolumesParameter[], CreateStorageVolumesParameter>();
                int n2 = 0;
                while (n2 < storageSubsystemArray.length) {
                    createStorageVolumesParameterArray = (CreateStorageVolumesParameter[])ExternalKeyConverter.getStorageSubsystemKey((StorageSubsystem)storageSubsystemArray[n2]);
                    CreateStorageVolumesParameter createStorageVolumesParameter = null;
                    createStorageVolumesParameter = !hashMap2.containsKey(createStorageVolumesParameterArray) ? new CreateStorageVolumesParameter(storageSubsystemArray[n2], cIMObjectPathArray[n2]) : (CreateStorageVolumesParameter)hashMap2.get(createStorageVolumesParameterArray);
                    createStorageVolumesParameter.addCreateStorageVolumeParameter(storagePoolArray[n2], cIMObjectPathArray2[n2], lArray[n2], stringArray2[n2]);
                    createStorageVolumesParameter.setCapability(subsystemConnectionDataArray[n2].getCapability());
                    createStorageVolumesParameter.setCimom(subsystemConnectionDataArray[n2].getCimom());
                    createStorageVolumesParameter.setStorageSubsystemID((String)createStorageVolumesParameterArray);
                    hashMap2.put(createStorageVolumesParameterArray, createStorageVolumesParameter);
                    ++n2;
                }
                IStorageSubsystemControl iStorageSubsystemControl = this.getStorageSubsystemController();
                createStorageVolumesParameterArray = hashMap2.values().toArray(new CreateStorageVolumesParameter[hashMap2.size()]);
                asyncResult2 = asyncResult = iStorageSubsystemControl.createStorageVolumes(createStorageVolumesParameterArray);
                Object var19_26 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            catch (NotAvailableException notAvailableException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)notAvailableException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            this.finallyCheckConnection(dBConnection, logTraceHelper);
            logTraceHelper.exit((Object)asyncResult);
            return asyncResult2;
        }
        catch (Throwable throwable) {
            Object var19_27 = null;
            this.finallyCheckConnection(dBConnection, logTraceHelper);
            logTraceHelper.exit(asyncResult);
            throw throwable;
        }
    }

    protected CIMOMSelector.SubsystemConnectionData getCimomForSubsystem(CIMOMSelector cIMOMSelector, StorageSubsystem storageSubsystem) {
        CIMOMSelector.SubsystemConnectionData subsystemConnectionData = (CIMOMSelector.SubsystemConnectionData)this.cSubsystemConnectionData.get(new Integer(storageSubsystem.getSubsystemId()));
        if (subsystemConnectionData != null) {
            return subsystemConnectionData;
        }
        subsystemConnectionData = cIMOMSelector.getCimomForSubsystem(storageSubsystem.getSubsystemId());
        this.cSubsystemConnectionData.put(new Integer(storageSubsystem.getSubsystemId()), subsystemConnectionData);
        return subsystemConnectionData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult deleteStorageVolumes(String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        String string = "deleteStorageVolumes";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)string, (Object[])new Object[]{stringArray});
        AsyncResult asyncResult = null;
        DBConnection dBConnection = null;
        try {
            AsyncResult asyncResult2;
            try {
                DeleteStorageVolumesParameter deleteStorageVolumesParameter;
                Object object;
                ParameterChecker.assertMandatoryParameter((int)1, (String)"StorageVolumeIDs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
                dBConnection = ServiceUtils.getConnection();
                StorageSubsystem[] storageSubsystemArray = new StorageSubsystem[stringArray.length];
                StorageVolume[] storageVolumeArray = new StorageVolume[stringArray.length];
                CimkeyVolume[] cimkeyVolumeArray = new CimkeyVolume[stringArray.length];
                CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[stringArray.length];
                CIMObjectPath[] cIMObjectPathArray2 = new CIMObjectPath[stringArray.length];
                CIMOMSelector.SubsystemConnectionData[] subsystemConnectionDataArray = new CIMOMSelector.SubsystemConnectionData[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    try {
                        String string2 = ExternalKeyConverter.frameKeyStorageSubsystemFromVolume((String)stringArray[n], (LogTraceHelper)logTraceHelper);
                        storageSubsystemArray[n] = ExternalKeyManager.getStorageSubsystem((String)string2, (DBConnection)dBConnection);
                        storageVolumeArray[n] = ExternalKeyManager.getStorageVolume((String)stringArray[n], (int)storageSubsystemArray[n].getSubsystemId(), (DBConnection)dBConnection);
                        if (storageVolumeArray[n].getIsAssigned() == 1) {
                            throw DiskMessageHelper.getServerException((String)"HWN021611E", (Object)stringArray[n], (LogTraceHelper)logTraceHelper);
                        }
                        object = CIMOMSelector.getSelector();
                        subsystemConnectionDataArray[n] = object.getCimomForSubsystem(storageSubsystemArray[n].getSubsystemId());
                        cimkeyVolumeArray[n] = ExternalKeyManager.getStorageVolumeCIM((int)storageVolumeArray[n].getSvid(), (int)subsystemConnectionDataArray[n].getCimNamespaceID(), (DBConnection)dBConnection);
                        cIMObjectPathArray[n] = subsystemConnectionDataArray[n].getSubsystemCop();
                        cIMObjectPathArray2[n] = ExternalKeyManager.getCIMObjectPath((CimkeyVolume)cimkeyVolumeArray[n], (String)subsystemConnectionDataArray[n].getCimNamespace());
                        deleteStorageVolumesParameter = subsystemConnectionDataArray[n].getCapability();
                        this.checkOperationSupported((CapabilityData)deleteStorageVolumesParameter, string2, "DeleteStorageVolumes", logTraceHelper);
                    }
                    catch (IDParseException iDParseException) {
                        throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)stringArray[n], (LogTraceHelper)logTraceHelper);
                    }
                    catch (EntityNotFoundException entityNotFoundException) {
                        throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021655E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
                    }
                    ++n;
                }
                dBConnection.commit();
                HashMap<Object, DeleteStorageVolumesParameter> hashMap = new HashMap<Object, DeleteStorageVolumesParameter>();
                int n2 = 0;
                while (n2 < storageSubsystemArray.length) {
                    object = (String)ExternalKeyConverter.getStorageSubsystemKey((StorageSubsystem)storageSubsystemArray[n2]);
                    deleteStorageVolumesParameter = null;
                    deleteStorageVolumesParameter = !hashMap.containsKey(object) ? new DeleteStorageVolumesParameter(storageSubsystemArray[n2], cIMObjectPathArray[n2]) : (DeleteStorageVolumesParameter)hashMap.get(object);
                    deleteStorageVolumesParameter.addDeleteStorageVolumeParameter(storageVolumeArray[n2], cIMObjectPathArray2[n2]);
                    deleteStorageVolumesParameter.setStorageSubsystemID((String)object);
                    deleteStorageVolumesParameter.setCapability(subsystemConnectionDataArray[n2].getCapability());
                    deleteStorageVolumesParameter.setCimom(subsystemConnectionDataArray[n2].getCimom());
                    hashMap.put(object, deleteStorageVolumesParameter);
                    ++n2;
                }
                DeleteStorageVolumesParameter[] deleteStorageVolumesParameterArray = new DeleteStorageVolumesParameter[hashMap.size()];
                deleteStorageVolumesParameterArray = hashMap.values().toArray(deleteStorageVolumesParameterArray);
                object = this.getStorageSubsystemController();
                asyncResult2 = asyncResult = object.deleteStorageVolumes(deleteStorageVolumesParameterArray);
                Object var16_23 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            catch (NotAvailableException notAvailableException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)notAvailableException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            this.finallyCheckConnection(dBConnection, logTraceHelper);
            logTraceHelper.exit((Object)asyncResult);
            return asyncResult2;
        }
        catch (Throwable throwable) {
            Object var16_24 = null;
            this.finallyCheckConnection(dBConnection, logTraceHelper);
            logTraceHelper.exit(asyncResult);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult assignStorageVolumesToWWPNs(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, int n, String string, String[] stringArray5, String[] stringArray6, boolean bl) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        String string2 = "assignStorageVolumesToWWPNs";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)string2, (Object[])new Object[]{stringArray, stringArray2, stringArray3, stringArray4, new Integer(n), string, stringArray5, stringArray6, new Boolean(bl)});
        AsyncResult asyncResult2 = null;
        DBHelper dBHelper = null;
        try {
            try {
                ParameterChecker.assertMandatoryParameter((int)1, (String)"StorageVolumeIDs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
                ParameterChecker.assertMandatoryParameter((int)4, (String)"HostWWPNs", (Object)stringArray4, (LogTraceHelper)logTraceHelper);
                dBHelper = new DBHelper();
                AssignStorageVolumesParameter assignStorageVolumesParameter = new AssignStorageVolumesParameter();
                assignStorageVolumesParameter.setVolumeIDs(stringArray);
                dBHelper.getStorageVolumesAndSubsystemObjects(assignStorageVolumesParameter, stringArray);
                ConfigurationParameter[] configurationParameterArray = DiskParameterHelper.combineConfigurationParametersByStorageSystem(assignStorageVolumesParameter).toArray(new AssignStorageVolumesParameter[0]);
                int n2 = 0;
                block7: while (true) {
                    if (n2 >= configurationParameterArray.length) {
                        IStorageSubsystemControl iStorageSubsystemControl = this.getStorageSubsystemController();
                        asyncResult = asyncResult2 = iStorageSubsystemControl.assignStorageVolumesToWWPNs(configurationParameterArray);
                        Object var23_30 = null;
                        if (dBHelper != null) {
                            dBHelper.close();
                        }
                        break;
                    }
                    CIMOMSelector cIMOMSelector = CIMOMSelector.getSelector();
                    CIMOMSelector.SubsystemConnectionData subsystemConnectionData = cIMOMSelector.getCimomForSubsystem(configurationParameterArray[n2].getStorageSubsystem().getSubsystemId());
                    configurationParameterArray[n2].setCIMClientWrapper(subsystemConnectionData.getClientWrapper());
                    configurationParameterArray[n2].setCimom(subsystemConnectionData.getCimom());
                    CapabilityData capabilityData = subsystemConnectionData.getCapability();
                    if (capabilityData.getPortsPerView() == 2 && stringArray2 == null) {
                        throw DiskMessageHelper.getServerException((String)"HWN021602E", (Object)configurationParameterArray[n2].getStorageSubsystemID(), (LogTraceHelper)logTraceHelper);
                    }
                    if (capabilityData.getAccessAssignment() != 1) {
                        throw DiskMessageHelper.getServerException((String)"HWN021536E", (Object)configurationParameterArray[n2].getStorageSubsystemID(), (Object)string2, (LogTraceHelper)logTraceHelper);
                    }
                    configurationParameterArray[n2].setCapability(capabilityData);
                    configurationParameterArray[n2].setVolumeCOPs(dBHelper.getVolumeAndSubsystemCOPs(subsystemConnectionData, configurationParameterArray[n2]));
                    if (stringArray2 != null) {
                        DiskParameterHelper.getTargetPorts(dBHelper, subsystemConnectionData, stringArray2, (AssignStorageVolumesParameter)configurationParameterArray[n2]);
                    }
                    ArrayList<Port> arrayList = new ArrayList<Port>();
                    Port[] portArray = dBHelper.getInitiatorPortObjects(configurationParameterArray[n2], stringArray4);
                    int n3 = 0;
                    while (true) {
                        if (n3 >= portArray.length) {
                            configurationParameterArray[n2].setInitiatorPorts(arrayList);
                            if (n != -1) {
                                CIMObjectPath cIMObjectPath = dBHelper.getClientSettingDataCOP(subsystemConnectionData, configurationParameterArray[n2].getStorageSubsystem().getSubsystemId(), n, string, configurationParameterArray[n2]);
                                configurationParameterArray[n2].setClientSettingDataCOP(cIMObjectPath);
                            }
                            if (stringArray3 != null) {
                                configurationParameterArray[n2].setDeviceNumbers(stringArray3);
                            }
                            configurationParameterArray[n2].setInitiatorWWPNs(stringArray4);
                            configurationParameterArray[n2].setHostNames(stringArray5);
                            configurationParameterArray[n2].setForce(bl);
                            ++n2;
                            continue block7;
                        }
                        arrayList.add(portArray[n3]);
                        ++n3;
                    }
                    break;
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                logTraceHelper.traceError("InvalidParameterException", (Throwable)invalidParameterException);
                throw invalidParameterException;
            }
            catch (MissingParameterException missingParameterException) {
                logTraceHelper.traceError("MissingParameterException", (Throwable)missingParameterException);
                throw missingParameterException;
            }
            catch (ServerException serverException) {
                logTraceHelper.traceError("ServerException", (Throwable)serverException);
                throw serverException;
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", (Throwable)sQLException);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var23_31 = null;
            if (dBHelper != null) {
                dBHelper.close();
            }
            logTraceHelper.exit(asyncResult2);
            throw throwable;
        }
        logTraceHelper.exit((Object)asyncResult2);
        return asyncResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult unassignStorageVolumesFromWWPNs(String[] stringArray, String[] stringArray2, int n, boolean bl) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        String string = "unassignStorageVolumesFromWWPNs";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)string, (Object[])new Object[]{stringArray, stringArray2, new Integer(n), new Boolean(bl)});
        DBHelper dBHelper = null;
        AsyncResult asyncResult2 = null;
        try {
            try {
                ParameterChecker.assertMandatoryParameter((int)1, (String)"StorageVolumeIDs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
                ParameterChecker.assertMandatoryParameter((int)2, (String)"HostWWPNs", (Object)stringArray2, (LogTraceHelper)logTraceHelper);
                ParameterChecker.assertOptionalParameterInRange((int)3, (String)"UnMappingMode", (int)n, (int)1, (int)3, (LogTraceHelper)logTraceHelper);
                if (n == -1) {
                    n = AssignmentParameter.MAP;
                }
                dBHelper = new DBHelper();
                AssignmentParameter assignmentParameter = new AssignmentParameter();
                assignmentParameter.setVolumeIDs(stringArray);
                dBHelper.getStorageVolumesAndSubsystemObjects(assignmentParameter, stringArray);
                ConfigurationParameter[] configurationParameterArray = DiskParameterHelper.combineConfigurationParametersByStorageSystem(assignmentParameter).toArray(new AssignmentParameter[0]);
                int n2 = 0;
                while (true) {
                    if (n2 >= configurationParameterArray.length) {
                        IStorageSubsystemControl iStorageSubsystemControl = this.getStorageSubsystemController();
                        asyncResult = asyncResult2 = iStorageSubsystemControl.unassignStorageVolumesFromWWPNs(configurationParameterArray);
                        Object var14_19 = null;
                        if (dBHelper != null) {
                            dBHelper.close();
                        }
                        break;
                    }
                    CIMOMSelector cIMOMSelector = CIMOMSelector.getSelector();
                    CIMOMSelector.SubsystemConnectionData subsystemConnectionData = cIMOMSelector.getCimomForSubsystem(configurationParameterArray[n2].getStorageSubsystem().getSubsystemId());
                    configurationParameterArray[n2].setCIMClientWrapper(subsystemConnectionData.getClientWrapper());
                    configurationParameterArray[n2].setCimom(subsystemConnectionData.getCimom());
                    configurationParameterArray[n2].setCapability(subsystemConnectionData.getCapability());
                    if (configurationParameterArray[n2].getCapability().getAccessUnassignment() != 1) {
                        throw DiskMessageHelper.getServerException((String)"HWN021536E", (Object)configurationParameterArray[n2].getStorageSubsystemID(), (Object)string, (LogTraceHelper)logTraceHelper);
                    }
                    configurationParameterArray[n2].setVolumeCOPs(dBHelper.getVolumeAndSubsystemCOPs(subsystemConnectionData, configurationParameterArray[n2]));
                    configurationParameterArray[n2].setInitiatorWWPNs(stringArray2);
                    configurationParameterArray[n2].setMappingMode(n);
                    configurationParameterArray[n2].setForce(bl);
                    ++n2;
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                logTraceHelper.traceError("InvalidParameterException", (Throwable)invalidParameterException);
                throw invalidParameterException;
            }
            catch (MissingParameterException missingParameterException) {
                logTraceHelper.traceError("MissingParameterException", (Throwable)missingParameterException);
                throw missingParameterException;
            }
            catch (ServerException serverException) {
                logTraceHelper.traceError("ServerException", (Throwable)serverException);
                throw serverException;
            }
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            if (dBHelper != null) {
                dBHelper.close();
            }
            logTraceHelper.exit(asyncResult2);
            throw throwable;
        }
        logTraceHelper.exit((Object)asyncResult2);
        return asyncResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult modifyStoragePoolSize(String string, String[] stringArray, String[] stringArray2) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        String string2 = "modifyStoragePoolSize";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)string2, (Object[])new Object[]{string, stringArray, stringArray2});
        AsyncResult asyncResult2 = null;
        DBConnection dBConnection = null;
        try {
            try {
                int n;
                String string3;
                ParameterChecker.assertMandatoryParameter((int)1, (String)"StoragePoolID", (Object)string, (LogTraceHelper)logTraceHelper);
                ParameterChecker.assertExclusiveMandatoryParameter((int)2, (String)"StorageExtentIDsToAdd, StorageExtentIDsToRemove", (Object)stringArray, (Object)stringArray2, (String)"StorageExtentIDsToAdd", (String)"StorageExtentIDsToRemove", (LogTraceHelper)logTraceHelper);
                dBConnection = ServiceUtils.getConnection();
                StorageSubsystem storageSubsystem = null;
                StoragePool storagePool = null;
                StorageExtent[] storageExtentArray = null;
                CIMObjectPath[] cIMObjectPathArray = null;
                StorageExtent[] storageExtentArray2 = null;
                CIMObjectPath[] cIMObjectPathArray2 = null;
                try {
                    string3 = ExternalKeyConverter.frameKeyStorageSubsystemFromPool((String)string, (LogTraceHelper)logTraceHelper);
                    storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)string3, (DBConnection)dBConnection);
                    storagePool = ExternalKeyManager.getStoragePool((String)string, (int)storageSubsystem.getSubsystemId(), (DBConnection)dBConnection);
                }
                catch (IDParseException iDParseException) {
                    throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)string, (LogTraceHelper)logTraceHelper);
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021654E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
                }
                string3 = CIMOMSelector.getSelector();
                CIMOMSelector.SubsystemConnectionData subsystemConnectionData = string3.getCimomForSubsystem(storageSubsystem.getSubsystemId());
                CIMObjectPath cIMObjectPath = subsystemConnectionData.getSubsystemCop();
                CIMObjectPath cIMObjectPath2 = ExternalKeyManager.getCIMObjectPath((StoragePool)storagePool, (String)subsystemConnectionData.getCimNamespace());
                if (stringArray != null) {
                    storageExtentArray = new StorageExtent[stringArray.length];
                    cIMObjectPathArray = new CIMObjectPath[stringArray.length];
                    n = 0;
                    while (n < stringArray.length) {
                        try {
                            storageExtentArray[n] = ExternalKeyManager.getStorageExtent((String)stringArray[n], (int)storageSubsystem.getSubsystemId(), (DBConnection)dBConnection);
                        }
                        catch (IDParseException iDParseException) {
                            throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN020003E", (Object)stringArray[n], (LogTraceHelper)logTraceHelper);
                        }
                        catch (EntityNotFoundException entityNotFoundException) {
                            throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN021658E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
                        }
                        cIMObjectPathArray[n] = ExternalKeyManager.getCIMObjectPath((StorageExtent)storageExtentArray[n], (String)subsystemConnectionData.getCimNamespace());
                        ++n;
                    }
                }
                if (stringArray2 != null) {
                    storageExtentArray2 = new StorageExtent[stringArray2.length];
                    cIMObjectPathArray2 = new CIMObjectPath[stringArray2.length];
                    n = 0;
                    while (n < stringArray2.length) {
                        try {
                            storageExtentArray2[n] = ExternalKeyManager.getStorageExtent((String)stringArray2[n], (int)storageSubsystem.getSubsystemId(), (DBConnection)dBConnection);
                        }
                        catch (IDParseException iDParseException) {
                            throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN020003E", (Object)stringArray[n], (LogTraceHelper)logTraceHelper);
                        }
                        catch (EntityNotFoundException entityNotFoundException) {
                            throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN021658E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
                        }
                        cIMObjectPathArray2[n] = ExternalKeyManager.getCIMObjectPath((StorageExtent)storageExtentArray2[n], (String)subsystemConnectionData.getCimNamespace());
                        ++n;
                    }
                }
                CapabilityData capabilityData = subsystemConnectionData.getCapability();
                ModifyStoragePoolParameter modifyStoragePoolParameter = new ModifyStoragePoolParameter(storageSubsystem, cIMObjectPath);
                modifyStoragePoolParameter.addModifyStoragePoolParameter(storagePool, cIMObjectPath2, storageExtentArray, cIMObjectPathArray, storageExtentArray2, cIMObjectPathArray2);
                modifyStoragePoolParameter.setCimom(subsystemConnectionData.getCimom());
                modifyStoragePoolParameter.setCapability(capabilityData);
                IStorageSubsystemControl iStorageSubsystemControl = this.getStorageSubsystemController();
                asyncResult2 = iStorageSubsystemControl.modifyStoragePoolSize(modifyStoragePoolParameter);
                dBConnection.commit();
                asyncResult = asyncResult2;
                Object var21_28 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            catch (NotAvailableException notAvailableException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)notAvailableException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var21_29 = null;
            this.finallyCheckConnection(dBConnection, logTraceHelper);
            logTraceHelper.exit(asyncResult2);
            throw throwable;
        }
        this.finallyCheckConnection(dBConnection, logTraceHelper);
        logTraceHelper.exit((Object)asyncResult2);
        return asyncResult;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult modifyStorageVolumeSize(String string, long l) throws ServerException, InvalidParameterException, MissingParameterException {
        String string2 = "modifyStorageVolumeSize";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)string2, (Object[])new Object[]{string, String.valueOf(l)});
        AsyncResult asyncResult = null;
        DBConnection dBConnection = null;
        try {
            try {
                ParameterChecker.assertMandatoryParameter((int)1, (String)"StorageVolumeID", (Object)string, (LogTraceHelper)logTraceHelper);
                ParameterChecker.assertValidPrimitiveParameterLong((int)2, (String)"NewSize", (long)l, (LogTraceHelper)logTraceHelper);
                dBConnection = ServiceUtils.getConnection();
                String string3 = ExternalKeyConverter.frameKeyStorageSubsystemFromVolume((String)string, (LogTraceHelper)logTraceHelper);
                StorageSubsystem storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)string3, (DBConnection)dBConnection);
                StorageVolume storageVolume = ExternalKeyManager.getStorageVolume((String)string, (int)storageSubsystem.getSubsystemId(), (DBConnection)dBConnection);
                dBConnection.commit();
                CIMOMSelector cIMOMSelector = CIMOMSelector.getSelector();
                CIMOMSelector.SubsystemConnectionData subsystemConnectionData = cIMOMSelector.getCimomForSubsystem(storageSubsystem.getSubsystemId());
                CimkeyVolume cimkeyVolume = ExternalKeyManager.getStorageVolumeCIM((int)storageVolume.getSvid(), (int)subsystemConnectionData.getCimNamespaceID(), (DBConnection)dBConnection);
                CIMObjectPath cIMObjectPath = subsystemConnectionData.getSubsystemCop();
                CIMObjectPath cIMObjectPath2 = null;
                ExternalKeyManager.getCIMObjectPath((CimkeyVolume)cimkeyVolume, (String)subsystemConnectionData.getCimNamespace());
                CapabilityData capabilityData = subsystemConnectionData.getCapability();
                this.checkOperationSupported(capabilityData, string3, "modifyStorageVolumeSize", logTraceHelper);
                ModifyStorageVolumeParameter modifyStorageVolumeParameter = new ModifyStorageVolumeParameter(storageSubsystem, cIMObjectPath);
                modifyStorageVolumeParameter.setCapability(capabilityData);
                modifyStorageVolumeParameter.setNewSize(l);
                modifyStorageVolumeParameter.setStorageVolume(storageVolume);
                modifyStorageVolumeParameter.setStorageVolumeCIMOP(cIMObjectPath2);
                IStorageSubsystemControl iStorageSubsystemControl = this.getStorageSubsystemController();
                asyncResult = iStorageSubsystemControl.modifyStorageVolumeSize(modifyStorageVolumeParameter);
            }
            catch (IDParseException iDParseException) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)string, (LogTraceHelper)logTraceHelper);
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            catch (NotAvailableException notAvailableException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)notAvailableException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021655E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            this.finallyCheckConnection(dBConnection, logTraceHelper);
            logTraceHelper.exit(asyncResult);
            throw throwable;
        }
        {
            Object var19_23 = null;
        }
        this.finallyCheckConnection(dBConnection, logTraceHelper);
        logTraceHelper.exit((Object)asyncResult);
        return asyncResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult createSVCVDisks(long[] lArray, String[] stringArray, String[] stringArray2, boolean bl, int n, int n2, String[] stringArray3) throws ServerException, InvalidParameterException, MissingParameterException {
        String string = "createSVCVDisks";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)string, (Object[])new Object[]{lArray, stringArray, stringArray2, String.valueOf(bl), String.valueOf(n), new Integer(n2), stringArray3});
        AsyncResult asyncResult = null;
        DBConnection dBConnection = null;
        try {
            AsyncResult asyncResult2;
            try {
                CreateSVCStorageVolumesParameter createSVCStorageVolumesParameter;
                String string2;
                ParameterChecker.assertMandatoryParameter((int)1, (String)"Sizes", (Object)lArray, (LogTraceHelper)logTraceHelper);
                ParameterChecker.assertMandatoryParameter((int)2, (String)"SVCMDiskGroupIDs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
                ParameterChecker.assertMandatoryParameterArraySizes((int)1, (String)"Sizes, SVCMDiskGroupIDs", (Object)lArray, (Object)stringArray, (LogTraceHelper)logTraceHelper);
                ParameterChecker.assertOptionalParameterArraySizes((int)2, (String)"SVCMDiskGroupIDs, SVCVDiskNames", (Object)stringArray, (Object)stringArray2, (LogTraceHelper)logTraceHelper);
                ParameterChecker.assertVitualizationType((int)5, (String)"VirtualizationType", (int)n, (LogTraceHelper)logTraceHelper);
                DiskParameterChecker.assertMDisksForVitualizationType(7, n, stringArray3, stringArray, logTraceHelper);
                if (stringArray2 == null) {
                    stringArray2 = new String[stringArray.length];
                }
                StorageSubsystem[] storageSubsystemArray = new StorageSubsystem[stringArray.length];
                CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[stringArray.length];
                StoragePool[] storagePoolArray = new StoragePool[stringArray.length];
                CIMObjectPath[] cIMObjectPathArray2 = new CIMObjectPath[stringArray.length];
                StorageExtent[] storageExtentArray = new StorageExtent[stringArray.length];
                CIMObjectPath[] cIMObjectPathArray3 = new CIMObjectPath[stringArray.length];
                dBConnection = ServiceUtils.getConnection();
                CIMOMSelector.SubsystemConnectionData subsystemConnectionData = null;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    try {
                        string2 = ExternalKeyConverter.frameKeyStorageSubsystemFromPool((String)stringArray[n3], (LogTraceHelper)logTraceHelper);
                        storageSubsystemArray[n3] = ExternalKeyManager.getStorageSubsystem((String)string2, (DBConnection)dBConnection);
                        storagePoolArray[n3] = ExternalKeyManager.getStoragePool((String)stringArray[n3], (int)storageSubsystemArray[n3].getSubsystemId(), (DBConnection)dBConnection);
                        CIMOMSelector cIMOMSelector = CIMOMSelector.getSelector();
                        subsystemConnectionData = cIMOMSelector.getCimomForSubsystem(storageSubsystemArray[n3].getSubsystemId());
                        cIMObjectPathArray[n3] = subsystemConnectionData.getSubsystemCop();
                        cIMObjectPathArray2[n3] = ExternalKeyManager.getCIMObjectPath((StoragePool)storagePoolArray[n3], (String)subsystemConnectionData.getCimNamespace());
                        if (n != 0) {
                            if (stringArray3.length != 1) {
                                storageExtentArray[n3] = ExternalKeyManager.getStorageExtent((String)stringArray3[n3], (int)storageSubsystemArray[n3].getSubsystemId(), (DBConnection)dBConnection);
                                cIMObjectPathArray3[n3] = ExternalKeyManager.getCIMObjectPath((StorageExtent)storageExtentArray[n3], (String)subsystemConnectionData.getCimNamespace());
                            } else if (storageExtentArray[0] == null) {
                                storageExtentArray[n3] = ExternalKeyManager.getStorageExtent((String)stringArray3[n3], (int)storageSubsystemArray[n3].getSubsystemId(), (DBConnection)dBConnection);
                                cIMObjectPathArray3[n3] = ExternalKeyManager.getCIMObjectPath((StorageExtent)storageExtentArray[n3], (String)subsystemConnectionData.getCimNamespace());
                            } else {
                                storageExtentArray[n3] = storageExtentArray[0];
                                cIMObjectPathArray3[n3] = cIMObjectPathArray2[0];
                            }
                        }
                        createSVCStorageVolumesParameter = subsystemConnectionData.getCapability();
                        this.checkOperationSupported((CapabilityData)createSVCStorageVolumesParameter, string2, "CreateStorageVolumes", logTraceHelper);
                    }
                    catch (IDParseException iDParseException) {
                        throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN020003E", (Object)stringArray[n3], (LogTraceHelper)logTraceHelper);
                    }
                    catch (EntityNotFoundException entityNotFoundException) {
                        throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN021654E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
                    }
                    ++n3;
                }
                HashMap<String, CreateSVCStorageVolumesParameter> hashMap = new HashMap<String, CreateSVCStorageVolumesParameter>();
                string2 = null;
                int n4 = 0;
                while (n4 < storagePoolArray.length) {
                    string2 = (String)ExternalKeyConverter.getStorageSubsystemKey((StorageSubsystem)storageSubsystemArray[n4]);
                    createSVCStorageVolumesParameter = null;
                    createSVCStorageVolumesParameter = !hashMap.containsKey(string2) ? new CreateSVCStorageVolumesParameter(storageSubsystemArray[n4], cIMObjectPathArray[n4]) : (CreateSVCStorageVolumesParameter)hashMap.get(string2);
                    createSVCStorageVolumesParameter.addCreateSVCStorageVolumeParameter(storagePoolArray[n4], cIMObjectPathArray2[n4], lArray[n4], stringArray2[n4], storageExtentArray[n4], cIMObjectPathArray3[n4], bl, n, null);
                    createSVCStorageVolumesParameter.setCapability(subsystemConnectionData.getCapability());
                    createSVCStorageVolumesParameter.setCimom(subsystemConnectionData.getCimom());
                    hashMap.put(string2, createSVCStorageVolumesParameter);
                    ++n4;
                }
                if (stringArray3 != null && n == 0) {
                    this.getMDisksForSubsystem(hashMap, string2, storageSubsystemArray[0].getSubsystemId(), stringArray3, subsystemConnectionData, dBConnection, logTraceHelper);
                }
                if (n2 != -1) {
                    this.getIOGroupForSubsystem(hashMap, string2, n2, subsystemConnectionData, dBConnection, logTraceHelper);
                }
                IStorageSubsystemControl iStorageSubsystemControl = this.getStorageSubsystemController();
                createSVCStorageVolumesParameter = new CreateSVCStorageVolumesParameter[hashMap.size()];
                createSVCStorageVolumesParameter = hashMap.values().toArray((T[])createSVCStorageVolumesParameter);
                asyncResult = iStorageSubsystemControl.createSVCDisks((CreateSVCStorageVolumesParameter[])createSVCStorageVolumesParameter);
                dBConnection.commit();
                asyncResult2 = asyncResult;
                Object var23_30 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            catch (NotAvailableException notAvailableException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)notAvailableException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            this.finallyCheckConnection(dBConnection, logTraceHelper);
            logTraceHelper.exit((Object)asyncResult);
            return asyncResult2;
        }
        catch (Throwable throwable) {
            Object var23_31 = null;
            this.finallyCheckConnection(dBConnection, logTraceHelper);
            logTraceHelper.exit(asyncResult);
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    private void getIOGroupForSubsystem(HashMap var1_1, String var2_2, int var3_3, CIMOMSelector.SubsystemConnectionData var4_4, DBConnection var5_5, LogTraceHelper var6_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 133->137)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void getMDisksForSubsystem(HashMap hashMap, String string, int n, String[] stringArray, CIMOMSelector.SubsystemConnectionData subsystemConnectionData, DBConnection dBConnection, LogTraceHelper logTraceHelper) {
        if (hashMap.size() > 1) {
            throw DiskMessageHelper.getInvalidParameterException((int)7, (String)"HWN020003E", (Object)stringArray, (LogTraceHelper)logTraceHelper);
        }
        int n2 = 0;
        try {
            ArrayList<StorageExtent> arrayList = new ArrayList<StorageExtent>();
            ArrayList<CIMObjectPath> arrayList2 = new ArrayList<CIMObjectPath>();
            n2 = 0;
            while (n2 < stringArray.length) {
                StorageExtent storageExtent = ExternalKeyManager.getStorageExtent((String)stringArray[n2], (int)n, (DBConnection)dBConnection);
                arrayList.add(storageExtent);
                arrayList2.add(ExternalKeyManager.getCIMObjectPath((StorageExtent)storageExtent, (String)subsystemConnectionData.getCimNamespace()));
                ++n2;
            }
            ((CreateSVCStorageVolumesParameter)hashMap.get(string)).setMDisks(arrayList);
            ((CreateSVCStorageVolumesParameter)hashMap.get(string)).setMDiskCIMOPs(arrayList2);
        }
        catch (IDParseException iDParseException) {
            throw DiskMessageHelper.getInvalidParameterException((int)7, (String)"HWN020003E", (Object)stringArray[n2], (LogTraceHelper)logTraceHelper);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            throw DiskMessageHelper.getInvalidParameterException((int)7, (String)"HWN021658E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
        }
    }

    private void checkOperationSupported(CapabilityData capabilityData, String string, String string2, LogTraceHelper logTraceHelper) throws ServerException {
        if (string2.equals("CreateStorageVolumes") ? capabilityData.getVolumeCreation() == 1 : (string2.equals("DeleteStorageVolumes") ? capabilityData.getVolumeDeletion() == 1 : (string2.equals("ModifyStoragePoolSize") ? capabilityData.getExtentData() == 1 : string2.equals("modifyStorageVolumeSize") && capabilityData.getVolumeExpansion() == 1 && capabilityData.getVolumeShrinking() == 1))) {
            return;
        }
        SRMMessage sRMMessage = new SRMMessage("HWN021536E", new String[]{string, string2});
        ServerException serverException = new ServerException(sRMMessage);
        logTraceHelper.traceError(serverException.getLocalizedMessage(), (Throwable)serverException);
        throw serverException;
    }

    private void checkSizeSupportedByPool(String string, long l, long l2, LogTraceHelper logTraceHelper) throws ServerException, InvalidParameterException {
        try {
            if (l2 < l) {
                SRMMessage sRMMessage = new SRMMessage("HWN021535E", new String[]{string, ExternalKeyConverter.frameKeyStorageSubsystemFromPool((String)string, (LogTraceHelper)logTraceHelper), String.valueOf(l)});
                throw new ServerException(sRMMessage);
            }
        }
        catch (IDParseException iDParseException) {
            throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN020003E", (Object)string, (LogTraceHelper)logTraceHelper);
        }
    }

    private void checkPoolSupportsSize(String[] stringArray, StoragePool[] storagePoolArray, CIMObjectPath[] cIMObjectPathArray, long[] lArray, LogTraceHelper logTraceHelper) throws ServerException, InvalidParameterException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length - 1) {
            boolean bl = false;
            long l = lArray[0];
            String string = stringArray[n];
            boolean bl2 = true;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                if (string.equals(arrayList.get(n2).toString())) {
                    bl2 = false;
                    break;
                }
                ++n2;
            }
            if (bl2) {
                n2 = n + 1;
                while (n2 < stringArray.length) {
                    if (string.equals(stringArray[n2])) {
                        if (!bl) {
                            arrayList.add(string);
                        }
                        bl = true;
                        l += lArray[n2];
                    }
                    ++n2;
                }
            }
            if (bl) {
                logTraceHelper.traceInfo("Several volumes to be created from same pool. Checking available space.");
                long[] lArray2 = this.cDM.getDefaultSupportedVolumeSizeRange(string);
                long l2 = lArray2[1];
                logTraceHelper.traceInfo("Space available:" + l2);
                logTraceHelper.traceInfo("Space needed:" + l);
                this.checkSizeSupportedByPool(string, l, l2, logTraceHelper);
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult unassignStorageVolumesFromWWPNs(String[] stringArray, String[] stringArray2, boolean bl) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"unassignStorageVolumesFromWWPNs", (Object[])new Object[]{stringArray, stringArray2, new Boolean(bl)});
        AsyncResult asyncResult = null;
        try {
            asyncResult = this.unassignStorageVolumesFromWWPNs(stringArray, stringArray2, AssignmentParameter.MAP, bl);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            logTraceHelper.exit((Object)asyncResult);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        logTraceHelper.exit((Object)asyncResult);
        return asyncResult;
    }

    private void finallyCheckConnection(DBConnection dBConnection, LogTraceHelper logTraceHelper) throws ServerException {
        if (dBConnection != null) {
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
    }
}

