/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.common.api.IdDenormalizer;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.api.DiskManagerFilterKeys;
import org.eclipse.aperi.disk.api.ExtendedVolumeAssignments;
import org.eclipse.aperi.disk.api.HostInfo;
import org.eclipse.aperi.disk.api.HostType;
import org.eclipse.aperi.disk.api.SingleMapping;
import org.eclipse.aperi.disk.api.WWPNCollection;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelperDummy;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.ParameterChecker;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.disk.control.IStorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.StorageConfigurationPluginFactory;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.ClientSettingData;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.MaskingInfo;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.sql.SqlDataPath;
import org.sblim.wbem.cim.CIMObjectPath;

public abstract class DiskReportingOperationsBase
implements DiskManagerFilterKeys {
    public static String[] getStorageSubsystems(HashMap hashMap, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException, InvalidParameterException {
        Class<?> clazz;
        logTraceHelper = DiskReportingOperationsBase.checkBaseParameter("getStorageSubsystems", logTraceHelper, dBConnection);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Hashtable hashtable = DiskReportingHelper.createWhereClauseMap(clazz, (Map)hashMap, (LogTraceHelper)logTraceHelper);
        new Vector(Arrays.asList("NAME", "NAME_FORMAT"));
        StorageSubsystem.StorageSubsystemCursor storageSubsystemCursor = StorageSubsystem.getCursor((DBConnection)dBConnection, (Hashtable)(hashtable.size() == 0 ? null : hashtable), null);
        while (storageSubsystemCursor.next()) {
            StorageSubsystem storageSubsystem = storageSubsystemCursor.getAttributes();
            linkedList.add(ExternalKeyConverter.getStorageSubsystemKey((StorageSubsystem)storageSubsystem));
        }
        storageSubsystemCursor.close();
        dBConnection.commit();
        return linkedList.toArray(new String[0]);
    }

    public static HashMap[] getStorageSubsystemAttributes(String[] stringArray, String[] stringArray2, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        logTraceHelper = DiskReportingOperationsBase.checkBaseParameter("getStorageSubsystemAttributes", logTraceHelper, dBConnection);
        HashMap[] hashMapArray = new HashMap[stringArray.length];
        ParameterChecker.assertMandatoryParameter((int)1, (String)"subsystemIDs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
        ParameterChecker.assertMandatoryParameter((int)2, (String)"attribList", (Object)stringArray2, (LogTraceHelper)logTraceHelper);
        int n = 0;
        while (n < stringArray.length) {
            HashMap hashMap = null;
            Hashtable hashtable = ExternalKeyConverter.getStorageSubsystemWhereClause((String)stringArray[n], (LogTraceHelper)logTraceHelper);
            StorageSubsystem.StorageSubsystemCursor storageSubsystemCursor = StorageSubsystem.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
            while (storageSubsystemCursor.next()) {
                StorageSubsystem storageSubsystem = storageSubsystemCursor.getAttributes();
                hashMap = DiskReportingHelper.getAttributes((Object)storageSubsystem, (String[])stringArray2, (LogTraceHelper)logTraceHelper);
                hashMap = IdDenormalizer.denormalizeIDsForStorageSubsystem((HashMap)hashMap);
            }
            storageSubsystemCursor.close();
            if (hashMap == null) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021657E", (Object)stringArray[n], (LogTraceHelper)logTraceHelper);
            }
            hashMapArray[n] = hashMap;
            hashMap = null;
            dBConnection.commit();
            ++n;
        }
        return hashMapArray;
    }

    public static String[] getPortsForSubsystem(String string, HashMap hashMap, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        Class<?> clazz;
        logTraceHelper = DiskReportingOperationsBase.checkBaseParameter("getPortsForSubsystem", logTraceHelper, dBConnection);
        LinkedList<String> linkedList = new LinkedList<String>();
        ParameterChecker.assertMandatoryParameter((int)1, (String)"SubsystemID", (Object)string, (LogTraceHelper)logTraceHelper);
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.Port");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Hashtable hashtable = DiskReportingHelper.createWhereClauseMap(clazz, (Map)hashMap, (LogTraceHelper)logTraceHelper);
        Object object = DiskReportingOperationsBase.getSubsystem_ID(string, dBConnection, logTraceHelper);
        DiskReportingOperationsBase.addStorageSubsystem(hashtable, object, logTraceHelper);
        Port.PortCursor portCursor = Port.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
        while (portCursor.next()) {
            Port port = portCursor.getAttributes();
            linkedList.add(ExternalKeyConverter.getPortKey((Port)port));
        }
        portCursor.close();
        dBConnection.commit();
        return linkedList.toArray(new String[0]);
    }

    private static String getSubsystem(String string, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SUBSYSTEM_ID", string);
        String[] stringArray = DiskReportingOperationsBase.getStorageSubsystems(hashMap, logTraceHelper, dBConnection);
        if (stringArray[0] != null) {
            return stringArray[0];
        }
        throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021657E", (Object)string, (LogTraceHelper)logTraceHelper);
    }

    private static Object getSubsystem_ID(String string, DBConnection dBConnection, LogTraceHelper logTraceHelper) throws ServerException, InvalidParameterException {
        try {
            StorageSubsystem storageSubsystem = null;
            storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)string, (DBConnection)dBConnection);
            return new Integer(storageSubsystem.getSubsystemId());
        }
        catch (IDParseException iDParseException) {
            throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)"subsystemID", (LogTraceHelper)logTraceHelper);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021657E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
        }
    }

    private static Hashtable addStorageSubsystem(Hashtable hashtable, Object object, LogTraceHelper logTraceHelper) throws ServerException {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.Port");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"SUBSYSTEM_ID", (LogTraceHelper)logTraceHelper);
        hashtable.put(columnInfo, object.toString());
        return hashtable;
    }

    public static HashMap[] getPortAttributes(String[] stringArray, String[] stringArray2, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        logTraceHelper = DiskReportingOperationsBase.checkBaseParameter("getPortAttributes", logTraceHelper, dBConnection);
        HashMap[] hashMapArray = new HashMap[stringArray.length];
        ParameterChecker.assertMandatoryParameter((int)1, (String)"PortIDs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
        ParameterChecker.assertMandatoryParameter((int)2, (String)"attribList", (Object)stringArray2, (LogTraceHelper)logTraceHelper);
        int n = 0;
        while (n < stringArray.length) {
            Class<?> clazz;
            HashMap hashMap = null;
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>(stringArray.length + 1);
            try {
                clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.Port");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"NAME", (LogTraceHelper)logTraceHelper);
            hashtable.put(columnInfo, stringArray[n]);
            Port.PortCursor portCursor = Port.getCursor((DBConnection)dBConnection, hashtable, null);
            while (portCursor.next()) {
                Port port = portCursor.getAttributes();
                hashMap = DiskReportingHelper.getAttributes((Object)port, (String[])stringArray2, (LogTraceHelper)logTraceHelper);
            }
            portCursor.close();
            if (hashMap == null) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021656E", (Object)stringArray[n], (LogTraceHelper)logTraceHelper);
            }
            hashMapArray[n] = hashMap;
            hashMap = null;
            dBConnection.commit();
            ++n;
        }
        return hashMapArray;
    }

    public static String[] getStoragePoolsForSubsystem(String string, HashMap hashMap, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        Class<?> clazz;
        logTraceHelper = DiskReportingOperationsBase.checkBaseParameter("getStoragePoolsForSubsystem", logTraceHelper, dBConnection);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        ParameterChecker.assertMandatoryParameter((int)1, (String)"SubsystemID", (Object)string, (LogTraceHelper)logTraceHelper);
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.StoragePool");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Hashtable hashtable = DiskReportingHelper.createWhereClauseMap(clazz, (Map)hashMap, (LogTraceHelper)logTraceHelper);
        Object object = DiskReportingOperationsBase.getSubsystem_ID(string, dBConnection, logTraceHelper);
        DiskReportingOperationsBase.addStorageSubsystem(hashtable, object, logTraceHelper);
        StoragePool.StoragePoolCursor storagePoolCursor = StoragePool.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
        try {
            while (storagePoolCursor.next()) {
                StoragePool storagePool = storagePoolCursor.getAttributes();
                if (storagePool.getPrimordial() != 0) continue;
                linkedList.add(ExternalKeyConverter.getStoragePoolKey((StoragePool)storagePool, (String)string, (LogTraceHelper)logTraceHelper));
            }
            storagePoolCursor.close();
        }
        catch (IDParseException iDParseException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)iDParseException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        dBConnection.commit();
        return linkedList.toArray(new String[0]);
    }

    public static HashMap[] getStoragePoolAttributes(String[] stringArray, String[] stringArray2, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        logTraceHelper = DiskReportingOperationsBase.checkBaseParameter("getStoragePoolAttributes", logTraceHelper, dBConnection);
        HashMap[] hashMapArray = new HashMap[stringArray.length];
        ParameterChecker.assertMandatoryParameter((int)1, (String)"PoolIDs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
        ParameterChecker.assertMandatoryParameter((int)2, (String)"attribList", (Object)stringArray2, (LogTraceHelper)logTraceHelper);
        int n = 0;
        while (n < stringArray.length) {
            HashMap hashMap = null;
            Hashtable hashtable = ExternalKeyConverter.getPoolWhereclause((LogTraceHelper)logTraceHelper, (String)stringArray[n], (DBConnection)dBConnection);
            StoragePool.StoragePoolCursor storagePoolCursor = StoragePool.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
            while (storagePoolCursor.next()) {
                StoragePool storagePool = storagePoolCursor.getAttributes();
                hashMap = DiskReportingHelper.getAttributes((Object)storagePool, (String[])stringArray2, (LogTraceHelper)logTraceHelper);
            }
            storagePoolCursor.close();
            if (hashMap == null) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021654E", (Object)stringArray[n], (LogTraceHelper)logTraceHelper);
            }
            hashMapArray[n] = hashMap;
            hashMap = null;
            dBConnection.commit();
            ++n;
        }
        return hashMapArray;
    }

    public static String[] getStorageVolumesForPool(String string, HashMap hashMap, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        Class<?> clazz;
        logTraceHelper = DiskReportingOperationsBase.checkBaseParameter("getStorageVolumesForPool", logTraceHelper, dBConnection);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        ParameterChecker.assertMandatoryParameter((int)1, (String)"poolID", (Object)string, (LogTraceHelper)logTraceHelper);
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.StorageVolume");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Hashtable hashtable = DiskReportingHelper.createWhereClauseMap(clazz, (Map)hashMap, (LogTraceHelper)logTraceHelper);
        Object object = DiskReportingOperationsBase.getPool_ID(string, logTraceHelper, dBConnection);
        DiskReportingOperationsBase.addStoragePoolID(hashtable, object, logTraceHelper);
        boolean bl = true;
        StorageVolume.StorageVolumeCursor storageVolumeCursor = StorageVolume.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
        String string2 = null;
        while (storageVolumeCursor.next()) {
            StorageVolume storageVolume = storageVolumeCursor.getAttributes();
            if (bl) {
                string2 = DiskReportingOperationsBase.getSubsystem(new Integer(storageVolume.getSubsystemId()).toString(), logTraceHelper, dBConnection);
                bl = false;
            }
            try {
                linkedList.add(ExternalKeyConverter.getStorageVolumeKey((StorageVolume)storageVolume, string2, (LogTraceHelper)logTraceHelper));
            }
            catch (IDParseException iDParseException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)iDParseException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        storageVolumeCursor.close();
        dBConnection.commit();
        return linkedList.toArray(new String[0]);
    }

    private static Hashtable addStoragePoolID(Hashtable hashtable, Object object, LogTraceHelper logTraceHelper) throws ServerException {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.StorageVolume");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"POOL_ID", (LogTraceHelper)logTraceHelper);
        hashtable.put(columnInfo, object.toString());
        return hashtable;
    }

    private static Object getPool_ID(String string, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException {
        String[] stringArray = new String[]{string};
        String[] stringArray2 = new String[]{"POOL_ID"};
        HashMap[] hashMapArray = DiskReportingOperationsBase.getStoragePoolAttributes(stringArray, stringArray2, logTraceHelper, dBConnection);
        if (hashMapArray[0] != null) {
            return hashMapArray[0].get(stringArray2[0]);
        }
        throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021654E", (Object)string, (LogTraceHelper)logTraceHelper);
    }

    public static String[] getStorageVolumesForSubsystem(String string, HashMap hashMap, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        Class<?> clazz;
        logTraceHelper = DiskReportingOperationsBase.checkBaseParameter("getStorageVolumesForSubsystem", logTraceHelper, dBConnection);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        ParameterChecker.assertMandatoryParameter((int)1, (String)"SubsystemID", (Object)string, (LogTraceHelper)logTraceHelper);
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.StorageVolume");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Hashtable hashtable = DiskReportingHelper.createWhereClauseMap(clazz, (Map)hashMap, (LogTraceHelper)logTraceHelper);
        Object object = DiskReportingOperationsBase.getSubsystem_ID(string, dBConnection, logTraceHelper);
        DiskReportingOperationsBase.addStorageSubsystem(hashtable, object, logTraceHelper);
        StorageVolume.StorageVolumeCursor storageVolumeCursor = StorageVolume.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
        while (storageVolumeCursor.next()) {
            try {
                StorageVolume storageVolume = storageVolumeCursor.getAttributes();
                linkedList.add(ExternalKeyConverter.getStorageVolumeKey((StorageVolume)storageVolume, (String)string, (LogTraceHelper)logTraceHelper));
            }
            catch (IDParseException iDParseException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)iDParseException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        storageVolumeCursor.close();
        dBConnection.commit();
        return linkedList.toArray(new String[0]);
    }

    public static HashMap[] getStorageVolumeAttributes(String[] stringArray, String[] stringArray2, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        logTraceHelper = DiskReportingOperationsBase.checkBaseParameter("getStorageVolumeAttributes", logTraceHelper, dBConnection);
        HashMap[] hashMapArray = new HashMap[stringArray.length];
        ParameterChecker.assertMandatoryParameter((int)1, (String)"StorageVolumeIDs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
        ParameterChecker.assertMandatoryParameter((int)2, (String)"Attributes", (Object)stringArray2, (LogTraceHelper)logTraceHelper);
        int n = 0;
        while (n < stringArray.length) {
            HashMap hashMap = null;
            Hashtable hashtable = ExternalKeyConverter.getVolumeWhereclause((LogTraceHelper)logTraceHelper, (String)stringArray[n], (DBConnection)dBConnection);
            StorageVolume.StorageVolumeCursor storageVolumeCursor = StorageVolume.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
            while (storageVolumeCursor.next()) {
                StorageVolume storageVolume = storageVolumeCursor.getAttributes();
                hashMap = DiskReportingHelper.getAttributes((Object)storageVolume, (String[])stringArray2, (LogTraceHelper)logTraceHelper);
            }
            storageVolumeCursor.close();
            hashMapArray[n] = hashMap;
            hashMap = null;
            dBConnection.commit();
            ++n;
        }
        return hashMapArray;
    }

    public static HashMap[] getStorageVolumeAssignments(String[] stringArray, HashMap hashMap, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        logTraceHelper = DiskReportingOperationsBase.checkBaseParameter("getStorageVolumeAssignments", logTraceHelper, dBConnection);
        HashMap[] hashMapArray = new HashMap[stringArray.length];
        HashMap hashMap2 = new HashMap(50);
        ParameterChecker.assertMandatoryParameter((int)1, (String)"StorageVolumeIDs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
        int n = 0;
        while (n < stringArray.length) {
            Hashtable hashtable = new Hashtable(5);
            String[] stringArray2 = new String[]{"SVID"};
            HashMap[] hashMapArray2 = null;
            hashMapArray2 = DiskReportingOperationsBase.getStorageVolumeAttributes(new String[]{stringArray[n]}, stringArray2, logTraceHelper, dBConnection);
            if (hashMapArray2[0] == null) {
                hashMapArray[n] = null;
            } else {
                ExtendedVolumeAssignments extendedVolumeAssignments;
                Object object;
                Object object2;
                DiskReportingOperationsBase.addVolumeID(hashtable, hashMapArray2[0].get(stringArray2[0]), logTraceHelper);
                DataPath.DataPathCursor dataPathCursor = DataPath.getCursor((DBConnection)dBConnection, hashtable, null);
                HashMap<Integer, MaskingInfo> hashMap3 = new HashMap<Integer, MaskingInfo>();
                MaskingInfo maskingInfo = null;
                LinkedList<Object> linkedList = new LinkedList<Object>();
                Vector<ExtendedVolumeAssignments> vector = new Vector<ExtendedVolumeAssignments>();
                Vector<Integer> vector2 = new Vector<Integer>();
                while (dataPathCursor.next()) {
                    object2 = dataPathCursor.getAttributes();
                    vector2.add(new Integer(object2.getInitiatorPortId()));
                    maskingInfo = (MaskingInfo)hashMap3.get(new Integer(object2.getMaskingInfoId()));
                    if (maskingInfo == null && object2.getMaskingInfoId() != 0) {
                        maskingInfo = DiskReportingOperationsBase.getMaskInfo(dBConnection, new Integer(object2.getMaskingInfoId()), logTraceHelper);
                        hashMap3.put(new Integer(object2.getMaskingInfoId()), maskingInfo);
                        logTraceHelper.traceInfo(maskingInfo.toString());
                    }
                    if (!linkedList.contains(object = DiskReportingOperationsBase.getHostWWPN(hashMap2, object2.getTargetPortId(), dBConnection, logTraceHelper))) {
                        linkedList.add(object);
                    }
                    extendedVolumeAssignments = DiskReportingOperationsBase.getExtVolAss((DataPath)object2, maskingInfo, dBConnection, hashMap2, logTraceHelper);
                    vector.add(extendedVolumeAssignments);
                }
                dataPathCursor.close();
                object2 = new HashMap();
                object = vector.iterator();
                extendedVolumeAssignments = vector2.iterator();
                while (object.hasNext()) {
                    ExtendedVolumeAssignments extendedVolumeAssignments2 = (ExtendedVolumeAssignments)object.next();
                    Integer n2 = (Integer)extendedVolumeAssignments.next();
                    extendedVolumeAssignments2.setSubsystemPorts(linkedList.toArray(new String[0]));
                    String string = DiskReportingOperationsBase.getHostWWPN(hashMap2, n2, dBConnection, logTraceHelper);
                    if (!DiskReportingOperationsBase.checkFilters(hashMap, extendedVolumeAssignments2, string, logTraceHelper)) continue;
                    ((HashMap)object2).put(string, extendedVolumeAssignments2);
                }
                hashMapArray[n] = object2;
            }
            ++n;
        }
        return hashMapArray;
    }

    private static boolean checkFilters(HashMap hashMap, ExtendedVolumeAssignments extendedVolumeAssignments, String string, LogTraceHelper logTraceHelper) {
        String[] stringArray = (String[])hashMap.get("WWPN");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string != null && stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (string.equalsIgnoreCase(stringArray[n])) {
                    logTraceHelper.traceInfo("WWPN found");
                    bl = true;
                }
                ++n;
            }
        } else {
            logTraceHelper.traceInfo("WWPN not set");
            bl = true;
        }
        String[] stringArray2 = (String[])hashMap.get("LUNID");
        if (extendedVolumeAssignments != null && stringArray2 != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (extendedVolumeAssignments.getVolumeDeviceNumber().equalsIgnoreCase(stringArray[n])) {
                    logTraceHelper.traceInfo("LUNID found");
                    bl2 = true;
                }
                ++n;
            }
        } else {
            logTraceHelper.traceInfo("LUNID not set");
            bl2 = true;
        }
        String string2 = (String)hashMap.get("COLLECTIONID");
        if (extendedVolumeAssignments != null && string2 != null) {
            WWPNCollection wWPNCollection = extendedVolumeAssignments.getCollection();
            if (wWPNCollection != null && extendedVolumeAssignments.getCollection().getID().equalsIgnoreCase(string2)) {
                logTraceHelper.traceInfo("COLLECTIONID found");
                bl3 = true;
            }
        } else {
            logTraceHelper.traceInfo("COLLECTIONID not set");
            bl3 = true;
        }
        return bl3 && bl2 && bl;
    }

    private static String getHostWWPN(Map map, int n, DBConnection dBConnection, LogTraceHelper logTraceHelper) throws ServerException {
        try {
            Integer n2 = new Integer(n);
            String string = (String)map.get(n2);
            if (string == null) {
                Class<?> clazz;
                Port port = null;
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>(1);
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.Port");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"PORT_ID", (LogTraceHelper)logTraceHelper);
                hashtable.put(columnInfo, n2.toString());
                Port.PortCursor portCursor = Port.getCursor((DBConnection)dBConnection, hashtable, null);
                while (portCursor.next()) {
                    port = portCursor.getAttributes();
                    string = port.getName();
                    map.put(n2, string);
                }
                portCursor.close();
            }
            return string;
        }
        catch (SQLException sQLException) {
            logTraceHelper.traceError("Internal error: SQLException", (Throwable)sQLException);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
    }

    private static ExtendedVolumeAssignments getExtVolAss(DataPath dataPath, MaskingInfo maskingInfo, DBConnection dBConnection, HashMap hashMap, LogTraceHelper logTraceHelper) throws ServerException {
        ExtendedVolumeAssignments extendedVolumeAssignments = new ExtendedVolumeAssignments();
        extendedVolumeAssignments.setCaption(maskingInfo.getHostCaption());
        extendedVolumeAssignments.setId(maskingInfo.getHostId());
        extendedVolumeAssignments.setName(maskingInfo.getHostElementName());
        String string = DiskReportingOperationsBase.getHostWWPN(hashMap, dataPath.getDeviceLunId(), dBConnection, logTraceHelper);
        extendedVolumeAssignments.setVolumeDeviceNumber(string);
        WWPNCollection wWPNCollection = new WWPNCollection();
        wWPNCollection.setName(maskingInfo.getCollectionName());
        wWPNCollection.setID(maskingInfo.getCollectionId());
        extendedVolumeAssignments.setCollection(wWPNCollection);
        extendedVolumeAssignments.setVolumeDeviceNumber(Integer.toHexString(dataPath.getDeviceLunId()));
        return extendedVolumeAssignments;
    }

    private static HostInfo getHostInfo(DataPath dataPath, MaskingInfo maskingInfo, DBConnection dBConnection, HashMap hashMap, LogTraceHelper logTraceHelper) throws ServerException {
        HostInfo hostInfo = new HostInfo();
        hostInfo.setCaption(maskingInfo.getHostCaption());
        hostInfo.setId(maskingInfo.getHostId());
        hostInfo.setName(maskingInfo.getHostElementName());
        WWPNCollection wWPNCollection = new WWPNCollection();
        wWPNCollection.setName(maskingInfo.getCollectionName());
        wWPNCollection.setID(maskingInfo.getCollectionId());
        return hostInfo;
    }

    private static MaskingInfo getMaskInfo(DBConnection dBConnection, Integer n, LogTraceHelper logTraceHelper) throws ServerException {
        ParameterChecker.assertMandatoryParameter((int)1, (String)"StorageVolumeIDs", (Object)n, (LogTraceHelper)logTraceHelper);
        try {
            Class<?> clazz;
            MaskingInfo maskingInfo = null;
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>(2);
            try {
                clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.MaskingInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"MASKING_INFO_ID", (LogTraceHelper)logTraceHelper);
            hashtable.put(columnInfo, n.toString());
            MaskingInfo.MaskingInfoCursor maskingInfoCursor = MaskingInfo.getCursor((DBConnection)dBConnection, hashtable, null);
            while (maskingInfoCursor.next()) {
                maskingInfo = maskingInfoCursor.getAttributes();
            }
            maskingInfoCursor.close();
            return maskingInfo;
        }
        catch (SQLException sQLException) {
            logTraceHelper.traceError("Internal error: SQLException", (Throwable)sQLException);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
    }

    private static Hashtable addVolumeID(Hashtable hashtable, Object object, LogTraceHelper logTraceHelper) throws ServerException {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.DataPath");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"VOLUME_ID", (LogTraceHelper)logTraceHelper);
        hashtable.put(columnInfo, object.toString());
        return hashtable;
    }

    public static HashMap getHostInfo(String string, HashMap hashMap, boolean bl, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        logTraceHelper = DiskReportingOperationsBase.checkBaseParameter("getHostInfo", logTraceHelper, dBConnection);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        HashMap<String, HostInfo> hashMap2 = new HashMap<String, HostInfo>();
        ParameterChecker.assertMandatoryParameter((int)1, (String)"SubsystemID", (Object)string, (LogTraceHelper)logTraceHelper);
        Object object = DiskReportingOperationsBase.getSubsystem_ID(string, dBConnection, logTraceHelper);
        DBResultSet dBResultSet = SqlDataPath.sqlQuery((DBConnection)dBConnection, (int)SqlDataPath.queryHostInfoIndex, (String)(String.valueOf(object.toString()) + ")"), null);
        while (dBResultSet.next()) {
            int n = dBResultSet.getInt("INITIATOR_PORT_ID");
            linkedList.add(new Integer(n));
        }
        dBResultSet.getStatement().close();
        new LinkedList();
        HashMap hashMap3 = new HashMap();
        HashMap<Integer, MaskingInfo> hashMap4 = new HashMap<Integer, MaskingInfo>();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            HashMap hashMap5 = new HashMap();
            HostInfo hostInfo = new HostInfo();
            String string2 = DiskReportingOperationsBase.getHostWWPN(hashMap3, n, dBConnection, logTraceHelper);
            if (!DiskReportingOperationsBase.checkFiltersWWPN(hashMap, string2, logTraceHelper)) {
                logTraceHelper.traceInfo("WWPNnot used");
                continue;
            }
            hostInfo.setStorageID(string2);
            hostInfo.setStorageSubsystemID(string);
            Hashtable hashtable = new Hashtable(5);
            DiskReportingOperationsBase.addIPID(hashtable, n, logTraceHelper);
            DataPath.DataPathCursor dataPathCursor = DataPath.getCursor((DBConnection)dBConnection, hashtable, null);
            while (dataPathCursor.next()) {
                MaskingInfo maskingInfo;
                DataPath dataPath = dataPathCursor.getAttributes();
                if (bl) {
                    if (!DiskReportingOperationsBase.checkFiltersLUN(hashMap, dataPath, logTraceHelper)) {
                        logTraceHelper.traceInfo("LUNIDnot used");
                        continue;
                    }
                    DiskReportingOperationsBase.addVolumeMapping(hashMap5, dataPath, string, dBConnection, logTraceHelper, hashMap3);
                }
                if ((maskingInfo = (MaskingInfo)hashMap4.get(new Integer(dataPath.getMaskingInfoId()))) == null) {
                    maskingInfo = DiskReportingOperationsBase.getMaskInfo(dBConnection, new Integer(dataPath.getMaskingInfoId()), logTraceHelper);
                    hashMap4.put(new Integer(dataPath.getMaskingInfoId()), maskingInfo);
                }
                if (hostInfo.getId() != null) continue;
                hostInfo.setCaption(maskingInfo.getHostCaption());
                hostInfo.setId(maskingInfo.getHostId());
                hostInfo.setName(maskingInfo.getHostElementName());
            }
            dataPathCursor.close();
            hostInfo.setCollections(DiskReportingOperationsBase.addWWPNCollection(hashMap4, hashMap, logTraceHelper));
            hostInfo.setVolumeMappings(hashMap5);
            hashMap2.put(string2, hostInfo);
        }
        return hashMap2;
    }

    private static boolean checkFiltersLUN(HashMap hashMap, DataPath dataPath, LogTraceHelper logTraceHelper) {
        String[] stringArray = (String[])hashMap.get("LUNID");
        boolean bl = false;
        if (dataPath != null && stringArray != null) {
            String string = Integer.toHexString(dataPath.getDeviceLunId());
            int n = 0;
            while (n < stringArray.length) {
                if (string.equalsIgnoreCase(stringArray[n])) {
                    logTraceHelper.traceInfo("LUNID found");
                    bl = true;
                }
                ++n;
            }
        }
        if (stringArray == null) {
            bl = true;
        }
        return bl;
    }

    private static boolean checkFiltersWWPN(HashMap hashMap, String string, LogTraceHelper logTraceHelper) {
        String[] stringArray = (String[])hashMap.get("WWPN");
        boolean bl = false;
        if (string != null && stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (string.equalsIgnoreCase(stringArray[n])) {
                    logTraceHelper.traceInfo("WWPN found");
                    bl = true;
                }
                ++n;
            }
        }
        if (stringArray == null) {
            bl = true;
        }
        return bl;
    }

    private static WWPNCollection[] addWWPNCollection(Map map, HashMap hashMap, LogTraceHelper logTraceHelper) {
        Iterator iterator = map.keySet().iterator();
        HashSet<WWPNCollection> hashSet = new HashSet<WWPNCollection>();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            MaskingInfo maskingInfo = (MaskingInfo)map.get(n);
            WWPNCollection wWPNCollection = new WWPNCollection();
            wWPNCollection.setID(maskingInfo.getCollectionId());
            wWPNCollection.setName(maskingInfo.getCollectionName());
            if (!DiskReportingOperationsBase.checkFilterCollection(hashMap, wWPNCollection, logTraceHelper)) {
                logTraceHelper.traceInfo("COLLECTIONIDnot used");
                continue;
            }
            hashSet.add(wWPNCollection);
        }
        return hashSet.toArray(new WWPNCollection[0]);
    }

    private static boolean checkFilterCollection(HashMap hashMap, WWPNCollection wWPNCollection, LogTraceHelper logTraceHelper) {
        String string = (String)hashMap.get("COLLECTIONID");
        boolean bl = false;
        if (string != null && wWPNCollection != null && wWPNCollection.getID().equalsIgnoreCase(string)) {
            logTraceHelper.traceInfo("COLLECTIONID found");
            bl = true;
        }
        if (string == null) {
            bl = true;
        }
        return bl;
    }

    private static void addVolumeMapping(HashMap hashMap, DataPath dataPath, String string, DBConnection dBConnection, LogTraceHelper logTraceHelper, Map map) throws SQLException, ServerException {
        String string2 = DiskReportingOperationsBase.getStorageVolumeID(dataPath.getVolumeId(), dBConnection, logTraceHelper, string);
        SingleMapping singleMapping = (SingleMapping)hashMap.get(string2);
        String string3 = DiskReportingOperationsBase.getHostWWPN(map, dataPath.getTargetPortId(), dBConnection, logTraceHelper);
        if (singleMapping != null) {
            String[] stringArray = singleMapping.getSubsystemPorts();
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray2.length - 1] = string3;
            singleMapping.setSubsystemPorts(stringArray2);
        } else {
            singleMapping = new SingleMapping();
            singleMapping.setLUNID(Integer.toHexString(dataPath.getDeviceLunId()));
            String[] stringArray = new String[]{string3};
            singleMapping.setSubsystemPorts(stringArray);
        }
        if (string2 != null && string2.length() > 0) {
            hashMap.put(string2, singleMapping);
        }
    }

    private static String getStorageVolumeID(int n, DBConnection dBConnection, LogTraceHelper logTraceHelper, String string) throws ServerException, SQLException {
        Class<?> clazz;
        Class<?> clazz2;
        Hashtable<ColumnInfo, Object> hashtable = new Hashtable<ColumnInfo, Object>(1);
        String string2 = "";
        try {
            clazz2 = Class.forName("org.eclipse.aperi.infrastructure.database.objects.StorageVolume");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz2, (String)"SVID", (LogTraceHelper)logTraceHelper);
        hashtable.put(columnInfo, new Integer(n).toString());
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.StorageVolume");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"SUBSYSTEM_ID", (LogTraceHelper)logTraceHelper);
        hashtable.put(columnInfo, (Integer)DiskReportingOperationsBase.getSubsystem_ID(string, dBConnection, logTraceHelper));
        StorageVolume.StorageVolumeCursor storageVolumeCursor = StorageVolume.getCursor((DBConnection)dBConnection, hashtable, null);
        while (storageVolumeCursor.next()) {
            try {
                StorageVolume storageVolume = storageVolumeCursor.getAttributes();
                string2 = (String)ExternalKeyConverter.getStorageVolumeKey((StorageVolume)storageVolume, (String)string, (LogTraceHelper)logTraceHelper);
            }
            catch (IDParseException iDParseException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)iDParseException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        storageVolumeCursor.close();
        return string2;
    }

    private static Hashtable addIPID(Hashtable hashtable, Integer n, LogTraceHelper logTraceHelper) throws ServerException {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.DataPath");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"INITIATOR_PORT_ID", (LogTraceHelper)logTraceHelper);
        hashtable.put(columnInfo, n.toString());
        return hashtable;
    }

    public static HostType[] getHostTypes(String string, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        Class<?> clazz;
        logTraceHelper = DiskReportingOperationsBase.checkBaseParameter("getHostTypes", logTraceHelper, dBConnection);
        LinkedList<HostType> linkedList = new LinkedList<HostType>();
        ParameterChecker.assertMandatoryParameter((int)1, (String)"subsystemID", (Object)string, (LogTraceHelper)logTraceHelper);
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>(1);
        Object object = DiskReportingOperationsBase.getSubsystem_ID(string, dBConnection, logTraceHelper);
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.ClientSettingData");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"SUBSYSTEM_ID", (LogTraceHelper)logTraceHelper);
        hashtable.put(columnInfo, object.toString());
        ClientSettingData.ClientSettingDataCursor clientSettingDataCursor = ClientSettingData.getCursor((DBConnection)dBConnection, hashtable, null);
        while (clientSettingDataCursor.next()) {
            ClientSettingData clientSettingData = clientSettingDataCursor.getAttributes();
            HostType hostType = new HostType();
            String string2 = clientSettingData.getClientTypes();
            if (string2.indexOf("[") != -1) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            hostType.setClientTypes(ParameterHelper.convertTointArray((String)string2));
            String string3 = clientSettingData.getClientTypeDescriptions();
            if (string3 != null) {
                if (string3.indexOf("[") != -1) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                hostType.setClientDescriptions(ParameterHelper.convertToStringArray((String)string3));
            }
            hostType.setElementName(clientSettingData.getElementName());
            linkedList.add(hostType);
        }
        clientSettingDataCursor.close();
        dBConnection.commit();
        return linkedList.toArray(new HostType[0]);
    }

    public static long[] getSupportedVolumeSizeRange(String string, int n, int n2, int n3, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        logTraceHelper = DiskReportingOperationsBase.checkBaseParameter("getSupportedVolumeSizeRange", logTraceHelper, dBConnection);
        ParameterChecker.assertMandatoryParameter((int)1, (String)"StoragePoolID", (Object)string, (LogTraceHelper)logTraceHelper);
        long[] lArray = null;
        StorageSubsystem storageSubsystem = null;
        StoragePool storagePool = null;
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = null;
        try {
            ExternalKeyConverter.frameKeyStorageSubsystemFromPool((String)string, (LogTraceHelper)logTraceHelper);
        }
        catch (IDParseException iDParseException) {
            throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)string, (LogTraceHelper)logTraceHelper);
        }
        IStorageConfigurationPlugin iStorageConfigurationPlugin = StorageConfigurationPluginFactory.getPlugin(new ConfigurationParameter(storageSubsystem, cIMObjectPath));
        lArray = iStorageConfigurationPlugin.getSupportedVolumeSizeRange(storagePool, cIMObjectPath2, n, n2, n3);
        return lArray;
    }

    private static LogTraceHelper checkBaseParameter(String string, LogTraceHelper logTraceHelper, DBConnection dBConnection) {
        LogTraceHelper logTraceHelper2 = logTraceHelper;
        if (logTraceHelper == null) {
            logTraceHelper2 = new LogTraceHelperDummy((Object)"DiskReportingOperationsBase", string);
        }
        if (dBConnection == null) {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"DBConnection", (Object)dBConnection, (LogTraceHelper)logTraceHelper2);
        }
        if (logTraceHelper != null) {
            return logTraceHelper;
        }
        return logTraceHelper2;
    }
}

