/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.aperi.discovery.ProbePerfTracker;
import org.eclipse.aperi.discovery.TrackProbePerformance;
import org.eclipse.aperi.discovery.interfaces.DiscoveryException;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;

public class MappingMaskingProcessor
extends DiskCIMProcessor
implements CIMNames,
DiscoveryConstants {
    PersistMaskingInfoHelper cMaskingInfoToPersist;
    PersistDataPathHelper cDataPathToPersist;
    Map cSHWIDList = new HashMap();
    protected Map cAuthPrivileges = new HashMap();

    public MappingMaskingProcessor(String string) {
        super(string);
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"MappingMaskingProcessor", null);
        this.cMaskingInfoToPersist = new PersistMaskingInfoHelper(this.cSHWIDList, this.cAuthPrivileges);
        this.cDataPathToPersist = new PersistDataPathHelper();
        logTraceHelper.exit(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleAssociation(JobInfo jobInfo, String string, String string2, Hashtable hashtable, String string3, Hashtable hashtable2, Hashtable hashtable3) throws DiscoveryException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"handleAssociation", (Object[])new Object[]{jobInfo.getResourceId(), string, string3});
        ProbePerfTracker.ProbeAction probeAction = TrackProbePerformance.startProbeAction((String)this.getScanID(jobInfo), (int)ProbePerfTracker.DISKCIMPROCESSOR_HANDLE_ASSOCIATION);
        if (logTraceHelper.isTraceHighEnabled()) {
            logTraceHelper.traceHigh("Properties to persist: " + DiskMessageHelper.toMsgString((Object)hashtable2));
        }
        try {
            if (!string.equals("CIM_ComponentCS")) {
                if (string.equals("CIM_SystemDevice")) {
                    this.cMaskingInfoToPersist.addProtocolController(hashtable2, jobInfo, this, logTraceHelper);
                    this.cDataPathToPersist.addProtocolController(hashtable2);
                } else if (string.equals("CIM_AuthorizedTarget")) {
                    this.cMaskingInfoToPersist.addAuthorizedPrivilege(hashtable2);
                    this.cMaskingInfoToPersist.clearCurrentSHWIDCollection();
                    this.cMaskingInfoToPersist.clearCurrentSHWID();
                } else if (string.equals("CIM_AuthorizedSubject")) {
                    if (hashtable2.get("originalcimclassname").equals("CIM_StorageHardwareID")) {
                        this.cMaskingInfoToPersist.clearCurrentSHWIDCollection();
                        this.cMaskingInfoToPersist.addSHWID(hashtable2, logTraceHelper);
                    } else {
                        this.cMaskingInfoToPersist.clearCurrentSHWID();
                        this.cMaskingInfoToPersist.addSystemSpecificCollection(hashtable2);
                    }
                } else if (string.equals("CIM_ElementSettingData")) {
                    this.cMaskingInfoToPersist.addClientSettingData(jobInfo, this, hashtable2, logTraceHelper);
                } else if (string.equals("CIM_MemberOfCollection")) {
                    if (hashtable2.get("originalcimclassname").equals("CIM_SystemSpecificCollection")) {
                        this.cMaskingInfoToPersist.addSystemSpecificCollection(hashtable2);
                    } else {
                        this.cMaskingInfoToPersist.addSHWID(hashtable2, logTraceHelper);
                    }
                } else if (string.equals("CIM_ProtocolControllerForPort")) {
                    this.cDataPathToPersist.addTargetFCPort(hashtable2, logTraceHelper);
                    this.cMaskingInfoToPersist.persist(jobInfo, (Processor)this, logTraceHelper);
                    this.cDataPathToPersist.addMaskingInfo(this.cMaskingInfoToPersist.getSHWIDSet());
                } else if (string.equals("CIM_ProtocolControllerForUnit")) {
                    this.cDataPathToPersist.addStorageVolume(hashtable2, logTraceHelper);
                    this.cDataPathToPersist.persist(jobInfo, (Processor)this);
                } else if (string.equals("CIM_HostedService")) {
                    this.cMaskingInfoToPersist.persist(jobInfo, (Processor)this, logTraceHelper);
                    this.cMaskingInfoToPersist.clear();
                    this.cMaskingInfoToPersist.clearCurrentSHWIDCollection();
                } else if (string.equals("CIM_ConcreteDependency")) {
                    this.cMaskingInfoToPersist.addSHWID(hashtable2, logTraceHelper);
                } else {
                    logTraceHelper.traceWarning("Can not handle result of association " + string);
                }
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            TrackProbePerformance.finishedProbeAction((ProbePerfTracker.ProbeAction)probeAction);
            logTraceHelper.exit(null);
            throw throwable;
        }
        TrackProbePerformance.finishedProbeAction((ProbePerfTracker.ProbeAction)probeAction);
        logTraceHelper.exit(null);
    }

    public void setDBReferences(Hashtable hashtable) {
        super.setDBReferences(hashtable);
        Enumeration enumeration = hashtable.elements();
        Hashtable hashtable2 = new Hashtable();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable3 = (Hashtable)enumeration.nextElement();
            hashtable2.putAll(hashtable3);
        }
        this.cMaskingInfoToPersist.addStorageSubsystem(hashtable2);
    }

    public void addVolumeToDataPathForSVC(String string, String string2) throws DiscoveryException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"addVolumeToDataPathForSVC", (Object[])new Object[]{string, string2});
        this.cDataPathToPersist.addStorageVolume(string, string2, logTraceHelper);
        this.cDataPathToPersist.persist(null, (Processor)this);
        logTraceHelper.exit(null);
    }

    public void addProtocolControllerToDatapathAndMaskingInfoForSVC(JobInfo jobInfo, Hashtable hashtable) throws DiscoveryException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"addProtocolControllerToDatapathAndMaskingInfoForSVC", (Object[])new Object[]{jobInfo, hashtable});
        this.cMaskingInfoToPersist.addProtocolController(hashtable, jobInfo, this, logTraceHelper);
        this.cDataPathToPersist.addProtocolController(hashtable);
        logTraceHelper.exit(null);
    }

    private class SHWIDHelper {
        private static final short FCPORT_NAMEFORMAT = 1;
        private String cMaskingInfoID = "";
        private String cHostID = "";
        private String cHostCaption = "";
        private String cHostElementName = "";
        private String cHostPortID = "";
        private String cClientSettingDataID = null;
        private Map cCollectionList = new HashMap();

        public SHWIDHelper(Map map, LogTraceHelper logTraceHelper) throws DiscoveryException {
            this.cHostID = (String)map.get("instanceid");
            if (this.cHostID == null) {
                this.cHostID = "";
            }
            this.cHostCaption = (String)map.get("caption");
            if (this.cHostCaption == null) {
                this.cHostCaption = "";
            }
            this.cHostElementName = (String)map.get("elementname");
            if (this.cHostElementName == null) {
                this.cHostElementName = "";
            }
            int n = Integer.MIN_VALUE;
            String string = (String)map.get("StorageID".toLowerCase());
            Port port = new Port();
            port.setName(string);
            port.setNameFormat((short)1);
            try {
                boolean bl = port.retrieve(MappingMaskingProcessor.this.getConnection());
                if (bl) {
                    n = port.getPortId();
                }
                port = new Port();
                port.setName(string);
                port.setNameFormat((short)1);
                if (!bl) {
                    logTraceHelper.traceInfo("InitiatorPort " + string + "+" + 1 + " not found in DB, creating with HOST_URL_BY_SUBSYSTEM " + this.cHostElementName);
                    String cfr_ignored_0 = (String)map.get("IDType".toLowerCase());
                    port.setType((short)0);
                    port.setDetectable((short)1);
                    port.setHostUrlBySubsystem(this.cHostElementName);
                    port.setDisplayName(string);
                    port.setPortId(AutoIdentifier.getIdentifier((int)1, (int)1));
                    port.setUpdateTimestamp(CurrentTime.getTimestamp((DBConnection)MappingMaskingProcessor.this.getConnection()));
                    bl = port.insert(MappingMaskingProcessor.this.getConnection());
                    n = port.getPortId();
                    MappingMaskingProcessor.this.commit(logTraceHelper);
                } else {
                    port.setHostUrlBySubsystem(this.cHostElementName);
                    port.update(MappingMaskingProcessor.this.getConnection());
                    MappingMaskingProcessor.this.commit(logTraceHelper);
                }
            }
            catch (SQLException sQLException) {
                MappingMaskingProcessor.this.rollback(logTraceHelper);
                logTraceHelper.traceError("Creation of initiatorPort " + string + "+" + 1 + " failed", (Throwable)sQLException);
            }
            this.cHostPortID = String.valueOf(n);
        }

        public void addClientSettingData(JobInfo jobInfo, DiskCIMProcessor diskCIMProcessor, Hashtable hashtable, LogTraceHelper logTraceHelper) throws DiscoveryException {
            String string = (String)hashtable.get("originalcimclassname");
            try {
                diskCIMProcessor.handleEntity(jobInfo, string, hashtable);
            }
            catch (Exception exception) {
                logTraceHelper.traceError(exception.getMessage(), (Throwable)exception);
            }
            Map map = (Map)diskCIMProcessor.getDBReferences().get(string);
            if (map != null) {
                this.cClientSettingDataID = (String)map.get("ref_setting_data_id");
            }
        }

        public void addSystemSpecificCollection(Map map) {
            if (map != null) {
                this.cCollectionList.put((String)map.get("instanceid"), (String)map.get("elementname"));
            }
        }

        public Map getCollectionList() {
            return this.cCollectionList;
        }

        public String getHostCaption() {
            return this.cHostCaption;
        }

        public String getHostElementName() {
            return this.cHostElementName;
        }

        public String getHostID() {
            return this.cHostID;
        }

        public String getHostPortID() {
            return this.cHostPortID;
        }

        public String getMaskingInfoID() {
            return this.cMaskingInfoID;
        }

        public void setMaskingInfoID(String string) {
            this.cMaskingInfoID = string;
        }

        public String getClientSettingDataID() {
            return this.cClientSettingDataID;
        }
    }

    private class PersistMaskingInfoHelper {
        private static final String MASKING_INFO_DBMAPPER = "MaskingInfo";
        private boolean cPeristed = true;
        private String cSubsystemID = "";
        private SHWIDHelper cCurrentSHWID;
        private Map cSystemSpecifcCollection = null;
        private Map cAllSHWIDs;
        private Map cAllAuthPrivileges;
        String cCurrentAuthPrivilegeID;
        private Set cSHWIDSet = new HashSet();
        private String cControllerCOP = "";

        public PersistMaskingInfoHelper(Map map, Map map2) {
            this.cAllSHWIDs = map;
            this.cAllAuthPrivileges = map2;
        }

        public void clear() {
            this.cPeristed = false;
            this.cControllerCOP = null;
            this.cCurrentAuthPrivilegeID = null;
            this.cSHWIDSet.clear();
        }

        public void clearCurrentSHWID() {
            this.cCurrentSHWID = null;
        }

        public void clearCurrentSHWIDCollection() {
            this.cSystemSpecifcCollection = null;
        }

        public void addAuthorizedPrivilege(Map map) {
            String string = (String)map.get("instanceid");
            if (this.cAllAuthPrivileges.containsKey(string)) {
                Set set = (Set)this.cAllAuthPrivileges.get(string);
                this.cSHWIDSet.addAll(set);
            } else {
                this.cAllAuthPrivileges.put(string, new HashSet());
            }
            this.cCurrentAuthPrivilegeID = string;
        }

        public void addStorageSubsystem(Map map) {
            this.cSubsystemID = (String)map.get("ref_toplevelsystem_id");
            if (this.cSubsystemID == null) {
                this.cSubsystemID = "";
            }
        }

        public void addSHWID(Map map, LogTraceHelper logTraceHelper) throws DiscoveryException {
            if (map.get("storageid") != null) {
                Object object;
                String string = (String)map.get("instanceid");
                if (!this.cAllSHWIDs.containsKey(string)) {
                    object = new SHWIDHelper(map, logTraceHelper);
                    this.cAllSHWIDs.put(string, object);
                    this.cCurrentSHWID = object;
                } else {
                    this.cCurrentSHWID = (SHWIDHelper)this.cAllSHWIDs.get(string);
                }
                if (this.cSystemSpecifcCollection != null) {
                    this.cCurrentSHWID.addSystemSpecificCollection(this.cSystemSpecifcCollection);
                }
                if (this.cCurrentAuthPrivilegeID != null) {
                    object = (Set)this.cAllAuthPrivileges.get(this.cCurrentAuthPrivilegeID);
                    object.add(this.cCurrentSHWID);
                    this.cSHWIDSet.add(this.cCurrentSHWID);
                }
            } else {
                logTraceHelper.traceWarning("CIM_StorageHardwareID Instance not persisted due missing storageid: " + DiskMessageHelper.toMsgString((Object)map));
            }
        }

        public void addClientSettingData(JobInfo jobInfo, DiskCIMProcessor diskCIMProcessor, Hashtable hashtable, LogTraceHelper logTraceHelper) throws DiscoveryException {
            this.cCurrentSHWID.addClientSettingData(jobInfo, diskCIMProcessor, hashtable, logTraceHelper);
        }

        public void addSystemSpecificCollection(Map map) {
            if (this.cCurrentSHWID == null) {
                this.cSystemSpecifcCollection = map;
            } else {
                this.cCurrentSHWID.addSystemSpecificCollection(map);
            }
        }

        public void addProtocolController(Map map, JobInfo jobInfo, DiskCIMProcessor diskCIMProcessor, LogTraceHelper logTraceHelper) throws DiscoveryException {
            this.persist(jobInfo, (Processor)diskCIMProcessor, logTraceHelper);
            this.clear();
            this.cControllerCOP = this.getCOPforController(map, MappingMaskingProcessor.this.getCIMNamespace());
            if (this.cControllerCOP == null) {
                this.cControllerCOP = "";
            }
        }

        public void persist(JobInfo jobInfo, Processor processor, LogTraceHelper logTraceHelper) throws DiscoveryException {
            if (!this.cPeristed) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("ref_toplevelsystem_id", this.cSubsystemID);
                hashtable.put("CONTOLLER_COP".toLowerCase(), this.cControllerCOP);
                Iterator iterator = this.cSHWIDSet.iterator();
                while (iterator.hasNext()) {
                    String string;
                    Object object;
                    SHWIDHelper sHWIDHelper = (SHWIDHelper)iterator.next();
                    hashtable.put("HOST_ID".toLowerCase(), sHWIDHelper.getHostID());
                    hashtable.put("HOST_ELEMENT_NAME".toLowerCase(), sHWIDHelper.getHostElementName());
                    hashtable.put("HOST_CAPTION".toLowerCase(), sHWIDHelper.getHostCaption());
                    if (sHWIDHelper.getClientSettingDataID() != null) {
                        hashtable.put("SETTING_DATA_ID".toLowerCase(), sHWIDHelper.getClientSettingDataID());
                    } else {
                        hashtable.remove("SETTING_DATA_ID".toLowerCase());
                    }
                    Map map = sHWIDHelper.getCollectionList();
                    if (map.isEmpty()) {
                        hashtable.remove("COLLECTION_ID".toLowerCase());
                        hashtable.remove("COLLECTION_NAME".toLowerCase());
                        processor.handleEntity(jobInfo, MASKING_INFO_DBMAPPER, hashtable);
                    } else {
                        object = map.keySet().iterator();
                        while (object.hasNext()) {
                            string = (String)object.next();
                            hashtable.put("COLLECTION_ID".toLowerCase(), string);
                            String string2 = (String)map.get(string);
                            if (string2 != null && string2.length() > 0) {
                                hashtable.put("COLLECTION_NAME".toLowerCase(), string2);
                            } else {
                                hashtable.remove("COLLECTION_NAME".toLowerCase());
                            }
                            processor.handleEntity(jobInfo, MASKING_INFO_DBMAPPER, hashtable);
                        }
                    }
                    object = (Map)MappingMaskingProcessor.this.getDBReferences().get(MASKING_INFO_DBMAPPER);
                    if (object != null) {
                        string = (String)object.get("ref_masking_info_id");
                        if (string != null) {
                            sHWIDHelper.setMaskingInfoID(string);
                            continue;
                        }
                        logTraceHelper.traceWarning("No ref_masking_info_id set for MaskingInfo!");
                        continue;
                    }
                    logTraceHelper.traceWarning("No DBRef Info found for MaskingInfo!");
                }
                this.cPeristed = true;
            }
        }

        private String getCOPforController(Map map, String string) {
            CIMObjectPath cIMObjectPath = new CIMObjectPath((String)map.get("creationclassname"), string);
            CIMProperty cIMProperty = new CIMProperty("DeviceID", new CIMValue(map.get("deviceid"), CIMDataType.getPredefinedType((int)8)));
            cIMObjectPath.addKey(cIMProperty);
            CIMProperty cIMProperty2 = new CIMProperty("CreationClassName", new CIMValue((Object)((String)map.get("creationclassname")), CIMDataType.getPredefinedType((int)8)));
            cIMObjectPath.addKey(cIMProperty2);
            CIMProperty cIMProperty3 = new CIMProperty("SystemCreationClassName", new CIMValue((Object)((String)map.get("systemcreationclassname")), CIMDataType.getPredefinedType((int)8)));
            cIMObjectPath.addKey(cIMProperty3);
            CIMProperty cIMProperty4 = new CIMProperty("SystemName", new CIMValue(map.get("systemname"), CIMDataType.getPredefinedType((int)8)));
            cIMObjectPath.addKey(cIMProperty4);
            return cIMObjectPath.toString();
        }

        public Set getSHWIDSet() {
            return this.cSHWIDSet;
        }
    }

    private class PersistDataPathHelper {
        private static final String DATA_PATH_DBMAPPER = "DataPath";
        private Set cInitiatorPorts = null;
        private String cVolumeID = "";
        private String cDeviceLUN = "";
        private String cNamespaceID = null;
        private Set cTargetPortIDs = new HashSet();

        public void addMaskingInfo(Set set) {
            this.cInitiatorPorts = set;
        }

        public void addProtocolController(Map map) {
            this.cTargetPortIDs.clear();
        }

        public void addTargetFCPort(Map map, LogTraceHelper logTraceHelper) throws DiscoveryException {
            int n = Short.MIN_VALUE;
            try {
                Hashtable hashtable = (Hashtable)map.get("Dependent".toLowerCase());
                if (this.cNamespaceID == null) {
                    this.cNamespaceID = MappingMaskingProcessor.this.getNamespaceID(MappingMaskingProcessor.this.getCIMServiceURL(), MappingMaskingProcessor.this.getCIMNamespace(), logTraceHelper);
                }
                if ((n = MappingMaskingProcessor.this.getPortID(hashtable, Integer.parseInt(this.cNamespaceID))) != Integer.MIN_VALUE) {
                    logTraceHelper.traceInfo("TargetPort " + n + " found in DB for CIM Device ID " + hashtable.get("DeviceID".toLowerCase()));
                    this.cTargetPortIDs.add("" + n);
                }
            }
            catch (SQLException sQLException) {
                try {
                    MappingMaskingProcessor.this.handleSQLException(logTraceHelper, sQLException, "MappingMaskingProcessor.addFCPort");
                }
                catch (SQLException sQLException2) {
                    logTraceHelper.traceError(sQLException.getMessage(), (Throwable)sQLException2);
                    throw new DiscoveryException((Throwable)sQLException2);
                }
            }
        }

        public void addStorageVolume(Map map, LogTraceHelper logTraceHelper) throws DiscoveryException {
            int n;
            String string = (String)map.get("DeviceNumber".toLowerCase());
            if (string != null) {
                n = Integer.parseInt(string, 16);
                this.cDeviceLUN = String.valueOf(n);
            } else {
                this.cDeviceLUN = null;
            }
            n = Integer.MIN_VALUE;
            try {
                Hashtable hashtable = (Hashtable)map.get("Dependent".toLowerCase());
                if (this.cNamespaceID == null) {
                    this.cNamespaceID = MappingMaskingProcessor.this.getNamespaceID(MappingMaskingProcessor.this.getCIMServiceURL(), MappingMaskingProcessor.this.getCIMNamespace(), logTraceHelper);
                }
                if ((n = MappingMaskingProcessor.this.getVolumeID(hashtable, Integer.parseInt(this.cNamespaceID))) != Integer.MIN_VALUE) {
                    logTraceHelper.traceInfo("Volume " + n + " found in DB for CIM Device ID " + hashtable.get("DeviceID".toLowerCase()));
                    this.cVolumeID = "" + n;
                } else {
                    logTraceHelper.traceWarning("Volume for CIM Device ID " + hashtable.get("DeviceID".toLowerCase()) + " NOT found in DB!");
                    this.cVolumeID = null;
                }
            }
            catch (SQLException sQLException) {
                try {
                    MappingMaskingProcessor.this.handleSQLException(logTraceHelper, sQLException, "MappingMaskingProcessor.addStorageVolume");
                }
                catch (SQLException sQLException2) {
                    logTraceHelper.traceError(sQLException.getMessage(), (Throwable)sQLException2);
                    throw new DiscoveryException((Throwable)sQLException2);
                }
            }
        }

        public void persist(JobInfo jobInfo, Processor processor) throws DiscoveryException {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (this.cDeviceLUN != null) {
                hashtable.put("DEVICE_LUN_ID".toLowerCase(), this.cDeviceLUN);
            }
            if (this.cVolumeID == null || this.cVolumeID.length() == 0) {
                return;
            }
            hashtable.put("VOLUME_ID".toLowerCase(), this.cVolumeID);
            if (this.cInitiatorPorts != null) {
                Iterator iterator = this.cInitiatorPorts.iterator();
                while (iterator.hasNext()) {
                    SHWIDHelper sHWIDHelper = (SHWIDHelper)iterator.next();
                    hashtable.put("ref_masking_info_id".toLowerCase(), sHWIDHelper.getMaskingInfoID());
                    hashtable.put("INITIATOR_PORT_ID".toLowerCase(), sHWIDHelper.getHostPortID());
                    hashtable.put("UNKNOWN_HOST_NAME".toLowerCase(), sHWIDHelper.getHostElementName());
                    Iterator iterator2 = this.cTargetPortIDs.iterator();
                    while (iterator2.hasNext()) {
                        hashtable.put("TARGET_PORT_ID".toLowerCase(), (String)iterator2.next());
                        processor.handleEntity(jobInfo, DATA_PATH_DBMAPPER, hashtable);
                    }
                }
            }
        }

        public void addStorageVolume(String string, String string2, LogTraceHelper logTraceHelper) throws DiscoveryException {
            this.cVolumeID = string;
            this.cDeviceLUN = string2;
        }
    }
}

