/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.interfaces.ParameterException;

public class ProbeCompleteSubsystem
extends DiscoverProcess
implements CIMNames,
DiscoveryConstants {
    public ProbeCompleteSubsystem(String string, boolean bl) {
        Class<?> clazz;
        Class<?> clazz2;
        String[] stringArray = new String[2];
        try {
            clazz2 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[0] = clazz2.getName();
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[1] = clazz.getName();
        super(string, bl, new String[]{"DEVICEID", "SUBSYSTEMID"}, stringArray);
    }

    public Result process(Request request, Map map) throws ParameterException {
        boolean bl = true;
        int n = 0;
        Result result = new Result();
        try {
            String[] stringArray = this.getDiscoverRouterService().perform("collectDataFromStorageSubsystem", map, new Integer(request.getId()).toString());
            if (stringArray == null) {
                bl = false;
                n = 1;
            } else {
                this.getDiscoverRouterService().waitTilComplete(stringArray);
                n = request.getReturnCode();
                if (n != 0 && n != -1000) {
                    bl = false;
                }
            }
            if (bl) {
                stringArray = this.getDiscoverRouterService().perform("collectSHWIDsFromStorageSubsystem", map, new Integer(request.getId()).toString());
                if (stringArray == null) {
                    bl = false;
                    n = 1;
                } else {
                    this.getDiscoverRouterService().waitTilComplete(stringArray);
                    request.getReturnCode();
                    if (n != 0 && n != -1000) {
                        bl = false;
                    }
                }
            }
        }
        catch (SRMRuntimeException sRMRuntimeException) {
            result.setRc(1);
            result.setSRMMessage(sRMRuntimeException.getSRMMessage());
        }
        catch (Exception exception) {
            result.setRc(1);
            result.setSRMMessage(new SRMMessage("HWN021503E", null));
        }
        return result;
    }

    public String getProcessInfoForJobLog(Map map) {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            String string = (String)ProbeCompleteSubsystem.getParameter((Map)map, (String)"SUBSYSTEMID", (String)clazz.getName());
            return "probeSubsystem+" + string;
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

