/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.SVCBackendControllerUpdatePostProcess;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.BackendController;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.interfaces.ParameterException;

public class SVCExtentUpdatePostProcess
extends SVCBackendControllerUpdatePostProcess {
    public SVCExtentUpdatePostProcess() {
        this("MDISK Update Post Processing");
    }

    protected SVCExtentUpdatePostProcess(String string) {
        super(string);
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"SVCExtentUpdatePostProcess", null);
        logTraceHelper.exit(null);
    }

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("SVCExtentUpdatePostProcess", null, "In Band Virtualization", "IBM", null, null)};
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result process(Request request, Map map) throws ParameterException {
        Result result;
        LogTraceHelper logTraceHelper;
        block13: {
            logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{request, map});
            result = new Result(1);
            DBConnection dBConnection = null;
            try {
                try {
                    Integer.parseInt((String)map.get("DEVICEID"));
                    String string = (String)map.get("SUBSYSTEMID");
                    dBConnection = ServiceUtils.getConnection();
                    StorageSubsystem storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)string, (DBConnection)dBConnection);
                    dBConnection.commit();
                    this.processMdisk(dBConnection, string, storageSubsystem);
                    dBConnection.commit();
                    result = new Result(0);
                }
                catch (Exception exception) {
                    if (dBConnection != null) {
                        try {
                            dBConnection.rollback();
                        }
                        catch (SQLException sQLException) {}
                    }
                    result = new Result(1);
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)exception.getMessage(), (Throwable)exception, (LogTraceHelper)logTraceHelper);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (dBConnection != null) {
                    try {
                        dBConnection.close();
                    }
                    catch (SQLException sQLException) {}
                }
                logTraceHelper.exit((Object)result);
                throw throwable;
            }
            {
                Object var8_11 = null;
                if (dBConnection == null) break block13;
            }
            try {}
            catch (SQLException sQLException) {}
            dBConnection.close();
        }
        logTraceHelper.exit((Object)result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processMdisk(DBConnection dBConnection, String string, StorageSubsystem storageSubsystem) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"processMdisk", (Object[])new Object[]{dBConnection, string, storageSubsystem});
        Result result = new Result(1);
        try {
            List list = this.getBackendController(storageSubsystem.getSubsystemId(), dBConnection);
            List list2 = this.getAllInitiatorPorts(storageSubsystem.getSubsystemId(), dBConnection, logTraceHelper);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BackendController backendController = (BackendController)iterator.next();
                logTraceHelper.traceInfo("BackendControllerID :" + backendController.getBackendControllerId());
                StorageSubsystem storageSubsystem2 = this.getStorageSubsystem(backendController.getReferencedSubsystemId(), dBConnection, logTraceHelper);
                if (storageSubsystem2 == null) continue;
                logTraceHelper.traceInfo("BackendController SubsystemID:" + storageSubsystem2.getSubsystemId());
                Vector vector = SVCExtentUpdatePostProcess.processArrayvalues(backendController.getPortWwns(), dBConnection, logTraceHelper);
                List list3 = this.getExtentEntries(backendController, dBConnection);
                Iterator iterator2 = list3.iterator();
                while (iterator2.hasNext()) {
                    StorageExtent storageExtent = (StorageExtent)iterator2.next();
                    logTraceHelper.traceInfo("StorageExtent : " + storageExtent.getStorageExtentId());
                    String string2 = storageExtent.getName();
                    if (string2 == null) continue;
                    String string3 = new String();
                    if (string2.startsWith("000000000000")) {
                        string3 = Integer.toString(Integer.parseInt(string2.substring(string2.length() - 4, string2.length()), 16));
                    } else {
                        if (!string2.startsWith("40")) continue;
                        string3 = String.valueOf(string2.substring(2, 4)) + string2.substring(6, 8);
                        string3 = Integer.toString(Integer.parseInt(string3, 16));
                    }
                    try {
                        this.UpdateMdisk_VolumeID(dBConnection, list2, vector, string3, Integer.toString(storageExtent.getStorageExtentId()));
                    }
                    catch (SQLException sQLException) {
                        logTraceHelper.traceAlways("Problem with MDISK update :" + storageSubsystem2.getSubsystemId() + "Initiator Port :" + list2.toString() + " Target Port :" + ((Object)vector).toString() + " LUNID :" + string3);
                    }
                }
            }
            result.setRc(0);
            Object var17_19 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            logTraceHelper.exit((Object)result);
            throw throwable;
        }
        logTraceHelper.exit((Object)result);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setMdisk(Integer n, Integer n2, DBConnection dBConnection) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"setMdisk", (Object[])new Object[]{dBConnection, n, n2});
        try {
            try {
                Class<?> clazz;
                ColumnInfo columnInfo = null;
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.StorageVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"SVID", (LogTraceHelper)logTraceHelper);
                hashtable.put(columnInfo, n.toString());
                StorageVolume.StorageVolumeCursor storageVolumeCursor = StorageVolume.getCursor((DBConnection)dBConnection, hashtable, null);
                while (true) {
                    block8: {
                        if (storageVolumeCursor.next()) break block8;
                        storageVolumeCursor.close();
                        break;
                    }
                    StorageVolume storageVolume = storageVolumeCursor.getObject();
                    storageVolume.setMdiskId(n2.intValue());
                    storageVolume.update(dBConnection);
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError(sQLException.getMessage(), (Throwable)sQLException);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        logTraceHelper.exit(null);
    }

    protected StorageSubsystem getStorageSubsystem(int n, DBConnection dBConnection, LogTraceHelper logTraceHelper) {
        StorageSubsystem storageSubsystem = null;
        try {
            try {
                Class<?> clazz;
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"SUBSYSTEM_ID", (LogTraceHelper)logTraceHelper);
                hashtable.put(columnInfo, Integer.toString(n));
                StorageSubsystem.StorageSubsystemCursor storageSubsystemCursor = StorageSubsystem.getCursor((DBConnection)dBConnection, hashtable, null);
                if (storageSubsystemCursor.next()) {
                    StorageSubsystem storageSubsystem2 = storageSubsystemCursor.getObject();
                    logTraceHelper.traceInfo("Found :" + storageSubsystem2.getSubsystemId());
                    storageSubsystem = storageSubsystem2;
                }
                storageSubsystemCursor.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", (Throwable)sQLException);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {}
        logTraceHelper.traceInfo("StorageSubsystem  :" + storageSubsystem + " found.");
        return storageSubsystem;
    }

    private List getAllInitiatorPorts(int n, DBConnection dBConnection, LogTraceHelper logTraceHelper) {
        Vector<String> vector = new Vector<String>();
        List list = this.getPortEntries(n, dBConnection);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            vector.add(Integer.toString(port.getPortId()));
        }
        logTraceHelper.traceInfo("getAllInitiatorPorts return :" + vector.toArray());
        return vector;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getExtentEntries(BackendController backendController, DBConnection dBConnection) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"getExtentEntries", (Object[])new Object[]{backendController, dBConnection});
        LinkedList<StorageExtent> linkedList = new LinkedList<StorageExtent>();
        try {
            try {
                Class<?> clazz;
                ColumnInfo columnInfo = null;
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.StorageExtent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"BACKEND_CONTROLLER_ID", (LogTraceHelper)logTraceHelper);
                hashtable.put(columnInfo, Integer.toString(backendController.getBackendControllerId()));
                StorageExtent.StorageExtentCursor storageExtentCursor = StorageExtent.getCursor((DBConnection)dBConnection, hashtable, null);
                while (true) {
                    block8: {
                        if (storageExtentCursor.next()) break block8;
                        storageExtentCursor.close();
                        dBConnection.commit();
                        break;
                    }
                    StorageExtent storageExtent = storageExtentCursor.getObject();
                    logTraceHelper.traceInfo("Found :" + storageExtent.getName());
                    linkedList.add(storageExtent);
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", (Throwable)sQLException);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            logTraceHelper.exit(linkedList);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        logTraceHelper.exit(linkedList);
        return linkedList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getBackendController(DBConnection dBConnection) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"getBackendController", (Object[])new Object[]{dBConnection});
        LinkedList<BackendController> linkedList = new LinkedList<BackendController>();
        try {
            try {
                Class<?> clazz;
                Hashtable hashtable = new Hashtable();
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.BackendController");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskReportingHelper.getColumnInfo(clazz, (String)"OWNING_SUBSYSTEM_ID", (LogTraceHelper)logTraceHelper);
                BackendController.BackendControllerCursor backendControllerCursor = BackendController.getCursor((DBConnection)dBConnection, hashtable, null);
                if (backendControllerCursor.next()) {
                    linkedList.add(backendControllerCursor.getObject());
                }
                backendControllerCursor.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", (Throwable)sQLException);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            logTraceHelper.exit(linkedList);
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        logTraceHelper.exit(linkedList);
        return linkedList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void UpdateMdisk_VolumeID(DBConnection dBConnection, List list, List list2, String string, String string2) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"getVolumeIDs", (Object[])new Object[]{dBConnection, list, list2, string});
        String string3 = list.toString().substring(1, list.toString().length() - 1);
        String string4 = list2.toString().substring(1, list2.toString().length() - 1);
        try {
            String string5 = "update " + StorageVolume.getTablename() + " set " + StorageVolume.getTablename() + "." + "MDISK_ID" + "=" + string2 + " WHERE " + StorageVolume.getTablename() + "." + "SVID" + " = ( SELECT DISTINCT " + "VOLUME_ID" + " from " + DataPath.getTablename() + " where (" + "DEVICE_LUN_ID" + " = " + string + " and " + "DEVICE_LUN_ID" + " >= " + "0" + " and " + "INITIATOR_PORT_ID" + " IN ( " + string3 + " ) and " + "TARGET_PORT_ID" + " IN ( " + string4 + " )))";
            logTraceHelper.traceHigh("Invoking query " + string5);
            int n = DiskCIMProcessor.updateComplexQueryDeadlockRetry((DBConnection)dBConnection, (String)string5, null);
            dBConnection.commit();
            logTraceHelper.traceHigh("MDSIK Query update result: " + n + " for " + string2);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        logTraceHelper.exit(null);
    }

    protected static Vector processArrayvalues(String string, DBConnection dBConnection, LogTraceHelper logTraceHelper) {
        Vector<String> vector = new Vector<String>();
        try {
            int n = string.indexOf("]");
            if (n == -1) {
                n = string.length();
            }
            string = string.substring(string.indexOf("[") + 1, n);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = SVCExtentUpdatePostProcess.getPortID(string2, dBConnection, logTraceHelper);
                vector.add(string3);
            }
            return vector;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPortID(String string, DBConnection dBConnection, LogTraceHelper logTraceHelper) {
        String string2 = "";
        try {
            try {
                Class<?> clazz;
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.Port");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"NAME", (LogTraceHelper)logTraceHelper);
                hashtable.put(columnInfo, string);
                Port.PortCursor portCursor = Port.getCursor((DBConnection)dBConnection, hashtable, null);
                if (portCursor.next()) {
                    Port port = portCursor.getObject();
                    logTraceHelper.traceInfo("Found :" + port.getName());
                    string2 = Integer.toString(port.getPortId());
                }
                portCursor.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", (Throwable)sQLException);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            logTraceHelper.traceInfo("Initiator Port :" + string + " with " + string2 + " found.");
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        logTraceHelper.traceInfo("Initiator Port :" + string + " with " + string2 + " found.");
        return string2;
    }
}

