/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.CIM.VolumeManagement;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DBHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.monitor.DiskMonitorHelper;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.objects.CreationClassName;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.SystemNames;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.client.CIMEnumeration;

public class SubProbeVolume {
    ConfigurationParameter cParams;
    private static final String PROCESSID_PREFIX = "C";
    private VolumeManagement cVolumeManagement = null;

    public SubProbeVolume(ConfigurationParameter configurationParameter, VolumeManagement volumeManagement) {
        this.cParams = configurationParameter;
        this.cVolumeManagement = volumeManagement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MapperResult persistVolumeOrPool(CIMInstance cIMInstance, String string, CIMObjectPath cIMObjectPath) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"persistVolumeOrPool", (Object[])new Object[]{cIMInstance, string, cIMObjectPath});
        MapperResult mapperResult = null;
        try {
            block25: {
                String string2 = null;
                string2 = cIMObjectPath != null ? "CIM_StorageVolume" : "CIM_StoragePool";
                DBConnection dBConnection = null;
                ChangeDetection changeDetection = null;
                Hashtable hashtable = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)cIMInstance);
                try {
                    block24: {
                        try {
                            IDBAttributeMapper iDBAttributeMapper;
                            dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                            dBConnection.setAutoCommit(false);
                            StorageSubsystem storageSubsystem = this.cParams.getStorageSubsystem();
                            StoragePool storagePool = null;
                            if (string != null) {
                                storagePool = ExternalKeyManager.getStoragePool((String)string, (int)storageSubsystem.getSubsystemId(), (DBConnection)dBConnection);
                            }
                            dBConnection.commit();
                            DBHelper.putObjectIntoHashtable(hashtable, "ref_toplevelsystem_id", Integer.toString(storageSubsystem.getSubsystemId()));
                            DBHelper.putObjectIntoHashtable(hashtable, "ref_toplevelsystem_name", storageSubsystem.getName());
                            DBHelper.putObjectIntoHashtable(hashtable, "ref_toplevelsystem_nameformat", Integer.toString(storageSubsystem.getNameFormat()));
                            DBHelper.putObjectIntoHashtable(hashtable, "ref_namespace", this.cParams.getStorageSubsystemCIMOP().getNameSpace());
                            DBHelper.putObjectIntoHashtable(hashtable, "ref_serviceurl", this.cParams.getCimom().getServiceUrl());
                            if (storagePool != null) {
                                DBHelper.putObjectIntoHashtable(hashtable, "ref_storagepool_id", Integer.toString(storagePool.getPoolId()));
                                DBHelper.putObjectIntoHashtable(hashtable, "ref_classname", storagePool.getClassName());
                            }
                            if ((iDBAttributeMapper = MapperRouter.getMapperRouter().findMapper(cIMInstance.getClassName(), this.cParams.getCapability().getSmisVersion(), storageSubsystem.getModel(), this.cParams.getCimom().getSoftwareLevel(), null, string2)) == null) {
                                logTraceHelper.traceHigh("Could not retrieve mapper");
                                break block24;
                            }
                            int n = 0;
                            int n2 = DiskManagerConfigSvc.getIntConfigValue((String)"Probe.Deadlock.MaxRetries", (int)2);
                            int n3 = DiskManagerConfigSvc.getIntConfigValue((String)"Probe.Deadlock.MaxRetryInterval", (int)5000);
                            while (n < n2) {
                                try {
                                    changeDetection = new ChangeDetection(dBConnection);
                                    mapperResult = iDBAttributeMapper.persist(dBConnection, hashtable, null);
                                    HashMap hashMap = new HashMap();
                                    DiskMonitorHelper.addEntriesToInternalList(hashMap, MapperResult.convertRowsToIdentifiers((Map)mapperResult.getInsertedRows()));
                                    DiskMonitorHelper.addEntriesToInternalList(hashMap, MapperResult.convertRowsToIdentifiers((Map)mapperResult.getUpdatedRows()));
                                    dBConnection.commit();
                                    changeDetection.complete(dBConnection, hashMap, PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString());
                                    dBConnection.commit();
                                    if (storagePool != null) {
                                        this.cVolumeManagement.indicateModifiedEntity(TResStoragePoolTable.getTablename(), String.valueOf(storagePool.getPoolId()));
                                    }
                                    break;
                                }
                                catch (SQLException sQLException) {
                                    if (!SQLExceptionHelper.isDeadlock((DBConnection)dBConnection, (SQLException)sQLException)) throw sQLException;
                                    Random random = new Random();
                                    logTraceHelper.traceWarning("Deadlock during retry (" + n + "/" + n2 + ")");
                                    ++n;
                                    try {
                                        long l = (long)random.nextInt(n3) * (long)n;
                                        logTraceHelper.traceHigh("Waiting for " + l + "msecs before retrying deadlocked operations");
                                        Thread.sleep(l);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                        }
                        catch (Exception exception) {
                            try {
                                if (dBConnection != null) {
                                    dBConnection.rollback();
                                }
                                Object var11_14 = null;
                            }
                            catch (Throwable throwable) {
                                Object var11_13 = null;
                                changeDetection.cancel();
                                throw throwable;
                            }
                            changeDetection.cancel();
                            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)exception, (LogTraceHelper)logTraceHelper);
                        }
                    }
                    Object var20_26 = null;
                    if (dBConnection == null) break block25;
                }
                catch (Throwable throwable) {
                    Object var20_25 = null;
                    if (dBConnection == null) throw throwable;
                    try {
                        dBConnection.close();
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
                    }
                }
                try {}
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
                }
                dBConnection.close();
            }
            Object var23_31 = null;
        }
        catch (Throwable throwable) {
            Object var23_30 = null;
            logTraceHelper.exit(mapperResult);
            throw throwable;
        }
        logTraceHelper.exit(mapperResult);
        return mapperResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector retrieveAssociatedExtents(CIMObjectPath cIMObjectPath) throws ServerException {
        Vector<String> vector;
        Vector<String> vector2;
        LogTraceHelper logTraceHelper;
        block11: {
            Vector<String> vector3;
            block10: {
                logTraceHelper = LogTraceHelper.entry((Object)this, (String)"retrieveAssociatedExtents", (Object[])new Object[]{cIMObjectPath});
                vector2 = new Vector<String>();
                try {
                    try {
                        CIMEnumeration cIMEnumeration = (CIMEnumeration)this.cParams.getCIMClientWrapper().associatorNames(cIMObjectPath, "CIM_BasedOn", "CIM_StorageExtent", null, null, logTraceHelper);
                        if (!cIMEnumeration.hasMoreElements()) {
                            cIMEnumeration.close();
                            logTraceHelper.traceError("WARNING: No StorageExtents returned from CIMOM.", null);
                            logTraceHelper.traceError("If this message is generated when a volume with size 0 is created it can be ignored.", null);
                            vector3 = vector2;
                            Object var7_10 = null;
                            break block10;
                        }
                        while (true) {
                            if (!cIMEnumeration.hasMoreElements()) {
                                cIMEnumeration.close();
                                vector = vector2;
                                break block11;
                            }
                            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)cIMEnumeration.nextElement();
                            String string = this.getExtentIDFromCIMObjectPath(cIMObjectPath2);
                            vector2.add(string);
                        }
                    }
                    catch (CIMException cIMException) {
                        logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                        throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cParams.getCIMClientWrapper().toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
                    }
                    catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                        logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                        throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cParams.getCIMClientWrapper(), (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
                    }
                    catch (IOException iOException) {
                        logTraceHelper.traceError("Internal error: IOException", (Throwable)iOException);
                        throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)iOException, (LogTraceHelper)logTraceHelper);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_12 = null;
                    logTraceHelper.exit(vector2);
                    throw throwable;
                }
            }
            logTraceHelper.exit(vector2);
            return vector3;
        }
        Object var7_11 = null;
        logTraceHelper.exit(vector2);
        return vector;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getExtentIDFromCIMObjectPath(CIMObjectPath cIMObjectPath) {
        LogTraceHelper logTraceHelper;
        String string;
        block13: {
            string = null;
            DBConnection dBConnection = ServiceUtils.getConnection();
            logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getExtentIDFromCIMObjectPath", (Object[])new Object[]{cIMObjectPath});
            try {
                try {
                    String string2 = (String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)cIMObjectPath, (String)"CreationClassName");
                    String string3 = (String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)cIMObjectPath, (String)"DeviceID");
                    String string4 = (String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)cIMObjectPath, (String)"SystemCreationClassName");
                    String string5 = (String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)cIMObjectPath, (String)"SystemName");
                    String string6 = dBConnection.getSchema();
                    String string7 = "select ID from " + string6 + "." + CreationClassName.getTablename() + " where " + "NAME" + " like '" + string2 + "'";
                    String string8 = "select ID from " + string6 + "." + CreationClassName.getTablename() + " where " + "NAME" + " like '" + string4 + "'";
                    String string9 = "select SYSTEM_NAMES_ID from " + string6 + "." + SystemNames.getTablename() + " where " + "SYSTEM_NAME" + " like '" + string5 + "'";
                    String string10 = "select STORAGE_EXTENT_ID from " + string6 + "." + StorageExtent.getTablename() + " where " + "CREATION_CLASS_NAME_ID" + " in (" + string7 + ") and " + "SYSTEM_CREATION_CLASS_NAME_ID" + " in (" + string8 + ") and " + "SYSTEM_NAMES_ID" + " in (" + string9 + ") and " + "DEVICE_ID" + " like '" + string3 + "'";
                    logTraceHelper.traceInfo("Sending DB2 complex query for ExtentCOP to ExtentID: " + string10);
                    DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string10, null);
                    while (true) {
                        block14: {
                            if (dBResultSet.next()) break block14;
                            dBResultSet.close();
                            dBConnection.commit();
                            break;
                        }
                        string = dBResultSet.getString(1);
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        dBConnection.rollback();
                        throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
                    }
                    catch (SQLException sQLException2) {}
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
                }
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                if (dBConnection != null) {
                    try {
                        dBConnection.close();
                    }
                    catch (SQLException sQLException) {
                        throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
                    }
                }
                logTraceHelper.exit(string);
                throw throwable;
            }
            {
                Object var15_18 = null;
                if (dBConnection == null) break block13;
            }
            try {}
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            dBConnection.close();
        }
        logTraceHelper.exit((Object)string);
        return string;
    }
}

