/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection.step;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.IProgressLogger;
import org.eclipse.aperi.discovery.NullProgressLogger;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.step.PersistInstanceStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class COPCacheStep
extends PersistInstanceStep
implements IStep,
CIMNames {
    protected Map cCOPCache;
    protected boolean cPersistInstance;
    protected boolean cCacheReadOnly = false;
    protected IProgressLogger cProgressLogger = NullProgressLogger.NULL_LOGGER;

    public COPCacheStep(String string, DiskCIMProcessor diskCIMProcessor, boolean bl) {
        super(string, diskCIMProcessor);
        this.cCOPCache = new HashMap();
        this.cPersistInstance = bl;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"COPCacheStep", (Object[])new Object[]{string, diskCIMProcessor, new Boolean(bl)});
        logTraceHelper.exit(null);
    }

    public COPCacheStep(COPCacheStep cOPCacheStep) {
        super(cOPCacheStep.cInstanceName, cOPCacheStep.cDiskCIMProcessor);
        this.cCOPCache = cOPCacheStep.cCOPCache;
        this.cPersistInstance = cOPCacheStep.cPersistInstance;
        this.cProgressLogger = cOPCacheStep.cProgressLogger;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"COPCacheStep", (Object[])new Object[]{cOPCacheStep});
        logTraceHelper.exit(null);
    }

    public COPCacheStep(COPCacheStep cOPCacheStep, boolean bl) {
        super(cOPCacheStep.cInstanceName, cOPCacheStep.cDiskCIMProcessor);
        this.cCOPCache = cOPCacheStep.cCOPCache;
        this.cPersistInstance = bl;
        this.cProgressLogger = cOPCacheStep.cProgressLogger;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"COPCacheStep", (Object[])new Object[]{cOPCacheStep, new Boolean(bl)});
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(String string, Map map) throws Exception {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{string});
        this.cProgressLogger.entry();
        Result result = new Result(0);
        CIMInstance cIMInstance = (CIMInstance)map.get(this.cInstanceName);
        CIMObjectPath cIMObjectPath = cIMInstance.getObjectPath();
        boolean bl = true;
        try {
            Hashtable hashtable = (Hashtable)this.cCOPCache.get(cIMObjectPath);
            if (hashtable != null) {
                this.handleCacheHit(string, cIMInstance, hashtable, map, logTraceHelper);
            } else {
                if (this.cPersistInstance) {
                    logTraceHelper.traceInfo("persist " + this.cInstanceName + " with COP " + cIMObjectPath.toString());
                    result = this.persistInstance(cIMInstance, this.cInstanceName, map, logTraceHelper);
                }
                if (result.getRc() == 0) {
                    boolean bl2;
                    if (!this.cCacheReadOnly) {
                        Hashtable hashtable2 = (Hashtable)this.cDiskCIMProcessor.getDBReferences().get(this.cInstanceName);
                        if (hashtable2 == null) {
                            hashtable2 = new Hashtable();
                        }
                        this.cCOPCache.put(cIMObjectPath, hashtable2);
                        this.cProgressLogger.elementDiscovered();
                    }
                    result.setRc((bl2 = this.processNext(string, map)) ? 0 : 1);
                }
            }
            boolean bl3 = bl = result.getRc() == 0;
            if (bl) {
                this.cProgressLogger.complete();
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.cProgressLogger.exit();
            logTraceHelper.exit((Object)result);
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        this.cProgressLogger.exit();
        logTraceHelper.exit((Object)result);
        return bl;
    }

    protected boolean handleCacheHit(String string, CIMInstance cIMInstance, Hashtable hashtable, Map map, LogTraceHelper logTraceHelper) throws Exception {
        logTraceHelper.traceInfo("Cache hit for " + this.cInstanceName + " with COP " + cIMInstance.getObjectPath().toString());
        this.cDiskCIMProcessor.getDBReferences().put(this.cInstanceName, hashtable);
        return true;
    }

    public void setCacheReadOnly(boolean bl) {
        this.cCacheReadOnly = bl;
    }

    public void setProgressLogger(IProgressLogger iProgressLogger) {
        this.cProgressLogger = iProgressLogger != null ? iProgressLogger : NullProgressLogger.NULL_LOGGER;
    }
}

