/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common;

import java.util.ArrayList;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.control.util.HardwareIDCollection;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;

public abstract class ExceptionHelper {
    public static ServerException generateHardwareIDsHaveNoMappingsException(Object object, String string, LogTraceHelper logTraceHelper) {
        ServerException serverException;
        if (object instanceof StorageHardwareID) {
            serverException = DiskMessageHelper.getServerException((String)"HWN021614E", (Object)((StorageHardwareID)object).getWWPN(), (Object)string, (LogTraceHelper)logTraceHelper);
            logTraceHelper.traceError("No Privileges returned for the StorageHardwareID, it has no mappings.", (Throwable)serverException);
        } else {
            ArrayList arrayList = ((HardwareIDCollection)object).getStorageHardwareIDs();
            String[] stringArray = new String[arrayList.size()];
            int n = 0;
            while (n < arrayList.size()) {
                stringArray[n] = ((StorageHardwareID)arrayList.get(n)).getWWPN();
                ++n;
            }
            serverException = DiskMessageHelper.getServerException((String)"HWN021614E", (Object)stringArray, (Object)string, (LogTraceHelper)logTraceHelper);
            logTraceHelper.traceError("No Privileges returned for the StorageHardwareCollection, it has no mappings.", (Throwable)serverException);
        }
        return serverException;
    }
}

