/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.discovery.interfaces.DiscoveryException;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.DiskActivator;
import org.eclipse.aperi.disk.api.ExtendedVolumeAssignments;
import org.eclipse.aperi.disk.api.VolumeAssignments;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.ISAssignedGenericUpdatePostProcess;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DBHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.monitor.DiskMonitorHelper;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.MaskingInfo;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;
import org.eclipse.aperi.infrastructure.database.tables.TResMaskingInfoTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class DBHelperCreateAndUpdate
extends DBHelper {
    private static final short FCPORT_NAMEFORMAT = 1;
    private static final String PROCESSID_PREFIX = "C";
    private static IEventMonitorService eventMonitor = null;

    public DBHelperCreateAndUpdate(Token token) {
        super(token);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createMappings(AsyncResult asyncResult, AssignmentParameter assignmentParameter) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createMappings", (Object[])new Object[]{asyncResult, assignmentParameter});
        try {
            this.updateMappings(asyncResult, assignmentParameter, true);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateMappings(AsyncResult asyncResult, AssignmentParameter assignmentParameter, boolean bl) {
        LogTraceHelper logTraceHelper;
        block13: {
            logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createMappings", (Object[])new Object[]{asyncResult, assignmentParameter, new Boolean(bl)});
            DiskCIMProcessor diskCIMProcessor = new DiskCIMProcessor(null);
            try {
                try {
                    diskCIMProcessor.setSMISVersion(assignmentParameter.getCapability().getSmisVersion());
                    diskCIMProcessor.setDeviceModel(assignmentParameter.getStorageSubsystem().getModel());
                    diskCIMProcessor.setInstrumentationVersion(assignmentParameter.getCimom().getSoftwareLevel());
                    diskCIMProcessor.setCIMNamespace(assignmentParameter.getCIMClientWrapper().getNameSpace().getNameSpace());
                    diskCIMProcessor.setCIMServiceURL(assignmentParameter.getCimom().getServiceUrl());
                    CIMOMManager.getCIMOMManager().registerCIMOMUsage(assignmentParameter.getCimom().getServiceUrl());
                    JobInfo jobInfo = new JobInfo();
                    jobInfo.setResourceId(assignmentParameter.getCimom().getServiceUrl());
                    ArrayList arrayList = ResultHelper.getSuccessfulSubResults((AsyncResult)asyncResult);
                    ArrayList<CIMObjectPath> arrayList2 = new ArrayList<CIMObjectPath>();
                    int n = 0;
                    while (true) {
                        if (n >= arrayList.size()) {
                            this.updateEntity(arrayList2, "CIM_StorageVolume", assignmentParameter, diskCIMProcessor, jobInfo);
                            ISAssignedGenericUpdatePostProcess.setIS_ASSIGNED(Integer.toString(assignmentParameter.getStorageSubsystem().getSubsystemId()), this.cDBConnection);
                        }
                        VolumeAssignments volumeAssignments = (VolumeAssignments)arrayList.get(n);
                        arrayList2.add(assignmentParameter.getVolumeCOPForID(volumeAssignments.getStorageVolumeID()));
                        String string = volumeAssignments.getStorageID();
                        Port port = null;
                        try {
                            port = ExternalKeyManager.getPort((String)string, (int)assignmentParameter.getStorageSubsystem().getSubsystemId(), (DBConnection)this.cDBConnection);
                        }
                        catch (EntityNotFoundException entityNotFoundException) {
                            if (!bl) {
                                ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)entityNotFoundException, (LogTraceHelper)logTraceHelper);
                                logTraceHelper.traceError("Port " + string + "was not found in the database.", (Throwable)serverException);
                                throw serverException;
                            }
                            port = this.createPort(string);
                        }
                        Integer n2 = new Integer(port.getPortId());
                        int n3 = assignmentParameter.getIDOfVolume(volumeAssignments.getStorageVolumeID());
                        if (bl) {
                            this.createDataPathAndMaskingInfo(assignmentParameter, diskCIMProcessor, jobInfo, volumeAssignments, n2, n3);
                        } else {
                            this.deleteDataPath(n2, n3);
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    logTraceHelper.traceError("Internal error: Exception", (Throwable)exception);
                    DiskMessageHelper.getServerException((String)"HWN021693W", null, (Throwable)exception, (LogTraceHelper)logTraceHelper);
                    this.rollback();
                    asyncResult.setReturnException((Exception)((Object)DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)exception, (LogTraceHelper)logTraceHelper)));
                }
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                if (diskCIMProcessor != null) {
                    diskCIMProcessor.shutdown();
                    diskCIMProcessor = null;
                }
                logTraceHelper.exit(null);
                throw throwable;
            }
            {
                Object var15_20 = null;
                if (diskCIMProcessor == null) break block13;
            }
            diskCIMProcessor.shutdown();
            diskCIMProcessor = null;
        }
        logTraceHelper.exit(null);
    }

    public Port createPort(String string) throws SQLException {
        Port port;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createPort", (Object[])new Object[]{string});
        Port port2 = new Port();
        try {
            port2.setName(string);
            port2.setNameFormat((short)1);
            logTraceHelper.traceInfo("Port " + string + " not found in DB, creating");
            port2.setType((short)0);
            port2.setPortId(AutoIdentifier.getIdentifier((int)1, (int)1));
            port2.setUpdateTimestamp(CurrentTime.getTimestamp((DBConnection)this.cDBConnection));
            boolean bl = port2.insert(this.cDBConnection);
            if (!bl) {
                ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021503E", null, (LogTraceHelper)logTraceHelper);
                logTraceHelper.traceError("Failed to create port for WWPN " + string, (Throwable)serverException);
                throw serverException;
            }
            this.indicateCreatedEntity(TResPortTable.getTablename(), new Integer(port2.getPortId()).toString());
            this.indicateModifiedEntity(TResPortTable.getTablename(), new Integer(port2.getPortId()).toString());
            ChangeDetection changeDetection = new ChangeDetection(this.cDBConnection);
            HashMap hashMap = new HashMap();
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(String.valueOf(port2.getPortId()));
            hashMap.put(TResPortTable.getTablename(), linkedList);
            this.commit();
            changeDetection.complete(this.cDBConnection, hashMap, PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString());
            port = port2;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            logTraceHelper.exit((Object)port2);
            throw throwable;
        }
        logTraceHelper.exit((Object)port2);
        return port;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createDataPathAndMaskingInfo(AssignmentParameter assignmentParameter, DiskCIMProcessor diskCIMProcessor, JobInfo jobInfo, VolumeAssignments volumeAssignments, Integer n, int n2) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createDataPathAndMaskingInfo", (Object[])new Object[]{assignmentParameter, diskCIMProcessor, jobInfo, n, new Integer(n2)});
        try {
            try {
                ChangeDetection changeDetection = new ChangeDetection(this.cDBConnection);
                Request request = Router.getRouter().getRequest(jobInfo.getDiscoverRequest());
                String string = null;
                if (request != null) {
                    string = request.getScannerId();
                }
                ExtendedVolumeAssignments extendedVolumeAssignments = (ExtendedVolumeAssignments)volumeAssignments;
                Hashtable hashtable = new Hashtable();
                DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, "ref_toplevelsystem_id", new Integer(assignmentParameter.getStorageSubsystem().getSubsystemId()));
                DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, "SUBSYSTEM_ID", new Integer(assignmentParameter.getStorageSubsystem().getSubsystemId()).toString());
                DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, "CONTOLLER_COP", extendedVolumeAssignments.getProtocolControllerCOP());
                if (extendedVolumeAssignments.getCollection() != null) {
                    DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, "COLLECTION_NAME", extendedVolumeAssignments.getCollection().getName());
                    DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, "COLLECTION_ID", extendedVolumeAssignments.getCollection().getID());
                }
                DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, "HOST_ID", extendedVolumeAssignments.getId());
                DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, "HOST_ELEMENT_NAME", extendedVolumeAssignments.getName());
                DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, "HOST_CAPTION", extendedVolumeAssignments.getCaption());
                MapperResult mapperResult = diskCIMProcessor.handleEntity(string, "MaskingInfo", hashtable);
                HashMap hashMap = new HashMap();
                DiskMonitorHelper.addEntriesToInternalList(hashMap, MapperResult.convertRowsToIdentifiers((Map)mapperResult.getInsertedRows()));
                DiskMonitorHelper.addEntriesToInternalList(hashMap, MapperResult.convertRowsToIdentifiers((Map)mapperResult.getUpdatedRows()));
                MaskingInfo maskingInfo = this.getMaskingInfo(extendedVolumeAssignments.getId(), assignmentParameter.getStorageSubsystem().getSubsystemId());
                this.indicateModifiedEntity(TResMaskingInfoTable.getTablename(), String.valueOf(maskingInfo.getMaskingInfoId()));
                String[] stringArray = extendedVolumeAssignments.getSubsystemPorts();
                int n3 = 0;
                while (true) {
                    block10: {
                        if (n3 < stringArray.length) break block10;
                        this.commit();
                        changeDetection.complete(this.cDBConnection, hashMap, PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString());
                        break;
                    }
                    Port port = ExternalKeyManager.getPort((String)stringArray[n3], (int)assignmentParameter.getStorageSubsystem().getSubsystemId(), (DBConnection)this.cDBConnection);
                    hashtable = new Hashtable();
                    DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, "INITIATOR_PORT_ID", n);
                    DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, "TARGET_PORT_ID", new Integer(port.getPortId()));
                    String string2 = extendedVolumeAssignments.getVolumeDeviceNumber();
                    if (string2 != null && string2.toLowerCase().startsWith("0x")) {
                        string2 = string2.substring(2);
                    }
                    if (string2 != null && string2 != "") {
                        DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, "DEVICE_LUN_ID", new Integer(Integer.parseInt(string2, 16)));
                        DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, "HOST_LUN_ID", new Integer(Integer.parseInt(string2, 16)));
                    }
                    DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, "VOLUME_ID", new Integer(n2));
                    DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, "MASKING_INFO_ID", new Integer(maskingInfo.getMaskingInfoId()));
                    mapperResult = diskCIMProcessor.handleEntity(string, "DataPath", hashtable);
                    this.indicateModifiedEntity(TResDataPathTable.getTablename(), (String)mapperResult.getInsertedRows().get("MASKING_INFO_ID"));
                    DiskMonitorHelper.addEntriesToInternalList(hashMap, MapperResult.convertRowsToIdentifiers((Map)mapperResult.getInsertedRows()));
                    DiskMonitorHelper.addEntriesToInternalList(hashMap, MapperResult.convertRowsToIdentifiers((Map)mapperResult.getUpdatedRows()));
                    ++n3;
                }
            }
            catch (Exception exception) {
                logTraceHelper.traceError("Internal Error: Exception", (Throwable)exception);
                this.rollback();
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)exception, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var20_23 = null;
        }
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateEntity(ArrayList arrayList, String string, ConfigurationParameter configurationParameter, DiskCIMProcessor diskCIMProcessor, JobInfo jobInfo) throws DiskManagerTimeoutException, DiscoveryException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"updateEntity", (Object[])new Object[]{arrayList, configurationParameter, diskCIMProcessor, jobInfo});
        try {
            ChangeDetection changeDetection = new ChangeDetection(this.cDBConnection);
            HashMap hashMap = new HashMap();
            int n = 0;
            while (true) {
                block5: {
                    if (n < arrayList.size()) break block5;
                    this.commit();
                    changeDetection.complete(this.cDBConnection, hashMap, PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString());
                    break;
                }
                CIMObjectPath cIMObjectPath = (CIMObjectPath)arrayList.get(n);
                CIMInstance cIMInstance = configurationParameter.getCIMClientWrapper().getInstance(cIMObjectPath, false, true, logTraceHelper);
                Hashtable hashtable = CIMInstanceHelper.changeCIMInstanceToHashtable((CIMInstance)cIMInstance);
                hashtable.put("originalcimclassname", string);
                Request request = Router.getRouter().getRequest(jobInfo.getDiscoverRequest());
                String string2 = null;
                if (request != null) {
                    string2 = request.getScannerId();
                }
                DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, "ref_toplevelsystem_id", new Integer(configurationParameter.getStorageSubsystem().getSubsystemId()));
                MapperResult mapperResult = diskCIMProcessor.handleEntity(string2, cIMObjectPath.getObjectName(), hashtable);
                DiskMonitorHelper.addEntriesToInternalList(hashMap, MapperResult.convertRowsToIdentifiers((Map)mapperResult.getInsertedRows()));
                DiskMonitorHelper.addEntriesToInternalList(hashMap, MapperResult.convertRowsToIdentifiers((Map)mapperResult.getUpdatedRows()));
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var16_18 = null;
        }
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteMappings(AsyncResult asyncResult, AssignmentParameter assignmentParameter) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"deleteMappings", (Object[])new Object[]{asyncResult});
        try {
            this.updateMappings(asyncResult, assignmentParameter, false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteDataPath(Integer n, int n2) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"deleteDataPath", (Object[])new Object[]{n, new Integer(n2)});
        try {
            ColumnInfo columnInfo;
            Hashtable hashtable = new Hashtable();
            if (n != null) {
                columnInfo = DataPath.getColumnInfo((String)"INITIATOR_PORT_ID");
                DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, columnInfo, n);
            }
            this.indicateRemovedEntity(DataPath.getTablename(), String.valueOf(n2));
            columnInfo = DataPath.getColumnInfo((String)"VOLUME_ID");
            DBHelperCreateAndUpdate.putObjectIntoHashtable(hashtable, columnInfo, Integer.toString(n2));
            DataPath.deletes((DBConnection)this.cDBConnection, hashtable);
            this.commit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        logTraceHelper.exit(null);
    }

    /*
     * Exception decompiling
     */
    protected void rollback() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 70->74)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static IEventMonitorService getEventMonitorProxy() {
        if (eventMonitor == null) {
            eventMonitor = (IEventMonitorService)DiskActivator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        }
        return eventMonitor;
    }

    protected void indicateCreatedEntity(String string, String string2) {
        DBHelperCreateAndUpdate.getEventMonitorProxy().handleNewDevice(this.cToken.getJobId(), string, string2);
        DBHelperCreateAndUpdate.getEventMonitorProxy().handleDeviceStateChange(this.cToken.getJobId(), string, string2, 0, 1);
        DBHelperCreateAndUpdate.getEventMonitorProxy().handleModelUpdate(this.cToken.getJobId());
    }

    protected void indicateRemovedEntity(String string, String string2) {
        DBHelperCreateAndUpdate.getEventMonitorProxy().handleDeviceStateChange(this.cToken.getJobId(), string, string2, 1, 0);
        DBHelperCreateAndUpdate.getEventMonitorProxy().handleModelUpdate(this.cToken.getJobId());
    }

    protected void indicateModifiedEntity(String string, String string2) {
        DBHelperCreateAndUpdate.getEventMonitorProxy().handleModelUpdate(this.cToken.getJobId());
    }
}

