/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control;

import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.HardwareIDMangement;
import org.eclipse.aperi.disk.common.CIM.MappingManagement;
import org.eclipse.aperi.disk.common.CIM.MappingManagementMultiplePort;
import org.eclipse.aperi.disk.common.CIM.PrivilegeManagement;
import org.eclipse.aperi.disk.common.CIM.VolumeManagement;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.PrivilegeToWWPNs;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class StorageConfigurationPluginMultiplePort
extends StorageConfigurationPlugin {
    public MappingManagement getMappingManagement() {
        if (this.cMappingManagement == null) {
            this.cMappingManagement = new MappingManagementMultiplePort(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getCapability(), this.cParams.getStorageSubsystemID(), this.cParams.getToken());
        }
        return this.cMappingManagement;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void validateAssignAccess(AssignStorageVolumesParameter assignStorageVolumesParameter) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)assignStorageVolumesParameter.getToken(), (Object)this, (String)"validateAssignAccess", (Object[])new Object[]{assignStorageVolumesParameter});
        try {
            super.validateAssignAccess(assignStorageVolumesParameter);
            try {
                DBConnection dBConnection = ServiceUtils.getConnection();
                try {
                    List list = this.retrieveInvolvedProtocolControllers(assignStorageVolumesParameter, false);
                    List list2 = this.retrieveAffectedVolumes(assignStorageVolumesParameter, list);
                    List list3 = this.extractUnique(Arrays.asList(assignStorageVolumesParameter.getVolumeCOPs()), list2, new Comparator(){

                        public int compare(Object object, Object object2) {
                            return ((CIMObjectPath)object).equals(object2) ? 0 : 1;
                        }
                    });
                    List list4 = this.retrieveAffectedInitiatorPortWWPNs(assignStorageVolumesParameter, list);
                    List list5 = this.extractUnique(assignStorageVolumesParameter.getInitiatorWWPNs(), list4, new Comparator(){

                        public int compare(Object object, Object object2) {
                            return ((String)object).compareTo((String)object2);
                        }
                    });
                    List list6 = this.getPortsFromWWPNs(dBConnection, assignStorageVolumesParameter, list5);
                    if (list3.size() > 0 || list6.size() > 0) {
                        ArrayList arrayList = new ArrayList(assignStorageVolumesParameter.getInitiatorPortList());
                        arrayList.addAll(list6);
                        assignStorageVolumesParameter.setInitiatorPorts(arrayList);
                        ArrayList arrayList2 = new ArrayList(assignStorageVolumesParameter.getInitiatorWWPNs());
                        arrayList2.addAll(list5);
                        assignStorageVolumesParameter.setInitiatorWWPNs(arrayList2);
                        ArrayList arrayList3 = new ArrayList(Arrays.asList(assignStorageVolumesParameter.getVolumeCOPs()));
                        arrayList3.addAll(list3);
                        assignStorageVolumesParameter.setVolumeCOPs(arrayList3.toArray(new CIMObjectPath[arrayList3.size()]));
                        List list7 = this.getVolumes(dBConnection, assignStorageVolumesParameter, list3);
                        ArrayList arrayList4 = new ArrayList(Arrays.asList(assignStorageVolumesParameter.getVolumes()));
                        arrayList4.addAll(list7);
                        assignStorageVolumesParameter.setVolumes(arrayList4.toArray(new StorageVolume[arrayList4.size()]));
                        List list8 = this.getVolumeIds(list7);
                        ArrayList arrayList5 = new ArrayList(Arrays.asList(assignStorageVolumesParameter.getVolumeIDs()));
                        arrayList5.addAll(list8);
                        assignStorageVolumesParameter.setVolumeIDs(arrayList5.toArray(new String[arrayList5.size()]));
                        List list9 = this.getVolumeNames(list7);
                        ArrayList arrayList6 = new ArrayList(Arrays.asList(assignStorageVolumesParameter.getVolumeNames()));
                        arrayList6.addAll(list9);
                        assignStorageVolumesParameter.setVolumeNames(arrayList6.toArray(new String[arrayList6.size()]));
                        if (!assignStorageVolumesParameter.isForce()) throw DiskMessageHelper.getServerException((String)"HWN021606E", (Object)list5, (Object)list9, (LogTraceHelper)logTraceHelper);
                        SRMMessage sRMMessage = DiskMessageHelper.getSRMMessage((String)"HWN021605I", null, null, (LogTraceHelper)logTraceHelper);
                        AsyncResult asyncResult = assignStorageVolumesParameter.getAsyncResult();
                        asyncResult.setSRMMessage(sRMMessage);
                        assignStorageVolumesParameter.setAsyncResult(asyncResult);
                    }
                }
                catch (Throwable throwable) {
                    Object var21_24 = null;
                    if (dBConnection == null) throw throwable;
                    dBConnection.close();
                    throw throwable;
                }
                {
                    Object var21_25 = null;
                    if (dBConnection != null) {
                        dBConnection.close();
                    }
                }
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)diskManagerTimeoutException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var23_27 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var23_28 = null;
        }
        logTraceHelper.exit(null);
    }

    private List getVolumeNames(List list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            StorageVolume storageVolume = (StorageVolume)iterator.next();
            arrayList.add(storageVolume.getName());
        }
        return arrayList;
    }

    private List getVolumeIds(List list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            StorageVolume storageVolume = (StorageVolume)iterator.next();
            arrayList.add(String.valueOf(storageVolume.getName()) + "+" + storageVolume.getNameFormat() + "+" + this.getParams().getStorageSubsystemID());
        }
        return arrayList;
    }

    private List getVolumes(DBConnection dBConnection, AssignmentParameter assignmentParameter, List list) throws SQLException, CIMException, DiskManagerTimeoutException {
        ArrayList<StorageVolume> arrayList = new ArrayList<StorageVolume>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CIMObjectPath cIMObjectPath = (CIMObjectPath)iterator.next();
            CIMInstance cIMInstance = assignmentParameter.getCIMClientWrapper().getInstance(cIMObjectPath, false);
            StorageVolume storageVolume = new StorageVolume();
            storageVolume.setName((String)cIMObjectPath.getKey("DeviceID").getValue().getValue());
            storageVolume.setNameFormat(((Number)cIMInstance.getProperty("NameFormat").getValue().getValue()).shortValue());
            storageVolume.setSubsystemId(assignmentParameter.getStorageSubsystem().getSubsystemId());
            if (!storageVolume.retrieve(dBConnection)) continue;
            arrayList.add(storageVolume);
        }
        return arrayList;
    }

    private List getPortsFromWWPNs(DBConnection dBConnection, AssignmentParameter assignmentParameter, List list) {
        LinkedList<Port> linkedList = new LinkedList<Port>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                Port port = ExternalKeyManager.getPort((String)((String)iterator.next()), (int)assignmentParameter.getStorageSubsystem().getSubsystemId(), (DBConnection)dBConnection);
                linkedList.add(port);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                linkedList.add(null);
            }
        }
        return linkedList;
    }

    private List retrieveAffectedVolumes(AssignmentParameter assignmentParameter, List list) {
        VolumeManagement volumeManagement = this.getVolumeManagement();
        LinkedList linkedList = new LinkedList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList = volumeManagement.retrieveVolumesOfProtocolController((CIMObjectPath)iterator.next());
            linkedList.addAll(arrayList);
        }
        return linkedList;
    }

    private List retrieveAffectedInitiatorPortWWPNs(AssignmentParameter assignmentParameter, List list) {
        Object object;
        PrivilegeManagement privilegeManagement = this.getPrivilegeManagement();
        LinkedList linkedList = new LinkedList();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (CIMObjectPath)object2.next();
            linkedList.addAll(privilegeManagement.retrievePrivilegesForProtocolController((CIMObjectPath)object, new ArrayList()));
        }
        object2 = new LinkedList();
        object = linkedList.iterator();
        while (object.hasNext()) {
            PrivilegeToWWPNs privilegeToWWPNs = (PrivilegeToWWPNs)object.next();
            object2.addAll(privilegeToWWPNs.getWWPNs());
        }
        return object2;
    }

    private List retrieveInvolvedProtocolControllers(AssignmentParameter assignmentParameter, boolean bl) {
        Object object;
        ArrayList<CIMObjectPath> arrayList;
        ArrayList arrayList2 = new ArrayList();
        MappingManagement mappingManagement = this.getMappingManagement();
        AbstractList abstractList = new LinkedList();
        abstractList.addAll(mappingManagement.retrieveProtocolControllersForVolumes(assignmentParameter.getVolumeCOPs(), arrayList2));
        if (!bl) {
            arrayList = assignmentParameter.getInitiatorWWPNs();
            object = this.getHardwareIDManagement();
            ArrayList arrayList3 = ((HardwareIDMangement)object).retrieveStorageHardwareIDs(arrayList, false);
            ArrayList arrayList4 = new ArrayList();
            abstractList.addAll(mappingManagement.retrieveProtocolControllersForStorageHardwareIDs(arrayList3, arrayList4));
            ArrayList arrayList5 = new ArrayList();
            int n = 0;
            while (n < abstractList.size()) {
                CIMObjectPath cIMObjectPath = this.getMappingManagement().validateProtocolController(((ProtocolControllerToPrivileges)abstractList.get(n)).getProtocolController());
                if (cIMObjectPath != null) {
                    arrayList5.add(abstractList.get(n));
                }
                ++n;
            }
            abstractList = arrayList5;
        }
        arrayList = new ArrayList<CIMObjectPath>(abstractList.size());
        object = abstractList.iterator();
        while (object.hasNext()) {
            arrayList.add(((ProtocolControllerToPrivileges)object.next()).getProtocolController());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void validateUnAssignAccess(AssignmentParameter assignmentParameter) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)assignmentParameter.getToken(), (Object)this, (String)"validateUnAssignAccess", (Object[])new Object[]{assignmentParameter});
        try {
            super.validateUnAssignAccess(assignmentParameter);
            try {
                DBConnection dBConnection = ServiceUtils.getConnection();
                try {
                    List list = this.retrieveInvolvedProtocolControllers(assignmentParameter, true);
                    List list2 = new LinkedList();
                    List list3 = new LinkedList();
                    if (assignmentParameter.getMappingMode() != AssignmentParameter.MAP) {
                        list2 = this.retrieveAffectedVolumes(assignmentParameter, list);
                        list3 = this.extractUnique(Arrays.asList(assignmentParameter.getVolumeCOPs()), list2, new Comparator(){

                            public int compare(Object object, Object object2) {
                                return ((CIMObjectPath)object).equals(object2) ? 0 : 1;
                            }
                        });
                    }
                    List list4 = new LinkedList();
                    List list5 = new LinkedList();
                    List list6 = new LinkedList();
                    if (assignmentParameter.getMappingMode() != AssignmentParameter.MASK) {
                        list4 = this.retrieveAffectedInitiatorPortWWPNs(assignmentParameter, list);
                        list5 = this.extractUnique(assignmentParameter.getInitiatorWWPNs(), list4, new Comparator(){

                            public int compare(Object object, Object object2) {
                                return ((String)object).compareTo((String)object2);
                            }
                        });
                        list6 = this.getPortsFromWWPNs(dBConnection, assignmentParameter, list5);
                        if (list6.size() > 0) {
                            list2 = this.retrieveAffectedVolumes(assignmentParameter, list);
                            list3 = this.extractUnique(Arrays.asList(assignmentParameter.getVolumeCOPs()), list2, new Comparator(){

                                public int compare(Object object, Object object2) {
                                    return ((CIMObjectPath)object).equals(object2) ? 0 : 1;
                                }
                            });
                            if (list3.size() == 0) {
                                assignmentParameter.setMappingMode(AssignmentParameter.MASK);
                                list6 = new ArrayList();
                            } else {
                                list3 = new ArrayList();
                            }
                        }
                    }
                    if (list3.size() > 0 || list6.size() > 0) {
                        ArrayList arrayList = new ArrayList(assignmentParameter.getInitiatorPortList());
                        arrayList.addAll(list6);
                        assignmentParameter.setInitiatorPorts(arrayList);
                        ArrayList arrayList2 = new ArrayList(assignmentParameter.getInitiatorWWPNs());
                        arrayList2.addAll(list5);
                        assignmentParameter.setInitiatorWWPNs(arrayList2);
                        ArrayList arrayList3 = new ArrayList(Arrays.asList(assignmentParameter.getVolumeCOPs()));
                        arrayList3.addAll(list3);
                        assignmentParameter.setVolumeCOPs(arrayList3.toArray(new CIMObjectPath[arrayList3.size()]));
                        List list7 = this.getVolumes(dBConnection, assignmentParameter, list3);
                        ArrayList arrayList4 = new ArrayList(Arrays.asList(assignmentParameter.getVolumes()));
                        arrayList4.addAll(list7);
                        assignmentParameter.setVolumes(arrayList4.toArray(new StorageVolume[arrayList4.size()]));
                        List list8 = this.getVolumeIds(list7);
                        ArrayList arrayList5 = new ArrayList(Arrays.asList(assignmentParameter.getVolumeIDs()));
                        arrayList5.addAll(list8);
                        assignmentParameter.setVolumeIDs(arrayList5.toArray(new String[arrayList5.size()]));
                        List list9 = this.getVolumeNames(list7);
                        ArrayList arrayList6 = new ArrayList(Arrays.asList(assignmentParameter.getVolumeNames()));
                        arrayList6.addAll(list9);
                        assignmentParameter.setVolumeNames(arrayList6.toArray(new String[arrayList6.size()]));
                        if (!assignmentParameter.isForce()) throw DiskMessageHelper.getServerException((String)"HWN021604E", list4, list5, (Object)assignmentParameter.getVolumeIDsForCOPs(arrayList3.toArray(new CIMObjectPath[list2.size()])), (Object)list9, (LogTraceHelper)logTraceHelper);
                        SRMMessage sRMMessage = DiskMessageHelper.getSRMMessage((String)"HWN021603W", null, null, (LogTraceHelper)logTraceHelper);
                        AsyncResult asyncResult = assignmentParameter.getAsyncResult();
                        asyncResult.setSRMMessage(sRMMessage);
                        assignmentParameter.setAsyncResult(asyncResult);
                    }
                }
                catch (Throwable throwable) {
                    Object var21_24 = null;
                    if (dBConnection == null) throw throwable;
                    dBConnection.close();
                    throw throwable;
                }
                {
                    Object var21_25 = null;
                    if (dBConnection != null) {
                        dBConnection.close();
                    }
                }
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)diskManagerTimeoutException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var23_27 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var23_28 = null;
        }
        logTraceHelper.exit(null);
    }
}

