/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.aperi.disk.control.util.OutputHelper;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class HardwareIDCollection {
    private CIMObjectPath cHardwareIDCollectionCOP;
    private CIMInstance cHardwareIDCollectionInstance;
    private ArrayList cStorageHardwareIDs = new ArrayList();

    public HardwareIDCollection(CIMObjectPath cIMObjectPath) {
        this.cHardwareIDCollectionCOP = cIMObjectPath;
    }

    public CIMObjectPath getHardwareIDCollectionCOP() {
        return this.cHardwareIDCollectionCOP;
    }

    public void setHardwareIDCollectionCOP(CIMObjectPath cIMObjectPath) {
        this.cHardwareIDCollectionCOP = cIMObjectPath;
    }

    public ArrayList getStorageHardwareIDs() {
        return this.cStorageHardwareIDs;
    }

    public void addStorageHardwareID(StorageHardwareID storageHardwareID) {
        if (!this.cStorageHardwareIDs.contains(storageHardwareID)) {
            this.cStorageHardwareIDs.add(storageHardwareID);
        }
    }

    public void addStorageHardwareIDs(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            this.addStorageHardwareID((StorageHardwareID)arrayList.get(n));
            ++n;
        }
    }

    public void setStorageHardwareIDs(ArrayList arrayList) {
        this.cStorageHardwareIDs = arrayList;
    }

    public boolean containsStorageHardwareID(StorageHardwareID storageHardwareID) {
        return this.cStorageHardwareIDs.contains(storageHardwareID);
    }

    public boolean containsStorageHardwareID(String string) {
        int n = 0;
        while (n < this.cStorageHardwareIDs.size()) {
            if (((StorageHardwareID)this.cStorageHardwareIDs.get(n)).getWWPN().equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public ArrayList getWWPNs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.cStorageHardwareIDs.size()) {
            arrayList.add(((StorageHardwareID)this.cStorageHardwareIDs.get(n)).getWWPN());
            ++n;
        }
        return arrayList;
    }

    public CIMInstance getHardwareIDCollectionInstance() {
        return this.cHardwareIDCollectionInstance;
    }

    public void setHardwareIDCollectionInstance(CIMInstance cIMInstance) {
        this.cHardwareIDCollectionInstance = cIMInstance;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(OutputHelper.toStringHeader(this.getClass()));
        stringBuffer.append(this.prepareToString());
        stringBuffer.append(OutputHelper.toStringFooter(this.getClass()));
        return stringBuffer.toString();
    }

    String prepareToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Hardware ID Collection COP: ");
        if (this.cHardwareIDCollectionCOP != null) {
            stringBuffer.append(this.cHardwareIDCollectionCOP.toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append("; WWPNs: {");
        stringBuffer.append(OutputHelper.listToCS((List)this.getWWPNs()));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

