/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.aperi.disk.control.util.HardwareIDCollection;
import org.eclipse.aperi.disk.control.util.OutputHelper;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class PrivilegeToWWPNs {
    private CIMObjectPath cPrivilege;
    private ArrayList cHardwareIDCollections = new ArrayList();
    private ArrayList cStorageHardwareIDs = new ArrayList();

    public PrivilegeToWWPNs(CIMObjectPath cIMObjectPath) {
        this.cPrivilege = cIMObjectPath;
    }

    public PrivilegeToWWPNs(CIMObjectPath cIMObjectPath, StorageHardwareID[] storageHardwareIDArray) {
        this.cPrivilege = cIMObjectPath;
        int n = 0;
        while (n < storageHardwareIDArray.length) {
            this.cStorageHardwareIDs.add(storageHardwareIDArray[n]);
            ++n;
        }
    }

    public PrivilegeToWWPNs(CIMObjectPath cIMObjectPath, StorageHardwareID storageHardwareID) {
        this.cPrivilege = cIMObjectPath;
        this.cStorageHardwareIDs.add(storageHardwareID);
    }

    public PrivilegeToWWPNs(CIMObjectPath cIMObjectPath, HardwareIDCollection hardwareIDCollection) {
        this.cPrivilege = cIMObjectPath;
        this.cHardwareIDCollections.add(hardwareIDCollection);
    }

    public PrivilegeToWWPNs(CIMObjectPath cIMObjectPath, Object object) {
        this.cPrivilege = cIMObjectPath;
        if (object instanceof StorageHardwareID) {
            this.cStorageHardwareIDs.add(object);
            return;
        }
        if (object instanceof HardwareIDCollection) {
            this.cHardwareIDCollections.add(object);
            return;
        }
        throw new RuntimeException("Invalid Class, use StorageHardwareID or HardwareIDCollection");
    }

    public boolean equals(PrivilegeToWWPNs privilegeToWWPNs) {
        return privilegeToWWPNs.getPrivilege().equals((Object)this.cPrivilege);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PrivilegeToWWPNs)) {
            return false;
        }
        return ((PrivilegeToWWPNs)object).getPrivilege().equals((Object)this.cPrivilege);
    }

    public boolean containsStorageHardwareID(StorageHardwareID storageHardwareID) {
        return this.cStorageHardwareIDs.contains(storageHardwareID);
    }

    public boolean containsStorageHardwareIDInstance(CIMInstance cIMInstance) {
        int n = 0;
        while (n < this.cStorageHardwareIDs.size()) {
            StorageHardwareID storageHardwareID = (StorageHardwareID)this.cStorageHardwareIDs.get(n);
            if (storageHardwareID.getStorageHardwareIDInstance().equals((Object)cIMInstance)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public CIMObjectPath getPrivilege() {
        return this.cPrivilege;
    }

    public void setPrivilege(CIMObjectPath cIMObjectPath) {
        this.cPrivilege = cIMObjectPath;
    }

    public ArrayList getStorageHardwareIDs() {
        return this.cStorageHardwareIDs;
    }

    public void addStorageHardwareID(StorageHardwareID storageHardwareID) {
        if (!this.cStorageHardwareIDs.contains(storageHardwareID)) {
            this.cStorageHardwareIDs.add(storageHardwareID);
        }
    }

    public void addStorageHardwareIDs(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            this.cStorageHardwareIDs.add(arrayList.get(n));
            ++n;
        }
    }

    public void addStorageHardwareIDCollection(HardwareIDCollection hardwareIDCollection) {
        if (!this.cStorageHardwareIDs.contains(hardwareIDCollection)) {
            this.cStorageHardwareIDs.add(hardwareIDCollection);
        }
    }

    public void addInitiator(Object object) {
        if (object instanceof StorageHardwareID) {
            this.cStorageHardwareIDs.add(object);
            return;
        }
        if (object instanceof HardwareIDCollection) {
            this.cHardwareIDCollections.add(object);
            return;
        }
        throw new RuntimeException("Invalid Class, use StorageHardwareID or HardwareIDCollection");
    }

    public ArrayList getWWPNs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.cStorageHardwareIDs.size()) {
            arrayList.add(((StorageHardwareID)this.cStorageHardwareIDs.get(n)).getWWPN());
            ++n;
        }
        n = 0;
        while (n < this.cHardwareIDCollections.size()) {
            arrayList.addAll(((HardwareIDCollection)this.cHardwareIDCollections.get(n)).getWWPNs());
            ++n;
        }
        return arrayList;
    }

    public ArrayList getHardwareIDCollections() {
        return this.cHardwareIDCollections;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(OutputHelper.toStringHeader(this.getClass()));
        stringBuffer.append(this.prepareToString());
        stringBuffer.append(OutputHelper.toStringFooter(this.getClass()));
        return stringBuffer.toString();
    }

    public List getAllStorageHardwareIDs() {
        ArrayList<StorageHardwareID> arrayList = new ArrayList<StorageHardwareID>();
        int n = 0;
        while (n < this.cStorageHardwareIDs.size()) {
            arrayList.add((StorageHardwareID)this.cStorageHardwareIDs.get(n));
            ++n;
        }
        n = 0;
        while (n < this.cHardwareIDCollections.size()) {
            arrayList.addAll(((HardwareIDCollection)this.cHardwareIDCollections.get(n)).getStorageHardwareIDs());
            ++n;
        }
        return arrayList;
    }

    String prepareToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Privilege COP: ");
        if (this.cPrivilege != null) {
            stringBuffer.append(this.cPrivilege.toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append("; WWPNs: {");
        stringBuffer.append(OutputHelper.listToCS((List)this.getWWPNs()));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

