/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.aperi.disk.control.util.OutputHelper;
import org.eclipse.aperi.disk.control.util.PrivilegeToWWPNs;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.sblim.wbem.cim.CIMObjectPath;

public class ProtocolControllerToPrivileges {
    private CIMObjectPath cProtocolController;
    private ArrayList cPrivilegeToWWPNs = new ArrayList();
    private CIMObjectPath cIOGroupCOP;
    private Integer cIOGroupID;

    public ProtocolControllerToPrivileges(CIMObjectPath cIMObjectPath, ArrayList arrayList) {
        this.cProtocolController = cIMObjectPath;
        this.cPrivilegeToWWPNs = arrayList;
    }

    public ProtocolControllerToPrivileges(CIMObjectPath cIMObjectPath) {
        this.cProtocolController = cIMObjectPath;
    }

    public ProtocolControllerToPrivileges(CIMObjectPath cIMObjectPath, PrivilegeToWWPNs[] privilegeToWWPNsArray) {
        this.cProtocolController = cIMObjectPath;
        int n = 0;
        while (n < privilegeToWWPNsArray.length) {
            this.cPrivilegeToWWPNs.add(privilegeToWWPNsArray[n]);
            ++n;
        }
    }

    public ProtocolControllerToPrivileges(CIMObjectPath cIMObjectPath, PrivilegeToWWPNs privilegeToWWPNs) {
        this.cProtocolController = cIMObjectPath;
        this.cPrivilegeToWWPNs.add(privilegeToWWPNs);
    }

    public boolean equals(ProtocolControllerToPrivileges protocolControllerToPrivileges) {
        return protocolControllerToPrivileges.getProtocolController().equals((Object)this.cProtocolController);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProtocolControllerToPrivileges)) {
            return false;
        }
        return ((ProtocolControllerToPrivileges)object).getProtocolController().equals((Object)this.cProtocolController);
    }

    public boolean containsPrivilege(PrivilegeToWWPNs privilegeToWWPNs) {
        return this.cPrivilegeToWWPNs.contains(privilegeToWWPNs);
    }

    public ArrayList getPrivilegeToWWPNs() {
        return this.cPrivilegeToWWPNs;
    }

    public void setPrivilegeToWWPNs(ArrayList arrayList) {
        this.cPrivilegeToWWPNs = arrayList;
    }

    public CIMObjectPath getProtocolController() {
        return this.cProtocolController;
    }

    public void setProtocolController(CIMObjectPath cIMObjectPath) {
        this.cProtocolController = cIMObjectPath;
    }

    public void add(PrivilegeToWWPNs privilegeToWWPNs) {
        if (!this.cPrivilegeToWWPNs.contains(privilegeToWWPNs)) {
            this.cPrivilegeToWWPNs.add(privilegeToWWPNs);
        }
    }

    public ArrayList getWWPNs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.cPrivilegeToWWPNs.size()) {
            PrivilegeToWWPNs privilegeToWWPNs = (PrivilegeToWWPNs)this.cPrivilegeToWWPNs.get(n);
            ArrayList arrayList2 = privilegeToWWPNs.getWWPNs();
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                String string = (String)arrayList2.get(n2);
                if (!arrayList.contains(string)) {
                    arrayList.add(string);
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    public List getStorageHardwareIDs() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.cPrivilegeToWWPNs.size()) {
            PrivilegeToWWPNs privilegeToWWPNs = (PrivilegeToWWPNs)this.cPrivilegeToWWPNs.get(n);
            arrayList.addAll(privilegeToWWPNs.getAllStorageHardwareIDs());
            ++n;
        }
        return arrayList;
    }

    public CIMObjectPath getIOGroupCOP() {
        return this.cIOGroupCOP;
    }

    public void setIOGroup(CIMObjectPath cIMObjectPath) {
        this.cIOGroupCOP = cIMObjectPath;
        String string = (String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)cIMObjectPath, (String)"Name");
        string = string.substring(string.indexOf(":") + 1, string.length());
        this.cIOGroupID = new Integer(string);
    }

    public Integer getIOGroupID() {
        return this.cIOGroupID;
    }

    public void setIOGroupID(Integer n) {
        this.cIOGroupID = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(OutputHelper.toStringHeader(this.getClass()));
        stringBuffer.append(this.prepareToString());
        stringBuffer.append(OutputHelper.toStringFooter(this.getClass()));
        return stringBuffer.toString();
    }

    String prepareToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Protocol Controller: ");
        if (this.cProtocolController != null) {
            stringBuffer.append(this.cProtocolController.toString());
        } else {
            stringBuffer.append("null");
        }
        if (this.cIOGroupID != null) {
            stringBuffer.append("; I/O Group ID: ");
            stringBuffer.append(this.cIOGroupID.toString());
        }
        stringBuffer.append("; WWPNs: {");
        stringBuffer.append(OutputHelper.listToCS((List)this.getWWPNs()));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

