/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.util.Hashtable;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.SubprofileConstants;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelperDummy;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.UnsignedInt16;

public class Capabilities
implements DiscoveryConstants,
CIMNames,
SubprofileConstants {
    private String cSMISVersion = null;
    private String cSMISProfile = null;
    private String cSMISSubProfile = null;
    private boolean cVolumeCreationSupported = false;
    private boolean cVolumeDeletionSupported = false;
    private boolean cAssignAccessSuported = false;
    private boolean cRemoveAccessSupported = false;
    private boolean cExtendDataAvailable = false;
    private boolean cDriveDataAvailable = false;
    private boolean cRemoteServiceAccessPontDataAvailable = false;
    private boolean cVolumeExpansionSupported = false;
    private boolean cVolumeShrinkingSupported = false;
    private int cNumberOfVolumesSuporrted = 0;
    private String[] cRaidLevelSupported = null;
    private boolean cTargetPortRestrictionSupported = false;
    private int cPortsPerView = 0;
    private boolean cOneHardwareIDPerView = false;
    private boolean cProtocolControllerRequirersAuthorizedIdentity = false;
    private boolean cProtocolControllerSupportsCollection = false;
    private boolean cUniqueUnitNumberPerPort = false;
    private boolean cAttachDeviceSupported = false;
    private boolean cExposePathSupported = false;
    private boolean cSPCAllowsNoLUs = false;
    private boolean cSPCAllowsNoTargets = false;
    private boolean cSPCAllowsNoInitiators = false;
    private boolean cSPCSupportsDefaultViews = false;
    private boolean cClientSelectableDeviceNumbers = false;
    private int cMaxMapCount = 0;

    public Capabilities() {
        this.setSMISVersion("");
        this.setSMISSubProfile("");
        this.setSMISProfile("");
    }

    public Capabilities(CIMInstance cIMInstance, Request request) {
        this.insertCapabilities(cIMInstance, request);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkSubProfile(String string) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"checkSubProfile", (Object[])new Object[]{string});
        try {
            this.setSMISSubProfile(string);
            if (string != null) {
                String string2 = CIMInstanceHelper.convertSubProfile((String)string, (LogTraceHelper)logTraceHelper);
                if (string2.indexOf("LC") >= 0) {
                    this.setVolumeCreationSupported(true);
                    this.setVolumeDeletionSupported(true);
                } else {
                    this.setVolumeCreationSupported(false);
                    this.setVolumeDeletionSupported(false);
                }
                if (string2.indexOf("LMM") >= 0 || string2.indexOf("MM") >= 0) {
                    this.setAssignAccessSuported(true);
                    this.setRemoveAccessSupported(true);
                } else {
                    this.setAssignAccessSuported(false);
                    this.setRemoveAccessSupported(false);
                }
                if (string2.indexOf("EM") >= 0 || string2.indexOf("EC") >= 0) {
                    this.setExtendDataAvailable(true);
                } else {
                    this.setExtendDataAvailable(false);
                }
                if (string2.indexOf("DD") >= 0 || string2.indexOf("DDL") >= 0) {
                    this.setDriveDataAvailable(true);
                } else {
                    this.setDriveDataAvailable(false);
                }
                if (string2.indexOf("AP") >= 0) {
                    this.setRemoteServiceAccessPontDataAvailable(true);
                } else {
                    this.setRemoteServiceAccessPontDataAvailable(false);
                }
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        logTraceHelper.exit(null);
    }

    public void setSVC() {
        this.setVolumeExpansionSupported(true);
        this.setVolumeShrinkingSupported(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertCapabilities(CIMInstance cIMInstance, Request request) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)request, (Object)this, (String)"insertCapabilities", (Object[])new Object[]{cIMInstance.toString()});
        try {
            this.setNumberOfVolumesSuporrted(0);
            this.setVolumeExpansionSupported(false);
            this.setVolumeShrinkingSupported(false);
            this.setPortsPerView(((UnsignedInt16)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"PortsPerView")).intValue());
            if (this.getPortsPerView() == 2 || this.getPortsPerView() == 3) {
                this.setTargetPortRestrictionSupported(true);
            }
            this.handleOneHardwareIDPerView(cIMInstance, logTraceHelper);
            this.handleProtocollControllerRequiresAuthorizedIdentity(cIMInstance);
            this.handleControllerSupportsCollection(cIMInstance, logTraceHelper);
            this.handleUniqueUnitNumberPerPort(cIMInstance, logTraceHelper);
            this.handleAttachDeviceSupported(cIMInstance);
            this.handleExposePathSupported(cIMInstance);
            this.handleSPCAllowNoLUs(cIMInstance);
            this.handleSPCAllowsNoTargets(cIMInstance);
            this.handleSPCAllowsNoInitiators(cIMInstance);
            this.handleSPCSupportsDefaultView(cIMInstance);
            this.handleClientSelectableDeviceNumbers(cIMInstance);
            this.handleMaxMapCount(cIMInstance);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            logTraceHelper.exit((Object)"");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        logTraceHelper.exit((Object)"");
    }

    private void handleMaxMapCount(CIMInstance cIMInstance) {
        Object object = CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"MaximumMapCount");
        if (object != null) {
            this.setMaxMapCount(((UnsignedInt16)object).intValue());
        } else {
            this.setMaxMapCount(0);
        }
    }

    private void handleClientSelectableDeviceNumbers(CIMInstance cIMInstance) {
        Object object = CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"ClientSelectableDeviceNumbers");
        if (object == null) {
            this.setClientSelectableDeviceNumbers(false);
        } else {
            this.setClientSelectableDeviceNumbers((Boolean)object);
        }
    }

    private void handleSPCSupportsDefaultView(CIMInstance cIMInstance) {
        Object object = CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"SPCSupportsDefaultViews");
        if (object == null) {
            this.setSPCSupportsDefaultViews(false);
        } else {
            this.setSPCSupportsDefaultViews((Boolean)object);
        }
    }

    private void handleSPCAllowsNoInitiators(CIMInstance cIMInstance) {
        Object object = CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"SPCAllowsNoInitiators");
        if (object == null) {
            this.setSPCAllowsNoInitiators(false);
        } else {
            this.setSPCAllowsNoInitiators((Boolean)object);
        }
    }

    private void handleSPCAllowsNoTargets(CIMInstance cIMInstance) {
        Object object = CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"SPCAllowsNoTargets");
        if (object == null) {
            this.setSPCAllowsNoTargets(false);
        } else {
            this.setSPCAllowsNoTargets((Boolean)object);
        }
    }

    private void handleSPCAllowNoLUs(CIMInstance cIMInstance) {
        Object object = CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"SPCAllowsNoLUs");
        if (object == null) {
            this.setSPCAllowsNoLUs(false);
        } else {
            this.setSPCAllowsNoLUs((Boolean)object);
        }
    }

    private void handleExposePathSupported(CIMInstance cIMInstance) {
        Object object = CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"ExposePathsSupported");
        if (object == null) {
            this.setExposePathSupported(false);
        } else {
            this.setExposePathSupported((Boolean)object);
        }
    }

    private void handleAttachDeviceSupported(CIMInstance cIMInstance) {
        Object object = CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"AttachDeviceSupported");
        if (object == null) {
            this.setAttachDeviceSupported(false);
        } else {
            this.setAttachDeviceSupported((Boolean)object);
        }
    }

    private void handleUniqueUnitNumberPerPort(CIMInstance cIMInstance, LogTraceHelper logTraceHelper) {
        Object object = CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"UniqueUnitNumbersPerPort");
        if (object == null) {
            logTraceHelper.traceInfo("no UniqueUnitNumbersPerPort found");
        } else {
            this.setUniqueUnitNumberPerPort((Boolean)object);
        }
    }

    private void handleControllerSupportsCollection(CIMInstance cIMInstance, LogTraceHelper logTraceHelper) {
        Object object = CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"ProtocolControllerSupportsCollections");
        if (object == null) {
            logTraceHelper.traceInfo("no ProtocolControllerSupportsCollections found");
        } else {
            this.setProtocolControllerSupportsCollection((Boolean)object);
        }
    }

    private void handleProtocollControllerRequiresAuthorizedIdentity(CIMInstance cIMInstance) {
        Object object = CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"ProtocolControllerRequiresAuthorizedIdentity");
        if (object == null) {
            this.setProtocolControllerRequirersAuthorizedIdentity(false);
        } else {
            this.setProtocolControllerRequirersAuthorizedIdentity((Boolean)object);
        }
    }

    private void handleOneHardwareIDPerView(CIMInstance cIMInstance, LogTraceHelper logTraceHelper) {
        Object object = CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"OneHardwareIDPerView");
        if (object == null) {
            logTraceHelper.traceInfo("no OneHardwareIDPerView found");
        } else {
            this.setOneHardwareIDPerView((Boolean)object);
        }
    }

    public Hashtable toHashtable(LogTraceHelper logTraceHelper) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("ACCESS_ASSIGNMENT", Boolean.toString(this.isAssignAccessSuported()));
        hashtable.put("ACCESS_POINT", Boolean.toString(this.isRemoteServiceAccessPontDataAvailable()));
        hashtable.put("ACCESS_UNASSIGNMENT", Boolean.toString(this.isRemoveAccessSupported()));
        hashtable.put("ATTACH_DEVICE", Boolean.toString(this.isAttachDeviceSupported()));
        hashtable.put("CONTROLLER_REQ_IDENTITY", Boolean.toString(this.isProtocolControllerRequirersAuthorizedIdentity()));
        hashtable.put("CONTROLLER_SUPP_COLL", Boolean.toString(this.isProtocolControllerSupportsCollection()));
        hashtable.put("DISK_DATA", Boolean.toString(this.isDriveDataAvailable()));
        hashtable.put("EXPOSE_PATH", Boolean.toString(this.isExposePathSupported()));
        hashtable.put("EXTENT_DATA", Boolean.toString(this.isExtendDataAvailable()));
        hashtable.put("NUM_VOLUMES", Integer.toString(this.getNumberOfVolumesSuporrted()));
        hashtable.put("ONE_HW_ID_PER_VIEW", Boolean.toString(this.isOneHardwareIDPerView()));
        hashtable.put("PORTS_PER_VIEW", Integer.toString(this.getPortsPerView()));
        if (this.getRaidLevelSupported() != null) {
            hashtable.put("RAID_LEVELS", this.getRaidLevelSupported());
        }
        hashtable.put("SMIS_PROFILE", this.getSMISProfile());
        hashtable.put("SMIS_SUB_PROFILES", CIMInstanceHelper.convertSubProfile((String)this.getSMISSubProfile(), (LogTraceHelper)logTraceHelper));
        hashtable.put("SMIS_VERSION", this.getSMISVersion());
        hashtable.put("SPC_ALLOWS_DEFAULT_VIEWS", Boolean.toString(this.isSPCSupportsDefaultViews()));
        hashtable.put("SPC_ALLOWS_NO_INITIATORS", Boolean.toString(this.isSPCAllowsNoInitiators()));
        hashtable.put("SPC_ALLOWS_NO_LUS", Boolean.toString(this.isSPCAllowsNoLUs()));
        hashtable.put("SPC_ALLOWS_NO_TGTS", Boolean.toString(this.isSPCAllowsNoTargets()));
        hashtable.put("TARGET_PORT_RESTRICTION", Boolean.toString(this.isTargetPortRestrictionSupported()));
        hashtable.put("UNIQUE_NUM_PER_PORT", Boolean.toString(this.isUniqueUnitNumberPerPort()));
        hashtable.put("VOLUME_CREATION", Boolean.toString(this.isVolumeCreationSupported()));
        hashtable.put("VOLUME_DELETION", Boolean.toString(this.isVolumeDeletionSupported()));
        hashtable.put("VOLUME_EXPANSION", Boolean.toString(this.isVolumeExpansionSupported()));
        hashtable.put("VOLUME_SHRINKING", Boolean.toString(this.isVolumeShrinkingSupported()));
        hashtable.put("CLNT_SELCTBL_DEVNO", Boolean.toString(this.isClientSelectableDeviceNumbers()));
        return hashtable;
    }

    public boolean isAssignAccessSuported() {
        return this.cAssignAccessSuported;
    }

    public void setAssignAccessSuported(boolean bl) {
        this.cAssignAccessSuported = bl;
    }

    public boolean isAttachDeviceSupported() {
        return this.cAttachDeviceSupported;
    }

    public void setAttachDeviceSupported(boolean bl) {
        this.cAttachDeviceSupported = bl;
    }

    public boolean isDriveDataAvailable() {
        return this.cDriveDataAvailable;
    }

    public void setDriveDataAvailable(boolean bl) {
        this.cDriveDataAvailable = bl;
    }

    public boolean isExposePathSupported() {
        return this.cExposePathSupported;
    }

    public void setExposePathSupported(boolean bl) {
        this.cExposePathSupported = bl;
    }

    public boolean isExtendDataAvailable() {
        return this.cExtendDataAvailable;
    }

    public void setExtendDataAvailable(boolean bl) {
        this.cExtendDataAvailable = bl;
    }

    public int getNumberOfVolumesSuporrted() {
        return this.cNumberOfVolumesSuporrted;
    }

    public void setNumberOfVolumesSuporrted(int n) {
        this.cNumberOfVolumesSuporrted = n;
    }

    public boolean isOneHardwareIDPerView() {
        return this.cOneHardwareIDPerView;
    }

    public void setOneHardwareIDPerView(boolean bl) {
        this.cOneHardwareIDPerView = bl;
    }

    public int getPortsPerView() {
        return this.cPortsPerView;
    }

    public void setPortsPerView(int n) {
        this.cPortsPerView = n;
    }

    public boolean isProtocolControllerRequirersAuthorizedIdentity() {
        return this.cProtocolControllerRequirersAuthorizedIdentity;
    }

    public void setProtocolControllerRequirersAuthorizedIdentity(boolean bl) {
        this.cProtocolControllerRequirersAuthorizedIdentity = bl;
    }

    public boolean isProtocolControllerSupportsCollection() {
        return this.cProtocolControllerSupportsCollection;
    }

    public void setProtocolControllerSupportsCollection(boolean bl) {
        this.cProtocolControllerSupportsCollection = bl;
    }

    public String[] getRaidLevelSupported() {
        return this.cRaidLevelSupported;
    }

    public void setRaidLevelSupported(String[] stringArray) {
        this.cRaidLevelSupported = stringArray;
    }

    public boolean isRemoteServiceAccessPontDataAvailable() {
        return this.cRemoteServiceAccessPontDataAvailable;
    }

    public void setRemoteServiceAccessPontDataAvailable(boolean bl) {
        this.cRemoteServiceAccessPontDataAvailable = bl;
    }

    public boolean isRemoveAccessSupported() {
        return this.cRemoveAccessSupported;
    }

    public void setRemoveAccessSupported(boolean bl) {
        this.cRemoveAccessSupported = bl;
    }

    public String getSMISProfile() {
        return this.cSMISProfile;
    }

    public void setSMISProfile(String string) {
        this.cSMISProfile = string;
    }

    public String getSMISSubProfile() {
        return this.cSMISSubProfile;
    }

    public void setSMISSubProfile(String string) {
        this.cSMISSubProfile = string;
    }

    public boolean isSPCAllowsNoInitiators() {
        return this.cSPCAllowsNoInitiators;
    }

    public void setSPCAllowsNoInitiators(boolean bl) {
        this.cSPCAllowsNoInitiators = bl;
    }

    public boolean isSPCAllowsNoLUs() {
        return this.cSPCAllowsNoLUs;
    }

    public void setSPCAllowsNoLUs(boolean bl) {
        this.cSPCAllowsNoLUs = bl;
    }

    public boolean isSPCAllowsNoTargets() {
        return this.cSPCAllowsNoTargets;
    }

    public void setSPCAllowsNoTargets(boolean bl) {
        this.cSPCAllowsNoTargets = bl;
    }

    public boolean isSPCSupportsDefaultViews() {
        return this.cSPCSupportsDefaultViews;
    }

    public void setSPCSupportsDefaultViews(boolean bl) {
        this.cSPCSupportsDefaultViews = bl;
    }

    public boolean isTargetPortRestrictionSupported() {
        return this.cTargetPortRestrictionSupported;
    }

    public void setTargetPortRestrictionSupported(boolean bl) {
        this.cTargetPortRestrictionSupported = bl;
    }

    public boolean isUniqueUnitNumberPerPort() {
        return this.cUniqueUnitNumberPerPort;
    }

    public void setUniqueUnitNumberPerPort(boolean bl) {
        this.cUniqueUnitNumberPerPort = bl;
    }

    public boolean isVolumeCreationSupported() {
        return this.cVolumeCreationSupported;
    }

    public void setVolumeCreationSupported(boolean bl) {
        this.cVolumeCreationSupported = bl;
    }

    public boolean isVolumeDeletionSupported() {
        return this.cVolumeDeletionSupported;
    }

    public void setVolumeDeletionSupported(boolean bl) {
        this.cVolumeDeletionSupported = bl;
    }

    public boolean isVolumeExpansionSupported() {
        return this.cVolumeExpansionSupported;
    }

    public void setVolumeExpansionSupported(boolean bl) {
        this.cVolumeExpansionSupported = bl;
    }

    public boolean isVolumeShrinkingSupported() {
        return this.cVolumeShrinkingSupported;
    }

    public void setVolumeShrinkingSupported(boolean bl) {
        this.cVolumeShrinkingSupported = bl;
    }

    public String getSMISVersion() {
        return this.cSMISVersion;
    }

    public void setSMISVersion(String string) {
        this.cSMISVersion = string;
    }

    public boolean isClientSelectableDeviceNumbers() {
        return this.cClientSelectableDeviceNumbers;
    }

    public void setClientSelectableDeviceNumbers(boolean bl) {
        this.cClientSelectableDeviceNumbers = bl;
    }

    public String toString() {
        LogTraceHelper logTraceHelper = LogTraceHelperDummy.entry((Object)this, (String)"checkSubProfile", (Object[])new Object[0]);
        return this.toHashtable(logTraceHelper).toString();
    }

    public int getMaxMapCount() {
        return this.cMaxMapCount;
    }

    public void setMaxMapCount(int n) {
        this.cMaxMapCount = n;
    }
}

