/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.discovery.Capabilities;
import org.eclipse.aperi.disk.discovery.DiscoveryException;
import org.eclipse.aperi.disk.discovery.GenericDiscoveryProcessPlugin;
import org.eclipse.aperi.disk.discovery.StorageDeviceData;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt64;

public class LSIDiscoveryProcessPlugin
extends GenericDiscoveryProcessPlugin {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LSIDiscoveryProcessPlugin() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"LSIDiscoveryProcessPlugin", null);
        try {
            Class<?> clazz;
            this.cCIMOMExclusions = this.readCimomExclusion(logTraceHelper);
            try {
                clazz = Class.forName("org.eclipse.aperi.disk.discovery.LSIDiscoveryProcessPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            logTraceHelper.objectCreation(clazz.getName());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        logTraceHelper.exit(null);
    }

    protected void getSpecificDataForDevice(CIMInstance cIMInstance, StorageDeviceData storageDeviceData) throws DiscoveryException {
        CIMInstance[] cIMInstanceArray = storageDeviceData.getNodes();
        long l = 0L;
        int n = 0;
        while (n < cIMInstanceArray.length) {
            CIMProperty cIMProperty = cIMInstanceArray[n].getProperty("CacheMemorySize");
            if (cIMProperty != null) {
                l += ((UnsignedInt64)cIMProperty.getValue().getValue()).longValue();
            }
            ++n;
        }
        l = l * 1024L * 1024L;
        cIMInstance.addProperty(new CIMProperty("CACHE".toLowerCase(), new CIMValue((Object)new Long(l), new CIMDataType(7))));
        this.getProviderVersion(cIMInstance, storageDeviceData);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getProviderVersion(CIMInstance cIMInstance, StorageDeviceData storageDeviceData) throws DiscoveryException {
        String string = "getProviderVersion";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)string, (Object[])new Object[]{cIMInstance, storageDeviceData});
        try {
            CIMInstance cIMInstance2 = null;
            this.cParameters.put("IN_SYSTEM_CIMOMVersion", cIMInstance);
            this.cParameters.put("NAMESPACE", storageDeviceData.getNameSpace());
            String[] stringArray = Router.getRouter().perform("CIMOMVersion", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(stringArray);
            JobInfo jobInfo = (JobInfo)JobEngine.getInstance().getJobs(stringArray[1]).get(0);
            if (!jobInfo.isSuccessful()) {
                this.cParameters.remove("NAMESPACE");
                this.checkJobSuccessful(string, logTraceHelper, jobInfo, "CONFIGURATIONCAPABILITIES");
            }
            this.cParameters.remove("NAMESPACE");
            Response response = jobInfo.getResponse();
            if (response instanceof Response) {
                Enumeration enumeration = (Enumeration)response.getData();
                while (enumeration.hasMoreElements()) {
                    cIMInstance2 = (CIMInstance)enumeration.nextElement();
                    String string2 = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance2, (String)"BuildInfo");
                    logTraceHelper.traceInfo("Used CIMOM Version:" + string2);
                    storageDeviceData.setCIMOMVersion(string2);
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        logTraceHelper.exit(null);
    }

    protected void saveSpecificData(StorageDeviceData storageDeviceData, LogTraceHelper logTraceHelper, MapperRouter mapperRouter, String string, String string2, Hashtable hashtable) throws SQLException {
        CIMInstance cIMInstance = storageDeviceData.getInstance("");
        int n = (Integer)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"MaxStorageVolumes");
        Capabilities capabilities = storageDeviceData.getCapabilities();
        logTraceHelper.traceInfo("saveSpecificData for FAStT MAX VOLUMES: " + n);
        capabilities.setNumberOfVolumesSuporrted(n);
        storageDeviceData.setCapabilities(capabilities);
    }

    protected String readCimomExclusion(LogTraceHelper logTraceHelper) {
        return this.readRegExForCIMOMExclusion("LSI", logTraceHelper);
    }

    protected boolean isUsedProfile(CIMInstance cIMInstance) {
        boolean bl = super.isUsedProfile(cIMInstance);
        String string = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"RegisteredVersion");
        if (string == null) {
            return bl;
        }
        return bl && !string.startsWith("1.0.2") && !string.startsWith("1.0.3");
    }
}

