/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.CIMExceptionResponse;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerRTException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.discovery.Capabilities;
import org.eclipse.aperi.disk.discovery.DiscoveryException;
import org.eclipse.aperi.disk.discovery.DiscoveryProcessPlugin;
import org.eclipse.aperi.disk.discovery.StorageDeviceData;
import org.eclipse.aperi.disk.util.DiscoveryMessageHelper;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.ConfigData;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.sblim.wbem.cim.CIMAuthenticationException;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMTransportException;
import org.sblim.wbem.cim.UnsignedInt16;

public abstract class ProcessPlugin
implements DiscoveryProcessPlugin,
DiscoveryConstants,
CIMNames {
    protected MapperRouter cMapperRouter = null;
    protected Request cRequest = null;
    protected Map cParameters = null;
    protected static final String SEPARATOR = ",";
    protected JobInfo cObjectJob = null;
    protected String cCIMOMExclusions = null;
    protected DiskCIMProcessor cDiskCimProcessor = null;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProcessPlugin() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"ProcessPlugin", null);
        try {
            Class<?> clazz;
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.disk.discovery.ProcessPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            logTraceHelper.objectCreation(clazz2.getName());
            try {
                clazz = Class.forName("org.eclipse.aperi.disk.discovery.ProcessPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            logTraceHelper.objectCreation(clazz.getName());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initRequest(Request request, Map map, DiskCIMProcessor diskCIMProcessor) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)request, (Object)this, (String)"ProcessPlugin", (Object[])new Object[]{request, map});
        try {
            this.cRequest = request;
            this.cParameters = map;
            this.cDiskCimProcessor = diskCIMProcessor;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        logTraceHelper.exit(null);
    }

    protected List getStorageProfiles() throws DiscoveryException {
        Vector<CIMInstance> vector;
        JobInfo jobInfo;
        Vector<CIMInstance> vector2;
        LogTraceHelper logTraceHelper;
        block5: {
            String string = "getStorageProfiles";
            logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)string, (Object[])new Object[0]);
            vector2 = new Vector<CIMInstance>();
            String[] stringArray = Router.getRouter().perform("RegisteredProfile", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(stringArray);
            jobInfo = (JobInfo)JobEngine.getInstance().getJobs(stringArray[1]).get(0);
            if (jobInfo.isSuccessful()) break block5;
            logTraceHelper.traceInfo(String.valueOf(string) + " returns false");
            Vector<CIMInstance> vector3 = vector2;
            Object var9_8 = null;
            logTraceHelper.exit(vector2);
            return vector3;
        }
        try {
            Response response = jobInfo.getResponse();
            if (response instanceof Response) {
                Enumeration enumeration = (Enumeration)response.getData();
                while (enumeration.hasMoreElements()) {
                    CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                    vector2.add(cIMInstance);
                }
            }
            vector = vector2;
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            logTraceHelper.exit(vector2);
            throw throwable;
        }
        logTraceHelper.exit(vector2);
        return vector;
    }

    protected List getSystemsForProfile(CIMInstance cIMInstance) throws DiscoveryException {
        Vector<CIMInstance> vector;
        String string = "getSystemsForProfile";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)string, (Object[])new Object[]{cIMInstance});
        Vector<CIMInstance> vector2 = new Vector<CIMInstance>();
        try {
            CIMInstance cIMInstance2 = null;
            this.cParameters.put("IN_SYSTEM_COMPUTERSYSTEM", cIMInstance);
            String[] stringArray = Router.getRouter().perform("COMPUTERSYSTEM", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(stringArray);
            JobInfo jobInfo = (JobInfo)JobEngine.getInstance().getJobs(stringArray[1]).get(0);
            if (!jobInfo.isSuccessful()) {
                this.checkJobSuccessful(string, logTraceHelper, jobInfo, "COMPUTERSYSTEM");
            }
            Response response = jobInfo.getResponse();
            Enumeration enumeration = (Enumeration)response.getData();
            while (enumeration.hasMoreElements()) {
                cIMInstance2 = (CIMInstance)enumeration.nextElement();
                vector2.add(cIMInstance2);
            }
            vector = vector2;
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            logTraceHelper.exit(vector2);
            throw throwable;
        }
        logTraceHelper.exit(vector2);
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getProductOfSystem(CIMInstance cIMInstance, StorageDeviceData storageDeviceData, boolean bl) throws DiscoveryException {
        LogTraceHelper logTraceHelper;
        block9: {
            block8: {
                String string = "getProductOfSystem";
                logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)string, (Object[])new Object[]{cIMInstance, storageDeviceData});
                try {
                    Enumeration enumeration;
                    Response response;
                    Enumeration enumeration2;
                    CIMInstance cIMInstance2 = storageDeviceData.getInstance("product");
                    if (cIMInstance2 != null) {
                        Object var16_7 = null;
                        break block8;
                    }
                    this.cParameters.put("IN_SYSTEM_PHYSICALPACKAGING", cIMInstance);
                    String[] stringArray = null;
                    Response response2 = null;
                    String[] stringArray2 = Router.getRouter().perform("PHYSICALPACKAGING", this.cParameters, new Integer(this.cRequest.getId()).toString());
                    Router.getRouter().waitTilComplete(stringArray2);
                    JobInfo jobInfo = (JobInfo)JobEngine.getInstance().getJobs(stringArray2[1]).get(0);
                    if (!jobInfo.isSuccessful()) {
                        this.checkJobSuccessful(string, logTraceHelper, jobInfo, "PHYSICALPACKAGING");
                    }
                    if (!(enumeration2 = (Enumeration)(response = jobInfo.getResponse()).getData()).hasMoreElements()) break block9;
                    cIMInstance2 = (CIMInstance)enumeration2.nextElement();
                    if (storageDeviceData.getInstance("physicalpackage") == null && bl) {
                        storageDeviceData.setDataFromInstance("physicalpackage", cIMInstance2, logTraceHelper);
                    }
                    this.cParameters.put("IN_SYSTEM_product", cIMInstance2);
                    stringArray = Router.getRouter().perform("product", this.cParameters, new Integer(this.cRequest.getId()).toString());
                    Router.getRouter().waitTilComplete(stringArray);
                    JobInfo jobInfo2 = (JobInfo)JobEngine.getInstance().getJobs(stringArray[1]).get(0);
                    if (!jobInfo2.isSuccessful()) {
                        this.checkJobSuccessful(string, logTraceHelper, jobInfo, "product");
                    }
                    if ((enumeration = (Enumeration)(response2 = jobInfo2.getResponse()).getData()).hasMoreElements()) {
                        CIMInstance cIMInstance3 = (CIMInstance)enumeration.nextElement();
                        storageDeviceData.setDataFromInstance("product", cIMInstance3, logTraceHelper);
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var16_8 = null;
                    logTraceHelper.exit(null);
                    throw throwable;
                }
            }
            logTraceHelper.exit(null);
            return;
        }
        Object var16_9 = null;
        logTraceHelper.exit(null);
    }

    protected List getNodesOfCluster(CIMInstance cIMInstance) throws DiscoveryException {
        Vector<CIMInstance> vector;
        String string = "getNodesOfCluster";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)string, (Object[])new Object[]{cIMInstance});
        CIMInstance cIMInstance2 = null;
        Vector<CIMInstance> vector2 = new Vector<CIMInstance>();
        try {
            this.cParameters.put("IN_SYSTEM_NOTESOFCLUSTER", cIMInstance);
            String[] stringArray = Router.getRouter().perform("NOTESOFCLUSTER", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(stringArray);
            JobInfo jobInfo = (JobInfo)JobEngine.getInstance().getJobs(stringArray[1]).get(0);
            if (!jobInfo.isSuccessful()) {
                this.checkJobSuccessful(string, logTraceHelper, jobInfo, "NOTESOFCLUSTER");
            }
            Response response = jobInfo.getResponse();
            Enumeration enumeration = (Enumeration)response.getData();
            while (enumeration.hasMoreElements()) {
                cIMInstance2 = (CIMInstance)enumeration.nextElement();
                vector2.add(cIMInstance2);
            }
            vector = vector2;
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            logTraceHelper.exit(vector2);
            throw throwable;
        }
        logTraceHelper.exit(vector2);
        return vector;
    }

    protected void getFCPortsOfSystem(CIMInstance cIMInstance, StorageDeviceData storageDeviceData) throws DiscoveryException {
        String string = "getFCPortsOfSystem";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)string, (Object[])new Object[]{cIMInstance});
        CIMInstance cIMInstance2 = null;
        Vector vector = new Vector();
        try {
            this.cParameters.put("IN_SYSTEM_FCPORTSOFSYSTEM", cIMInstance);
            String[] stringArray = Router.getRouter().perform("FCPORTSOFSYSTEM", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(stringArray);
            JobInfo jobInfo = (JobInfo)JobEngine.getInstance().getJobs(stringArray[1]).get(0);
            if (!jobInfo.isSuccessful()) {
                this.checkJobSuccessful(string, logTraceHelper, jobInfo, "FCPORTSOFSYSTEM");
            }
            Response response = jobInfo.getResponse();
            Enumeration enumeration = (Enumeration)response.getData();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                cIMInstance2 = (CIMInstance)enumeration.nextElement();
                storageDeviceData.setDataFromInstance("fcport_" + ++n, cIMInstance2, logTraceHelper);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            logTraceHelper.exit(vector);
            throw throwable;
        }
        logTraceHelper.exit(vector);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getSoftwareOfDevice(CIMInstance cIMInstance, StorageDeviceData storageDeviceData) throws DiscoveryException {
        LogTraceHelper logTraceHelper;
        block7: {
            block6: {
                String string = "getSoftwareOfDevice";
                logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)string, (Object[])new Object[]{cIMInstance, storageDeviceData});
                CIMInstance cIMInstance2 = null;
                try {
                    if (!this.supportsSubProfile(storageDeviceData.getSubProfile(), "Software")) {
                        logTraceHelper.traceInfo("Device does not support software subprofile");
                        Object var10_6 = null;
                        break block6;
                    }
                    this.cParameters.put("IN_SYSTEM_SOFTWAREIDENTITY", cIMInstance);
                    String[] stringArray = Router.getRouter().perform("SOFTWAREIDENTITY", this.cParameters, new Integer(this.cRequest.getId()).toString());
                    Router.getRouter().waitTilComplete(stringArray);
                    JobInfo jobInfo = (JobInfo)JobEngine.getInstance().getJobs(stringArray[1]).get(0);
                    if (!jobInfo.isSuccessful()) {
                        this.checkJobSuccessful(string, logTraceHelper, jobInfo, "SOFTWAREIDENTITY");
                    }
                    Response response = jobInfo.getResponse();
                    Enumeration enumeration = (Enumeration)response.getData();
                    while (enumeration.hasMoreElements()) {
                        cIMInstance2 = (CIMInstance)enumeration.nextElement();
                        storageDeviceData.setDataFromInstance("software", cIMInstance2, logTraceHelper);
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var10_7 = null;
                    logTraceHelper.exit(null);
                    throw throwable;
                }
            }
            logTraceHelper.exit(null);
            return;
        }
        Object var10_8 = null;
        logTraceHelper.exit(null);
    }

    protected String getSubProfileString(CIMInstance cIMInstance) throws DiscoveryException {
        String string;
        String string2 = "getSubProfileString";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)string2, (Object[])new Object[]{cIMInstance});
        String string3 = null;
        try {
            if (cIMInstance != null) {
                CIMInstance cIMInstance2 = null;
                StringBuffer stringBuffer = new StringBuffer();
                this.cParameters.put("IN_SYSTEM_SUBPROFILE", cIMInstance);
                String[] stringArray = Router.getRouter().perform("SUBPROFILE", this.cParameters, new Integer(this.cRequest.getId()).toString());
                Router.getRouter().waitTilComplete(stringArray);
                JobInfo jobInfo = (JobInfo)JobEngine.getInstance().getJobs(stringArray[1]).get(0);
                if (!jobInfo.isSuccessful()) {
                    this.checkJobSuccessful(string2, logTraceHelper, jobInfo, "SUBPROFILE");
                }
                Response response = jobInfo.getResponse();
                Enumeration enumeration = (Enumeration)response.getData();
                while (enumeration.hasMoreElements()) {
                    cIMInstance2 = (CIMInstance)enumeration.nextElement();
                    String string4 = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance2, (String)"RegisteredName");
                    string4 = string4.replaceAll(SEPARATOR, "");
                    stringBuffer.append(String.valueOf(string4) + SEPARATOR);
                }
                string3 = stringBuffer.toString();
                string3 = string3.endsWith(SEPARATOR) ? string3.toString().substring(0, string3.length() - 1) : string3;
            }
            string = string3;
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            logTraceHelper.exit(string3);
            throw throwable;
        }
        logTraceHelper.exit(string3);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getSAPForSystem(CIMInstance cIMInstance, StorageDeviceData storageDeviceData) throws DiscoveryException {
        LogTraceHelper logTraceHelper;
        block11: {
            block10: {
                String string = "getSAPForSystem";
                logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)string, (Object[])new Object[]{cIMInstance, storageDeviceData});
                try {
                    Enumeration enumeration;
                    if (!this.supportsSubProfile(storageDeviceData.getSubProfile(), "Access Point") && !this.supportsSubProfile(storageDeviceData.getSubProfile(), "Access Points")) {
                        logTraceHelper.traceInfo("Device does not support remote service access point subprofile");
                        Object var14_5 = null;
                        break block10;
                    }
                    CIMInstance cIMInstance2 = null;
                    this.cParameters.put("IN_SYSTEM_REMOTESERVICE", cIMInstance);
                    String[] stringArray = Router.getRouter().perform("REMOTESERVICE", this.cParameters, new Integer(this.cRequest.getId()).toString());
                    Router.getRouter().waitTilComplete(stringArray);
                    JobInfo jobInfo = (JobInfo)JobEngine.getInstance().getJobs(stringArray[1]).get(0);
                    if (!jobInfo.isSuccessful()) {
                        this.checkJobSuccessful(string, logTraceHelper, jobInfo, "REMOTESERVICE");
                    }
                    Response response = jobInfo.getResponse();
                    Enumeration enumeration2 = (Enumeration)response.getData();
                    while (true) {
                        if (!enumeration2.hasMoreElements()) {
                            if (storageDeviceData.getInstance("accessPoint") == null) {
                                this.cParameters.put("IN_SYSTEM_REMOTESERVICE2", cIMInstance);
                                String[] stringArray2 = Router.getRouter().perform("REMOTESERVICE2", this.cParameters, new Integer(this.cRequest.getId()).toString());
                                Router.getRouter().waitTilComplete(stringArray2);
                                JobInfo jobInfo2 = (JobInfo)JobEngine.getInstance().getJobs(stringArray2[1]).get(0);
                                if (!jobInfo2.isSuccessful()) {
                                    this.checkJobSuccessful(string, logTraceHelper, jobInfo2, "REMOTESERVICE2");
                                }
                                Response response2 = jobInfo2.getResponse();
                                enumeration = (Enumeration)response2.getData();
                                break;
                            }
                            break block11;
                        }
                        cIMInstance2 = (CIMInstance)enumeration2.nextElement();
                        storageDeviceData.setDataFromInstance("accessPoint", cIMInstance2, logTraceHelper);
                    }
                    while (enumeration.hasMoreElements()) {
                        cIMInstance2 = (CIMInstance)enumeration.nextElement();
                        storageDeviceData.setDataFromInstance("accessPoint", cIMInstance2, logTraceHelper);
                    }
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var14_6 = null;
                    logTraceHelper.exit(null);
                    throw throwable;
                }
            }
            logTraceHelper.exit(null);
            return;
        }
        Object var14_7 = null;
        logTraceHelper.exit(null);
    }

    public List collectDeviceData(String string, String string2) throws DiscoveryException {
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleComputerSystem(List list, CIMInstance cIMInstance, String string, List list2) throws DiscoveryException {
        LogTraceHelper logTraceHelper;
        block7: {
            logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"handleComputerSystem", (Object[])new Object[]{list, cIMInstance, string, list2});
            boolean bl = false;
            try {
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    CIMInstance cIMInstance2 = (CIMInstance)iterator.next();
                    if (string == null || string.length() <= 0) {
                        string = this.getSubProfileString(cIMInstance);
                    }
                    string = this.correctSubProfileString(string);
                    StorageDeviceData storageDeviceData = new StorageDeviceData();
                    storageDeviceData.setDataFromInstance("", cIMInstance2, logTraceHelper);
                    list.add(new Object[]{storageDeviceData, cIMInstance2});
                    storageDeviceData.setSubProfile(string);
                    storageDeviceData.setNameSpace(cIMInstance2.getObjectPath().getNameSpace());
                    Capabilities capabilities = null;
                    if (cIMInstance != null) {
                        storageDeviceData.setSMISVersion((String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"RegisteredVersion"));
                        String string2 = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"RegisteredName");
                        storageDeviceData.setProfile(string2);
                        capabilities = storageDeviceData.getCapabilities();
                        capabilities.checkSubProfile(string);
                        capabilities.setSMISProfile(string2);
                    }
                    storageDeviceData.setCapabilities(capabilities);
                    logTraceHelper.traceInfo("New StorageDevice for :" + CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance2, (String)"Name"));
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (!bl) {
                    logTraceHelper.logMsg("HWN021726I", new Object[]{((String[])this.cParameters.get("CIMOM"))[0]});
                }
                logTraceHelper.exit(null);
                throw throwable;
            }
            {
                Object var12_14 = null;
                if (bl) break block7;
            }
            logTraceHelper.logMsg("HWN021726I", new Object[]{((String[])this.cParameters.get("CIMOM"))[0]});
        }
        logTraceHelper.exit(null);
    }

    protected Hashtable saveNameSpace(LogTraceHelper logTraceHelper, MapperRouter mapperRouter, String string, String string2, String string3) throws SQLException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable hashtable2 = new Hashtable();
        MapperResult mapperResult = null;
        try {
            try {
                if (string2 != null) {
                    String[] stringArray = (String[])this.cParameters.get("CIMOM");
                    hashtable.put("ref_serviceurl", stringArray[0]);
                    hashtable.put("namespace", string2);
                    if (string3 != null) {
                        hashtable.put("software_level", string3);
                    }
                    this.cDiskCimProcessor.setSMISVersion("");
                    this.cDiskCimProcessor.setInstrumentationVersion("");
                    mapperResult = this.cDiskCimProcessor.handleEntity("", "SLP", hashtable);
                    hashtable2 = mapperResult.getKeyReferences();
                    logTraceHelper.traceInfo("saveNamespace");
                }
            }
            catch (org.eclipse.aperi.discovery.interfaces.DiscoveryException discoveryException) {
                if (discoveryException.getCause() instanceof SQLException) {
                    throw (SQLException)discoveryException.getCause();
                }
                logTraceHelper.traceInfo("not handeled " + discoveryException.getCause().getMessage());
            }
        }
        catch (Throwable throwable) {}
        return hashtable2;
    }

    protected MapperRouter getMapperRouter() {
        if (this.cMapperRouter == null) {
            this.cMapperRouter = MapperRouter.getMapperRouter();
        }
        return this.cMapperRouter;
    }

    protected void saveSoftware(Object[] objectArray, LogTraceHelper logTraceHelper, MapperRouter mapperRouter, String string, Hashtable hashtable) throws SQLException {
        Hashtable hashtable2 = null;
        try {
            CIMInstance cIMInstance = ((StorageDeviceData)objectArray[0]).getInstance("software");
            if (cIMInstance != null) {
                hashtable2 = CIMInstanceHelper.changeCIMInstanceToHashtable((CIMInstance)cIMInstance);
                hashtable2.putAll(hashtable);
                this.cDiskCimProcessor.setSMISVersion(((StorageDeviceData)objectArray[0]).getSMISVersion());
                this.cDiskCimProcessor.setInstrumentationVersion(((String[])this.cParameters.get("CIMOM"))[5]);
                hashtable2.put("originalcimclassname", "CIM_SoftwareIdentity");
                this.cDiskCimProcessor.handleEntity("", cIMInstance.getClassName(), hashtable2);
            } else {
                logTraceHelper.traceInfo("No Software found");
            }
        }
        catch (org.eclipse.aperi.discovery.interfaces.DiscoveryException discoveryException) {
            if (discoveryException.getCause() instanceof SQLException) {
                throw (SQLException)discoveryException.getCause();
            }
            logTraceHelper.traceInfo("not handeled " + discoveryException.getCause().getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveCapabilities(Object[] objectArray, MapperRouter mapperRouter, String string, Hashtable hashtable) throws SQLException {
        LogTraceHelper logTraceHelper;
        block10: {
            block9: {
                logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"saveCapabilities", (Object[])new Object[]{mapperRouter, string, hashtable});
                try {
                    try {
                        Hashtable hashtable2 = null;
                        StorageDeviceData storageDeviceData = (StorageDeviceData)objectArray[0];
                        if (!("Array".equalsIgnoreCase(storageDeviceData.getProfile()) || "In Band Virtualization".equalsIgnoreCase(storageDeviceData.getProfile()) || "Storage Library".equalsIgnoreCase(storageDeviceData.getProfile()))) {
                            Object var10_9 = null;
                            break block9;
                        }
                        Capabilities capabilities = storageDeviceData.getCapabilities();
                        if (capabilities.getSMISVersion() == null || capabilities.getSMISVersion().length() == 0) {
                            capabilities.setSMISVersion(storageDeviceData.getSMISVersion());
                        }
                        hashtable2 = capabilities.toHashtable(logTraceHelper);
                        hashtable2.putAll(hashtable);
                        this.cDiskCimProcessor.setSMISVersion(((StorageDeviceData)objectArray[0]).getSMISVersion());
                        this.cDiskCimProcessor.setInstrumentationVersion(((String[])this.cParameters.get("CIMOM"))[5]);
                        String string2 = "CapabilityData";
                        if ("Storage Library".equalsIgnoreCase(((StorageDeviceData)objectArray[0]).getProfile())) {
                            string2 = String.valueOf(string2) + "SML";
                        }
                        this.cDiskCimProcessor.handleEntity("", string2, hashtable2);
                        logTraceHelper.traceInfo("saveCapabilities");
                    }
                    catch (org.eclipse.aperi.discovery.interfaces.DiscoveryException discoveryException) {
                        if (discoveryException.getCause() instanceof SQLException) {
                            throw (SQLException)discoveryException.getCause();
                        }
                        logTraceHelper.traceInfo("not handeled " + discoveryException.getCause().getMessage());
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    logTraceHelper.exit(null);
                    throw throwable;
                }
            }
            logTraceHelper.exit(null);
            return;
        }
        Object var10_11 = null;
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveNodes(Object[] objectArray, LogTraceHelper logTraceHelper, MapperRouter mapperRouter, String string, Hashtable hashtable) throws SQLException {
        Hashtable hashtable2 = null;
        try {
            try {
                int n = 1;
                CIMInstance cIMInstance = ((StorageDeviceData)objectArray[0]).getInstance("node_" + n);
                while (cIMInstance != null) {
                    hashtable2 = CIMInstanceHelper.changeCIMInstanceToHashtable((CIMInstance)cIMInstance);
                    hashtable2.putAll(hashtable);
                    Vector vector = (Vector)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"Dedicated");
                    String string2 = null;
                    string2 = vector != null ? vector.toString() : "0";
                    this.cDiskCimProcessor.setSMISVersion(((StorageDeviceData)objectArray[0]).getSMISVersion());
                    this.cDiskCimProcessor.setInstrumentationVersion(((String[])this.cParameters.get("CIMOM"))[5]);
                    this.cDiskCimProcessor.setDedicated(string2);
                    hashtable2.put("originalcimclassname", "CIM_ComputerSystem");
                    this.cDiskCimProcessor.handleEntity("", cIMInstance.getClassName(), hashtable2);
                    logTraceHelper.traceInfo("saveNode " + n);
                    cIMInstance = ((StorageDeviceData)objectArray[0]).getInstance("node_" + ++n);
                }
            }
            catch (org.eclipse.aperi.discovery.interfaces.DiscoveryException discoveryException) {
                if (discoveryException.getCause() instanceof SQLException) {
                    throw (SQLException)discoveryException.getCause();
                }
                logTraceHelper.traceInfo("not handeled " + discoveryException.getCause().getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.cDiskCimProcessor.setDedicated(null);
            throw throwable;
        }
        {
            Object var11_14 = null;
        }
        this.cDiskCimProcessor.setDedicated(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveFCPorts(Object[] objectArray, LogTraceHelper logTraceHelper, MapperRouter mapperRouter, String string, Hashtable hashtable) throws SQLException {
        Hashtable hashtable2 = null;
        try {
            try {
                int n = 1;
                CIMInstance cIMInstance = ((StorageDeviceData)objectArray[0]).getInstance("fcport_" + n);
                while (cIMInstance != null) {
                    hashtable2 = CIMInstanceHelper.changeCIMInstanceToHashtable((CIMInstance)cIMInstance);
                    hashtable2.putAll(hashtable);
                    this.cDiskCimProcessor.setSMISVersion(((StorageDeviceData)objectArray[0]).getSMISVersion());
                    this.cDiskCimProcessor.setInstrumentationVersion(((String[])this.cParameters.get("CIMOM"))[5]);
                    this.cDiskCimProcessor.setDedicated(null);
                    hashtable2.put("originalcimclassname", "CIM_FCPort");
                    this.cDiskCimProcessor.handleEntity("", cIMInstance.getClassName(), hashtable2);
                    logTraceHelper.traceInfo("saveFCPort " + n);
                    cIMInstance = ((StorageDeviceData)objectArray[0]).getInstance("fcport_" + ++n);
                }
            }
            catch (org.eclipse.aperi.discovery.interfaces.DiscoveryException discoveryException) {
                if (discoveryException.getCause() instanceof SQLException) {
                    throw (SQLException)discoveryException.getCause();
                }
                logTraceHelper.traceInfo("not handeled " + discoveryException.getCause().getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.cDiskCimProcessor.setDedicated(null);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        this.cDiskCimProcessor.setDedicated(null);
    }

    protected void saveProduct(Object[] objectArray, LogTraceHelper logTraceHelper, MapperRouter mapperRouter, String string, Hashtable hashtable) throws SQLException {
        Hashtable hashtable2 = null;
        try {
            CIMInstance cIMInstance = ((StorageDeviceData)objectArray[0]).getInstance("product");
            if (cIMInstance != null) {
                hashtable2 = CIMInstanceHelper.changeCIMInstanceToHashtable((CIMInstance)cIMInstance);
                hashtable2.putAll(hashtable);
                this.cDiskCimProcessor.setSMISVersion(((StorageDeviceData)objectArray[0]).getSMISVersion());
                this.cDiskCimProcessor.setInstrumentationVersion(((String[])this.cParameters.get("CIMOM"))[5]);
                hashtable2.put("originalcimclassname", "CIM_Product");
                this.cDiskCimProcessor.handleEntity("", cIMInstance.getClassName(), hashtable2);
                logTraceHelper.traceInfo("saveProduct");
            } else {
                logTraceHelper.traceInfo("No product available!");
            }
        }
        catch (org.eclipse.aperi.discovery.interfaces.DiscoveryException discoveryException) {
            if (discoveryException.getCause() instanceof SQLException) {
                throw (SQLException)discoveryException.getCause();
            }
            logTraceHelper.traceInfo("not handeled " + discoveryException.getCause().getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Hashtable saveSubSystem(Object[] objectArray, LogTraceHelper logTraceHelper, MapperRouter mapperRouter, String string, Hashtable hashtable) throws SQLException {
        Hashtable hashtable2 = null;
        try {
            block10: {
                try {
                    CIMInstance cIMInstance = ((StorageDeviceData)objectArray[0]).getInstance("");
                    String string2 = String.valueOf((String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"Name")) + "/" + (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"ElementName");
                    hashtable2 = new Hashtable();
                    if (cIMInstance != null) {
                        Object object;
                        Hashtable hashtable3 = CIMInstanceHelper.changeCIMInstanceToHashtable((CIMInstance)cIMInstance);
                        hashtable3.putAll(hashtable);
                        CIMInstance cIMInstance2 = ((StorageDeviceData)objectArray[0]).getInstance("physicalpackage");
                        if (cIMInstance2 != null && (object = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance2, (String)"SerialNumber")) != null) {
                            hashtable3.put("SerialNumber", object);
                        }
                        logTraceHelper.traceInfo("SaveSubSystem Name: " + string2 + " SMIS:" + ((StorageDeviceData)objectArray[0]).getSMISVersion() + " CIMOM Version:" + ((String[])this.cParameters.get("CIMOM"))[5]);
                        ((StorageDeviceData)objectArray[0]).addAccessInfo(hashtable3);
                        this.cDiskCimProcessor.setSMISVersion(((StorageDeviceData)objectArray[0]).getSMISVersion());
                        this.cDiskCimProcessor.setInstrumentationVersion(((String[])this.cParameters.get("CIMOM"))[5]);
                        hashtable3.put("originalcimclassname", "CIM_ComputerSystem");
                        object = CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"Dedicated");
                        if (object != null) {
                            String string3 = object.toString();
                            this.cDiskCimProcessor.setDedicated(string3);
                            MapperResult mapperResult = this.cDiskCimProcessor.handleEntity("", cIMInstance.getClassName(), hashtable3);
                            hashtable2 = mapperResult.getKeyReferences();
                            logTraceHelper.traceInfo("saveProduct");
                            logTraceHelper.logMsg("HWN021725I", new Object[]{string2, ((String[])this.cParameters.get("CIMOM"))[0]});
                            break block10;
                        } else {
                            logTraceHelper.traceInfo("No dedicated field available!");
                        }
                        break block10;
                    }
                    logTraceHelper.traceInfo("No Subsystem available!");
                }
                catch (org.eclipse.aperi.discovery.interfaces.DiscoveryException discoveryException) {
                    if (discoveryException.getCause() instanceof SQLException) {
                        throw (SQLException)discoveryException.getCause();
                    }
                    logTraceHelper.traceInfo("not handeled " + discoveryException.getCause().getMessage());
                }
            }
            Object var14_17 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.cDiskCimProcessor.setDedicated(null);
            throw throwable;
        }
        this.cDiskCimProcessor.setDedicated(null);
        return hashtable2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getCapabilitiesOfDevice(CIMInstance cIMInstance, StorageDeviceData storageDeviceData) throws DiscoveryException {
        String string = "getCapabilitiesOfDevice";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)string, (Object[])new Object[]{cIMInstance, storageDeviceData});
        CIMInstance cIMInstance2 = null;
        try {
            if ("Array".equalsIgnoreCase(storageDeviceData.getProfile()) || "In Band Virtualization".equalsIgnoreCase(storageDeviceData.getProfile())) {
                Response response;
                Enumeration enumeration;
                this.cParameters.put("IN_SYSTEM_CAPABILITIES", cIMInstance);
                String[] stringArray = Router.getRouter().perform("CAPABILITIES", this.cParameters, new Integer(this.cRequest.getId()).toString());
                Router.getRouter().waitTilComplete(stringArray);
                JobInfo jobInfo = (JobInfo)JobEngine.getInstance().getJobs(stringArray[1]).get(0);
                if (!jobInfo.isSuccessful()) {
                    this.checkJobSuccessful(string, logTraceHelper, jobInfo, "CONFIGURATIONSERVICE");
                }
                if ((enumeration = (Enumeration)(response = jobInfo.getResponse()).getData()).hasMoreElements()) {
                    cIMInstance2 = (CIMInstance)enumeration.nextElement();
                    Capabilities capabilities = storageDeviceData.getCapabilities();
                    capabilities.insertCapabilities(cIMInstance2, this.cRequest);
                    storageDeviceData.setCapabilities(capabilities);
                    if (storageDeviceData.getSMISVersion().compareToIgnoreCase("1.1.0") == 0) {
                        logTraceHelper.traceInfo("Capabilities for 1.1.0");
                        storageDeviceData.setCapabilities(this.getCapabilitiesOfDeviceFor_110(cIMInstance, capabilities));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        logTraceHelper.exit(null);
    }

    public void checkJobSuccessful(String string, LogTraceHelper logTraceHelper, JobInfo jobInfo, String string2) throws DiscoveryException {
        DiscoveryException discoveryException = null;
        Throwable throwable = null;
        Object object = jobInfo.getResponse().getData();
        if (object instanceof CIMException) {
            throwable = (Throwable)((CIMExceptionResponse)jobInfo.getResponse()).getData();
        } else if (object instanceof DiskManagerRTException) {
            Throwable throwable2 = (Throwable)((CIMExceptionResponse)jobInfo.getResponse()).getData();
            while (throwable2.getCause() != null) {
                if ((throwable2 = throwable2.getCause()) instanceof CIMException) {
                    throwable = throwable2;
                    break;
                }
                throwable = null;
            }
        } else {
            logTraceHelper.traceInfo("No instance of CIMException");
            throwable = null;
        }
        if (throwable != null && throwable instanceof CIMTransportException || throwable != null && throwable instanceof CIMException && throwable.getMessage().indexOf("UNABLE_TO_CONNECT") > 0) {
            logTraceHelper.traceError("CIMOM connection Failure", throwable);
            discoveryException = DiscoveryMessageHelper.getDiscoveryException((String)(String.valueOf(string) + string2), (String)"HWN021537E", (String[])new String[]{((String[])this.cParameters.get("CIMOM"))[0], throwable.getMessage()}, (JobInfo)jobInfo, (LogTraceHelper)logTraceHelper);
        } else if (throwable != null && throwable instanceof CIMAuthenticationException) {
            logTraceHelper.traceError("CIMOM authentication Failure", throwable);
            discoveryException = DiscoveryMessageHelper.getDiscoveryException((String)(String.valueOf(string) + string2), (String)"HWN021538E", (String[])new String[]{(String)this.cParameters.get("USERID"), ((String[])this.cParameters.get("CIMOM"))[0], throwable.getMessage()}, (JobInfo)jobInfo, (LogTraceHelper)logTraceHelper);
        } else if (throwable != null && throwable instanceof CIMException && throwable.getMessage().indexOf("ERR_TIME_OUT") > 0) {
            logTraceHelper.traceError("CIMOM timout Failure", throwable);
            discoveryException = DiscoveryMessageHelper.getDiscoveryException((String)(String.valueOf(string) + string2), (String)"HWN021650E", (String[])new String[]{((String[])this.cParameters.get("CIMOM"))[0]}, (JobInfo)jobInfo, (LogTraceHelper)logTraceHelper);
        } else if (object != null && object instanceof DiskManagerTimeoutException) {
            logTraceHelper.traceError("CIMOM timout Failure", throwable);
            discoveryException = DiscoveryMessageHelper.getDiscoveryException((String)(String.valueOf(string) + string2), (String)"HWN021650E", (String[])new String[]{((String[])this.cParameters.get("CIMOM"))[0]}, (JobInfo)jobInfo, (LogTraceHelper)logTraceHelper);
        } else if (throwable != null && throwable instanceof CIMException) {
            logTraceHelper.traceError("CIMOM timout Failure", throwable);
            discoveryException = DiscoveryMessageHelper.getDiscoveryException((String)(String.valueOf(string) + string2), (String)"HWN021529E", (String[])new String[]{((String[])this.cParameters.get("CIMOM"))[0]}, (JobInfo)jobInfo, (LogTraceHelper)logTraceHelper);
        } else {
            discoveryException = DiscoveryMessageHelper.getDiscoveryException((String)(String.valueOf(string) + string2), (String)"HWN021503E", (String[])new String[0], (JobInfo)jobInfo, (LogTraceHelper)logTraceHelper);
        }
        throw discoveryException;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Capabilities getCapabilitiesOfDeviceFor_110(CIMInstance cIMInstance, Capabilities capabilities) throws DiscoveryException {
        String string = "getCapabilitiesOfDeviceFor_110";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)string, (Object[])new Object[]{cIMInstance, capabilities});
        try {
            Response response;
            Enumeration enumeration;
            CIMInstance cIMInstance2 = null;
            this.cParameters.put("IN_SYSTEM_CONFIGURATIONSERVICE", cIMInstance);
            String[] stringArray = Router.getRouter().perform("CONFIGURATIONSERVICE", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(stringArray);
            JobInfo jobInfo = (JobInfo)JobEngine.getInstance().getJobs(stringArray[1]).get(0);
            if (!jobInfo.isSuccessful()) {
                this.checkJobSuccessful(string, logTraceHelper, jobInfo, "CONFIGURATIONSERVICE");
            }
            if ((enumeration = (Enumeration)(response = jobInfo.getResponse()).getData()).hasMoreElements()) {
                cIMInstance2 = (CIMInstance)enumeration.nextElement();
                this.cParameters.put("IN_SYSTEM_CONFIGURATIONCAPABILITIES", cIMInstance2);
                stringArray = Router.getRouter().perform("CONFIGURATIONCAPABILITIES", this.cParameters, new Integer(this.cRequest.getId()).toString());
                Router.getRouter().waitTilComplete(stringArray);
                jobInfo = (JobInfo)JobEngine.getInstance().getJobs(stringArray[1]).get(0);
                if (!jobInfo.isSuccessful()) {
                    this.checkJobSuccessful(string, logTraceHelper, jobInfo, "CONFIGURATIONCAPABILITIES");
                }
                response = jobInfo.getResponse();
                enumeration = (Enumeration)response.getData();
                while (enumeration.hasMoreElements()) {
                    Vector vector;
                    Vector vector2;
                    cIMInstance2 = (CIMInstance)enumeration.nextElement();
                    Vector vector3 = (Vector)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance2, (String)"SupportedStoragePoolFeatures");
                    if (vector3 == null) {
                        vector3 = new Vector();
                    }
                    if ((vector2 = (Vector)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance2, (String)"SupportedSynchronousActions")) == null) {
                        vector2 = new Vector();
                    }
                    if ((vector = (Vector)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance2, (String)"SupportedAsynchronousActions")) != null) {
                        vector2.addAll(vector);
                    }
                    if (vector3.contains(new UnsignedInt16(3)) || vector2.contains(new UnsignedInt16(5))) {
                        capabilities.setVolumeCreationSupported(true);
                        logTraceHelper.traceInfo("Capabilities set volumecreation true");
                    } else {
                        capabilities.setVolumeCreationSupported(false);
                        logTraceHelper.traceInfo("Capabilities set volumecreation false");
                    }
                    if (vector2.contains(new UnsignedInt16(6))) {
                        capabilities.setVolumeDeletionSupported(true);
                        logTraceHelper.traceInfo("Capabilities set volume deletion true");
                    } else {
                        capabilities.setVolumeDeletionSupported(false);
                        logTraceHelper.traceInfo("Capabilities set volume deletion false");
                    }
                    capabilities = this.handleCapabilitiesByVendorSpecificCapabilityInstance(capabilities, cIMInstance2);
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            logTraceHelper.exit((Object)capabilities);
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        logTraceHelper.exit((Object)capabilities);
        return capabilities;
    }

    protected Capabilities handleCapabilitiesByVendorSpecificCapabilityInstance(Capabilities capabilities, CIMInstance cIMInstance) {
        return capabilities;
    }

    protected void getSpecificDataForDevice(CIMInstance cIMInstance, StorageDeviceData storageDeviceData) throws DiscoveryException {
    }

    protected void getSpecificDataForNode(CIMInstance cIMInstance, StorageDeviceData storageDeviceData) throws DiscoveryException {
    }

    protected void saveSpecificData(StorageDeviceData storageDeviceData, LogTraceHelper logTraceHelper, MapperRouter mapperRouter, String string, String string2, Hashtable hashtable) throws SQLException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isUsedProfile(CIMInstance cIMInstance) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"isUsedProfile", (Object[])new Object[]{cIMInstance});
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            if (cIMInstance == null) {
                string3 = " CIMInstance was null!  ";
            } else {
                string = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"RegisteredName");
                string2 = (String)this.cParameters.get("Type");
                if ((string.indexOf("Array") >= 0 || string.indexOf("In Band Virtualization") >= 0) && (this.isComputersystemType() || this.isAllType()) || string.indexOf("Switch") >= 0 && (this.isSwitchType() || this.isAllType()) || string.indexOf("Storage Library") >= 0 && (this.isTapeLibraryType() || this.isAllType())) {
                    string3 = " is used for type ";
                    Object var6_7 = null;
                    logTraceHelper.exit((Object)(String.valueOf(string) + string3 + string2));
                    return true;
                }
                string3 = " is not used for type ";
            }
            Object var6_6 = null;
            logTraceHelper.exit((Object)(String.valueOf(string) + string3 + string2));
            return false;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            logTraceHelper.exit((Object)(String.valueOf(string) + string3 + string2));
            throw throwable;
        }
    }

    protected boolean supportsSubProfile(String string, String string2) {
        boolean bl;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"supportsSubProfile", (Object[])new Object[]{string, string2});
        boolean bl2 = false;
        try {
            bl2 = string != null && string.indexOf(string2) >= 0;
            bl = bl2;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            logTraceHelper.exit((Object)new Boolean(bl2));
            throw throwable;
        }
        logTraceHelper.exit((Object)new Boolean(bl2));
        return bl;
    }

    protected Capabilities correctCapabilities(StorageDeviceData storageDeviceData) {
        return storageDeviceData.getCapabilities();
    }

    protected String correctSubProfileString(String string) {
        return string;
    }

    public final boolean isTapeLibraryType() {
        String string = (String)this.cParameters.get("Type");
        return string.equals("ToplevelLibrary");
    }

    public final boolean isAllType() {
        String string = (String)this.cParameters.get("Type");
        return string.equals("ToplevelALL");
    }

    public final boolean isComputersystemType() {
        String string = (String)this.cParameters.get("Type");
        return string.equals("ToplevelStorageSubsystem");
    }

    public final boolean isSwitchType() {
        String string = (String)this.cParameters.get("Type");
        return string.equals("ToplevelSwitch");
    }

    protected boolean checkCIMOMVersion(String string) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"ProcessPlugin.checkCIMOMVersion", (Object[])new Object[]{string});
        boolean bl = true;
        logTraceHelper.exit((Object)new Boolean(bl));
        return bl;
    }

    protected String readRegExForCIMOMExclusion(String string, LogTraceHelper logTraceHelper) {
        String string2 = null;
        DBConnection dBConnection = null;
        try {
            dBConnection = ServiceUtils.getConnection();
            ConfigData configData = ParameterHelper.readConfigData((DBConnection)dBConnection, (String)string, (LogTraceHelper)logTraceHelper);
            if (configData != null) {
                string2 = configData.getValue();
            } else {
                logTraceHelper.traceInfo("readRegExForCIMOMExclusion is not used for type :" + string);
            }
        }
        catch (Throwable throwable) {}
        if (dBConnection != null) {
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException) {}
        }
        return string2;
    }

    protected String readCimomExclusion(LogTraceHelper logTraceHelper) {
        return "";
    }
}

