/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.discovery.DiscoveryException;
import org.eclipse.aperi.disk.discovery.ProcessPlugin;
import org.eclipse.aperi.disk.discovery.StorageDeviceData;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.UnsignedInt16;

public class SwitchDiscoveryProcessPlugin
extends ProcessPlugin {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SwitchDiscoveryProcessPlugin() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"SwitchDiscoveryProcessPlugin", null);
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.disk.discovery.SwitchDiscoveryProcessPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            logTraceHelper.objectCreation(clazz.getName());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List collectDeviceData(String string, String string2) throws DiscoveryException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"collectDeviceData", (Object[])new Object[]{string});
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        boolean bl = string != null;
        String string3 = null;
        try {
            try {
                List list = this.getEnumeratedSystems();
                string3 = this.cObjectJob.getResourceId();
                this.cObjectJob.getResponse();
                this.handleComputerSystem(linkedList, null, null, list);
                Iterator iterator = linkedList.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    Object[] objectArray = (Object[])iterator.next();
                    ++n;
                    this.getProductOfSystem((CIMInstance)objectArray[1], (StorageDeviceData)objectArray[0], false);
                    this.getSAPForSystem((CIMInstance)objectArray[1], (StorageDeviceData)objectArray[0]);
                    this.getFCPortsOfSystem((CIMInstance)objectArray[1], (StorageDeviceData)objectArray[0]);
                    this.getSoftwareOfDevice((CIMInstance)objectArray[1], (StorageDeviceData)objectArray[0]);
                    this.getSpecificDataForDevice((CIMInstance)objectArray[1], (StorageDeviceData)objectArray[0]);
                    logTraceHelper.traceInfo("NameSpace :" + ((StorageDeviceData)objectArray[0]).getNameSpace());
                    logTraceHelper.traceInfo(((StorageDeviceData)objectArray[0]).getDebugString());
                    this.saveAllInformation(linkedList2, string3, objectArray);
                }
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            logTraceHelper.traceInfo("Ready");
            logTraceHelper.exit(linkedList2);
            throw throwable;
        }
        {
            Object var11_14 = null;
        }
        logTraceHelper.traceInfo("Ready");
        logTraceHelper.exit(linkedList2);
        return linkedList2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveAllInformation(List list, String string, Object[] objectArray) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"saveAllInformation", (Object[])new Object[]{list, string, objectArray});
        this.cDiskCimProcessor.setDBReferences(new Hashtable());
        try {
            Hashtable hashtable = this.saveNameSpace(logTraceHelper, this.getMapperRouter(), string, ((StorageDeviceData)objectArray[0]).getNameSpace(), ((StorageDeviceData)objectArray[0]).getCIMOMVersion());
            Hashtable hashtable2 = this.saveSubSystem(objectArray, logTraceHelper, this.getMapperRouter(), string, hashtable);
            if (hashtable2.size() > 0) {
                hashtable2.putAll(hashtable);
                this.saveProduct(objectArray, logTraceHelper, this.getMapperRouter(), string, hashtable2);
                this.saveNodes(objectArray, logTraceHelper, this.getMapperRouter(), string, hashtable2);
                this.saveSoftware(objectArray, logTraceHelper, this.getMapperRouter(), string, hashtable2);
                this.saveSpecificData((StorageDeviceData)objectArray[0], logTraceHelper, this.getMapperRouter(), ((StorageDeviceData)objectArray[0]).getSMISVersion(), string, hashtable2);
                this.saveFCPorts(objectArray, logTraceHelper, this.getMapperRouter(), string, hashtable2);
                this.cDiskCimProcessor.doCommit(logTraceHelper);
                Vector vector = (Vector)CIMInstanceHelper.getCIMProperyValue((CIMInstance)((CIMInstance)objectArray[1]), (String)"Dedicated");
                if (((StorageDeviceData)objectArray[0]).getProfile() != null && ((StorageDeviceData)objectArray[0]).getProfile().indexOf("Switch") >= 0 || vector != null && (vector.contains(DiscoveryConstants.DEDICATED_SWITCH) || vector.contains(DiscoveryConstants.DEDICATED_L3SWITCH) || vector.contains(DiscoveryConstants.DEDICATED_OFFICESWITCH))) {
                    CIMOMSelector.getSelector().activateCimomForSwitch(Integer.parseInt((String)hashtable2.get("ref_toplevelsystem_cimom2namespaceid")), (String)hashtable2.get("ref_switch_wwn"));
                    list.add((StorageDeviceData)objectArray[0]);
                } else {
                    logTraceHelper.traceWarning("Not a switch profile or a computer system dedicated as switch");
                }
            } else {
                logTraceHelper.traceInfo("No additional info returned for SaveSubsystem");
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List getEnumeratedSystems() throws DiscoveryException {
        String string = "getEnumeratedSystems";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)string, (Object[])new Object[0]);
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        CIMInstance cIMInstance = null;
        try {
            String[] stringArray = Router.getRouter().perform("ENUM_COMPUTERSYSTEM", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(stringArray);
            JobInfo jobInfo = (JobInfo)JobEngine.getInstance().getJobs(stringArray[1]).get(0);
            if (!jobInfo.isSuccessful()) {
                this.checkJobSuccessful(string, logTraceHelper, jobInfo, "ENUM_COMPUTERSYSTEM");
            }
            this.cObjectJob = jobInfo;
            Response response = jobInfo.getResponse();
            Enumeration enumeration = (Enumeration)response.getData();
            while (enumeration.hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
                Vector vector2 = (Vector)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"Dedicated");
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)vector2.get(0);
                if (unsignedInt16.intValue() == 5) {
                    vector.add(cIMInstance);
                    continue;
                }
                logTraceHelper.traceInfo("Not used dedicated field");
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            logTraceHelper.exit(vector);
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        logTraceHelper.exit(vector);
        return vector;
    }
}

