/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;

public class PoolIndicationHandler
extends CIMIndicationHandler {
    public static final String GENERIC_CLASS = "CIM_StoragePool";

    public PoolIndicationHandler(String string, String string2, CIMIndicationEvent cIMIndicationEvent) {
        super(string, string2, cIMIndicationEvent);
    }

    public HandlingResult handle(LogTraceHelper logTraceHelper, String string) {
        return null;
    }

    protected CIMInstance getTopLevelSystemInstance(CIMInstance cIMInstance) throws CIMException, DiskManagerTimeoutException {
        block4: {
            Enumeration enumeration;
            Enumeration enumeration2;
            CIMInstance cIMInstance2;
            LogTraceHelper logTraceHelper;
            block5: {
                CIMInstance cIMInstance3;
                logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"getTopLevelSystemInstance", (Object[])new Object[]{cIMInstance});
                cIMInstance2 = null;
                try {
                    enumeration2 = this.getEvent().getCIMClient().associators(cIMInstance.getObjectPath(), "CIM_HostedStoragePool", "CIM_System", "PartComponent", "GroupComponent", false, false, null, logTraceHelper);
                    if (!enumeration2.hasMoreElements()) break block4;
                    cIMInstance2 = (CIMInstance)enumeration2.nextElement();
                    enumeration = this.getEvent().getCIMClient().associatorNames(cIMInstance2.getObjectPath(), "CIM_ElementConformsToProfile", "CIM_RegisteredProfile", "ManagedElement", "ConformantStandard", logTraceHelper);
                    if (!enumeration.hasMoreElements()) break block5;
                    cIMInstance3 = cIMInstance2;
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    logTraceHelper.exit(cIMInstance2);
                    throw throwable;
                }
                logTraceHelper.exit((Object)cIMInstance2);
                return cIMInstance3;
            }
            enumeration2 = this.getEvent().getCIMClient().associators(cIMInstance2.getObjectPath(), "CIM_ComponentCS", "CIM_ComputerSystem", "PartComponent", "GroupComponent", false, false, null, logTraceHelper);
            if (!enumeration2.hasMoreElements()) break block4;
            cIMInstance2 = (CIMInstance)enumeration2.nextElement();
            enumeration = this.getEvent().getCIMClient().associatorNames(cIMInstance2.getObjectPath(), "CIM_ElementConformsToProfile", "CIM_RegisteredProfile", "ManagedElement", "ConformantStandard", logTraceHelper);
            if (!enumeration.hasMoreElements()) break block4;
            CIMInstance cIMInstance4 = cIMInstance2;
            Object var6_9 = null;
            logTraceHelper.exit((Object)cIMInstance2);
            return cIMInstance4;
        }
        throw new RuntimeException("Cannot detect TopLevelComputerSystem");
    }

    protected static StoragePool getPool(DBConnection dBConnection, String string, int[] nArray, String string2) throws SQLException {
        int n = 0;
        while (n < nArray.length) {
            StoragePool storagePool = new StoragePool();
            storagePool.setInstanceId(string);
            storagePool.setSubsystemId(nArray[n]);
            storagePool.setClassName(string2);
            if (storagePool.retrieve(dBConnection)) {
                return storagePool;
            }
            ++n;
        }
        return null;
    }

    protected static int[] getAffectedVolumes(DBConnection dBConnection, StoragePool storagePool) throws SQLException {
        int[] nArray;
        block4: {
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(TResStorageVolumeTable.getColumnInfo((String)"POOL_ID"), new Integer(storagePool.getPoolId()).toString());
            String string = "SELECT SVID FROM " + TResStorageVolumeTable.getTablename() + " WHERE " + "POOL_ID" + " = (?)";
            DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string, hashtable);
            try {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                while (dBResultSet.next()) {
                    arrayList.add(new Integer(dBResultSet.getInt(1)));
                }
                int[] nArray2 = new int[arrayList.size()];
                int n = 0;
                while (n < nArray2.length) {
                    nArray2[n] = (Integer)arrayList.get(n);
                    ++n;
                }
                nArray = nArray2;
                Object var8_9 = null;
                if (dBResultSet == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var8_10 = null;
                    if (dBResultSet == null) break block5;
                    dBResultSet.closeAll();
                }
                throw throwable;
            }
            dBResultSet.closeAll();
        }
        return nArray;
    }

    protected static void detachExtents(DBConnection dBConnection, StoragePool storagePool) throws SQLException {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(TResStorageExtentTable.getColumnInfo((String)"POOL_ID"), new Integer(storagePool.getPoolId()).toString());
        String string = "UPDATE " + TResStorageExtentTable.getTablename() + " SET " + "POOL_ID" + " = CAST(NULL AS INTEGER) WHERE " + "POOL_ID" + " = (?)";
        ComplexQuery.sqlUpdate((DBConnection)dBConnection, (String)string, hashtable);
    }

    public static int changeDetectableAttributeForStoragePool(DBConnection dBConnection, String string, Integer n) throws SQLException {
        if (!string.equals("0") && !string.equals("1")) {
            return 0;
        }
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(TResStoragePoolTable.getColumnInfo((String)"DETECTABLE"), n.toString());
        String string2 = "UPDATE " + TResStoragePoolTable.getTablename() + " SET " + "DETECTABLE" + " = " + string + " WHERE " + "POOL_ID" + " = (?)";
        return ComplexQuery.sqlUpdate((DBConnection)dBConnection, (String)string2, hashtable);
    }
}

