/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.DiscoveryActivator;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.interfaces.DiscoverRequest;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMTransportException;

public abstract class DiscoverProcess
implements Cloneable,
IDiscoverProcess {
    private DiscoverRequest cRequest = null;
    private String cDescription = null;
    private boolean cIsMainProcess = false;

    public DiscoverProcess(String string, boolean bl, String[] stringArray, String[] stringArray2) {
        this.cRequest = new DiscoverRequest(string, stringArray, stringArray2);
        this.cDescription = string;
        this.cIsMainProcess = bl;
    }

    protected IDiscoverRouterService getDiscoverRouterService() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (IDiscoverRouterService)DiscoveryActivator._serviceHelper.bindLocalOSGiService(clazz.getName());
    }

    public DiscoverRequest getRequest() {
        return this.cRequest;
    }

    public boolean isMainProcess() {
        return this.cIsMainProcess;
    }

    public String getDescription() {
        return this.cDescription;
    }

    public String[] getParameterNames() {
        Map map = this.cRequest.getParameters();
        return map.keySet().toArray(new String[map.size()]);
    }

    public String getParameterType(String string) {
        return this.cRequest.getParameterType(string);
    }

    public abstract Result process(Request var1, Map var2) throws ParameterException, Exception;

    public Object getParameter(String string) {
        return this.cRequest.getParameter(string);
    }

    public static Object getParameter(Map map, String string, String string2) throws ParameterException {
        Object v = map.get(string);
        if (v == null) {
            throw new ParameterException("Parameter " + string + " is missing.");
        }
        try {
            if (!Class.forName(string2).isInstance(v)) {
                throw new ParameterException("Parameter " + string + "(" + v.getClass().getName() + ") is not of type " + string2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParameterException("Class named " + string2 + " is not defined");
        }
        return v;
    }

    public boolean checkParameters(Map map) throws ParameterException {
        Map map2 = this.cRequest.getParameters();
        if (map2.size() != map.size()) {
            throw new ParameterException("Not all parameters are specified.");
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            DiscoverProcess.getParameter(map, string, string2);
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DiscoverProcess: " + this.cDescription + "\n");
        Map map = this.cRequest.getParameters();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            stringBuffer.append("   " + string + " of type " + string2 + "\n");
        }
        return stringBuffer.toString();
    }

    public String getScannerId(Map map) throws ParameterException {
        return null;
    }

    public int getAuthoritativeReferenceType(Map map) throws ParameterException {
        return -1;
    }

    public int getAuthoritativeReferenceId(Map map) throws ParameterException {
        return -1;
    }

    public String getProcessInfoForJobLog(Map map) {
        return null;
    }

    public String getComputerForJobLog(Map map) {
        return null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void checkException(Throwable throwable, LogTraceHelper logTraceHelper, Map map) {
        if (throwable != null) {
            if (throwable instanceof CIMException) {
                if (throwable.getMessage().indexOf("ERR_TIME_OUT") > 0) {
                    logTraceHelper.traceError("CIMOM timout Failure", throwable);
                    logTraceHelper.logMsg("HWN021650E", new Object[]{((String[])map.get("CIMOM"))[0]});
                } else if (throwable instanceof CIMTransportException) {
                    logTraceHelper.traceError("CIMOM Connection Failure", throwable);
                    logTraceHelper.logMsg("HWN021537E", new Object[]{((String[])map.get("CIMOM"))[0], throwable.getMessage()});
                } else {
                    logTraceHelper.traceError("CIMOM Exception", throwable);
                    logTraceHelper.logMsg("HWN021529E", new Object[]{((String[])map.get("CIMOM"))[0]});
                }
            } else if (throwable instanceof DiskManagerTimeoutException) {
                logTraceHelper.traceError("CIMOM timout Failure", throwable);
                logTraceHelper.logMsg("HWN021650E", new Object[]{((String[])map.get("CIMOM"))[0]});
            } else {
                Throwable throwable2;
                Throwable throwable3 = throwable2 = throwable.getCause();
                while (throwable3 != null && !(throwable3 instanceof CIMException)) {
                    throwable3 = throwable3.getCause();
                }
                if (throwable3 != null) {
                    throwable2 = throwable3;
                }
                if (throwable2 != null) {
                    if (throwable2 instanceof CIMException) {
                        if (throwable.getMessage().indexOf("ERR_TIME_OUT") > 0) {
                            logTraceHelper.traceError("CIMOM timout Failure", throwable2);
                            logTraceHelper.logMsg("HWN021650E", new Object[]{((String[])map.get("CIMOM"))[0]});
                        } else if (throwable.getMessage().indexOf("EXT_ERR_UNABLE_TO_CONNECT") > 0) {
                            logTraceHelper.traceError("CIMOM connection Failure", throwable2);
                            logTraceHelper.logMsg("HWN021537E", new Object[]{((String[])map.get("CIMOM"))[0], throwable2.getMessage()});
                        } else if (throwable2 instanceof CIMTransportException) {
                            logTraceHelper.traceError("CIMOM Connection Failure", throwable2);
                            logTraceHelper.logMsg("HWN021537E", new Object[]{((String[])map.get("CIMOM"))[0], throwable2.getMessage()});
                        } else {
                            logTraceHelper.traceError("CIMOM Exception", throwable2);
                            logTraceHelper.logMsg("HWN021529E", new Object[]{((String[])map.get("CIMOM"))[0]});
                        }
                    } else if (throwable2 instanceof DiskManagerTimeoutException) {
                        logTraceHelper.traceError("CIMOM timout Failure", throwable2);
                        logTraceHelper.logMsg("HWN021650E", new Object[]{((String[])map.get("CIMOM"))[0]});
                    } else {
                        logTraceHelper.traceError("Unexpected error ", throwable2);
                        logTraceHelper.logMsg("HWN021503E", null);
                    }
                } else {
                    logTraceHelper.traceError("Unexpected error ", throwable);
                    logTraceHelper.logMsg("HWN021503E", null);
                }
            }
        }
    }

    public static class RegistrationData {
        private String mName;
        private String mSmisVersion;
        private String mProfile;
        private String mVendor;
        private String mModel;
        private String mInstrumentationVersion;

        public RegistrationData(String string, String string2, String string3, String string4, String string5, String string6) {
            if (string == null || string.trim().length() == 0) {
                throw new NullPointerException("Name must be neither null nor whitespace only.");
            }
            this.mName = string;
            this.mSmisVersion = string2;
            this.mProfile = string3;
            this.mVendor = string4;
            this.mModel = string5;
            this.mInstrumentationVersion = string6;
        }

        public String getInstrumentationVersion() {
            return this.mInstrumentationVersion;
        }

        public String getModel() {
            return this.mModel;
        }

        public String getName() {
            return this.mName;
        }

        public String getProfile() {
            return this.mProfile;
        }

        public String getSmisVersion() {
            return this.mSmisVersion;
        }

        public String getVendor() {
            return this.mVendor;
        }

        public boolean equals(Object object) {
            if (object instanceof RegistrationData) {
                RegistrationData registrationData = (RegistrationData)object;
                return this.mName.equals(registrationData.mName) && this.mSmisVersion.equals(registrationData.mSmisVersion) && this.mProfile.equals(registrationData.mProfile) && this.mVendor.equals(registrationData.mVendor) && this.mModel.equals(registrationData.mModel) && this.mInstrumentationVersion.equals(registrationData.mInstrumentationVersion);
            }
            return false;
        }
    }
}

