/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi;

import java.util.ArrayList;
import org.eclipse.aperi.discovery.DiscoveryActivator;
import org.eclipse.aperi.interfaces.IDiscover;

public class JobMonitor
implements Runnable {
    private static IDiscover discoverProxy = null;
    private static JobMonitor jobMonitor;
    private static Thread runner;
    private static ArrayList jobsToMonitor;
    private boolean shutdown = false;

    static {
        runner = null;
        jobsToMonitor = new ArrayList();
    }

    private JobMonitor() {
        if (discoverProxy == null) {
            discoverProxy = (IDiscover)DiscoveryActivator._serviceHelper.bindLocal("DiscoverService");
        }
    }

    public static JobMonitor getJobMonitor() {
        if (jobMonitor == null) {
            jobMonitor = new JobMonitor();
        }
        return jobMonitor;
    }

    public synchronized void monitor(String string) {
        if (this.shutdown) {
            return;
        }
        jobsToMonitor.add(string);
        if (runner == null) {
            runner = new Thread(this);
            runner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!jobsToMonitor.isEmpty() && !this.shutdown) {
            String string = null;
            JobMonitor jobMonitor = this;
            synchronized (jobMonitor) {
                string = (String)jobsToMonitor.remove(0);
            }
            if (string == null) continue;
            discoverProxy.waitTilComplete(string);
        }
        runner = null;
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

