/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi;

import com.ibm.log.Level;
import java.io.InvalidClassException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.JobLogDeletionHandler;
import org.eclipse.aperi.JobMonitor;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.interfaces.DiscoverRequest;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.UStack;
import org.eclipse.aperi.util.extensions.AbstractExtensionMgr;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public final class Router
extends AbstractExtensionMgr
implements Observer,
IDiscoverRouterService {
    public static final String MESSAGE_NAME = "aperi.logger.message.DiscoverRouter";
    public static final String TRACE_NAME = "aperi.logger.trace.DiscoverRouter";
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    public static String MSG_FILE;
    public static String className;
    public static int LOCK_WAIT_TIME;
    private static final String EXTENSION_POINT_ID = "org.eclipse.aperi.discovery.discoverProcess";
    public static final String ATTR_NAME = "DiscoverProcessName";
    public static final String ATTR_IMPL = "impl";
    public static final String ELEMENT_SMISREGISTRATIONDATA = "SMISRegistrationData";
    public static final String ATTR_SMISVERSION = "SMISVersion";
    public static final String ATTR_SMISPROFILE = "SMISProfile";
    public static final String ATTR_VENDOR = "Vendor";
    public static final String ATTR_MODEL = "Model";
    public static final String ATTR_SMISPROVIDERVERION = "SMISProviderVersion";
    private static final String ROOT = "ROOT";
    private static Router stRouter;
    private Map cProcessMap;
    private Map<String, IDiscoverProcess> cLegacyProcessMap;
    private Map cRequestMap;
    private Map cStepMap;
    Object lock = new Object();

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        MSG_FILE = "org.eclipse.aperi.resources.Router";
        try {
            clazz = Class.forName("org.eclipse.aperi.Router");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        LOCK_WAIT_TIME = 10000;
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
    }

    private static Map getInnerMap(Map map, String string) {
        Map map2;
        if (map.containsKey(string)) {
            map2 = (Map)map.get(string);
        } else {
            map2 = new HashMap();
            map.put(string, map2);
        }
        return map2;
    }

    public static synchronized Router getRouter() {
        if (stRouter == null) {
            stRouter = new Router();
            JobEngine.getInstance().addObserver((Observer)stRouter);
        }
        return stRouter;
    }

    private Router() {
        this.cProcessMap = new HashMap();
        this.cRequestMap = Collections.synchronizedMap(new HashMap());
        this.cLegacyProcessMap = Collections.synchronizedMap(new HashMap());
    }

    public void startup() {
        this.initialize();
        String[] stringArray = this.getAllExtensionIds();
        int n = 0;
        while (n < stringArray.length) {
            this.extensionAdded(stringArray[n]);
            ++n;
        }
    }

    public boolean cancel(String string) {
        JobMonitor.getJobMonitor().monitor(string);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.cProcessMap;
        synchronized (map) {
            this.cProcessMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findBestMatch(Map map, UStack uStack, MatchGauge matchGauge) {
        Map map2 = this.cProcessMap;
        synchronized (map2) {
            boolean bl;
            boolean bl2;
            String string;
            block8: {
                string = (String)uStack.pop();
                bl2 = map.containsKey(string);
                bl = map.containsKey(null);
                if (bl2 || bl) break block8;
                matchGauge.markMismatch();
                return null;
            }
            if (uStack.empty()) {
                if (!bl2) {
                    matchGauge.countGenericMatch();
                    return map.get(null);
                }
                matchGauge.countPreciseMatch();
                return map.get(string);
            }
            if (!bl2) {
                return this.findBestMatch((HashMap)map.get(null), uStack, matchGauge.countGenericMatch());
            }
            if (!bl) {
                return this.findBestMatch((HashMap)map.get(string), uStack, matchGauge.countPreciseMatch());
            }
            MatchGauge matchGauge2 = new MatchGauge();
            MatchGauge matchGauge3 = new MatchGauge();
            Object object = this.findBestMatch((HashMap)map.get(null), new UStack(uStack), matchGauge2.countGenericMatch());
            Object object2 = this.findBestMatch((HashMap)map.get(string), new UStack(uStack), matchGauge3.countPreciseMatch());
            matchGauge.concat(matchGauge3.less(matchGauge2) ? matchGauge2 : matchGauge3);
            return matchGauge3.less(matchGauge2) ? object : object2;
        }
    }

    public IDiscoverProcess findProcess(String string, Map map) {
        Object object;
        if (this.cLegacyProcessMap.containsKey(string)) {
            DiscoverProcess discoverProcess = (DiscoverProcess)((DiscoverProcess)this.cLegacyProcessMap.get(string)).clone();
            return discoverProcess;
        }
        if (map.get("CIMOM") == null) {
            int n = Integer.parseInt(map.get("DEVICEID").toString());
            object = CIMOMSelector.getSelector().getCimomForSubsystem(n);
            map.put("CIMOM", new String[]{object.getCimom().getServiceUrl(), object.getCimNamespace(), object.getCimom().getUserId(), object.getCimom().getPassword()});
            map.put("CAPABILITY", object.getCapability());
            map.put("TL_CS", object.getSubsystemCop());
            map.put("VENDOR", object.getSubsystem().getVendor());
            map.put("MODEL", object.getSubsystem().getModel());
            map.put("CIMOMSWLVL", object.getCimom().getSoftwareLevel());
        }
        UStack uStack = new UStack();
        uStack.push(map.get("CIMOMSWLVL"));
        uStack.push(map.get("MODEL"));
        uStack.push(map.get("VENDOR"));
        uStack.push((Object)((CapabilityData)map.get("CAPABILITY")).getSmisProfile());
        uStack.push((Object)((CapabilityData)map.get("CAPABILITY")).getSmisVersion());
        uStack.push((Object)string);
        object = this.findBestMatch(this.cProcessMap, uStack, new MatchGauge());
        IDiscoverProcess iDiscoverProcess = null;
        if (object != null) {
            try {
                Class<?> clazz;
                try {
                    clazz = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (object.getClass().getName().equals(clazz.getName())) {
                    iDiscoverProcess = (IDiscoverProcess)this.getExtensionImpl((String)object, false);
                } else {
                    Class clazz2 = (Class)object;
                    iDiscoverProcess = (IDiscoverProcess)clazz2.newInstance();
                    iDiscoverProcess.getRequest().setCommand(string);
                }
                return iDiscoverProcess;
            }
            catch (Exception exception) {
                traceLogger.exception(Level.ERROR, (Object)this, "findProcess", (Throwable)exception, "Exception during process creation for " + string + " with received object " + object.toString());
            }
        } else {
            traceLogger.text(Level.ERROR, (Object)this, "findProcess", "No process found for " + string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void finish(Request request, boolean bl, int n) {
        String string = "finish";
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFORMATION, (Object)className, string, "Router.finish " + request.getDeviceServerRunNumber() + ":" + request.getId() + ", status=" + bl + ", returnCode=" + n + "- request.isRunning=" + request.isRunning() + ", hasRunningChildRequests=" + request.hasRunningChildRequests() + ", Job status=" + JobEngine.getInstance().getJobStatus(Integer.toString(request.getId())));
        }
        Object object = request;
        synchronized (object) {
            if (!bl && request.getStatus() != 0) {
                request.setStatus(4);
                if (request.getReturnCode() == 0) {
                    request.setReturnCode(n);
                } else if (request.getReturnCode() < n) {
                    request.setReturnCode(n);
                }
            }
        }
        if (!request.isRunning() && !request.hasRunningChildRequests() && JobEngine.getInstance().getJobStatus(Integer.toString(request.getId())) == 2) {
            if (request.getStatus() == 2) {
                request.setStatus(1);
            }
            if (request.getParentRequest() != null && request.getParentRequest().getJobLogger() != null && request.getParentRequest().getJobLogger() != request.getJobLogger()) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.Router");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                request.getParentRequest().getJobLogger().message(IRecordType.TYPE_INFORMATION, (Object)clazz.getName(), "finish", "DiscoverJob_childJobFinished", (Object[])new String[]{new Integer(request.getId()).toString(), new Integer(request.getStatus()).toString(), new Integer(request.getReturnCode()).toString()});
            }
            if (!request.isNoJobManagement() && request.isMainProcess()) {
                ServiceUtils.updateJobRecord((int)Integer.parseInt(request.getDeviceServerRunNumber()), (int)request.getId(), (int)request.getStatus(), (int)request.getReturnCode());
            }
            if (request.isExternalJobLogger()) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.Router");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                request.getJobLogger().message(IRecordType.TYPE_INFORMATION, (Object)clazz.getName(), "finish", "DiscoverJob_jobFinished", (Object[])new String[]{request.getDeviceServerRunNumber(), new Integer(request.getId()).toString(), new Integer(request.getStatus()).toString(), new Integer(request.getReturnCode()).toString()});
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFORMATION, (Object)className, string, "Finished DiscoverProcess: RUN ID=" + request.getDeviceServerRunNumber() + ", Job ID=" + new Integer(request.getId()).toString() + ", Status =" + new Integer(request.getStatus()).toString() + ", Return Code=" + new Integer(request.getReturnCode()).toString());
            }
            if (request.isMainProcess()) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.Router");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                request.getJobLogger().message(IRecordType.TYPE_INFORMATION, (Object)clazz.getName(), "finish", "DiscoverJob_jobFinished", (Object[])new String[]{request.getDeviceServerRunNumber(), new Integer(request.getId()).toString(), new Integer(request.getStatus()).toString(), new Integer(request.getReturnCode()).toString()});
                if (!request.isExternalJobLogger()) {
                    LogManagerFactory.returnJobLogger((ILogger)request.getJobLogger());
                }
            }
            this.cRequestMap.remove(Integer.toString(request.getId()));
            JobEngine.getInstance().addFinishedRequests(request.getDeviceServerRunNumber(), Integer.toString(request.getId()));
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFORMATION, (Object)className, string, "Router.finished - " + request.getId());
            }
            if (request.getParentRequest() != null) {
                object = request.getParentRequest();
                synchronized (object) {
                    request.getParentRequest().removeChildRequest(request);
                }
                this.finish(request.getParentRequest(), request.getReturnCode() == 0, request.getReturnCode());
            } else {
                object = ServiceUtils.activeJobs.remove(request.getDeviceServerRunNumber());
                if (object != null) {
                    ServiceUtils.completedJobResults.put(request.getDeviceServerRunNumber(), object);
                } else {
                    AsyncResult asyncResult = ServiceUtils.getJobStatus((String)request.getDeviceServerRunNumber());
                    if (ServiceUtils.populateResults((AsyncResult)asyncResult, (boolean)true)) {
                        ServiceUtils.completedJobResults.put(request.getDeviceServerRunNumber(), asyncResult);
                    } else {
                        JobEngine.getInstance().cleanupRequestInformation(request.getDeviceServerRunNumber());
                    }
                }
            }
            object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    public DiscoverProcess.RegistrationData[] getRegisteredProcesses() {
        List list = this.recurseRequests(this.cProcessMap, new UStack());
        return list.toArray(new DiscoverProcess.RegistrationData[list.size()]);
    }

    public DiscoverProcess.RegistrationData[] getRegisteredProcessNames() {
        List list = this.recurseRequests(this.cProcessMap, new UStack());
        return list.toArray(new DiscoverProcess.RegistrationData[list.size()]);
    }

    public DiscoverProcess.RegistrationData[] getRegisteredSteps() {
        List list = this.recurseRequests(this.cStepMap, new UStack());
        return list.toArray(new DiscoverProcess.RegistrationData[list.size()]);
    }

    public List getRequests() {
        return this.getRequests(ROOT);
    }

    public List getRequests(String string) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ArrayList arrayList2 = (ArrayList)this.cRequestMap.get(string);
        if (arrayList2 != null) {
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Object[] objectArray = new Object[]{string2, this.getRequests(string2), JobEngine.getInstance().getJobs(string2)};
                arrayList.add(objectArray);
            }
        }
        return arrayList;
    }

    public Request getRequest(String string) {
        return (Request)this.cRequestMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getSupportedRequests() {
        HashMap<String, DiscoverRequest> hashMap = new HashMap<String, DiscoverRequest>();
        Map<String, IDiscoverProcess> map = this.cLegacyProcessMap;
        synchronized (map) {
            Iterator<Map.Entry<String, IDiscoverProcess>> iterator = this.cLegacyProcessMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, IDiscoverProcess> entry = iterator.next();
                hashMap.put(entry.getKey(), ((DiscoverProcess)entry.getValue()).getRequest());
            }
        }
        return hashMap;
    }

    public String[] perform(String string, Map map) {
        return this.perform(string, map, ROOT, false, null);
    }

    public String[] perform(String string, Map map, String string2) {
        return this.perform(string, map, string2, false, null);
    }

    public String[] perform(String string, Map map, boolean bl, ILogger iLogger) {
        return this.perform(string, map, ROOT, bl, iLogger);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] perform(String string, Map hashMap, String string2, boolean bl, ILogger iLogger) {
        String string3 = "perform";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3, new Object[]{string, hashMap, string2, new Boolean(bl), iLogger});
        }
        try {
            String string4;
            String[] stringArray;
            String string5;
            String string6;
            IDiscoverProcess iDiscoverProcess = this.findProcess(string, hashMap);
            if (iDiscoverProcess == null) {
                throw new IllegalArgumentException("Cannot process " + string);
            }
            Request request = (Request)this.cRequestMap.get(string2);
            boolean bl2 = bl || request != null && request.isNoJobManagement();
            boolean bl3 = !bl2 && (iDiscoverProcess.isMainProcess() || request == null);
            String string7 = null;
            string7 = request != null ? request.getDeviceServerRunNumber() : Integer.toString(ServiceUtils.getJobIdentifier((boolean)bl3, (int)7));
            String string8 = Integer.toString(ServiceUtils.getJobIdentifier((boolean)bl3, (int)2));
            String string9 = null;
            if (request != null) {
                string9 = request.getScannerId();
            }
            if (string9 == null) {
                string9 = iDiscoverProcess.getScannerId(hashMap);
            }
            int n = -1;
            if (request != null) {
                n = request.getAuthoritativeReferenceType();
            }
            if (n == -1) {
                n = iDiscoverProcess.getAuthoritativeReferenceType(hashMap);
            }
            int n2 = -1;
            if (request != null) {
                n2 = request.getAuthoritativeReferenceId();
            }
            if (n2 == -1) {
                n2 = iDiscoverProcess.getAuthoritativeReferenceId(hashMap);
            }
            if ((string6 = iDiscoverProcess.getProcessInfoForJobLog(hashMap)) == null) {
                string6 = string;
            }
            String string10 = null;
            Map map = ServiceUtils.getUserProperties();
            if (map.get("TPC_USER") != null) {
                String string11 = (String)map.get("TPC_USER");
                string5 = (String)map.get("TPC_JOBNAME");
                stringArray = this.getScheduleIdSidRunNumber((String)map.get("TPC_SCHEDULE_ID"));
                String string12 = null;
                if (stringArray != null) {
                    string12 = stringArray[0];
                }
                string4 = (String)map.get("TPC_DESCRIPTION");
                string10 = String.valueOf(string11 == null ? "" : string11) + "." + (string5 == null ? "" : string5) + "." + (string12 == null ? "" : string12) + "_" + (string4 == null ? "" : string4);
            } else if (request != null) {
                string10 = request.getJobPrefix();
            }
            if (string10 == null) {
                string10 = "msg";
            }
            boolean bl4 = false;
            if (iLogger != null) {
                bl4 = true;
            } else if (request != null && request.isExternalJobLogger()) {
                bl4 = true;
                iLogger = request.getJobLogger();
            } else {
                bl4 = false;
                if (bl3) {
                    try {
                        Class<?> clazz;
                        iLogger = LogManagerFactory.getJobLogger((String)string10, (String)string6, (String)string7, (String)string8);
                        try {
                            clazz = Class.forName("org.eclipse.aperi.disk.resources.DMJobMessages");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        iLogger.setMessageFile(clazz.getName());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (request != null) {
                    iLogger = request.getJobLogger();
                }
            }
            string5 = new Request(Integer.parseInt(string8), string7, request, iLogger, bl4, bl2, bl3, string9, n, n2, string10);
            this.cRequestMap.put(new Integer(string5.getId()).toString(), string5);
            if (hashMap == null) {
                hashMap = new HashMap();
            }
            if (bl3) {
                block58: {
                    ServiceUtils.createJobRecord((int)Integer.parseInt(string7), (int)Integer.parseInt(string8), (String)iDiscoverProcess.getDescription(), (String)LogManagerFactory.getLogFileName((ILogger)iLogger));
                    try {
                        map = ServiceUtils.getUserProperties();
                        if (map.get("TPC_USER") != null && (stringArray = this.getScheduleIdSidRunNumber((String)map.get("TPC_SCHEDULE_ID"))) != null) {
                            JobLogDeletionHandler.purgeLogFiles((int)Integer.parseInt(stringArray[0] == null ? "-9999" : stringArray[0]), (int)Integer.parseInt(stringArray[1] == null ? "-9999" : stringArray[1]));
                        }
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block58;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception);
                        traceLogger.text(IRecordType.TYPE_INFORMATION, (Object)className, string3, "Error during job log deletion : RUN ID=" + string7 + ", Job ID=" + string8 + ", Description =" + iDiscoverProcess.getDescription());
                    }
                }
                if (iLogger != null) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.Router");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    iLogger.message(IRecordType.TYPE_INFORMATION, (Object)clazz.getName(), "perform", "DiscoverJob_jobStarted", (Object[])new String[]{string7, string8, iDiscoverProcess.getDescription()});
                }
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFORMATION, (Object)className, string3, "Starting DiscoverProcess: RUN ID=" + string7 + ", Job ID=" + string8 + ", Description =" + iDiscoverProcess.getDescription());
            }
            if (request != null && request.getJobLogger() != null && request.getJobLogger() != iLogger) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.Router");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                request.getJobLogger().message(IRecordType.TYPE_INFORMATION, (Object)clazz.getName(), "perform", "DiscoverJob_childJobStarted", (Object[])new String[]{string8, iDiscoverProcess.getDescription()});
            }
            stringArray = new Result(0);
            try {
                block59: {
                    try {
                        stringArray = iDiscoverProcess.process((Request)string5, hashMap);
                        if (stringArray.getRc() != -1000 && stringArray.getRc() != -1001) {
                            if (ServiceUtils.activeJobs.contains(string7) || ServiceUtils.completedJobResults.contains(string7)) {
                                if (traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Error - AsyncResult set by process " + string + " but result RC=" + stringArray.getRc() + ", therefore results not populated into AsyncResult.");
                                }
                                break block59;
                            }
                            ServiceUtils.jobResults.put(String.valueOf(string7) + ":" + string8, stringArray);
                            break block59;
                        }
                        if (!ServiceUtils.activeJobs.contains(string7) && !ServiceUtils.completedJobResults.contains(string7) && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Error - AsyncResult not set by process " + string + "  but result RC indicates it was.");
                        }
                    }
                    catch (ParameterException parameterException) {
                        if (string5.getJobLogger() != null) {
                            string5.getJobLogger().message(IRecordType.TYPE_ERR, (Object)className, string3, "Router_Error", (Object)parameterException);
                        }
                        msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)parameterException);
                        if (traceLogger.isLogging()) {
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)parameterException);
                        }
                        throw new IllegalArgumentException(parameterException.getMessage());
                    }
                    catch (Exception exception) {
                        stringArray.setRc(1);
                        if (string5.getJobLogger() != null) {
                            string5.getJobLogger().message(IRecordType.TYPE_ERR, (Object)className, string3, "Router_Error", (Object)exception);
                        }
                        msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception);
                        if (traceLogger.isLogging()) {
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception);
                        }
                        ServiceUtils.jobExceptions.put(String.valueOf(string7) + ":" + string8, exception);
                    }
                }
                string4 = null;
            }
            catch (Throwable throwable) {
                string4 = null;
                string5.setRunning(false);
                int n3 = stringArray.getRc();
                if (n3 == -1000) {
                    n3 = 0;
                }
                if (n3 == -1001) {
                    n3 = 1;
                }
                this.finish((Request)string5, n3 == 0, n3);
                throw throwable;
            }
            string5.setRunning(false);
            int n4 = stringArray.getRc();
            if (n4 == -1000) {
                n4 = 0;
            }
            if (n4 == -1001) {
                n4 = 1;
            }
            this.finish((Request)string5, n4 == 0, n4);
            return new String[]{string7, string8};
        }
        catch (ServerException serverException) {
            throw serverException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List recurseRequests(Map map, UStack uStack) {
        ArrayList<DiscoverProcess.RegistrationData> arrayList = new ArrayList<DiscoverProcess.RegistrationData>();
        Map map2 = map;
        synchronized (map2) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                uStack.push(entry.getKey());
                if (entry.getValue() instanceof Map) {
                    arrayList.addAll(this.recurseRequests((Map)entry.getValue(), uStack));
                } else {
                    UStack uStack2 = new UStack(uStack);
                    String string = (String)uStack2.pop();
                    String string2 = (String)uStack2.pop();
                    String string3 = (String)uStack2.pop();
                    String string4 = (String)uStack2.pop();
                    String string5 = (String)uStack2.pop();
                    String string6 = (String)uStack2.pop();
                    DiscoverProcess.RegistrationData registrationData = new DiscoverProcess.RegistrationData(string6, string5, string4, string3, string2, string);
                    arrayList.add(registrationData);
                }
                uStack.pop();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerProcess(Class clazz) throws InvalidClassException {
        DiscoverProcess.RegistrationData[] registrationDataArray;
        Class<?> clazz2;
        Class clazz3 = clazz;
        do {
            if ((clazz3 = clazz3.getSuperclass()) == null) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.DiscoverProcess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                throw new InvalidClassException(clazz.getName(), "Class doesn't extend " + clazz4.getName());
            }
            try {
                clazz2 = Class.forName("org.eclipse.aperi.DiscoverProcess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (!clazz3.equals(clazz2));
        try {
            Method method = clazz.getMethod("getRegistrationData", new Class[0]);
            registrationDataArray = (DiscoverProcess.RegistrationData[])method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            throw new InvalidClassException(clazz.getName(), "Class doesn't implement getRegistrationData() properly.");
        }
        int n = 0;
        while (n < registrationDataArray.length) {
            UStack uStack = new UStack();
            uStack.push((Object)registrationDataArray[n].getInstrumentationVersion());
            uStack.push((Object)registrationDataArray[n].getModel());
            uStack.push((Object)registrationDataArray[n].getVendor());
            uStack.push((Object)registrationDataArray[n].getProfile());
            uStack.push((Object)registrationDataArray[n].getSmisVersion());
            uStack.push((Object)registrationDataArray[n].getName());
            Map map = this.cProcessMap;
            synchronized (map) {
                String string = (String)uStack.pop();
                Map map2 = this.cProcessMap;
                while (!uStack.empty()) {
                    map2 = Router.getInnerMap(map2, string);
                    string = (String)uStack.pop();
                }
                if (map2.containsKey(string)) {
                    throw new IllegalArgumentException("Registration of DiscoverProcess " + clazz.getName() + " failed! Pattern for process " + registrationDataArray[n].getName() + " already registered.");
                }
                map2.put(string, clazz);
            }
            ++n;
        }
        return true;
    }

    public void addProcess(String string, IDiscoverProcess iDiscoverProcess) {
        iDiscoverProcess.getRequest().setCommand(string);
        this.cLegacyProcessMap.put(string, iDiscoverProcess);
    }

    public void update(Observable observable, Object object) {
        Request request;
        String string = "update";
        JobInfo jobInfo = (JobInfo)object;
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFORMATION, (Object)className, string, "Router.update - notified that job " + jobInfo.getId() + " has changed state.");
        }
        if ((request = (Request)this.cRequestMap.get(jobInfo.getDiscoverRequest())) == null) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Error - no status for RequestID " + jobInfo.getDiscoverRequest());
            }
            return;
        }
        this.finish(request, jobInfo.isSuccessful(), jobInfo.getReturnCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJobStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CURRENT JOB STATUS\n");
        if (this.cRequestMap.isEmpty()) {
            stringBuffer.append("No jobs are currently running.");
        } else {
            Map map = this.cRequestMap;
            synchronized (map) {
                Iterator iterator = this.cRequestMap.values().iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append("-----------------------\n");
                    Request request = (Request)iterator.next();
                    stringBuffer.append("  Request: " + request.getId() + " Device Server Run ID: " + request.getDeviceServerRunNumber() + " hasRunningChildRequests: " + request.hasRunningChildRequests() + " isRunning: " + request.isRunning() + " status: " + request.getStatus() + "\n");
                    stringBuffer.append("   Sub Requests: ");
                    Request[] requestArray = request.getChildRequests();
                    int n = 0;
                    while (n < requestArray.length) {
                        stringBuffer.append(requestArray[n].getId());
                        ++n;
                    }
                    stringBuffer.append("\n");
                    ArrayList arrayList = JobEngine.getInstance().getJobs(new Integer(request.getId()).toString());
                    int n2 = 0;
                    while (n2 < arrayList.size()) {
                        stringBuffer.append(arrayList.get(n2) + "\n");
                        ++n2;
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobToComplete(String string) {
        boolean bl = false;
        while (!bl) {
            bl = true;
            Object object = this.cRequestMap;
            synchronized (object) {
                Iterator iterator = this.cRequestMap.values().iterator();
                while (iterator.hasNext()) {
                    Request request = (Request)iterator.next();
                    if (!string.equals(request.getDeviceServerRunNumber())) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) break;
            object = this.lock;
            synchronized (object) {
                if (this.cRequestMap.isEmpty()) {
                    bl = true;
                } else {
                    try {
                        this.lock.wait(LOCK_WAIT_TIME);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTilComplete(String string) {
        while (this.cRequestMap.containsKey(string)) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait(LOCK_WAIT_TIME);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void waitTilComplete(String[] stringArray) {
        this.waitTilComplete(stringArray[1]);
    }

    private String[] getScheduleIdSidRunNumber(String string) {
        if (string.length() <= 1) {
            return null;
        }
        int n = string.indexOf(58);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String[] stringArray = new String[]{string3, string2};
        return stringArray;
    }

    public String getExtensionPointId() {
        return EXTENSION_POINT_ID;
    }

    protected void extensionAdded(String string) {
        String string2 = "extensionAdded";
        try {
            this.handleDiscoverProcessExtension(string, true);
        }
        catch (Exception exception) {
            traceLogger.exception(Level.ERROR, (Object)this, string2, (Throwable)exception, "Failed to register extension " + string + " for Extensionpoint " + this.getExtensionPointId());
        }
    }

    protected void extensionRemoved(String string) {
        String string2 = "extensionRemoved";
        try {
            this.handleDiscoverProcessExtension(string, false);
        }
        catch (Exception exception) {
            traceLogger.exception(Level.ERROR, (Object)this, string2, (Throwable)exception, "Failed to deregister extension " + string + " for Extensionpoint " + this.getExtensionPointId());
        }
    }

    private void handleDiscoverProcessExtension(String string, boolean bl) {
        IConfigurationElement[] iConfigurationElementArray;
        String string2 = this.getExtensionAttribute(string, ATTR_NAME);
        IExtension iExtension = this.getExtension(string);
        if (iExtension != null && (iConfigurationElementArray = iExtension.getConfigurationElements()) != null) {
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[0].getChildren(ELEMENT_SMISREGISTRATIONDATA);
            int n = 0;
            while (n < iConfigurationElementArray2.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n];
                this.registerSMISProcess(string, string2, iConfigurationElement, bl);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSMISProcess(String string, String string2, IConfigurationElement iConfigurationElement, boolean bl) {
        if (ELEMENT_SMISREGISTRATIONDATA.equals(iConfigurationElement.getName())) {
            UStack uStack = new UStack();
            uStack.push((Object)iConfigurationElement.getAttribute(ATTR_SMISPROVIDERVERION));
            uStack.push((Object)iConfigurationElement.getAttribute(ATTR_MODEL));
            uStack.push((Object)iConfigurationElement.getAttribute(ATTR_VENDOR));
            uStack.push((Object)iConfigurationElement.getAttribute(ATTR_SMISPROFILE));
            uStack.push((Object)iConfigurationElement.getAttribute(ATTR_SMISVERSION));
            uStack.push((Object)string2);
            Map map = this.cProcessMap;
            synchronized (map) {
                String string3 = (String)uStack.pop();
                Map map2 = this.cProcessMap;
                while (!uStack.empty()) {
                    map2 = Router.getInnerMap(map2, string3);
                    string3 = (String)uStack.pop();
                }
                if (map2.containsKey(string3)) {
                    if (!bl) {
                        map2.remove(string3);
                    } else {
                        throw new IllegalArgumentException("Registration of DiscoverProcess " + string + " failed! Pattern for process " + string2 + " already registered.");
                    }
                }
                map2.put(string3, string);
            }
        } else {
            throw new IllegalArgumentException("No SMISRegistrationData Extensionelement passed.");
        }
    }

    private static final class MatchGauge {
        private int mPreciseMatchCount;
        private int mLevel;
        private int mMatchPattern;

        public MatchGauge() {
            this.mPreciseMatchCount = 0;
            this.mLevel = 0;
            this.mMatchPattern = 0;
        }

        public MatchGauge(MatchGauge matchGauge) {
            this.mPreciseMatchCount = matchGauge.mPreciseMatchCount;
            this.mLevel = matchGauge.mLevel;
            this.mMatchPattern = matchGauge.mMatchPattern;
        }

        public MatchGauge countPreciseMatch() {
            ++this.mLevel;
            ++this.mPreciseMatchCount;
            this.mMatchPattern += 1 << this.mLevel;
            return this;
        }

        public MatchGauge countGenericMatch() {
            ++this.mLevel;
            return this;
        }

        public void markMismatch() {
            this.mPreciseMatchCount = -1;
        }

        public MatchGauge concat(MatchGauge matchGauge) {
            if (matchGauge.mPreciseMatchCount == -1) {
                this.markMismatch();
            } else {
                this.mPreciseMatchCount += matchGauge.mPreciseMatchCount;
                this.mMatchPattern += matchGauge.mMatchPattern << this.mLevel;
                this.mLevel += matchGauge.mLevel;
            }
            return this;
        }

        public boolean less(MatchGauge matchGauge) {
            return this.mPreciseMatchCount != matchGauge.mPreciseMatchCount ? this.mPreciseMatchCount < matchGauge.mPreciseMatchCount : this.mMatchPattern < matchGauge.mMatchPattern;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            stringBuffer.append(this.mPreciseMatchCount);
            stringBuffer.append(',');
            stringBuffer.append(this.mMatchPattern);
            stringBuffer.append(',');
            stringBuffer.append(this.mLevel);
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }
}

