/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.cimom.CIMScanner;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.CIMParser;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.CIMOMSelectorDbHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class AssociatorCIMQuery
extends DiscoverProcess {
    Query queryTemplate;
    String entityName;
    String entityClass;
    boolean persist;

    public AssociatorCIMQuery(String string, Query query, String string2, String string3, boolean bl) {
        Class<?> clazz;
        String[] stringArray = new String[2];
        try {
            clazz = Class.forName("[Ljava.lang.String;");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[0] = clazz.getName();
        stringArray[1] = string3;
        super(string, false, new String[]{"CIMOM", string2}, stringArray);
        this.queryTemplate = null;
        this.entityName = null;
        this.entityClass = null;
        this.queryTemplate = query;
        this.entityName = string2;
        this.entityClass = string3;
        this.persist = bl;
    }

    public Result process(Request request, Map map) throws ParameterException {
        Class<?> clazz;
        try {
            clazz = Class.forName("[Ljava.lang.String;");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        String[] stringArray = (String[])AssociatorCIMQuery.getParameter(map, "CIMOM", clazz.getName());
        Object object = AssociatorCIMQuery.getParameter(map, this.entityName, this.entityClass);
        try {
            CIMInstance cIMInstance = new CIMInstance();
            cIMInstance = object instanceof CIMInstance ? (CIMInstance)object : this.processUnusualEntityClass(object, stringArray);
            Vector vector = cIMInstance.getAllProperties();
            Query query = (Query)this.queryTemplate.clone();
            query.setClassName(cIMInstance.getClassName());
            query.setProperties(vector);
            query.setCOP(cIMInstance.getObjectPath());
            JobInfo jobInfo = new JobInfo();
            jobInfo.setDiscoverRequest(new Integer(request.getId()).toString());
            jobInfo.setResourceQueue(this.getResourceQueueName());
            jobInfo.setResourceId(stringArray[0]);
            jobInfo.setRequestId(String.valueOf(stringArray[0]) + ":" + query.getCmd() + ":" + query.getClassName() + query.getAssocClassName() + query.getResultClassName() + vector);
            jobInfo.setRequest((Response)query);
            jobInfo.setTarget(stringArray);
            if (this.persist) {
                JobInfo jobInfo2 = (JobInfo)jobInfo.clone();
                jobInfo2.setResourceQueue(CIMParser.queueName);
                jobInfo.setNextJob(jobInfo2);
            }
            JobEngine.getInstance().addJob(jobInfo);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Result(99);
        }
        return new Result(0);
    }

    private CIMInstance processUnusualEntityClass(Object object, String[] stringArray) {
        if (object instanceof StorageSubsystem) {
            try {
                StorageSubsystem storageSubsystem = (StorageSubsystem)object;
                CIMOMSelectorDbHelper.CIMOMInformation[] cIMOMInformationArray = CIMOMSelectorDbHelper.Subsystem.getCimomInformation((int)storageSubsystem.getSubsystemId());
                if (cIMOMInformationArray.length == 0) {
                    CIMOMSelectorDbHelper.Subsystem.setMissing((int)storageSubsystem.getSubsystemId());
                    throw new CIMOMSelector.NoCimomAvailableException(new SRMMessage("HWN021801E", null));
                }
                int n = 0;
                while (n < cIMOMInformationArray.length) {
                    CIMOMSelectorDbHelper.CIMOMInformation cIMOMInformation = cIMOMInformationArray[n];
                    CIMOM cIMOM = CIMOMSelectorDbHelper.getCimom((int)cIMOMInformation.getId());
                    String string = cIMOM.getServiceUrl();
                    if (string.equalsIgnoreCase(stringArray[0])) {
                        CimkeySubsystem cimkeySubsystem = CIMOMSelectorDbHelper.Subsystem.getCimNamespaceMapping((int)storageSubsystem.getSubsystemId(), (int)cIMOMInformation.getNamespaceId());
                        CIMObjectPath cIMObjectPath = ExternalKeyManager.getCIMObjectPath((CimkeySubsystem)cimkeySubsystem, (String)cIMOMInformation.getNamespace());
                        return new CIMInstance(cIMObjectPath);
                    }
                    ++n;
                }
            }
            catch (SQLException sQLException) {
                throw new CIMOMSelector.NoCimomAvailableException(new SRMMessage("HWN021503E", null), (Throwable)sQLException);
            }
        }
        return null;
    }

    protected String getResourceQueueName() {
        return CIMScanner.queueName;
    }
}

