/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.interfaces.DiscoverRequest;
import org.eclipse.aperi.interfaces.EnumeratedResponse;
import org.eclipse.aperi.interfaces.ParameterException;

public class EnumeratedResponseCollaterStep
implements IStep {
    private ArrayList keyNames_ = new ArrayList();
    private ArrayList keyTypes_ = new ArrayList();
    public static final String ENUMRESPONSE = "ENUMERATE RESPONSE";
    public static final int TPCASYNCRESULT_DEFAULT_RC = 0;
    public static final int ENUM_RESPONSE_DEFAULT_SIZE = 10;

    public EnumeratedResponseCollaterStep(Object[] objectArray, Object[] objectArray2) {
        this.keyNames_.addAll((Collection)Arrays.asList(objectArray));
        this.keyTypes_.addAll((Collection)Arrays.asList(objectArray2));
    }

    public EnumeratedResponseCollaterStep(Object[] objectArray) {
        this.keyNames_.addAll((Collection)Arrays.asList(objectArray));
    }

    public void addNextStep(IStep iStep) {
    }

    public boolean process(String string, Map map) {
        ArrayList arrayList = new ArrayList(this.keyNames_.size());
        EnumeratedResponse enumeratedResponse = null;
        boolean bl = true;
        try {
            enumeratedResponse = EnumeratedResponseCollaterStep.retrieveEnumeratedResponse(map);
            String string2 = null;
            int n = 0;
            Iterator iterator = this.keyNames_.iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                arrayList.add(map.get(string2));
                ++n;
            }
        }
        catch (ParameterException parameterException) {
            parameterException.printStackTrace();
            bl = false;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            bl = false;
        }
        enumeratedResponse.add(arrayList);
        enumeratedResponse.readyForNext();
        return bl;
    }

    public static EnumeratedResponse allocateReturnArea(Request request) {
        AsyncResult asyncResult = new AsyncResult(0, 2);
        EnumeratedResponse enumeratedResponse = EnumeratedResponseCollaterStep.allocateReturnArea(asyncResult);
        ServiceUtils.activeJobs.put(request.getDeviceServerRunNumber(), asyncResult);
        return enumeratedResponse;
    }

    public static EnumeratedResponse allocateReturnArea(AsyncResult asyncResult) {
        EnumeratedResponse enumeratedResponse = new EnumeratedResponse(asyncResult, 10);
        asyncResult.setResults(new Object[]{enumeratedResponse});
        return enumeratedResponse;
    }

    public static void placeEnumeratedResponse(EnumeratedResponse enumeratedResponse, Map map) {
        map.put(ENUMRESPONSE, enumeratedResponse);
    }

    public static EnumeratedResponse retrieveEnumeratedResponse(Map map) throws ParameterException {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.interfaces.EnumeratedResponse");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        EnumeratedResponse enumeratedResponse = (EnumeratedResponse)DiscoverRequest.getParameter((Map)map, (String)ENUMRESPONSE, (String)clazz.getName());
        return enumeratedResponse;
    }
}

