/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.parser;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.discovery.interfaces.DiscoveryException;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.parser.Processor;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;

public class CIMProcessor
extends Processor {
    public CIMProcessor() {
        super("SMIS");
    }

    public static Hashtable convertPropertiesToHashtable(Vector vector, Hashtable hashtable) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Cloneable cloneable;
            Object object;
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            CIMValue cIMValue = cIMProperty.getValue();
            if (cIMValue == null) continue;
            String string = cIMProperty.getName().toLowerCase();
            if (cIMValue.getValue() instanceof CIMObjectPath) {
                object = (CIMObjectPath)cIMValue.getValue();
                cloneable = new Hashtable<String, String>();
                ((Hashtable)cloneable).put("instance", object.getObjectName().toString());
                hashtable.put(string, CIMProcessor.convertPropertiesToHashtable(object.getKeys(), cloneable));
                continue;
            }
            if (cIMValue.isArrayValue()) {
                object = (Vector)cIMValue.getValue();
                cloneable = new Vector();
                int n = 0;
                while (n < ((Vector)object).size()) {
                    ((Vector)cloneable).add(((Vector)object).elementAt(n).toString());
                    ++n;
                }
                hashtable.put(string, ((Vector)cloneable).toString());
                continue;
            }
            hashtable.put(string, cIMProperty.getValue().getValue().toString());
        }
        return hashtable;
    }

    public void handleInstance(JobInfo jobInfo, CIMInstance cIMInstance) throws DiscoveryException {
        Hashtable hashtable;
        Hashtable hashtable2 = CIMProcessor.convertPropertiesToHashtable(cIMInstance.getProperties(), new Hashtable());
        Hashtable hashtable3 = (Hashtable)hashtable2.get("partcomponent");
        if (hashtable3 == null) {
            hashtable3 = (Hashtable)hashtable2.get("dependent");
        }
        if ((hashtable = (Hashtable)hashtable2.get("groupcomponent")) == null) {
            hashtable = (Hashtable)hashtable2.get("antecedent");
        }
        if (hashtable3 != null && hashtable != null) {
            this.handleAssociation(jobInfo, cIMInstance.getClassName(), (String)hashtable.get("instance"), hashtable, (String)hashtable3.get("instance"), hashtable3, hashtable2);
        } else {
            this.handleEntity(jobInfo, cIMInstance.getClassName(), hashtable2);
        }
    }

    public void handleEntity(JobInfo jobInfo, String string, Hashtable hashtable) throws DiscoveryException {
        hashtable.put("ref_serviceurl", jobInfo.getTarget()[0]);
        hashtable.put("ref_namespace", jobInfo.getTarget()[1]);
        super.handleEntity(jobInfo, string, hashtable);
    }

    public void handleAssociation(JobInfo jobInfo, String string, String string2, Hashtable hashtable, String string3, Hashtable hashtable2, Hashtable hashtable3) throws DiscoveryException {
        hashtable.put("ref_serviceurl", jobInfo.getTarget()[0]);
        hashtable.put("ref_namespace", jobInfo.getTarget()[1]);
        hashtable2.put("ref_serviceurl", jobInfo.getTarget()[0]);
        hashtable2.put("ref_namespace", jobInfo.getTarget()[1]);
        hashtable3.put("ref_serviceurl", jobInfo.getTarget()[0]);
        hashtable3.put("ref_namespace", jobInfo.getTarget()[1]);
        super.handleAssociation(jobInfo, string, string2, hashtable, string3, hashtable2, hashtable3);
    }
}

